/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.test.BaseTest;
import cryptix.util.core.BI;
import cryptix.util.core.Hex;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAFactors;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

class TestRSA
extends BaseTest {
    private static final byte[] message = "Je ne veux que du magnifique, et je ne travaille pas pour le vulgaire des lecteurs --Giambattista BODONI (1740-1813)".getBytes();
    private static byte[] signature;
    private static final SecureRandom prng;

    public static void main(String[] stringArray) {
        new TestRSA().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        Signature signature = Signature.getInstance("MD2/RSA/PKCS#1");
        Signature signature2 = Signature.getInstance("MD5/RSA/PKCS#1");
        Signature signature3 = Signature.getInstance("SHA-1/RSA/PKCS#1");
        Signature signature4 = Signature.getInstance("RIPEMD160/RSA/PKCS#1");
        this.setExpectedPasses(20);
        int n = 0;
        while (n < 5) {
            int n2 = 512 + 128 * n;
            this.out.println("\nTest #" + (n + 1) + " (" + n2 + "-bit modulus)\n");
            this.test(n2, keyPairGenerator, signature);
            this.test(n2, keyPairGenerator, signature2);
            this.test(n2, keyPairGenerator, signature3);
            this.test(n2, keyPairGenerator, signature4);
            ++n;
        }
    }

    private void test(int n, KeyPairGenerator keyPairGenerator, Signature signature) {
        block9: {
            try {
                this.out.println("1. Generating keypair...\n");
                keyPairGenerator.initialize(n, prng);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PublicKey publicKey = keyPair.getPublic();
                PrivateKey privateKey = keyPair.getPrivate();
                this.out.println("2. Using keypair for signature...");
                this.out.println("2.1 Signing with a " + n + "-bit key using " + signature.getAlgorithm() + "...");
                signature.initSign(privateKey);
                signature.update(message);
                TestRSA.signature = signature.sign();
                this.out.println("2.2 Verifying with same " + n + "-bit key using " + signature.getAlgorithm() + "...\n");
                signature.initVerify(publicKey);
                signature.update(message);
                boolean bl = signature.verify(TestRSA.signature);
                this.passIf(bl, "Signature verification");
                if (bl) break block9;
                this.out.println("---- begin debugging -----\n");
                this.out.println("Computed signature: " + Hex.dumpString((byte[])TestRSA.signature));
                this.out.println("RSA parameters:");
                BigInteger bigInteger = ((RSAPublicKey)publicKey).getModulus();
                BigInteger bigInteger2 = ((RSAPublicKey)publicKey).getExponent();
                this.out.println("   Public key material:");
                this.out.println("   n: " + BI.dumpString((BigInteger)bigInteger));
                this.out.println("   e: " + BI.dumpString((BigInteger)bigInteger2));
                BigInteger bigInteger3 = ((RSAPrivateKey)privateKey).getModulus();
                BigInteger bigInteger4 = ((RSAPrivateKey)privateKey).getExponent();
                BigInteger bigInteger5 = ((RSAFactors)((Object)privateKey)).getP();
                BigInteger bigInteger6 = ((RSAFactors)((Object)privateKey)).getQ();
                BigInteger bigInteger7 = ((RSAFactors)((Object)privateKey)).getInverseOfQModP();
                this.out.println("   Private key material:");
                this.out.println("   n: " + BI.dumpString((BigInteger)bigInteger3));
                this.out.println("   d: " + BI.dumpString((BigInteger)bigInteger4));
                this.out.println("   p: " + BI.dumpString((BigInteger)bigInteger5));
                this.out.println("   q: " + BI.dumpString((BigInteger)bigInteger6));
                this.out.println("   u: " + BI.dumpString((BigInteger)bigInteger7));
                BigInteger bigInteger8 = new BigInteger(TestRSA.signature);
                this.out.println("   The signature as a BigInteger:");
                this.out.println("   x: " + BI.dumpString((BigInteger)bigInteger8));
                this.out.println("RSA correctness tests:");
                try {
                    boolean bl2 = bigInteger.compareTo(bigInteger3) == 0;
                    this.passIf(bl2, "\t1. Same modulus?");
                    if (!bl2) {
                        throw new RuntimeException();
                    }
                    bl2 = bigInteger5.multiply(bigInteger6).compareTo(bigInteger3) == 0;
                    this.passIf(bl2, "\t2. n = pq?");
                    if (!bl2) {
                        throw new RuntimeException();
                    }
                    BigInteger bigInteger9 = bigInteger8.modPow(bigInteger2, bigInteger3);
                    BigInteger bigInteger10 = bigInteger9.modPow(bigInteger4, bigInteger3);
                    bl2 = bigInteger10.compareTo(bigInteger8) == 0;
                    this.passIf(bl2, "\t3. x = (x ** ed) mod n?");
                    if (!bl2) {
                        throw new RuntimeException();
                    }
                    BigInteger bigInteger11 = BigInteger.valueOf(1L);
                    BigInteger bigInteger12 = bigInteger4.mod(bigInteger5.subtract(bigInteger11));
                    BigInteger bigInteger13 = bigInteger4.mod(bigInteger6.subtract(bigInteger11));
                    BigInteger bigInteger14 = bigInteger9.mod(bigInteger5).modPow(bigInteger12, bigInteger5);
                    BigInteger bigInteger15 = bigInteger9.mod(bigInteger6).modPow(bigInteger13, bigInteger6);
                    if ((bigInteger15 = bigInteger15.subtract(bigInteger14)).signum() == -1) {
                        bigInteger15 = bigInteger15.add(bigInteger6);
                    }
                    bl2 = (bigInteger10 = bigInteger14.add(bigInteger5.multiply(bigInteger15.multiply(bigInteger7).mod(bigInteger6)))).compareTo(bigInteger8) == 0;
                    this.passIf(bl2, "\t4. (x ** e) mod n = (y ** d) mod pq?");
                    if (!bl2) {
                        throw new RuntimeException();
                    }
                    this.out.println();
                }
                catch (Exception exception) {
                    this.fail("Exception during pure RSA tests");
                    throw new RuntimeException("PANIC: Failed pure RSA tests...");
                }
                this.out.println("---- end debugging -----");
                throw new RuntimeException("PANIC...");
            }
            catch (Exception exception) {
                this.fail("Unexpected exception");
                exception.printStackTrace();
            }
        }
    }

    TestRSA() {
    }

    static {
        prng = new SecureRandom();
    }
}

