/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.security.BlockCipher;
import cryptix.security.CryptoError;
import java.security.Cipher;

public class SPEED
extends BlockCipher {
    private static final int KEY_LEN_MAX = 32;
    private static final int KEY_LEN_MIN = 6;
    private static byte[][] keys = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96}};
    private static byte[][] plains = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31}};
    private static byte[][] ciphers = new byte[][]{{109, -123, 38, -68, 25, -128, 0, 46}, {-24, -60, 91, -111, 22, -40, 84, -85, 113, 21, 23, -61, -71, -28, 19, 108}, {104, 16, 49, -70, -52, 49, -79, 8, -41, 97, 107, 41, -118, 85, -86, 63, 27, -20, 63, 105, 116, 21, 78, 67, 71, 104, 98, -102, -6, 108, -31, 61}};
    private static int[][] params = new int[][]{{8, 64}, {16, 128}, {32, 256}};

    public static final int blockLengthMax() {
        return 32;
    }

    public static final int blockLengthMin() {
        return 8;
    }

    public static final int blockLengthMod() {
        return 8;
    }

    public static final int keyLengthMax() {
        return 32;
    }

    public static final int keyLengthMin() {
        return 6;
    }

    public static final int keyLengthMod() {
        return 2;
    }

    public static final int numRoundsMax() {
        return -1879048196;
    }

    public static final int numRoundsMin() {
        return 32;
    }

    public static final int numRoundsMod() {
        return 4;
    }

    public final int numRounds() {
        return ((cryptix.provider.cipher.SPEED)this.cipher).getRounds();
    }

    public SPEED(byte[] byArray) {
        super(SPEED.getCipherImpl(8, 64), byArray);
    }

    public SPEED(byte[] byArray, int n, int n2) {
        super(SPEED.getCipherImpl(n, n2), byArray);
    }

    private static Cipher getCipherImpl(int n, int n2) {
        try {
            cryptix.provider.cipher.SPEED sPEED = (cryptix.provider.cipher.SPEED)Cipher.getInstance((String)"SPEED", (String)"Cryptix");
            sPEED.setBlockSize(n);
            sPEED.setRounds(n2);
            return sPEED;
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        try {
            SPEED.self_test();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public static void self_test() throws CryptoError {
        int n = 0;
        while (n < keys.length) {
            SPEED sPEED = new SPEED(keys[n], params[n][0], params[n][1]);
            byte[] byArray = new byte[plains[n].length];
            sPEED.encrypt(plains[n], byArray);
            if (SPEED.notEquals(ciphers[n], byArray)) {
                throw new CryptoError("encrypt #" + n + " failed");
            }
            sPEED.decrypt(ciphers[n], byArray);
            if (SPEED.notEquals(plains[n], byArray)) {
                throw new CryptoError("decrypt #" + n + " failed");
            }
            ++n;
        }
    }

    private static boolean notEquals(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

