/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import java.security.Cipher;
import java.security.Key;
import java.util.Date;

class TestCAST5
extends BaseTest {
    private Cipher alg;
    private static final byte[] input = Hex.fromString((String)"0123456789ABCDEF");

    public static void main(String[] stringArray) {
        new TestCAST5().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(7);
        this.alg = Cipher.getInstance((String)"CAST5", (String)"Cryptix");
        this.test1();
        this.test2();
    }

    private void test1() throws Exception {
        String[][] stringArrayArray = new String[][]{{"0123456712345678234567893456789A", "238B4FE5847E44B2"}, {"01234567123456782345", "EB6A711A2C02271B"}, {"0123456712", "7AC816D16E9B302E"}};
        int n = 0;
        while (n < stringArrayArray.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("CAST5", Hex.fromString((String)stringArrayArray[n][0]));
            byte[] byArray = Hex.fromString((String)stringArrayArray[n][1]);
            this.out.println("\nTest vector (" + 4 * stringArrayArray[n][0].length() + "-bit key):");
            this.out.println("\nEncrypting:");
            this.alg.initEncrypt((Key)rawSecretKey);
            this.compareIt(this.alg.crypt(input), byArray);
            this.out.println("\nDecrypting:");
            this.alg.initDecrypt((Key)rawSecretKey);
            this.compareIt(this.alg.crypt(byArray), input);
            ++n;
        }
    }

    private void test2() throws Exception {
        int n;
        RawSecretKey rawSecretKey = new RawSecretKey("CAST5", Hex.fromString((String)"0123456712"));
        byte[] byArray = Hex.fromString((String)"0123456789ABCDEF");
        this.alg.initEncrypt((Key)rawSecretKey);
        this.out.println("\nSpeed test (10,000 x 8-byte w/40-bit key):\n");
        this.out.println("...Encryption\n");
        this.out.println("      start date/time: " + new Date());
        int n2 = 0;
        while (n2 < 10) {
            n = 0;
            while (n < 1000) {
                this.alg.crypt(byArray, 0, 8, byArray, 0);
                ++n;
            }
            ++n2;
        }
        this.out.println("     finish date/time: " + new Date());
        this.alg.initDecrypt((Key)rawSecretKey);
        this.out.println("\n...Decryption\n");
        this.out.println("      start date/time: " + new Date());
        n = 0;
        while (n < 10) {
            int n3 = 0;
            while (n3 < 1000) {
                this.alg.crypt(byArray, 0, 8, byArray, 0);
                ++n3;
            }
            ++n;
        }
        this.out.println("     finish date/time: " + new Date());
        this.out.println("\n result:");
        this.compareIt(byArray, input);
    }

    private void test3() throws Exception {
        byte[] byArray = Hex.fromString((String)"0123456712345678234567893456789A");
        byte[] byArray2 = Hex.fromString((String)"0123456712345678234567893456789A");
        byte[] byArray3 = Hex.fromString((String)"EEA9D0A249FD3BA6B3436FB89D6DCA92");
        byte[] byArray4 = Hex.fromString((String)"B2C95EB00C31AD7180AC05B8E83D696E");
        this.out.println("\nTest 1,000,000 encryptions with 128-bit key:\n");
        this.out.println("  start date/time: " + new Date());
        int n = 0;
        while (n < 1000) {
            int n2 = 0;
            while (n2 < 1000) {
                this.alg.initEncrypt((Key)new RawSecretKey("CAST5", byArray2));
                byArray = this.alg.crypt(byArray);
                this.alg.initEncrypt((Key)new RawSecretKey("CAST5", byArray));
                byArray2 = this.alg.crypt(byArray2);
                ++n2;
            }
            ++n;
        }
        this.out.println(" finish date/time: " + new Date());
        this.out.println("\n result for 'a'\n");
        this.compareIt(byArray, byArray3);
        this.out.println("\n result for 'b'\n");
        this.compareIt(byArray2, byArray4);
    }

    private void compareIt(byte[] byArray, byte[] byArray2) {
        this.out.println("  computed: " + Hex.dumpString((byte[])byArray));
        this.out.println(" certified: " + Hex.dumpString((byte[])byArray2));
        this.passIf(ArrayUtil.areEqual((byte[])byArray, (byte[])byArray2), " *** CAST5 OUTPUT");
    }

    TestCAST5() {
    }
}

