/*
 * Decompiled with CFR 0.152.
 */
package LOKI97;

import LOKI97.LOKI97_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class LOKI97_Algorithm {
    static final String NAME = "LOKI97_Algorithm";
    static final String FULL_NAME;
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err;
    static final boolean TRACE;
    static final int BLOCK_SIZE = 16;
    static final int ROUNDS = 16;
    static final int NUM_SUBKEYS = 48;
    private static final long DELTA = -7046029254386353131L;
    private static final int S1_GEN = 10513;
    static final int S1_SIZE = 8192;
    static final byte[] S1;
    private static final int S2_GEN = 2727;
    static final int S2_SIZE = 2048;
    static final byte[] S2;
    static final long[] P;
    private static final char[] HEX_DIGITS;

    static void debug(String string) {
        ((PrintWriter)null).println(">>> " + "LOKI97 ver. " + 0.1 + ": " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> LOKI97_Algorithm." + string);
        }
    }

    static final byte exp3(int n, int n2, int n3) {
        if (n == 0) {
            return 0;
        }
        int n4 = n;
        n = LOKI97_Algorithm.mult(n4, n, n2, n3);
        n4 = LOKI97_Algorithm.mult(n4, n, n2, n3);
        return (byte)n4;
    }

    static final int mult(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n5 ^= n;
            }
            if ((n <<= 1) >= n4) {
                n ^= n3;
            }
            n2 >>>= 1;
        }
        return n5;
    }

    public static synchronized Object makeKey(byte[] byArray) throws InvalidKeyException {
        long l;
        long l2;
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        long[] lArray = new long[48];
        long l3 = -7046029254386353131L;
        int n = 0;
        long l4 = ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
        long l5 = ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
        if (byArray.length == 16) {
            l2 = LOKI97_Algorithm.f(l5, l4);
            l = LOKI97_Algorithm.f(l4, l5);
        } else {
            l2 = ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
            l = byArray.length == 24 ? LOKI97_Algorithm.f(l4, l5) : ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
        }
        n = 0;
        while (n < 48) {
            long l6 = LOKI97_Algorithm.f(l + l5 + l3, l2);
            lArray[n] = l4 ^ l6;
            l4 = l5;
            l5 = l2;
            l2 = l;
            l = lArray[n];
            l3 += -7046029254386353131L;
            ++n;
        }
        return lArray;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        long[] lArray = (long[])object;
        long l = ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
        long l2 = ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 16) {
            long l3 = l2 + lArray[n2++];
            long l4 = LOKI97_Algorithm.f(l3, lArray[n2++]);
            int n4 = n2++;
            l2 = l ^ l4;
            l = l3 += lArray[n4];
            ++n3;
        }
        byte[] byArray2 = new byte[]{(byte)(l2 >>> 56), (byte)(l2 >>> 48), (byte)(l2 >>> 40), (byte)(l2 >>> 32), (byte)(l2 >>> 24), (byte)(l2 >>> 16), (byte)(l2 >>> 8), (byte)l2, (byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        long[] lArray = (long[])object;
        long l = ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
        long l2 = ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
        int n2 = 47;
        int n3 = 0;
        while (n3 < 16) {
            long l3 = l2 - lArray[n2--];
            long l4 = LOKI97_Algorithm.f(l3, lArray[n2--]);
            int n4 = n2--;
            l2 = l ^ l4;
            l = l3 -= lArray[n4];
            ++n3;
        }
        byte[] byArray2 = new byte[]{(byte)(l2 >>> 56), (byte)(l2 >>> 48), (byte)(l2 >>> 40), (byte)(l2 >>> 32), (byte)(l2 >>> 24), (byte)(l2 >>> 16), (byte)(l2 >>> 8), (byte)l2, (byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        return byArray2;
    }

    public static boolean self_test() {
        boolean bl = false;
        try {
            byte[] byArray;
            byte[] byArray2 = new byte[32];
            byArray2[1] = 1;
            byArray2[2] = 2;
            byArray2[3] = 3;
            byArray2[4] = 4;
            byArray2[5] = 5;
            byArray2[6] = 6;
            byArray2[7] = 7;
            byArray2[8] = 8;
            byArray2[9] = 9;
            byArray2[10] = 10;
            byArray2[11] = 11;
            byArray2[12] = 12;
            byArray2[13] = 13;
            byArray2[14] = 14;
            byArray2[15] = 15;
            byArray2[16] = 16;
            byArray2[17] = 17;
            byArray2[18] = 18;
            byArray2[19] = 19;
            byArray2[20] = 20;
            byArray2[21] = 21;
            byArray2[22] = 22;
            byArray2[23] = 23;
            byArray2[24] = 24;
            byArray2[25] = 25;
            byArray2[26] = 26;
            byArray2[27] = 27;
            byArray2[28] = 28;
            byArray2[29] = 29;
            byArray2[30] = 30;
            byArray2[31] = 31;
            byte[] byArray3 = byArray2;
            byte[] byArray4 = new byte[16];
            int n = 0;
            while (n < 16) {
                byArray4[n] = (byte)n;
                ++n;
            }
            Object object = LOKI97_Algorithm.makeKey(byArray3);
            byte[] byArray5 = LOKI97_Algorithm.fromString("75080E359F10FE640144B35C57128DAD");
            bl = LOKI97_Algorithm.areEqual(byArray5, byArray = LOKI97_Algorithm.blockEncrypt(byArray4, 0, object));
            if (!bl) {
                throw new RuntimeException("Encryption failed");
            }
            byArray = LOKI97_Algorithm.blockDecrypt(byArray5, 0, object);
            bl = LOKI97_Algorithm.areEqual(byArray4, byArray);
            if (!bl) {
                throw new RuntimeException("Decryption failed");
            }
            bl = LOKI97_Algorithm.self_test(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static int blockSize() {
        return 16;
    }

    private static long f(long l, long l2) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        int n3 = (int)l2;
        long l3 = (long)(n & ~n3 | n2 & n3) << 32 | (long)(n2 & ~n3 | n & n3) & 0xFFFFFFFFL;
        long l4 = P[S1[(int)((l3 >>> 56 | l3 << 8) & 0x1FFFL)] & 0xFF] >>> 7 | P[S2[(int)(l3 >>> 48 & 0x7FFL)] & 0xFF] >>> 6 | P[S1[(int)(l3 >>> 40 & 0x1FFFL)] & 0xFF] >>> 5 | P[S2[(int)(l3 >>> 32 & 0x7FFL)] & 0xFF] >>> 4 | P[S2[(int)(l3 >>> 24 & 0x7FFL)] & 0xFF] >>> 3 | P[S1[(int)(l3 >>> 16 & 0x1FFFL)] & 0xFF] >>> 2 | P[S2[(int)(l3 >>> 8 & 0x7FFL)] & 0xFF] >>> 1 | P[S1[(int)(l3 & 0x1FFFL)] & 0xFF];
        long l5 = ((long)S2[(int)(l4 >>> 56 & 0xFFL | l2 >>> 53 & 0x700L)] & 0xFFL) << 56 | ((long)S2[(int)(l4 >>> 48 & 0xFFL | l2 >>> 50 & 0x700L)] & 0xFFL) << 48 | ((long)S1[(int)(l4 >>> 40 & 0xFFL | l2 >>> 45 & 0x1F00L)] & 0xFFL) << 40 | ((long)S1[(int)(l4 >>> 32 & 0xFFL | l2 >>> 40 & 0x1F00L)] & 0xFFL) << 32 | ((long)S2[(int)(l4 >>> 24 & 0xFFL | l2 >>> 37 & 0x700L)] & 0xFFL) << 24 | ((long)S2[(int)(l4 >>> 16 & 0xFFL | l2 >>> 34 & 0x700L)] & 0xFFL) << 16 | ((long)S1[(int)(l4 >>> 8 & 0xFFL | l2 >>> 29 & 0x1F00L)] & 0xFFL) << 8 | (long)S1[(int)(l4 & 0xFFL | l2 >>> 24 & 0x1F00L)] & 0xFFL;
        return l5;
    }

    private static boolean self_test(int n) {
        boolean bl = false;
        try {
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[16];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)n2;
                ++n2;
            }
            n2 = 0;
            while (n2 < 16) {
                byArray2[n2] = (byte)n2;
                ++n2;
            }
            Object object = LOKI97_Algorithm.makeKey(byArray);
            byte[] byArray3 = LOKI97_Algorithm.blockEncrypt(byArray2, 0, object);
            byte[] byArray4 = LOKI97_Algorithm.blockDecrypt(byArray3, 0, object);
            bl = LOKI97_Algorithm.areEqual(byArray2, byArray4);
            if (!bl) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static byte[] fromString(String string) {
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        if (n % 2 == 1) {
            byArray[n3++] = (byte)LOKI97_Algorithm.fromDigit(string.charAt(n2++));
        }
        while (n2 < n) {
            byArray[n3++] = (byte)(LOKI97_Algorithm.fromDigit(string.charAt(n2++)) << 4 | LOKI97_Algorithm.fromDigit(string.charAt(n2++)));
        }
        return byArray;
    }

    public static int fromDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hex digit '" + c + "'");
    }

    private static String byteToString(int n) {
        char[] cArray = new char[]{HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n & 0xF]};
        return new String(cArray);
    }

    private static String shortToString(int n) {
        char[] cArray = new char[]{HEX_DIGITS[n >>> 12 & 0xF], HEX_DIGITS[n >>> 8 & 0xF], HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n & 0xF]};
        return new String(cArray);
    }

    private static String longToString(long l) {
        char[] cArray = new char[16];
        int n = 15;
        while (n >= 0) {
            cArray[n] = HEX_DIGITS[(int)l & 0xF];
            l >>>= 4;
            --n;
        }
        return new String(cArray);
    }

    private static String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) {
        LOKI97_Algorithm.self_test(16);
        LOKI97_Algorithm.self_test(24);
        LOKI97_Algorithm.self_test(32);
    }

    static {
        int n;
        FULL_NAME = "LOKI97 ver. " + 0.1;
        err = null;
        TRACE = LOKI97_Properties.isTraceable(NAME);
        S1 = new byte[8192];
        S2 = new byte[2048];
        P = new long[256];
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        long l = System.currentTimeMillis();
        int n2 = 0;
        n2 = 0;
        while (n2 < 8192) {
            n = n2 ^ 0x1FFF;
            LOKI97_Algorithm.S1[n2] = LOKI97_Algorithm.exp3(n, 10513, 8192);
            ++n2;
        }
        n2 = 0;
        while (n2 < 2048) {
            n = n2 ^ 0x7FF;
            LOKI97_Algorithm.S2[n2] = LOKI97_Algorithm.exp3(n, 2727, 2048);
            ++n2;
        }
        n2 = 0;
        while (n2 < 256) {
            long l2 = 0L;
            int n3 = 0;
            int n4 = 7;
            while (n3 < 8) {
                l2 |= (long)(n2 >>> n3 & 1) << n4;
                ++n3;
                n4 += 8;
            }
            LOKI97_Algorithm.P[n2] = l2;
            ++n2;
        }
        l = System.currentTimeMillis() - l;
    }
}

