/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#ifndef __EXTENSION_TAB_PRESENTER__
#define __EXTENSION_TAB_PRESENTER__

#include <QScrollArea>
#include <VariantDataModel.h>
#include "CamiTKExtensionModelPresenter.h"

/**
 * @brief Presenter for generic action extension.
 *
 * Should not be used directly please use either CppExtensionTabPresenter or PythonExtensionTabPresenter.
 */
class ExtensionTabPresenter : public QScrollArea {
    Q_OBJECT
public:
    /// constructor
    ExtensionTabPresenter(CamiTKExtensionModelPresenter* presenter, VariantDataModel& dataModel, QWidget* parent = nullptr);

    virtual ~ExtensionTabPresenter() = default;

protected:
    /// The main layout where all the widgets are presented
    QGridLayout* extensionTabLayout;
};

#endif // __EXTENSION_TAB_PRESENTER__