import camitk
import vtkmodules.all as vtk
from vtk.util import numpy_support

def init(self:camitk.Action):
    camitk.info("CamiTK version: " + camitk.__version__)

def process(self:camitk.Action):
    sphere = vtk.vtkSphereSource()
    sphere.SetRadius(self.getParameterValue("Radius"))
    sphere.SetThetaResolution(self.getParameterValue("Theta Resolution"))
    sphere.SetPhiResolution(self.getParameterValue("Phi Resolution"))
    sphere.Update()

    polydata = sphere.GetOutput()

    points = numpy_support.vtk_to_numpy(polydata.GetPoints().GetData())
    polys = numpy_support.vtk_to_numpy(polydata.GetPolys().GetData()).reshape(-1, 4) # (n_triangles, 4)
    print("points", points)
    print("polys", polys)
    # Each row = [3, p0, p1, p2] -> meaning "triangle with 3 points"
    # Here no cell type, only count + point ids

    msh = camitk.newMeshComponentFromNumpy("Sphere " + str(self.getParameterValue("Radius")), points, polys)
    camitk.refresh()
    # or similar to C++ self.refreshApplication() 
    return