from gourmand.i18n import _

appname = _("Gourmand Recipe Manager")
copyright = _("Copyright (c) 2004-2021 Thomas M. Hinkle and Contributors.\n" "Copyright (c) 2021 The Gourmand Team and Contributors")
version = "1.2.0"
url = "https://github.com/GourmandRecipeManager/gourmand"
description = "Recipe Organizer and Shopping List Generator"
long_description = _(
    """\
Gourmand is an application to store, organize and search recipes.

Features:
* Makes it easy to create shopping lists from recipes.
* Imports recipes from a number of sources, including MealMaster and MasterCook
  archives and several popular websites.
* Exports recipes as PDF files, plain text, MealMaster files, HTML web pages,
  and a custom XML format for exchange with other Gourmet users.
* Supports linking images with recipes.
* Can calculate nutritional information for recipes based on the ingredients.
"""
)
author = "Gourmand Team and Contributors"
authors = []  # FIXME: get list of contributors
maintainer = "Cyril Danilevski, FriedrichFröbel"
maintainer_email = "gourmand@cyril.wtf"
artists = [_("Nyall Dawson (cookie icon)"), _("Kati Pregartner (splash screen image)")]
license = "GPL-2.0-only"
