
MODULES = \
  platform-specific-impl \
  basic-math \
  binary-file-io \
  bitwise-arithmetic \
  bvm-diag-matrix \
  bvm-matrices \
  bvm-matrix-base \
  bytevector \
  command-line-parser \
  complex \
  console-io \
  core \
  core-forms \
  core-forms2 \
  dynamic-list \
  files \
  goops-classes \
  hash-table0 \
  hash-table \
  hash-table-opt \
  iterator \
  list-utilities \
  math \
  matrix \
  mutable-pair \
  nonpure-iterator \
  object-string-conversion \
  plugins \
  promise \
  rational \
  real-math \
  singleton \
  stream \
  string-utilities \
  text-file-io \
  statprof \
  system

EXTRA_MATH = 1
POSIX_MATH = 1

ifdef EXTRA_MATH
  MODULES += extra-math
endif

ifdef POSIX_MATH
  MODULES += posix-math
endif

PLATFORM_INTF = platform-specific-impl-guile-3.0.thi
PLATFORM_BODY = platform-specific-impl-guile-3.0.thb

INTERFACE_TARGET = $(MODULES:%=%.tci)
BODY_TARGET = $(MODULES:%=%.tcb)
INTERFACE_LINKED = $(MODULES:%=__intf_%.go)
BODY_LINKED = $(MODULES:%=__impl_%.go)
INTERFACE_AUX = $(MODULES:%=__intf_%.aux)
BODY_AUX = $(MODULES:%=__impl_%.aux)

BODY_LINKED0 = $(patsubst %,__impl_%.go,$(filter-out statprof,$(MODULES)))

EXTRA_COMP_OPTIONS ?=
EXTRA_LINK_OPTIONS ?=

COMPILE ?= theme-d-compile
LINK ?= theme-d-link

.PHONY: all clean link-clean pcode-modules link-modules link-bodies

all: pcode-modules link-modules

pcode-modules: $(INTERFACE_TARGET) $(BODY_TARGET)

link-modules: link-interfaces link-bodies

link-interfaces: $(MODULES:%=__intf_%.go) $(MODULES:%=__intf_%.aux)

link-bodies: $(MODULES:%=__impl_%.go) $(MODULES:%=__impl_%.aux)

%.tci : %.thi
	$(COMPILE) -m .. -o $@ $(EXTRA_COMP_OPTIONS) $<

%.tcb : %.thb
	$(COMPILE) -m .. -o $@ $(EXTRA_COMP_OPTIONS) $<

$(INTERFACE_LINKED) : __intf_%.go : %.tci
	$(LINK) --module -M ..: -o $@ $(EXTRA_LINK_OPTIONS) $<

$(INTERFACE_AUX) : __intf_%.aux : __intf_%.go

$(BODY_LINKED0) : __impl_%.go : %.tcb
	$(LINK) --module -M ..: -o $@ $(EXTRA_LINK_OPTIONS) $<

__impl_statprof.go : statprof.tcb
	$(LINK) --module -M ..: -x "(statprof)" -o $@ $(EXTRA_LINK_OPTIONS) $<

$(BODY_AUX) : __impl_%.aux : __impl_%.go

clean:
	-rm -f *.tc?
	-rm -f platform-specific-impl.thi
	-rm -f platform-specific-impl.thb
	-rm -f $(INTERFACE_LINKED) $(INTERFACE_AUX)
	-rm -f $(BODY_LINKED) $(BODY_AUX)

link-clean:
	-rm -f $(INTERFACE_LINKED) $(INTERFACE_AUX)
	-rm -f $(BODY_LINKED) $(BODY_AUX)

platform-specific-impl.thi: $(PLATFORM_INTF)
	ln -sf $(PLATFORM_INTF) platform-specific-impl.thi

platform-specific-impl.thb: $(PLATFORM_BODY)
	ln -sf $(PLATFORM_BODY) platform-specific-impl.thb

platform-specific-impl.tci : core-forms.tci

platform-specific-impl.tcb : platform-specific-impl.tci

__intf_platform-specific-impl.go : __intf_core-forms.go

include deps.mk
