/*
 *  This file is a part of TiledArray.
 *  Copyright (C) 2020 Virginia Tech
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  David Williams-Young
 *  Computational Research Division, Lawrence Berkeley National Laboratory
 *
 *  scalapack.h
 *  Created:  25 May, 2020
 *
 */
#ifndef TILEDARRAY_MATH_SCALAPACK_H__INCLUDED
#define TILEDARRAY_MATH_SCALAPACK_H__INCLUDED

#if TILEDARRAY_HAS_SCALAPACK

#include <TiledArray/math/scalapack/heig.h>
#include <TiledArray/math/scalapack/chol.h>
#include <TiledArray/math/scalapack/svd.h>
#include <TiledArray/math/scalapack/lu.h>

#endif

#endif

