"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadCff2 = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
const subroutine_index_1 = require("../char-string/read/subroutine-index");
const read_1 = require("../context/read");
const top_1 = require("../dict/top");
const cff2_header_1 = require("../structs/cff2-header");
const shared_1 = require("./shared");
exports.ReadCff2 = (0, bin_util_1.Read)((view, cfg, gOrd, designSpace, coStat) => {
    const ctx = new read_1.CffReadContext(2, view.lift(0), coStat);
    const cff = new ot_glyphs_1.Cff.Table(2);
    const header = view.next(cff2_header_1.Cff2Header);
    const topDict = view.next(top_1.CffTopDictIo, ctx, header.topDictLength);
    const gSubrs = view.next(subroutine_index_1.CffSubroutineIndex, ctx);
    (0, shared_1.readCffCommon)(cff, gOrd, topDict, ctx, gSubrs, designSpace);
    (0, shared_1.cffCleanupUnusedData)(cff);
    return { cff, cffGlyphNaming: ctx.naming };
});
//# sourceMappingURL=read-cff2.js.map