"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decideIgnoreFlags = void 0;
const ot_layout_1 = require("@ot-builder/ot-layout");
function decideIgnoreFlags(gs, fn) {
    if (!fn)
        return null;
    return (igfEmpty(gs) ||
        igfGlyphClass(gs, fn.glyphClassDef) ||
        igcMarkAttachmentClass(gs, fn.markAttachClassDef) ||
        igfMarkGlyphSet(gs, fn.markGlyphSets));
}
exports.decideIgnoreFlags = decideIgnoreFlags;
function igfEmpty(gs) {
    if (!gs || !gs.size) {
        return {
            ignoreBaseGlyphs: false,
            ignoreLigatures: false,
            ignoreMarks: false
        };
    }
    return null;
}
class HasAllState {
    constructor() {
        this.has = false;
        this.all = true;
    }
    update(x) {
        if (x)
            this.has = true;
        else
            this.all = false;
    }
    get mix() {
        return this.has && !this.all;
    }
}
function igfGlyphClass(gs, cd) {
    if (!gs || !gs.size || !cd)
        return null;
    const base = new HasAllState(), ligature = new HasAllState(), mark = new HasAllState();
    const cov = new Set();
    for (const [g, cl] of cd) {
        const inSet = gs.has(g);
        switch (cl) {
            case ot_layout_1.Gdef.GlyphClass.Base:
                base.update(inSet);
                cov.add(g);
                break;
            case ot_layout_1.Gdef.GlyphClass.Ligature:
                ligature.update(inSet);
                cov.add(g);
                break;
            case ot_layout_1.Gdef.GlyphClass.Mark:
                mark.update(inSet);
                cov.add(g);
        }
    }
    if (base.mix || ligature.mix || mark.mix)
        return null;
    for (const g of gs)
        if (!cov.has(g))
            return null;
    return {
        ignoreBaseGlyphs: base.has,
        ignoreLigatures: ligature.has,
        ignoreMarks: mark.has
    };
}
function igcMarkAttachmentClass(gs, maCd) {
    if (!gs || !gs.size || !maCd)
        return null;
    // Get an matching mark class
    let kMark = undefined;
    for (const g of gs) {
        const kg = maCd.get(g);
        if (kg === undefined)
            return null;
        if (kMark === undefined)
            kMark = kg;
        else if (kg !== kMark)
            return null;
    }
    // ensure the glyph set satisfying this mark class equal to GS
    if (kMark === undefined)
        return null;
    for (const [g, cl] of maCd) {
        if (cl === kMark && !gs.has(g))
            return null;
    }
    return {
        ignoreBaseGlyphs: false,
        ignoreLigatures: false,
        ignoreMarks: false,
        markAttachmentType: kMark
    };
}
function setEqual(a, b) {
    for (const g of a)
        if (!b.has(g))
            return false;
    for (const g of b)
        if (!a.has(g))
            return false;
    return true;
}
function igfMarkGlyphSet(gs, mgs) {
    if (!mgs || !gs || !gs.size)
        return null;
    for (let mgsIndex = 0; mgsIndex < mgs.length; mgsIndex++) {
        if (setEqual(gs, mgs[mgsIndex])) {
            return {
                ignoreBaseGlyphs: false,
                ignoreLigatures: false,
                ignoreMarks: false,
                markFilteringSet: mgsIndex
            };
        }
    }
    return null;
}
//# sourceMappingURL=decide-ignore-flags.js.map