import { BinaryView, Frag } from "@ot-builder/bin-util";
import * as ImpLib from "@ot-builder/common-impl";
import { Gpos } from "@ot-builder/ot-layout";
import { Data } from "@ot-builder/prelude";
import { ReadTimeIVS, WriteTimeIVS } from "@ot-builder/var-store";
import { OtVar } from "@ot-builder/variance";
export declare enum GposAdjustmentFormat {
    X_PLACEMENT = 1,
    Y_PLACEMENT = 2,
    X_ADVANCE = 4,
    Y_ADVANCE = 8,
    X_PLACEMENT_DEVICE = 16,
    Y_PLACEMENT_DEVICE = 32,
    X_ADVANCE_DEVICE = 64,
    Y_ADVANCE_DEVICE = 128
}
export declare const GposAdjustment: {
    read(view: BinaryView, format: number, ivs: Data.Maybe<ReadTimeIVS>): Gpos.Adjustment;
    write(b: Frag, adj: Gpos.Adjustment, format: number, ivs: Data.Maybe<WriteTimeIVS>): void;
    measure(adj: Gpos.Adjustment, format: number): number;
    decideFormat(adj: Gpos.Adjustment): GposAdjustmentFormat;
    hash(adj: Gpos.Adjustment, ivs?: Data.Maybe<WriteTimeIVS>): string;
    hashPair(adj: Gpos.AdjustmentPair, ivs?: Data.Maybe<WriteTimeIVS>): string;
};
export declare function hashVarVal(h: ImpLib.Hasher, ivs: Data.Maybe<WriteTimeIVS>, x: OtVar.Value, device: Data.Maybe<ReadonlyArray<number>>): void;
//# sourceMappingURL=gpos-adjust.d.ts.map