import { UInt16 } from "@ot-builder/primitive";
import { OtVar } from "@ot-builder/variance";
export declare const Tag = "fvar";
export declare enum AxisFlags {
    Default = 0,
    Hidden = 1
}
export declare class Axis {
    readonly dim: OtVar.Dim;
    readonly flags: AxisFlags;
    readonly axisNameID: UInt16;
    constructor(dim: OtVar.Dim, flags: AxisFlags, axisNameID: UInt16);
}
export declare enum InstanceFlags {
    Default = 0
}
export declare class Instance {
    readonly subfamilyNameID: number;
    readonly flags: InstanceFlags;
    readonly coordinates: OtVar.Instance;
    readonly postScriptNameID?: number | undefined;
    constructor(subfamilyNameID: number, flags: InstanceFlags, coordinates: OtVar.Instance, postScriptNameID?: number | undefined);
}
export declare class Table {
    axes: Axis[];
    instances: Instance[];
    constructor(axes?: Axis[], instances?: Instance[]);
    getDesignSpace(): import("@ot-builder/prelude/lib/data").Order<OtVar.Dim>;
}
//# sourceMappingURL=fvar.d.ts.map