import { DerivableFunction } from "./interface";
export declare namespace D {
    class Const implements DerivableFunction {
        private readonly t;
        constructor(t: number);
        eval(): number;
        derivative(): number;
    }
    const Param: DerivableFunction;
    class Add implements DerivableFunction {
        private readonly a;
        private readonly b;
        constructor(a: DerivableFunction, b: DerivableFunction);
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Sub implements DerivableFunction {
        private readonly a;
        private readonly b;
        constructor(a: DerivableFunction, b: DerivableFunction);
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Mul implements DerivableFunction {
        private readonly a;
        private readonly b;
        constructor(a: DerivableFunction, b: DerivableFunction);
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Div implements DerivableFunction {
        private readonly a;
        private readonly b;
        constructor(a: DerivableFunction, b: DerivableFunction);
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Co implements DerivableFunction {
        private readonly a;
        constructor(a: DerivableFunction);
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Nest implements DerivableFunction {
        private readonly a;
        private readonly b;
        constructor(a: DerivableFunction, b: DerivableFunction);
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Pow implements DerivableFunction {
        p: number;
        constructor(p: number);
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Hermite00 implements DerivableFunction {
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Hermite01 implements DerivableFunction {
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Hermite10 implements DerivableFunction {
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Hermite11 implements DerivableFunction {
        eval(t: number): number;
        derivative(t: number): number;
    }
    class Slice implements DerivableFunction {
        private readonly start;
        private readonly end;
        constructor(start: number, end: number);
        eval(t: number): number;
        derivative(t: number): number;
    }
}
