------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUN-TIME COMPONENTS                         --
--                                                                          --
--            G N A T . S E C O N D A R Y _ S T A C K _ I N F O             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                      Copyright (C) 2004-2026, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
-- As a special exception under Section 7 of GPL version 3, you are granted --
-- additional permissions described in the GCC Runtime Library Exception,   --
-- version 3.1, as published by the Free Software Foundation.               --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  This package provides a public interface to the internal package
--  ``System.Secondary_Stack``. It allows users to query the current high water
--  mark of the secondary stack, the stack used to return unconstrained types.

with System.Secondary_Stack;

package GNAT.Secondary_Stack_Info is

   function SS_Get_Max return Long_Long_Integer
     renames System.Secondary_Stack.SS_Get_Max;
   --  Return the high water mark of the secondary stack for the current
   --  secondary stack in bytes.

end GNAT.Secondary_Stack_Info;
