/* GCompris - ActivityInfo.qml
 *
 * Copyright (C) 2016 Stefan Toncu <stefan.toncu29@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses/>.
 */
import GCompris 1.0

ActivityInfo {
  name: "share/Share.qml"
  difficulty: 2
  icon: "share/share.svg"
  author: "Stefan Toncu &lt;stefan.toncu29@gmail.com&gt;"
  //: Activity title
  title: qsTr("Share pieces of candy")
  //: Help title
  description: qsTr("Try to split the pieces of candy between a given number of children.")
  //intro: "Share the candies equally among the specified number of children and notice that there may be a rest left"
  //: Help goal
  goal: qsTr("Learn division of numbers.")
  //: Help prerequisite
  prerequisite: qsTr("Know how to count.")
  //: Help manual
  manual: qsTr("Follow the instructions shown on the screen: first, drag the given number of boys/girls to the center, then drag pieces of candy to each child's rectangle.") + ("<br>") +
    qsTr("If there is a rest, it needs to be placed inside the candy jar.")
  credit: ""
  section: "math arithmetic"
  createdInVersion: 7000
  levels :"1,2,3"
}
