//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpeering

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// RegisteredAsnsClient contains the methods for the RegisteredAsns group.
// Don't use this type directly, use NewRegisteredAsnsClient() instead.
type RegisteredAsnsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewRegisteredAsnsClient creates a new instance of RegisteredAsnsClient with the specified values.
// subscriptionID - The Azure subscription ID.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewRegisteredAsnsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*RegisteredAsnsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &RegisteredAsnsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates a new registered ASN with the specified name under the given subscription, resource group and
// peering.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// resourceGroupName - The name of the resource group.
// peeringName - The name of the peering.
// registeredAsnName - The name of the ASN.
// registeredAsn - The properties needed to create a registered ASN.
// options - RegisteredAsnsClientCreateOrUpdateOptions contains the optional parameters for the RegisteredAsnsClient.CreateOrUpdate
// method.
func (client *RegisteredAsnsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, peeringName string, registeredAsnName string, registeredAsn RegisteredAsn, options *RegisteredAsnsClientCreateOrUpdateOptions) (RegisteredAsnsClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, peeringName, registeredAsnName, registeredAsn, options)
	if err != nil {
		return RegisteredAsnsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RegisteredAsnsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return RegisteredAsnsClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *RegisteredAsnsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, peeringName string, registeredAsnName string, registeredAsn RegisteredAsn, options *RegisteredAsnsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}/registeredAsns/{registeredAsnName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if peeringName == "" {
		return nil, errors.New("parameter peeringName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{peeringName}", url.PathEscape(peeringName))
	if registeredAsnName == "" {
		return nil, errors.New("parameter registeredAsnName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{registeredAsnName}", url.PathEscape(registeredAsnName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, registeredAsn)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *RegisteredAsnsClient) createOrUpdateHandleResponse(resp *http.Response) (RegisteredAsnsClientCreateOrUpdateResponse, error) {
	result := RegisteredAsnsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RegisteredAsn); err != nil {
		return RegisteredAsnsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes an existing registered ASN with the specified name under the given subscription, resource group and peering.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// resourceGroupName - The name of the resource group.
// peeringName - The name of the peering.
// registeredAsnName - The name of the registered ASN.
// options - RegisteredAsnsClientDeleteOptions contains the optional parameters for the RegisteredAsnsClient.Delete method.
func (client *RegisteredAsnsClient) Delete(ctx context.Context, resourceGroupName string, peeringName string, registeredAsnName string, options *RegisteredAsnsClientDeleteOptions) (RegisteredAsnsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, peeringName, registeredAsnName, options)
	if err != nil {
		return RegisteredAsnsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RegisteredAsnsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return RegisteredAsnsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return RegisteredAsnsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *RegisteredAsnsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, peeringName string, registeredAsnName string, options *RegisteredAsnsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}/registeredAsns/{registeredAsnName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if peeringName == "" {
		return nil, errors.New("parameter peeringName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{peeringName}", url.PathEscape(peeringName))
	if registeredAsnName == "" {
		return nil, errors.New("parameter registeredAsnName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{registeredAsnName}", url.PathEscape(registeredAsnName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets an existing registered ASN with the specified name under the given subscription, resource group and peering.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// resourceGroupName - The name of the resource group.
// peeringName - The name of the peering.
// registeredAsnName - The name of the registered ASN.
// options - RegisteredAsnsClientGetOptions contains the optional parameters for the RegisteredAsnsClient.Get method.
func (client *RegisteredAsnsClient) Get(ctx context.Context, resourceGroupName string, peeringName string, registeredAsnName string, options *RegisteredAsnsClientGetOptions) (RegisteredAsnsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, peeringName, registeredAsnName, options)
	if err != nil {
		return RegisteredAsnsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RegisteredAsnsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RegisteredAsnsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *RegisteredAsnsClient) getCreateRequest(ctx context.Context, resourceGroupName string, peeringName string, registeredAsnName string, options *RegisteredAsnsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}/registeredAsns/{registeredAsnName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if peeringName == "" {
		return nil, errors.New("parameter peeringName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{peeringName}", url.PathEscape(peeringName))
	if registeredAsnName == "" {
		return nil, errors.New("parameter registeredAsnName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{registeredAsnName}", url.PathEscape(registeredAsnName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *RegisteredAsnsClient) getHandleResponse(resp *http.Response) (RegisteredAsnsClientGetResponse, error) {
	result := RegisteredAsnsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RegisteredAsn); err != nil {
		return RegisteredAsnsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByPeeringPager - Lists all registered ASNs under the given subscription, resource group and peering.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-01-01
// resourceGroupName - The name of the resource group.
// peeringName - The name of the peering.
// options - RegisteredAsnsClientListByPeeringOptions contains the optional parameters for the RegisteredAsnsClient.ListByPeering
// method.
func (client *RegisteredAsnsClient) NewListByPeeringPager(resourceGroupName string, peeringName string, options *RegisteredAsnsClientListByPeeringOptions) *runtime.Pager[RegisteredAsnsClientListByPeeringResponse] {
	return runtime.NewPager(runtime.PagingHandler[RegisteredAsnsClientListByPeeringResponse]{
		More: func(page RegisteredAsnsClientListByPeeringResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RegisteredAsnsClientListByPeeringResponse) (RegisteredAsnsClientListByPeeringResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByPeeringCreateRequest(ctx, resourceGroupName, peeringName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return RegisteredAsnsClientListByPeeringResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return RegisteredAsnsClientListByPeeringResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return RegisteredAsnsClientListByPeeringResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByPeeringHandleResponse(resp)
		},
	})
}

// listByPeeringCreateRequest creates the ListByPeering request.
func (client *RegisteredAsnsClient) listByPeeringCreateRequest(ctx context.Context, resourceGroupName string, peeringName string, options *RegisteredAsnsClientListByPeeringOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}/registeredAsns"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if peeringName == "" {
		return nil, errors.New("parameter peeringName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{peeringName}", url.PathEscape(peeringName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByPeeringHandleResponse handles the ListByPeering response.
func (client *RegisteredAsnsClient) listByPeeringHandleResponse(resp *http.Response) (RegisteredAsnsClientListByPeeringResponse, error) {
	result := RegisteredAsnsClientListByPeeringResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RegisteredAsnListResult); err != nil {
		return RegisteredAsnsClientListByPeeringResponse{}, err
	}
	return result, nil
}
