//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicebus

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type CorrelationFilter.
func (c CorrelationFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "contentType", c.ContentType)
	populate(objectMap, "correlationId", c.CorrelationID)
	populate(objectMap, "label", c.Label)
	populate(objectMap, "messageId", c.MessageID)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "replyTo", c.ReplyTo)
	populate(objectMap, "replyToSessionId", c.ReplyToSessionID)
	populate(objectMap, "requiresPreprocessing", c.RequiresPreprocessing)
	populate(objectMap, "sessionId", c.SessionID)
	populate(objectMap, "to", c.To)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Encryption.
func (e Encryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "keySource", e.KeySource)
	populate(objectMap, "keyVaultProperties", e.KeyVaultProperties)
	populate(objectMap, "requireInfrastructureEncryption", e.RequireInfrastructureEncryption)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type NetworkRuleSetProperties.
func (n NetworkRuleSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultAction", n.DefaultAction)
	populate(objectMap, "ipRules", n.IPRules)
	populate(objectMap, "publicNetworkAccess", n.PublicNetworkAccess)
	populate(objectMap, "trustedServiceAccessEnabled", n.TrustedServiceAccessEnabled)
	populate(objectMap, "virtualNetworkRules", n.VirtualNetworkRules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNamespacePatch.
func (r ResourceNamespacePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SBAuthorizationRuleProperties.
func (s SBAuthorizationRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "rights", s.Rights)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SBNamespace.
func (s SBNamespace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SBNamespaceProperties.
func (s SBNamespaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alternateName", s.AlternateName)
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "disableLocalAuth", s.DisableLocalAuth)
	populate(objectMap, "encryption", s.Encryption)
	populate(objectMap, "metricId", s.MetricID)
	populate(objectMap, "minimumTlsVersion", s.MinimumTLSVersion)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", s.PublicNetworkAccess)
	populate(objectMap, "serviceBusEndpoint", s.ServiceBusEndpoint)
	populate(objectMap, "status", s.Status)
	populateTimeRFC3339(objectMap, "updatedAt", s.UpdatedAt)
	populate(objectMap, "zoneRedundant", s.ZoneRedundant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SBNamespaceProperties.
func (s *SBNamespaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateName":
			err = unpopulate(val, "AlternateName", &s.AlternateName)
			delete(rawMsg, key)
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &s.DisableLocalAuth)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &s.Encryption)
			delete(rawMsg, key)
		case "metricId":
			err = unpopulate(val, "MetricID", &s.MetricID)
			delete(rawMsg, key)
		case "minimumTlsVersion":
			err = unpopulate(val, "MinimumTLSVersion", &s.MinimumTLSVersion)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &s.PublicNetworkAccess)
			delete(rawMsg, key)
		case "serviceBusEndpoint":
			err = unpopulate(val, "ServiceBusEndpoint", &s.ServiceBusEndpoint)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "updatedAt":
			err = unpopulateTimeRFC3339(val, "UpdatedAt", &s.UpdatedAt)
			delete(rawMsg, key)
		case "zoneRedundant":
			err = unpopulate(val, "ZoneRedundant", &s.ZoneRedundant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SBNamespaceUpdateParameters.
func (s SBNamespaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SBNamespaceUpdateProperties.
func (s SBNamespaceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alternateName", s.AlternateName)
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "disableLocalAuth", s.DisableLocalAuth)
	populate(objectMap, "encryption", s.Encryption)
	populate(objectMap, "metricId", s.MetricID)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "serviceBusEndpoint", s.ServiceBusEndpoint)
	populate(objectMap, "status", s.Status)
	populateTimeRFC3339(objectMap, "updatedAt", s.UpdatedAt)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SBNamespaceUpdateProperties.
func (s *SBNamespaceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateName":
			err = unpopulate(val, "AlternateName", &s.AlternateName)
			delete(rawMsg, key)
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &s.DisableLocalAuth)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &s.Encryption)
			delete(rawMsg, key)
		case "metricId":
			err = unpopulate(val, "MetricID", &s.MetricID)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "serviceBusEndpoint":
			err = unpopulate(val, "ServiceBusEndpoint", &s.ServiceBusEndpoint)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "updatedAt":
			err = unpopulateTimeRFC3339(val, "UpdatedAt", &s.UpdatedAt)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SBQueueProperties.
func (s SBQueueProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "accessedAt", s.AccessedAt)
	populate(objectMap, "autoDeleteOnIdle", s.AutoDeleteOnIdle)
	populate(objectMap, "countDetails", s.CountDetails)
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "deadLetteringOnMessageExpiration", s.DeadLetteringOnMessageExpiration)
	populate(objectMap, "defaultMessageTimeToLive", s.DefaultMessageTimeToLive)
	populate(objectMap, "duplicateDetectionHistoryTimeWindow", s.DuplicateDetectionHistoryTimeWindow)
	populate(objectMap, "enableBatchedOperations", s.EnableBatchedOperations)
	populate(objectMap, "enableExpress", s.EnableExpress)
	populate(objectMap, "enablePartitioning", s.EnablePartitioning)
	populate(objectMap, "forwardDeadLetteredMessagesTo", s.ForwardDeadLetteredMessagesTo)
	populate(objectMap, "forwardTo", s.ForwardTo)
	populate(objectMap, "lockDuration", s.LockDuration)
	populate(objectMap, "maxDeliveryCount", s.MaxDeliveryCount)
	populate(objectMap, "maxMessageSizeInKilobytes", s.MaxMessageSizeInKilobytes)
	populate(objectMap, "maxSizeInMegabytes", s.MaxSizeInMegabytes)
	populate(objectMap, "messageCount", s.MessageCount)
	populate(objectMap, "requiresDuplicateDetection", s.RequiresDuplicateDetection)
	populate(objectMap, "requiresSession", s.RequiresSession)
	populate(objectMap, "sizeInBytes", s.SizeInBytes)
	populate(objectMap, "status", s.Status)
	populateTimeRFC3339(objectMap, "updatedAt", s.UpdatedAt)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SBQueueProperties.
func (s *SBQueueProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessedAt":
			err = unpopulateTimeRFC3339(val, "AccessedAt", &s.AccessedAt)
			delete(rawMsg, key)
		case "autoDeleteOnIdle":
			err = unpopulate(val, "AutoDeleteOnIdle", &s.AutoDeleteOnIdle)
			delete(rawMsg, key)
		case "countDetails":
			err = unpopulate(val, "CountDetails", &s.CountDetails)
			delete(rawMsg, key)
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "deadLetteringOnMessageExpiration":
			err = unpopulate(val, "DeadLetteringOnMessageExpiration", &s.DeadLetteringOnMessageExpiration)
			delete(rawMsg, key)
		case "defaultMessageTimeToLive":
			err = unpopulate(val, "DefaultMessageTimeToLive", &s.DefaultMessageTimeToLive)
			delete(rawMsg, key)
		case "duplicateDetectionHistoryTimeWindow":
			err = unpopulate(val, "DuplicateDetectionHistoryTimeWindow", &s.DuplicateDetectionHistoryTimeWindow)
			delete(rawMsg, key)
		case "enableBatchedOperations":
			err = unpopulate(val, "EnableBatchedOperations", &s.EnableBatchedOperations)
			delete(rawMsg, key)
		case "enableExpress":
			err = unpopulate(val, "EnableExpress", &s.EnableExpress)
			delete(rawMsg, key)
		case "enablePartitioning":
			err = unpopulate(val, "EnablePartitioning", &s.EnablePartitioning)
			delete(rawMsg, key)
		case "forwardDeadLetteredMessagesTo":
			err = unpopulate(val, "ForwardDeadLetteredMessagesTo", &s.ForwardDeadLetteredMessagesTo)
			delete(rawMsg, key)
		case "forwardTo":
			err = unpopulate(val, "ForwardTo", &s.ForwardTo)
			delete(rawMsg, key)
		case "lockDuration":
			err = unpopulate(val, "LockDuration", &s.LockDuration)
			delete(rawMsg, key)
		case "maxDeliveryCount":
			err = unpopulate(val, "MaxDeliveryCount", &s.MaxDeliveryCount)
			delete(rawMsg, key)
		case "maxMessageSizeInKilobytes":
			err = unpopulate(val, "MaxMessageSizeInKilobytes", &s.MaxMessageSizeInKilobytes)
			delete(rawMsg, key)
		case "maxSizeInMegabytes":
			err = unpopulate(val, "MaxSizeInMegabytes", &s.MaxSizeInMegabytes)
			delete(rawMsg, key)
		case "messageCount":
			err = unpopulate(val, "MessageCount", &s.MessageCount)
			delete(rawMsg, key)
		case "requiresDuplicateDetection":
			err = unpopulate(val, "RequiresDuplicateDetection", &s.RequiresDuplicateDetection)
			delete(rawMsg, key)
		case "requiresSession":
			err = unpopulate(val, "RequiresSession", &s.RequiresSession)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &s.SizeInBytes)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "updatedAt":
			err = unpopulateTimeRFC3339(val, "UpdatedAt", &s.UpdatedAt)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SBSubscriptionProperties.
func (s SBSubscriptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "accessedAt", s.AccessedAt)
	populate(objectMap, "autoDeleteOnIdle", s.AutoDeleteOnIdle)
	populate(objectMap, "clientAffineProperties", s.ClientAffineProperties)
	populate(objectMap, "countDetails", s.CountDetails)
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "deadLetteringOnFilterEvaluationExceptions", s.DeadLetteringOnFilterEvaluationExceptions)
	populate(objectMap, "deadLetteringOnMessageExpiration", s.DeadLetteringOnMessageExpiration)
	populate(objectMap, "defaultMessageTimeToLive", s.DefaultMessageTimeToLive)
	populate(objectMap, "duplicateDetectionHistoryTimeWindow", s.DuplicateDetectionHistoryTimeWindow)
	populate(objectMap, "enableBatchedOperations", s.EnableBatchedOperations)
	populate(objectMap, "forwardDeadLetteredMessagesTo", s.ForwardDeadLetteredMessagesTo)
	populate(objectMap, "forwardTo", s.ForwardTo)
	populate(objectMap, "isClientAffine", s.IsClientAffine)
	populate(objectMap, "lockDuration", s.LockDuration)
	populate(objectMap, "maxDeliveryCount", s.MaxDeliveryCount)
	populate(objectMap, "messageCount", s.MessageCount)
	populate(objectMap, "requiresSession", s.RequiresSession)
	populate(objectMap, "status", s.Status)
	populateTimeRFC3339(objectMap, "updatedAt", s.UpdatedAt)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SBSubscriptionProperties.
func (s *SBSubscriptionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessedAt":
			err = unpopulateTimeRFC3339(val, "AccessedAt", &s.AccessedAt)
			delete(rawMsg, key)
		case "autoDeleteOnIdle":
			err = unpopulate(val, "AutoDeleteOnIdle", &s.AutoDeleteOnIdle)
			delete(rawMsg, key)
		case "clientAffineProperties":
			err = unpopulate(val, "ClientAffineProperties", &s.ClientAffineProperties)
			delete(rawMsg, key)
		case "countDetails":
			err = unpopulate(val, "CountDetails", &s.CountDetails)
			delete(rawMsg, key)
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "deadLetteringOnFilterEvaluationExceptions":
			err = unpopulate(val, "DeadLetteringOnFilterEvaluationExceptions", &s.DeadLetteringOnFilterEvaluationExceptions)
			delete(rawMsg, key)
		case "deadLetteringOnMessageExpiration":
			err = unpopulate(val, "DeadLetteringOnMessageExpiration", &s.DeadLetteringOnMessageExpiration)
			delete(rawMsg, key)
		case "defaultMessageTimeToLive":
			err = unpopulate(val, "DefaultMessageTimeToLive", &s.DefaultMessageTimeToLive)
			delete(rawMsg, key)
		case "duplicateDetectionHistoryTimeWindow":
			err = unpopulate(val, "DuplicateDetectionHistoryTimeWindow", &s.DuplicateDetectionHistoryTimeWindow)
			delete(rawMsg, key)
		case "enableBatchedOperations":
			err = unpopulate(val, "EnableBatchedOperations", &s.EnableBatchedOperations)
			delete(rawMsg, key)
		case "forwardDeadLetteredMessagesTo":
			err = unpopulate(val, "ForwardDeadLetteredMessagesTo", &s.ForwardDeadLetteredMessagesTo)
			delete(rawMsg, key)
		case "forwardTo":
			err = unpopulate(val, "ForwardTo", &s.ForwardTo)
			delete(rawMsg, key)
		case "isClientAffine":
			err = unpopulate(val, "IsClientAffine", &s.IsClientAffine)
			delete(rawMsg, key)
		case "lockDuration":
			err = unpopulate(val, "LockDuration", &s.LockDuration)
			delete(rawMsg, key)
		case "maxDeliveryCount":
			err = unpopulate(val, "MaxDeliveryCount", &s.MaxDeliveryCount)
			delete(rawMsg, key)
		case "messageCount":
			err = unpopulate(val, "MessageCount", &s.MessageCount)
			delete(rawMsg, key)
		case "requiresSession":
			err = unpopulate(val, "RequiresSession", &s.RequiresSession)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "updatedAt":
			err = unpopulateTimeRFC3339(val, "UpdatedAt", &s.UpdatedAt)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SBTopicProperties.
func (s SBTopicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "accessedAt", s.AccessedAt)
	populate(objectMap, "autoDeleteOnIdle", s.AutoDeleteOnIdle)
	populate(objectMap, "countDetails", s.CountDetails)
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "defaultMessageTimeToLive", s.DefaultMessageTimeToLive)
	populate(objectMap, "duplicateDetectionHistoryTimeWindow", s.DuplicateDetectionHistoryTimeWindow)
	populate(objectMap, "enableBatchedOperations", s.EnableBatchedOperations)
	populate(objectMap, "enableExpress", s.EnableExpress)
	populate(objectMap, "enablePartitioning", s.EnablePartitioning)
	populate(objectMap, "maxMessageSizeInKilobytes", s.MaxMessageSizeInKilobytes)
	populate(objectMap, "maxSizeInMegabytes", s.MaxSizeInMegabytes)
	populate(objectMap, "requiresDuplicateDetection", s.RequiresDuplicateDetection)
	populate(objectMap, "sizeInBytes", s.SizeInBytes)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "subscriptionCount", s.SubscriptionCount)
	populate(objectMap, "supportOrdering", s.SupportOrdering)
	populateTimeRFC3339(objectMap, "updatedAt", s.UpdatedAt)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SBTopicProperties.
func (s *SBTopicProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessedAt":
			err = unpopulateTimeRFC3339(val, "AccessedAt", &s.AccessedAt)
			delete(rawMsg, key)
		case "autoDeleteOnIdle":
			err = unpopulate(val, "AutoDeleteOnIdle", &s.AutoDeleteOnIdle)
			delete(rawMsg, key)
		case "countDetails":
			err = unpopulate(val, "CountDetails", &s.CountDetails)
			delete(rawMsg, key)
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "defaultMessageTimeToLive":
			err = unpopulate(val, "DefaultMessageTimeToLive", &s.DefaultMessageTimeToLive)
			delete(rawMsg, key)
		case "duplicateDetectionHistoryTimeWindow":
			err = unpopulate(val, "DuplicateDetectionHistoryTimeWindow", &s.DuplicateDetectionHistoryTimeWindow)
			delete(rawMsg, key)
		case "enableBatchedOperations":
			err = unpopulate(val, "EnableBatchedOperations", &s.EnableBatchedOperations)
			delete(rawMsg, key)
		case "enableExpress":
			err = unpopulate(val, "EnableExpress", &s.EnableExpress)
			delete(rawMsg, key)
		case "enablePartitioning":
			err = unpopulate(val, "EnablePartitioning", &s.EnablePartitioning)
			delete(rawMsg, key)
		case "maxMessageSizeInKilobytes":
			err = unpopulate(val, "MaxMessageSizeInKilobytes", &s.MaxMessageSizeInKilobytes)
			delete(rawMsg, key)
		case "maxSizeInMegabytes":
			err = unpopulate(val, "MaxSizeInMegabytes", &s.MaxSizeInMegabytes)
			delete(rawMsg, key)
		case "requiresDuplicateDetection":
			err = unpopulate(val, "RequiresDuplicateDetection", &s.RequiresDuplicateDetection)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &s.SizeInBytes)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "subscriptionCount":
			err = unpopulate(val, "SubscriptionCount", &s.SubscriptionCount)
			delete(rawMsg, key)
		case "supportOrdering":
			err = unpopulate(val, "SupportOrdering", &s.SupportOrdering)
			delete(rawMsg, key)
		case "updatedAt":
			err = unpopulateTimeRFC3339(val, "UpdatedAt", &s.UpdatedAt)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
