//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

const (
	moduleName    = "armsynapse"
	moduleVersion = "v0.5.0"
)

type AzureADOnlyAuthenticationName string

const (
	AzureADOnlyAuthenticationNameDefault AzureADOnlyAuthenticationName = "default"
)

// PossibleAzureADOnlyAuthenticationNameValues returns the possible values for the AzureADOnlyAuthenticationName const type.
func PossibleAzureADOnlyAuthenticationNameValues() []AzureADOnlyAuthenticationName {
	return []AzureADOnlyAuthenticationName{
		AzureADOnlyAuthenticationNameDefault,
	}
}

// AzureScaleType - Scale type.
type AzureScaleType string

const (
	AzureScaleTypeAutomatic AzureScaleType = "automatic"
	AzureScaleTypeManual    AzureScaleType = "manual"
	AzureScaleTypeNone      AzureScaleType = "none"
)

// PossibleAzureScaleTypeValues returns the possible values for the AzureScaleType const type.
func PossibleAzureScaleTypeValues() []AzureScaleType {
	return []AzureScaleType{
		AzureScaleTypeAutomatic,
		AzureScaleTypeManual,
		AzureScaleTypeNone,
	}
}

type BlobAuditingPolicyName string

const (
	BlobAuditingPolicyNameDefault BlobAuditingPolicyName = "default"
)

// PossibleBlobAuditingPolicyNameValues returns the possible values for the BlobAuditingPolicyName const type.
func PossibleBlobAuditingPolicyNameValues() []BlobAuditingPolicyName {
	return []BlobAuditingPolicyName{
		BlobAuditingPolicyNameDefault,
	}
}

// BlobAuditingPolicyState - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled
// are required.
type BlobAuditingPolicyState string

const (
	BlobAuditingPolicyStateEnabled  BlobAuditingPolicyState = "Enabled"
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = "Disabled"
)

// PossibleBlobAuditingPolicyStateValues returns the possible values for the BlobAuditingPolicyState const type.
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return []BlobAuditingPolicyState{
		BlobAuditingPolicyStateEnabled,
		BlobAuditingPolicyStateDisabled,
	}
}

// BlobStorageEventType - The name of blob storage event type to process.
type BlobStorageEventType string

const (
	BlobStorageEventTypeMicrosoftStorageBlobCreated BlobStorageEventType = "Microsoft.Storage.BlobCreated"
	BlobStorageEventTypeMicrosoftStorageBlobRenamed BlobStorageEventType = "Microsoft.Storage.BlobRenamed"
)

// PossibleBlobStorageEventTypeValues returns the possible values for the BlobStorageEventType const type.
func PossibleBlobStorageEventTypeValues() []BlobStorageEventType {
	return []BlobStorageEventType{
		BlobStorageEventTypeMicrosoftStorageBlobCreated,
		BlobStorageEventTypeMicrosoftStorageBlobRenamed,
	}
}

// ClusterPrincipalRole - Cluster principal role.
type ClusterPrincipalRole string

const (
	ClusterPrincipalRoleAllDatabasesAdmin  ClusterPrincipalRole = "AllDatabasesAdmin"
	ClusterPrincipalRoleAllDatabasesViewer ClusterPrincipalRole = "AllDatabasesViewer"
)

// PossibleClusterPrincipalRoleValues returns the possible values for the ClusterPrincipalRole const type.
func PossibleClusterPrincipalRoleValues() []ClusterPrincipalRole {
	return []ClusterPrincipalRole{
		ClusterPrincipalRoleAllDatabasesAdmin,
		ClusterPrincipalRoleAllDatabasesViewer,
	}
}

// ColumnDataType - The column data type.
type ColumnDataType string

const (
	ColumnDataTypeBigint           ColumnDataType = "bigint"
	ColumnDataTypeBinary           ColumnDataType = "binary"
	ColumnDataTypeBit              ColumnDataType = "bit"
	ColumnDataTypeChar             ColumnDataType = "char"
	ColumnDataTypeDate             ColumnDataType = "date"
	ColumnDataTypeDatetime         ColumnDataType = "datetime"
	ColumnDataTypeDatetime2        ColumnDataType = "datetime2"
	ColumnDataTypeDatetimeoffset   ColumnDataType = "datetimeoffset"
	ColumnDataTypeDecimal          ColumnDataType = "decimal"
	ColumnDataTypeFloat            ColumnDataType = "float"
	ColumnDataTypeGeography        ColumnDataType = "geography"
	ColumnDataTypeGeometry         ColumnDataType = "geometry"
	ColumnDataTypeHierarchyid      ColumnDataType = "hierarchyid"
	ColumnDataTypeImage            ColumnDataType = "image"
	ColumnDataTypeInt              ColumnDataType = "int"
	ColumnDataTypeMoney            ColumnDataType = "money"
	ColumnDataTypeNchar            ColumnDataType = "nchar"
	ColumnDataTypeNtext            ColumnDataType = "ntext"
	ColumnDataTypeNumeric          ColumnDataType = "numeric"
	ColumnDataTypeNvarchar         ColumnDataType = "nvarchar"
	ColumnDataTypeReal             ColumnDataType = "real"
	ColumnDataTypeSQLVariant       ColumnDataType = "sql_variant"
	ColumnDataTypeSmalldatetime    ColumnDataType = "smalldatetime"
	ColumnDataTypeSmallint         ColumnDataType = "smallint"
	ColumnDataTypeSmallmoney       ColumnDataType = "smallmoney"
	ColumnDataTypeSysname          ColumnDataType = "sysname"
	ColumnDataTypeText             ColumnDataType = "text"
	ColumnDataTypeTime             ColumnDataType = "time"
	ColumnDataTypeTimestamp        ColumnDataType = "timestamp"
	ColumnDataTypeTinyint          ColumnDataType = "tinyint"
	ColumnDataTypeUniqueidentifier ColumnDataType = "uniqueidentifier"
	ColumnDataTypeVarbinary        ColumnDataType = "varbinary"
	ColumnDataTypeVarchar          ColumnDataType = "varchar"
	ColumnDataTypeXML              ColumnDataType = "xml"
)

// PossibleColumnDataTypeValues returns the possible values for the ColumnDataType const type.
func PossibleColumnDataTypeValues() []ColumnDataType {
	return []ColumnDataType{
		ColumnDataTypeBigint,
		ColumnDataTypeBinary,
		ColumnDataTypeBit,
		ColumnDataTypeChar,
		ColumnDataTypeDate,
		ColumnDataTypeDatetime,
		ColumnDataTypeDatetime2,
		ColumnDataTypeDatetimeoffset,
		ColumnDataTypeDecimal,
		ColumnDataTypeFloat,
		ColumnDataTypeGeography,
		ColumnDataTypeGeometry,
		ColumnDataTypeHierarchyid,
		ColumnDataTypeImage,
		ColumnDataTypeInt,
		ColumnDataTypeMoney,
		ColumnDataTypeNchar,
		ColumnDataTypeNtext,
		ColumnDataTypeNumeric,
		ColumnDataTypeNvarchar,
		ColumnDataTypeReal,
		ColumnDataTypeSQLVariant,
		ColumnDataTypeSmalldatetime,
		ColumnDataTypeSmallint,
		ColumnDataTypeSmallmoney,
		ColumnDataTypeSysname,
		ColumnDataTypeText,
		ColumnDataTypeTime,
		ColumnDataTypeTimestamp,
		ColumnDataTypeTinyint,
		ColumnDataTypeUniqueidentifier,
		ColumnDataTypeVarbinary,
		ColumnDataTypeVarchar,
		ColumnDataTypeXML,
	}
}

// Compression - The compression type
type Compression string

const (
	CompressionGZip Compression = "GZip"
	CompressionNone Compression = "None"
)

// PossibleCompressionValues returns the possible values for the Compression const type.
func PossibleCompressionValues() []Compression {
	return []Compression{
		CompressionGZip,
		CompressionNone,
	}
}

// ConfigurationType - The type of the spark config properties file.
type ConfigurationType string

const (
	ConfigurationTypeArtifact ConfigurationType = "Artifact"
	ConfigurationTypeFile     ConfigurationType = "File"
)

// PossibleConfigurationTypeValues returns the possible values for the ConfigurationType const type.
func PossibleConfigurationTypeValues() []ConfigurationType {
	return []ConfigurationType{
		ConfigurationTypeArtifact,
		ConfigurationTypeFile,
	}
}

type ConnectionPolicyName string

const (
	ConnectionPolicyNameDefault ConnectionPolicyName = "default"
)

// PossibleConnectionPolicyNameValues returns the possible values for the ConnectionPolicyName const type.
func PossibleConnectionPolicyNameValues() []ConnectionPolicyName {
	return []ConnectionPolicyName{
		ConnectionPolicyNameDefault,
	}
}

// CreateMode - Specifies the mode of sql pool creation.
// Default: regular sql pool creation.
// PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must
// be specified as the resource ID of the existing sql pool, and
// restorePointInTime must be specified.
// Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId must be specified as the recoverableDatabaseId
// to restore.
// Restore: Creates a sql pool by restoring a backup of a deleted sql pool. SourceDatabaseId should be the sql pool's original
// resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be
// specified.
type CreateMode string

const (
	CreateModeDefault            CreateMode = "Default"
	CreateModePointInTimeRestore CreateMode = "PointInTimeRestore"
	CreateModeRecovery           CreateMode = "Recovery"
	CreateModeRestore            CreateMode = "Restore"
)

// PossibleCreateModeValues returns the possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{
		CreateModeDefault,
		CreateModePointInTimeRestore,
		CreateModeRecovery,
		CreateModeRestore,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DataConnectionKind - Kind of the endpoint for the data connection
type DataConnectionKind string

const (
	DataConnectionKindEventGrid DataConnectionKind = "EventGrid"
	DataConnectionKindEventHub  DataConnectionKind = "EventHub"
	DataConnectionKindIotHub    DataConnectionKind = "IotHub"
)

// PossibleDataConnectionKindValues returns the possible values for the DataConnectionKind const type.
func PossibleDataConnectionKindValues() []DataConnectionKind {
	return []DataConnectionKind{
		DataConnectionKindEventGrid,
		DataConnectionKindEventHub,
		DataConnectionKindIotHub,
	}
}

// DataFlowComputeType - Compute type of the cluster which will execute data flow job.
type DataFlowComputeType string

const (
	DataFlowComputeTypeComputeOptimized DataFlowComputeType = "ComputeOptimized"
	DataFlowComputeTypeGeneral          DataFlowComputeType = "General"
	DataFlowComputeTypeMemoryOptimized  DataFlowComputeType = "MemoryOptimized"
)

// PossibleDataFlowComputeTypeValues returns the possible values for the DataFlowComputeType const type.
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return []DataFlowComputeType{
		DataFlowComputeTypeComputeOptimized,
		DataFlowComputeTypeGeneral,
		DataFlowComputeTypeMemoryOptimized,
	}
}

// DataMaskingFunction - The masking function that is used for the data masking rule.
type DataMaskingFunction string

const (
	DataMaskingFunctionDefault DataMaskingFunction = "Default"
	DataMaskingFunctionCCN     DataMaskingFunction = "CCN"
	DataMaskingFunctionEmail   DataMaskingFunction = "Email"
	DataMaskingFunctionNumber  DataMaskingFunction = "Number"
	DataMaskingFunctionSSN     DataMaskingFunction = "SSN"
	DataMaskingFunctionText    DataMaskingFunction = "Text"
)

// PossibleDataMaskingFunctionValues returns the possible values for the DataMaskingFunction const type.
func PossibleDataMaskingFunctionValues() []DataMaskingFunction {
	return []DataMaskingFunction{
		DataMaskingFunctionDefault,
		DataMaskingFunctionCCN,
		DataMaskingFunctionEmail,
		DataMaskingFunctionNumber,
		DataMaskingFunctionSSN,
		DataMaskingFunctionText,
	}
}

// DataMaskingRuleState - The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName,
// columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't
// already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState.
type DataMaskingRuleState string

const (
	DataMaskingRuleStateDisabled DataMaskingRuleState = "Disabled"
	DataMaskingRuleStateEnabled  DataMaskingRuleState = "Enabled"
)

// PossibleDataMaskingRuleStateValues returns the possible values for the DataMaskingRuleState const type.
func PossibleDataMaskingRuleStateValues() []DataMaskingRuleState {
	return []DataMaskingRuleState{
		DataMaskingRuleStateDisabled,
		DataMaskingRuleStateEnabled,
	}
}

// DataMaskingState - The state of the data masking policy.
type DataMaskingState string

const (
	DataMaskingStateDisabled DataMaskingState = "Disabled"
	DataMaskingStateEnabled  DataMaskingState = "Enabled"
)

// PossibleDataMaskingStateValues returns the possible values for the DataMaskingState const type.
func PossibleDataMaskingStateValues() []DataMaskingState {
	return []DataMaskingState{
		DataMaskingStateDisabled,
		DataMaskingStateEnabled,
	}
}

type DataWarehouseUserActivityName string

const (
	DataWarehouseUserActivityNameCurrent DataWarehouseUserActivityName = "current"
)

// PossibleDataWarehouseUserActivityNameValues returns the possible values for the DataWarehouseUserActivityName const type.
func PossibleDataWarehouseUserActivityNameValues() []DataWarehouseUserActivityName {
	return []DataWarehouseUserActivityName{
		DataWarehouseUserActivityNameCurrent,
	}
}

// DatabasePrincipalRole - Database principal role.
type DatabasePrincipalRole string

const (
	DatabasePrincipalRoleAdmin              DatabasePrincipalRole = "Admin"
	DatabasePrincipalRoleIngestor           DatabasePrincipalRole = "Ingestor"
	DatabasePrincipalRoleMonitor            DatabasePrincipalRole = "Monitor"
	DatabasePrincipalRoleUnrestrictedViewer DatabasePrincipalRole = "UnrestrictedViewer"
	DatabasePrincipalRoleUser               DatabasePrincipalRole = "User"
	DatabasePrincipalRoleViewer             DatabasePrincipalRole = "Viewer"
)

// PossibleDatabasePrincipalRoleValues returns the possible values for the DatabasePrincipalRole const type.
func PossibleDatabasePrincipalRoleValues() []DatabasePrincipalRole {
	return []DatabasePrincipalRole{
		DatabasePrincipalRoleAdmin,
		DatabasePrincipalRoleIngestor,
		DatabasePrincipalRoleMonitor,
		DatabasePrincipalRoleUnrestrictedViewer,
		DatabasePrincipalRoleUser,
		DatabasePrincipalRoleViewer,
	}
}

// DayOfWeek - Day of maintenance window.
type DayOfWeek string

const (
	DayOfWeekFriday    DayOfWeek = "Friday"
	DayOfWeekMonday    DayOfWeek = "Monday"
	DayOfWeekSaturday  DayOfWeek = "Saturday"
	DayOfWeekSunday    DayOfWeek = "Sunday"
	DayOfWeekThursday  DayOfWeek = "Thursday"
	DayOfWeekTuesday   DayOfWeek = "Tuesday"
	DayOfWeekWednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns the possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{
		DayOfWeekFriday,
		DayOfWeekMonday,
		DayOfWeekSaturday,
		DayOfWeekSunday,
		DayOfWeekThursday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
	}
}

type DedicatedSQLMinimalTLSSettingsName string

const (
	DedicatedSQLMinimalTLSSettingsNameDefault DedicatedSQLMinimalTLSSettingsName = "default"
)

// PossibleDedicatedSQLMinimalTLSSettingsNameValues returns the possible values for the DedicatedSQLMinimalTLSSettingsName const type.
func PossibleDedicatedSQLMinimalTLSSettingsNameValues() []DedicatedSQLMinimalTLSSettingsName {
	return []DedicatedSQLMinimalTLSSettingsName{
		DedicatedSQLMinimalTLSSettingsNameDefault,
	}
}

// DefaultPrincipalsModificationKind - The default principals modification kind
type DefaultPrincipalsModificationKind string

const (
	DefaultPrincipalsModificationKindNone    DefaultPrincipalsModificationKind = "None"
	DefaultPrincipalsModificationKindReplace DefaultPrincipalsModificationKind = "Replace"
	DefaultPrincipalsModificationKindUnion   DefaultPrincipalsModificationKind = "Union"
)

// PossibleDefaultPrincipalsModificationKindValues returns the possible values for the DefaultPrincipalsModificationKind const type.
func PossibleDefaultPrincipalsModificationKindValues() []DefaultPrincipalsModificationKind {
	return []DefaultPrincipalsModificationKind{
		DefaultPrincipalsModificationKindNone,
		DefaultPrincipalsModificationKindReplace,
		DefaultPrincipalsModificationKindUnion,
	}
}

type EncryptionProtectorName string

const (
	EncryptionProtectorNameCurrent EncryptionProtectorName = "current"
)

// PossibleEncryptionProtectorNameValues returns the possible values for the EncryptionProtectorName const type.
func PossibleEncryptionProtectorNameValues() []EncryptionProtectorName {
	return []EncryptionProtectorName{
		EncryptionProtectorNameCurrent,
	}
}

// EventGridDataFormat - The data format of the message. Optionally the data format can be added to each message.
type EventGridDataFormat string

const (
	EventGridDataFormatAPACHEAVRO EventGridDataFormat = "APACHEAVRO"
	EventGridDataFormatAVRO       EventGridDataFormat = "AVRO"
	EventGridDataFormatCSV        EventGridDataFormat = "CSV"
	EventGridDataFormatJSON       EventGridDataFormat = "JSON"
	EventGridDataFormatMULTIJSON  EventGridDataFormat = "MULTIJSON"
	EventGridDataFormatORC        EventGridDataFormat = "ORC"
	EventGridDataFormatPARQUET    EventGridDataFormat = "PARQUET"
	EventGridDataFormatPSV        EventGridDataFormat = "PSV"
	EventGridDataFormatRAW        EventGridDataFormat = "RAW"
	EventGridDataFormatSCSV       EventGridDataFormat = "SCSV"
	EventGridDataFormatSINGLEJSON EventGridDataFormat = "SINGLEJSON"
	EventGridDataFormatSOHSV      EventGridDataFormat = "SOHSV"
	EventGridDataFormatTSV        EventGridDataFormat = "TSV"
	EventGridDataFormatTSVE       EventGridDataFormat = "TSVE"
	EventGridDataFormatTXT        EventGridDataFormat = "TXT"
	EventGridDataFormatW3CLOGFILE EventGridDataFormat = "W3CLOGFILE"
)

// PossibleEventGridDataFormatValues returns the possible values for the EventGridDataFormat const type.
func PossibleEventGridDataFormatValues() []EventGridDataFormat {
	return []EventGridDataFormat{
		EventGridDataFormatAPACHEAVRO,
		EventGridDataFormatAVRO,
		EventGridDataFormatCSV,
		EventGridDataFormatJSON,
		EventGridDataFormatMULTIJSON,
		EventGridDataFormatORC,
		EventGridDataFormatPARQUET,
		EventGridDataFormatPSV,
		EventGridDataFormatRAW,
		EventGridDataFormatSCSV,
		EventGridDataFormatSINGLEJSON,
		EventGridDataFormatSOHSV,
		EventGridDataFormatTSV,
		EventGridDataFormatTSVE,
		EventGridDataFormatTXT,
		EventGridDataFormatW3CLOGFILE,
	}
}

// EventHubDataFormat - The data format of the message. Optionally the data format can be added to each message.
type EventHubDataFormat string

const (
	EventHubDataFormatAPACHEAVRO EventHubDataFormat = "APACHEAVRO"
	EventHubDataFormatAVRO       EventHubDataFormat = "AVRO"
	EventHubDataFormatCSV        EventHubDataFormat = "CSV"
	EventHubDataFormatJSON       EventHubDataFormat = "JSON"
	EventHubDataFormatMULTIJSON  EventHubDataFormat = "MULTIJSON"
	EventHubDataFormatORC        EventHubDataFormat = "ORC"
	EventHubDataFormatPARQUET    EventHubDataFormat = "PARQUET"
	EventHubDataFormatPSV        EventHubDataFormat = "PSV"
	EventHubDataFormatRAW        EventHubDataFormat = "RAW"
	EventHubDataFormatSCSV       EventHubDataFormat = "SCSV"
	EventHubDataFormatSINGLEJSON EventHubDataFormat = "SINGLEJSON"
	EventHubDataFormatSOHSV      EventHubDataFormat = "SOHSV"
	EventHubDataFormatTSV        EventHubDataFormat = "TSV"
	EventHubDataFormatTSVE       EventHubDataFormat = "TSVE"
	EventHubDataFormatTXT        EventHubDataFormat = "TXT"
	EventHubDataFormatW3CLOGFILE EventHubDataFormat = "W3CLOGFILE"
)

// PossibleEventHubDataFormatValues returns the possible values for the EventHubDataFormat const type.
func PossibleEventHubDataFormatValues() []EventHubDataFormat {
	return []EventHubDataFormat{
		EventHubDataFormatAPACHEAVRO,
		EventHubDataFormatAVRO,
		EventHubDataFormatCSV,
		EventHubDataFormatJSON,
		EventHubDataFormatMULTIJSON,
		EventHubDataFormatORC,
		EventHubDataFormatPARQUET,
		EventHubDataFormatPSV,
		EventHubDataFormatRAW,
		EventHubDataFormatSCSV,
		EventHubDataFormatSINGLEJSON,
		EventHubDataFormatSOHSV,
		EventHubDataFormatTSV,
		EventHubDataFormatTSVE,
		EventHubDataFormatTXT,
		EventHubDataFormatW3CLOGFILE,
	}
}

type GeoBackupPolicyName string

const (
	GeoBackupPolicyNameDefault GeoBackupPolicyName = "Default"
)

// PossibleGeoBackupPolicyNameValues returns the possible values for the GeoBackupPolicyName const type.
func PossibleGeoBackupPolicyNameValues() []GeoBackupPolicyName {
	return []GeoBackupPolicyName{
		GeoBackupPolicyNameDefault,
	}
}

// GeoBackupPolicyState - The state of the geo backup policy.
type GeoBackupPolicyState string

const (
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	GeoBackupPolicyStateEnabled  GeoBackupPolicyState = "Enabled"
)

// PossibleGeoBackupPolicyStateValues returns the possible values for the GeoBackupPolicyState const type.
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return []GeoBackupPolicyState{
		GeoBackupPolicyStateDisabled,
		GeoBackupPolicyStateEnabled,
	}
}

// IntegrationRuntimeAuthKeyName - The name of the authentication key to regenerate.
type IntegrationRuntimeAuthKeyName string

const (
	IntegrationRuntimeAuthKeyNameAuthKey1 IntegrationRuntimeAuthKeyName = "authKey1"
	IntegrationRuntimeAuthKeyNameAuthKey2 IntegrationRuntimeAuthKeyName = "authKey2"
)

// PossibleIntegrationRuntimeAuthKeyNameValues returns the possible values for the IntegrationRuntimeAuthKeyName const type.
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return []IntegrationRuntimeAuthKeyName{
		IntegrationRuntimeAuthKeyNameAuthKey1,
		IntegrationRuntimeAuthKeyNameAuthKey2,
	}
}

// IntegrationRuntimeAutoUpdate - The state of integration runtime auto update.
type IntegrationRuntimeAutoUpdate string

const (
	IntegrationRuntimeAutoUpdateOff IntegrationRuntimeAutoUpdate = "Off"
	IntegrationRuntimeAutoUpdateOn  IntegrationRuntimeAutoUpdate = "On"
)

// PossibleIntegrationRuntimeAutoUpdateValues returns the possible values for the IntegrationRuntimeAutoUpdate const type.
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return []IntegrationRuntimeAutoUpdate{
		IntegrationRuntimeAutoUpdateOff,
		IntegrationRuntimeAutoUpdateOn,
	}
}

// IntegrationRuntimeEdition - The edition for the SSIS Integration Runtime
type IntegrationRuntimeEdition string

const (
	IntegrationRuntimeEditionEnterprise IntegrationRuntimeEdition = "Enterprise"
	IntegrationRuntimeEditionStandard   IntegrationRuntimeEdition = "Standard"
)

// PossibleIntegrationRuntimeEditionValues returns the possible values for the IntegrationRuntimeEdition const type.
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return []IntegrationRuntimeEdition{
		IntegrationRuntimeEditionEnterprise,
		IntegrationRuntimeEditionStandard,
	}
}

// IntegrationRuntimeEntityReferenceType - The type of this referenced entity.
type IntegrationRuntimeEntityReferenceType string

const (
	IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = "IntegrationRuntimeReference"
	IntegrationRuntimeEntityReferenceTypeLinkedServiceReference      IntegrationRuntimeEntityReferenceType = "LinkedServiceReference"
)

// PossibleIntegrationRuntimeEntityReferenceTypeValues returns the possible values for the IntegrationRuntimeEntityReferenceType const type.
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return []IntegrationRuntimeEntityReferenceType{
		IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference,
		IntegrationRuntimeEntityReferenceTypeLinkedServiceReference,
	}
}

// IntegrationRuntimeInternalChannelEncryptionMode - It is used to set the encryption mode for node-node communication channel
// (when more than 2 self-hosted integration runtime nodes exist).
type IntegrationRuntimeInternalChannelEncryptionMode string

const (
	IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "NotEncrypted"
	IntegrationRuntimeInternalChannelEncryptionModeNotSet       IntegrationRuntimeInternalChannelEncryptionMode = "NotSet"
	IntegrationRuntimeInternalChannelEncryptionModeSSLEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "SslEncrypted"
)

// PossibleIntegrationRuntimeInternalChannelEncryptionModeValues returns the possible values for the IntegrationRuntimeInternalChannelEncryptionMode const type.
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return []IntegrationRuntimeInternalChannelEncryptionMode{
		IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted,
		IntegrationRuntimeInternalChannelEncryptionModeNotSet,
		IntegrationRuntimeInternalChannelEncryptionModeSSLEncrypted,
	}
}

// IntegrationRuntimeLicenseType - License type for bringing your own license scenario.
type IntegrationRuntimeLicenseType string

const (
	IntegrationRuntimeLicenseTypeBasePrice       IntegrationRuntimeLicenseType = "BasePrice"
	IntegrationRuntimeLicenseTypeLicenseIncluded IntegrationRuntimeLicenseType = "LicenseIncluded"
)

// PossibleIntegrationRuntimeLicenseTypeValues returns the possible values for the IntegrationRuntimeLicenseType const type.
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return []IntegrationRuntimeLicenseType{
		IntegrationRuntimeLicenseTypeBasePrice,
		IntegrationRuntimeLicenseTypeLicenseIncluded,
	}
}

// IntegrationRuntimeSsisCatalogPricingTier - The pricing tier for the catalog database. The valid values could be found in
// https://azure.microsoft.com/en-us/pricing/details/sql-database/
type IntegrationRuntimeSsisCatalogPricingTier string

const (
	IntegrationRuntimeSsisCatalogPricingTierBasic     IntegrationRuntimeSsisCatalogPricingTier = "Basic"
	IntegrationRuntimeSsisCatalogPricingTierPremium   IntegrationRuntimeSsisCatalogPricingTier = "Premium"
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = "PremiumRS"
	IntegrationRuntimeSsisCatalogPricingTierStandard  IntegrationRuntimeSsisCatalogPricingTier = "Standard"
)

// PossibleIntegrationRuntimeSsisCatalogPricingTierValues returns the possible values for the IntegrationRuntimeSsisCatalogPricingTier const type.
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return []IntegrationRuntimeSsisCatalogPricingTier{
		IntegrationRuntimeSsisCatalogPricingTierBasic,
		IntegrationRuntimeSsisCatalogPricingTierPremium,
		IntegrationRuntimeSsisCatalogPricingTierPremiumRS,
		IntegrationRuntimeSsisCatalogPricingTierStandard,
	}
}

// IntegrationRuntimeState - The state of integration runtime.
type IntegrationRuntimeState string

const (
	IntegrationRuntimeStateAccessDenied     IntegrationRuntimeState = "AccessDenied"
	IntegrationRuntimeStateInitial          IntegrationRuntimeState = "Initial"
	IntegrationRuntimeStateLimited          IntegrationRuntimeState = "Limited"
	IntegrationRuntimeStateNeedRegistration IntegrationRuntimeState = "NeedRegistration"
	IntegrationRuntimeStateOffline          IntegrationRuntimeState = "Offline"
	IntegrationRuntimeStateOnline           IntegrationRuntimeState = "Online"
	IntegrationRuntimeStateStarted          IntegrationRuntimeState = "Started"
	IntegrationRuntimeStateStarting         IntegrationRuntimeState = "Starting"
	IntegrationRuntimeStateStopped          IntegrationRuntimeState = "Stopped"
	IntegrationRuntimeStateStopping         IntegrationRuntimeState = "Stopping"
)

// PossibleIntegrationRuntimeStateValues returns the possible values for the IntegrationRuntimeState const type.
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return []IntegrationRuntimeState{
		IntegrationRuntimeStateAccessDenied,
		IntegrationRuntimeStateInitial,
		IntegrationRuntimeStateLimited,
		IntegrationRuntimeStateNeedRegistration,
		IntegrationRuntimeStateOffline,
		IntegrationRuntimeStateOnline,
		IntegrationRuntimeStateStarted,
		IntegrationRuntimeStateStarting,
		IntegrationRuntimeStateStopped,
		IntegrationRuntimeStateStopping,
	}
}

// IntegrationRuntimeType - The type of integration runtime.
type IntegrationRuntimeType string

const (
	IntegrationRuntimeTypeManaged    IntegrationRuntimeType = "Managed"
	IntegrationRuntimeTypeSelfHosted IntegrationRuntimeType = "SelfHosted"
)

// PossibleIntegrationRuntimeTypeValues returns the possible values for the IntegrationRuntimeType const type.
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return []IntegrationRuntimeType{
		IntegrationRuntimeTypeManaged,
		IntegrationRuntimeTypeSelfHosted,
	}
}

// IntegrationRuntimeUpdateResult - The result of the last integration runtime node update.
type IntegrationRuntimeUpdateResult string

const (
	IntegrationRuntimeUpdateResultFail    IntegrationRuntimeUpdateResult = "Fail"
	IntegrationRuntimeUpdateResultNone    IntegrationRuntimeUpdateResult = "None"
	IntegrationRuntimeUpdateResultSucceed IntegrationRuntimeUpdateResult = "Succeed"
)

// PossibleIntegrationRuntimeUpdateResultValues returns the possible values for the IntegrationRuntimeUpdateResult const type.
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return []IntegrationRuntimeUpdateResult{
		IntegrationRuntimeUpdateResultFail,
		IntegrationRuntimeUpdateResultNone,
		IntegrationRuntimeUpdateResultSucceed,
	}
}

// IotHubDataFormat - The data format of the message. Optionally the data format can be added to each message.
type IotHubDataFormat string

const (
	IotHubDataFormatAPACHEAVRO IotHubDataFormat = "APACHEAVRO"
	IotHubDataFormatAVRO       IotHubDataFormat = "AVRO"
	IotHubDataFormatCSV        IotHubDataFormat = "CSV"
	IotHubDataFormatJSON       IotHubDataFormat = "JSON"
	IotHubDataFormatMULTIJSON  IotHubDataFormat = "MULTIJSON"
	IotHubDataFormatORC        IotHubDataFormat = "ORC"
	IotHubDataFormatPARQUET    IotHubDataFormat = "PARQUET"
	IotHubDataFormatPSV        IotHubDataFormat = "PSV"
	IotHubDataFormatRAW        IotHubDataFormat = "RAW"
	IotHubDataFormatSCSV       IotHubDataFormat = "SCSV"
	IotHubDataFormatSINGLEJSON IotHubDataFormat = "SINGLEJSON"
	IotHubDataFormatSOHSV      IotHubDataFormat = "SOHSV"
	IotHubDataFormatTSV        IotHubDataFormat = "TSV"
	IotHubDataFormatTSVE       IotHubDataFormat = "TSVE"
	IotHubDataFormatTXT        IotHubDataFormat = "TXT"
	IotHubDataFormatW3CLOGFILE IotHubDataFormat = "W3CLOGFILE"
)

// PossibleIotHubDataFormatValues returns the possible values for the IotHubDataFormat const type.
func PossibleIotHubDataFormatValues() []IotHubDataFormat {
	return []IotHubDataFormat{
		IotHubDataFormatAPACHEAVRO,
		IotHubDataFormatAVRO,
		IotHubDataFormatCSV,
		IotHubDataFormatJSON,
		IotHubDataFormatMULTIJSON,
		IotHubDataFormatORC,
		IotHubDataFormatPARQUET,
		IotHubDataFormatPSV,
		IotHubDataFormatRAW,
		IotHubDataFormatSCSV,
		IotHubDataFormatSINGLEJSON,
		IotHubDataFormatSOHSV,
		IotHubDataFormatTSV,
		IotHubDataFormatTSVE,
		IotHubDataFormatTXT,
		IotHubDataFormatW3CLOGFILE,
	}
}

// Kind - Kind of the database
type Kind string

const (
	KindReadOnlyFollowing Kind = "ReadOnlyFollowing"
	KindReadWrite         Kind = "ReadWrite"
)

// PossibleKindValues returns the possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{
		KindReadOnlyFollowing,
		KindReadWrite,
	}
}

// LanguageExtensionName - Language extension that can run within KQL query.
type LanguageExtensionName string

const (
	LanguageExtensionNamePYTHON LanguageExtensionName = "PYTHON"
	LanguageExtensionNameR      LanguageExtensionName = "R"
)

// PossibleLanguageExtensionNameValues returns the possible values for the LanguageExtensionName const type.
func PossibleLanguageExtensionNameValues() []LanguageExtensionName {
	return []LanguageExtensionName{
		LanguageExtensionNamePYTHON,
		LanguageExtensionNameR,
	}
}

// ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState - Actual state
type ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState string

const (
	ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateDisabled  ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState = "Disabled"
	ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateDisabling ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState = "Disabling"
	ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateEnabled   ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState = "Enabled"
	ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateEnabling  ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState = "Enabling"
	ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateUnknown   ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState = "Unknown"
)

// PossibleManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateValues returns the possible values for the ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState const type.
func PossibleManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateValues() []ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState {
	return []ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualState{
		ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateDisabled,
		ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateDisabling,
		ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateEnabled,
		ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateEnabling,
		ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityActualStateUnknown,
	}
}

// ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredState - Desired state
type ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredState string

const (
	ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredStateDisabled ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredState = "Disabled"
	ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredStateEnabled  ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredState = "Enabled"
)

// PossibleManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredStateValues returns the possible values for the ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredState const type.
func PossibleManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredStateValues() []ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredState {
	return []ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredState{
		ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredStateDisabled,
		ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentityDesiredStateEnabled,
	}
}

// ManagedIntegrationRuntimeNodeStatus - The managed integration runtime node status.
type ManagedIntegrationRuntimeNodeStatus string

const (
	ManagedIntegrationRuntimeNodeStatusAvailable   ManagedIntegrationRuntimeNodeStatus = "Available"
	ManagedIntegrationRuntimeNodeStatusRecycling   ManagedIntegrationRuntimeNodeStatus = "Recycling"
	ManagedIntegrationRuntimeNodeStatusStarting    ManagedIntegrationRuntimeNodeStatus = "Starting"
	ManagedIntegrationRuntimeNodeStatusUnavailable ManagedIntegrationRuntimeNodeStatus = "Unavailable"
)

// PossibleManagedIntegrationRuntimeNodeStatusValues returns the possible values for the ManagedIntegrationRuntimeNodeStatus const type.
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return []ManagedIntegrationRuntimeNodeStatus{
		ManagedIntegrationRuntimeNodeStatusAvailable,
		ManagedIntegrationRuntimeNodeStatusRecycling,
		ManagedIntegrationRuntimeNodeStatusStarting,
		ManagedIntegrationRuntimeNodeStatusUnavailable,
	}
}

// ManagementOperationState - The operation state.
type ManagementOperationState string

const (
	ManagementOperationStateCancelInProgress ManagementOperationState = "CancelInProgress"
	ManagementOperationStateCancelled        ManagementOperationState = "Cancelled"
	ManagementOperationStateFailed           ManagementOperationState = "Failed"
	ManagementOperationStateInProgress       ManagementOperationState = "InProgress"
	ManagementOperationStatePending          ManagementOperationState = "Pending"
	ManagementOperationStateSucceeded        ManagementOperationState = "Succeeded"
)

// PossibleManagementOperationStateValues returns the possible values for the ManagementOperationState const type.
func PossibleManagementOperationStateValues() []ManagementOperationState {
	return []ManagementOperationState{
		ManagementOperationStateCancelInProgress,
		ManagementOperationStateCancelled,
		ManagementOperationStateFailed,
		ManagementOperationStateInProgress,
		ManagementOperationStatePending,
		ManagementOperationStateSucceeded,
	}
}

// NodeSize - The level of compute power that each node in the Big Data pool has.
type NodeSize string

const (
	NodeSizeLarge    NodeSize = "Large"
	NodeSizeMedium   NodeSize = "Medium"
	NodeSizeNone     NodeSize = "None"
	NodeSizeSmall    NodeSize = "Small"
	NodeSizeXLarge   NodeSize = "XLarge"
	NodeSizeXXLarge  NodeSize = "XXLarge"
	NodeSizeXXXLarge NodeSize = "XXXLarge"
)

// PossibleNodeSizeValues returns the possible values for the NodeSize const type.
func PossibleNodeSizeValues() []NodeSize {
	return []NodeSize{
		NodeSizeLarge,
		NodeSizeMedium,
		NodeSizeNone,
		NodeSizeSmall,
		NodeSizeXLarge,
		NodeSizeXXLarge,
		NodeSizeXXXLarge,
	}
}

// NodeSizeFamily - The kind of nodes that the Big Data pool provides.
type NodeSizeFamily string

const (
	NodeSizeFamilyHardwareAcceleratedFPGA NodeSizeFamily = "HardwareAcceleratedFPGA"
	NodeSizeFamilyHardwareAcceleratedGPU  NodeSizeFamily = "HardwareAcceleratedGPU"
	NodeSizeFamilyMemoryOptimized         NodeSizeFamily = "MemoryOptimized"
	NodeSizeFamilyNone                    NodeSizeFamily = "None"
)

// PossibleNodeSizeFamilyValues returns the possible values for the NodeSizeFamily const type.
func PossibleNodeSizeFamilyValues() []NodeSizeFamily {
	return []NodeSizeFamily{
		NodeSizeFamilyHardwareAcceleratedFPGA,
		NodeSizeFamilyHardwareAcceleratedGPU,
		NodeSizeFamilyMemoryOptimized,
		NodeSizeFamilyNone,
	}
}

// OperationStatus - Operation status
type OperationStatus string

const (
	OperationStatusCanceled   OperationStatus = "Canceled"
	OperationStatusFailed     OperationStatus = "Failed"
	OperationStatusInProgress OperationStatus = "InProgress"
	OperationStatusSucceeded  OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns the possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{
		OperationStatusCanceled,
		OperationStatusFailed,
		OperationStatusInProgress,
		OperationStatusSucceeded,
	}
}

// PrincipalType - Principal type.
type PrincipalType string

const (
	PrincipalTypeApp   PrincipalType = "App"
	PrincipalTypeGroup PrincipalType = "Group"
	PrincipalTypeUser  PrincipalType = "User"
)

// PossiblePrincipalTypeValues returns the possible values for the PrincipalType const type.
func PossiblePrincipalTypeValues() []PrincipalType {
	return []PrincipalType{
		PrincipalTypeApp,
		PrincipalTypeGroup,
		PrincipalTypeUser,
	}
}

// PrincipalsModificationKind - The principals modification kind of the database
type PrincipalsModificationKind string

const (
	PrincipalsModificationKindNone    PrincipalsModificationKind = "None"
	PrincipalsModificationKindReplace PrincipalsModificationKind = "Replace"
	PrincipalsModificationKindUnion   PrincipalsModificationKind = "Union"
)

// PossiblePrincipalsModificationKindValues returns the possible values for the PrincipalsModificationKind const type.
func PossiblePrincipalsModificationKindValues() []PrincipalsModificationKind {
	return []PrincipalsModificationKind{
		PrincipalsModificationKindNone,
		PrincipalsModificationKindReplace,
		PrincipalsModificationKindUnion,
	}
}

// ProvisioningState - Resource provisioning state
type ProvisioningState string

const (
	ProvisioningStateDeleteError  ProvisioningState = "DeleteError"
	ProvisioningStateDeleting     ProvisioningState = "Deleting"
	ProvisioningStateFailed       ProvisioningState = "Failed"
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	ProvisioningStateSucceeded    ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateDeleteError,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateProvisioning,
		ProvisioningStateSucceeded,
	}
}

// QueryAggregationFunction - The function that is used to aggregate each query's metrics.
type QueryAggregationFunction string

const (
	QueryAggregationFunctionMin QueryAggregationFunction = "min"
	QueryAggregationFunctionMax QueryAggregationFunction = "max"
	QueryAggregationFunctionAvg QueryAggregationFunction = "avg"
	QueryAggregationFunctionSum QueryAggregationFunction = "sum"
)

// PossibleQueryAggregationFunctionValues returns the possible values for the QueryAggregationFunction const type.
func PossibleQueryAggregationFunctionValues() []QueryAggregationFunction {
	return []QueryAggregationFunction{
		QueryAggregationFunctionMin,
		QueryAggregationFunctionMax,
		QueryAggregationFunctionAvg,
		QueryAggregationFunctionSum,
	}
}

// QueryExecutionType - The execution type that is used to filter the query instances that are returned.
type QueryExecutionType string

const (
	QueryExecutionTypeAny       QueryExecutionType = "any"
	QueryExecutionTypeRegular   QueryExecutionType = "regular"
	QueryExecutionTypeIrregular QueryExecutionType = "irregular"
	QueryExecutionTypeAborted   QueryExecutionType = "aborted"
	QueryExecutionTypeException QueryExecutionType = "exception"
)

// PossibleQueryExecutionTypeValues returns the possible values for the QueryExecutionType const type.
func PossibleQueryExecutionTypeValues() []QueryExecutionType {
	return []QueryExecutionType{
		QueryExecutionTypeAny,
		QueryExecutionTypeRegular,
		QueryExecutionTypeIrregular,
		QueryExecutionTypeAborted,
		QueryExecutionTypeException,
	}
}

// QueryMetricUnit - The unit of measurement
type QueryMetricUnit string

const (
	QueryMetricUnitPercentage   QueryMetricUnit = "percentage"
	QueryMetricUnitKB           QueryMetricUnit = "KB"
	QueryMetricUnitMicroseconds QueryMetricUnit = "microseconds"
)

// PossibleQueryMetricUnitValues returns the possible values for the QueryMetricUnit const type.
func PossibleQueryMetricUnitValues() []QueryMetricUnit {
	return []QueryMetricUnit{
		QueryMetricUnitPercentage,
		QueryMetricUnitKB,
		QueryMetricUnitMicroseconds,
	}
}

// QueryObservedMetricType - The type of metric to use for ordering the top metrics.
type QueryObservedMetricType string

const (
	QueryObservedMetricTypeCPU            QueryObservedMetricType = "cpu"
	QueryObservedMetricTypeIo             QueryObservedMetricType = "io"
	QueryObservedMetricTypeLogio          QueryObservedMetricType = "logio"
	QueryObservedMetricTypeDuration       QueryObservedMetricType = "duration"
	QueryObservedMetricTypeExecutionCount QueryObservedMetricType = "executionCount"
)

// PossibleQueryObservedMetricTypeValues returns the possible values for the QueryObservedMetricType const type.
func PossibleQueryObservedMetricTypeValues() []QueryObservedMetricType {
	return []QueryObservedMetricType{
		QueryObservedMetricTypeCPU,
		QueryObservedMetricTypeIo,
		QueryObservedMetricTypeLogio,
		QueryObservedMetricTypeDuration,
		QueryObservedMetricTypeExecutionCount,
	}
}

// Reason - Message providing the reason why the given name is invalid.
type Reason string

const (
	ReasonAlreadyExists Reason = "AlreadyExists"
	ReasonInvalid       Reason = "Invalid"
)

// PossibleReasonValues returns the possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{
		ReasonAlreadyExists,
		ReasonInvalid,
	}
}

type RecommendedSensitivityLabelUpdateKind string

const (
	RecommendedSensitivityLabelUpdateKindEnable  RecommendedSensitivityLabelUpdateKind = "enable"
	RecommendedSensitivityLabelUpdateKindDisable RecommendedSensitivityLabelUpdateKind = "disable"
)

// PossibleRecommendedSensitivityLabelUpdateKindValues returns the possible values for the RecommendedSensitivityLabelUpdateKind const type.
func PossibleRecommendedSensitivityLabelUpdateKindValues() []RecommendedSensitivityLabelUpdateKind {
	return []RecommendedSensitivityLabelUpdateKind{
		RecommendedSensitivityLabelUpdateKindEnable,
		RecommendedSensitivityLabelUpdateKindDisable,
	}
}

// ReplicationRole - The role of the Sql pool in the replication link.
type ReplicationRole string

const (
	ReplicationRolePrimary              ReplicationRole = "Primary"
	ReplicationRoleSecondary            ReplicationRole = "Secondary"
	ReplicationRoleNonReadableSecondary ReplicationRole = "NonReadableSecondary"
	ReplicationRoleSource               ReplicationRole = "Source"
	ReplicationRoleCopy                 ReplicationRole = "Copy"
)

// PossibleReplicationRoleValues returns the possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{
		ReplicationRolePrimary,
		ReplicationRoleSecondary,
		ReplicationRoleNonReadableSecondary,
		ReplicationRoleSource,
		ReplicationRoleCopy,
	}
}

// ReplicationState - The replication state for the replication link.
type ReplicationState string

const (
	ReplicationStateCATCHUP   ReplicationState = "CATCH_UP"
	ReplicationStatePENDING   ReplicationState = "PENDING"
	ReplicationStateSEEDING   ReplicationState = "SEEDING"
	ReplicationStateSUSPENDED ReplicationState = "SUSPENDED"
)

// PossibleReplicationStateValues returns the possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{
		ReplicationStateCATCHUP,
		ReplicationStatePENDING,
		ReplicationStateSEEDING,
		ReplicationStateSUSPENDED,
	}
}

// ResourceIdentityType - The type of managed identity for the workspace
type ResourceIdentityType string

const (
	ResourceIdentityTypeNone                       ResourceIdentityType = "None"
	ResourceIdentityTypeSystemAssigned             ResourceIdentityType = "SystemAssigned"
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned,UserAssigned"
)

// PossibleResourceIdentityTypeValues returns the possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{
		ResourceIdentityTypeNone,
		ResourceIdentityTypeSystemAssigned,
		ResourceIdentityTypeSystemAssignedUserAssigned,
	}
}

// ResourceProvisioningState - The provisioned state of the resource.
type ResourceProvisioningState string

const (
	ResourceProvisioningStateCanceled  ResourceProvisioningState = "Canceled"
	ResourceProvisioningStateCreating  ResourceProvisioningState = "Creating"
	ResourceProvisioningStateDeleting  ResourceProvisioningState = "Deleting"
	ResourceProvisioningStateFailed    ResourceProvisioningState = "Failed"
	ResourceProvisioningStateMoving    ResourceProvisioningState = "Moving"
	ResourceProvisioningStateRunning   ResourceProvisioningState = "Running"
	ResourceProvisioningStateSucceeded ResourceProvisioningState = "Succeeded"
)

// PossibleResourceProvisioningStateValues returns the possible values for the ResourceProvisioningState const type.
func PossibleResourceProvisioningStateValues() []ResourceProvisioningState {
	return []ResourceProvisioningState{
		ResourceProvisioningStateCanceled,
		ResourceProvisioningStateCreating,
		ResourceProvisioningStateDeleting,
		ResourceProvisioningStateFailed,
		ResourceProvisioningStateMoving,
		ResourceProvisioningStateRunning,
		ResourceProvisioningStateSucceeded,
	}
}

// RestorePointType - The type of restore point
type RestorePointType string

const (
	RestorePointTypeCONTINUOUS RestorePointType = "CONTINUOUS"
	RestorePointTypeDISCRETE   RestorePointType = "DISCRETE"
)

// PossibleRestorePointTypeValues returns the possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{
		RestorePointTypeCONTINUOUS,
		RestorePointTypeDISCRETE,
	}
}

// SKUName - SKU name.
type SKUName string

const (
	SKUNameComputeOptimized SKUName = "Compute optimized"
	SKUNameStorageOptimized SKUName = "Storage optimized"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameComputeOptimized,
		SKUNameStorageOptimized,
	}
}

// SKUSize - SKU size.
type SKUSize string

const (
	SKUSizeExtraSmall SKUSize = "Extra small"
	SKUSizeLarge      SKUSize = "Large"
	SKUSizeMedium     SKUSize = "Medium"
	SKUSizeSmall      SKUSize = "Small"
)

// PossibleSKUSizeValues returns the possible values for the SKUSize const type.
func PossibleSKUSizeValues() []SKUSize {
	return []SKUSize{
		SKUSizeExtraSmall,
		SKUSizeLarge,
		SKUSizeMedium,
		SKUSizeSmall,
	}
}

type SecurityAlertPolicyName string

const (
	SecurityAlertPolicyNameDefault SecurityAlertPolicyName = "default"
)

// PossibleSecurityAlertPolicyNameValues returns the possible values for the SecurityAlertPolicyName const type.
func PossibleSecurityAlertPolicyNameValues() []SecurityAlertPolicyName {
	return []SecurityAlertPolicyName{
		SecurityAlertPolicyNameDefault,
	}
}

type SecurityAlertPolicyNameAutoGenerated string

const (
	SecurityAlertPolicyNameAutoGeneratedDefault SecurityAlertPolicyNameAutoGenerated = "Default"
)

// PossibleSecurityAlertPolicyNameAutoGeneratedValues returns the possible values for the SecurityAlertPolicyNameAutoGenerated const type.
func PossibleSecurityAlertPolicyNameAutoGeneratedValues() []SecurityAlertPolicyNameAutoGenerated {
	return []SecurityAlertPolicyNameAutoGenerated{
		SecurityAlertPolicyNameAutoGeneratedDefault,
	}
}

// SecurityAlertPolicyState - Specifies the state of the policy, whether it is enabled or disabled or a policy has not been
// applied yet on the specific Sql pool.
type SecurityAlertPolicyState string

const (
	SecurityAlertPolicyStateNew      SecurityAlertPolicyState = "New"
	SecurityAlertPolicyStateEnabled  SecurityAlertPolicyState = "Enabled"
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
)

// PossibleSecurityAlertPolicyStateValues returns the possible values for the SecurityAlertPolicyState const type.
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return []SecurityAlertPolicyState{
		SecurityAlertPolicyStateNew,
		SecurityAlertPolicyStateEnabled,
		SecurityAlertPolicyStateDisabled,
	}
}

// SelfHostedIntegrationRuntimeNodeStatus - Status of the integration runtime node.
type SelfHostedIntegrationRuntimeNodeStatus string

const (
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = "InitializeFailed"
	SelfHostedIntegrationRuntimeNodeStatusInitializing     SelfHostedIntegrationRuntimeNodeStatus = "Initializing"
	SelfHostedIntegrationRuntimeNodeStatusLimited          SelfHostedIntegrationRuntimeNodeStatus = "Limited"
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = "NeedRegistration"
	SelfHostedIntegrationRuntimeNodeStatusOffline          SelfHostedIntegrationRuntimeNodeStatus = "Offline"
	SelfHostedIntegrationRuntimeNodeStatusOnline           SelfHostedIntegrationRuntimeNodeStatus = "Online"
	SelfHostedIntegrationRuntimeNodeStatusUpgrading        SelfHostedIntegrationRuntimeNodeStatus = "Upgrading"
)

// PossibleSelfHostedIntegrationRuntimeNodeStatusValues returns the possible values for the SelfHostedIntegrationRuntimeNodeStatus const type.
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return []SelfHostedIntegrationRuntimeNodeStatus{
		SelfHostedIntegrationRuntimeNodeStatusInitializeFailed,
		SelfHostedIntegrationRuntimeNodeStatusInitializing,
		SelfHostedIntegrationRuntimeNodeStatusLimited,
		SelfHostedIntegrationRuntimeNodeStatusNeedRegistration,
		SelfHostedIntegrationRuntimeNodeStatusOffline,
		SelfHostedIntegrationRuntimeNodeStatusOnline,
		SelfHostedIntegrationRuntimeNodeStatusUpgrading,
	}
}

type SensitivityLabelRank string

const (
	SensitivityLabelRankNone     SensitivityLabelRank = "None"
	SensitivityLabelRankLow      SensitivityLabelRank = "Low"
	SensitivityLabelRankMedium   SensitivityLabelRank = "Medium"
	SensitivityLabelRankHigh     SensitivityLabelRank = "High"
	SensitivityLabelRankCritical SensitivityLabelRank = "Critical"
)

// PossibleSensitivityLabelRankValues returns the possible values for the SensitivityLabelRank const type.
func PossibleSensitivityLabelRankValues() []SensitivityLabelRank {
	return []SensitivityLabelRank{
		SensitivityLabelRankNone,
		SensitivityLabelRankLow,
		SensitivityLabelRankMedium,
		SensitivityLabelRankHigh,
		SensitivityLabelRankCritical,
	}
}

type SensitivityLabelSource string

const (
	SensitivityLabelSourceCurrent     SensitivityLabelSource = "current"
	SensitivityLabelSourceRecommended SensitivityLabelSource = "recommended"
)

// PossibleSensitivityLabelSourceValues returns the possible values for the SensitivityLabelSource const type.
func PossibleSensitivityLabelSourceValues() []SensitivityLabelSource {
	return []SensitivityLabelSource{
		SensitivityLabelSourceCurrent,
		SensitivityLabelSourceRecommended,
	}
}

type SensitivityLabelUpdateKind string

const (
	SensitivityLabelUpdateKindSet    SensitivityLabelUpdateKind = "set"
	SensitivityLabelUpdateKindRemove SensitivityLabelUpdateKind = "remove"
)

// PossibleSensitivityLabelUpdateKindValues returns the possible values for the SensitivityLabelUpdateKind const type.
func PossibleSensitivityLabelUpdateKindValues() []SensitivityLabelUpdateKind {
	return []SensitivityLabelUpdateKind{
		SensitivityLabelUpdateKindSet,
		SensitivityLabelUpdateKindRemove,
	}
}

// ServerKeyType - The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
type ServerKeyType string

const (
	ServerKeyTypeAzureKeyVault  ServerKeyType = "AzureKeyVault"
	ServerKeyTypeServiceManaged ServerKeyType = "ServiceManaged"
)

// PossibleServerKeyTypeValues returns the possible values for the ServerKeyType const type.
func PossibleServerKeyTypeValues() []ServerKeyType {
	return []ServerKeyType{
		ServerKeyTypeAzureKeyVault,
		ServerKeyTypeServiceManaged,
	}
}

// SsisObjectMetadataType - The type of SSIS object metadata.
type SsisObjectMetadataType string

const (
	SsisObjectMetadataTypeEnvironment SsisObjectMetadataType = "Environment"
	SsisObjectMetadataTypeFolder      SsisObjectMetadataType = "Folder"
	SsisObjectMetadataTypePackage     SsisObjectMetadataType = "Package"
	SsisObjectMetadataTypeProject     SsisObjectMetadataType = "Project"
)

// PossibleSsisObjectMetadataTypeValues returns the possible values for the SsisObjectMetadataType const type.
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return []SsisObjectMetadataType{
		SsisObjectMetadataTypeEnvironment,
		SsisObjectMetadataTypeFolder,
		SsisObjectMetadataTypePackage,
		SsisObjectMetadataTypeProject,
	}
}

// State - The state of the resource.
type State string

const (
	StateCreating    State = "Creating"
	StateDeleted     State = "Deleted"
	StateDeleting    State = "Deleting"
	StateRunning     State = "Running"
	StateStarting    State = "Starting"
	StateStopped     State = "Stopped"
	StateStopping    State = "Stopping"
	StateUnavailable State = "Unavailable"
	StateUpdating    State = "Updating"
)

// PossibleStateValues returns the possible values for the State const type.
func PossibleStateValues() []State {
	return []State{
		StateCreating,
		StateDeleted,
		StateDeleting,
		StateRunning,
		StateStarting,
		StateStopped,
		StateStopping,
		StateUnavailable,
		StateUpdating,
	}
}

// StateValue - property configuration state
type StateValue string

const (
	StateValueConsistent   StateValue = "Consistent"
	StateValueInConsistent StateValue = "InConsistent"
	StateValueUpdating     StateValue = "Updating"
)

// PossibleStateValueValues returns the possible values for the StateValue const type.
func PossibleStateValueValues() []StateValue {
	return []StateValue{
		StateValueConsistent,
		StateValueInConsistent,
		StateValueUpdating,
	}
}

// StorageAccountType - The storage account type used to store backups for this sql pool.
type StorageAccountType string

const (
	StorageAccountTypeGRS StorageAccountType = "GRS"
	StorageAccountTypeLRS StorageAccountType = "LRS"
)

// PossibleStorageAccountTypeValues returns the possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{
		StorageAccountTypeGRS,
		StorageAccountTypeLRS,
	}
}

type TransparentDataEncryptionName string

const (
	TransparentDataEncryptionNameCurrent TransparentDataEncryptionName = "current"
)

// PossibleTransparentDataEncryptionNameValues returns the possible values for the TransparentDataEncryptionName const type.
func PossibleTransparentDataEncryptionNameValues() []TransparentDataEncryptionName {
	return []TransparentDataEncryptionName{
		TransparentDataEncryptionNameCurrent,
	}
}

// TransparentDataEncryptionStatus - The status of the database transparent data encryption.
type TransparentDataEncryptionStatus string

const (
	TransparentDataEncryptionStatusEnabled  TransparentDataEncryptionStatus = "Enabled"
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
)

// PossibleTransparentDataEncryptionStatusValues returns the possible values for the TransparentDataEncryptionStatus const type.
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return []TransparentDataEncryptionStatus{
		TransparentDataEncryptionStatusEnabled,
		TransparentDataEncryptionStatusDisabled,
	}
}

// Type - The type of resource, for instance Microsoft.Synapse/workspaces/kustoPools/databases.
type Type string

const (
	TypeMicrosoftSynapseWorkspacesKustoPoolsDatabases                      Type = "Microsoft.Synapse/workspaces/kustoPools/databases"
	TypeMicrosoftSynapseWorkspacesKustoPoolsAttachedDatabaseConfigurations Type = "Microsoft.Synapse/workspaces/kustoPools/attachedDatabaseConfigurations"
)

// PossibleTypeValues returns the possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{
		TypeMicrosoftSynapseWorkspacesKustoPoolsDatabases,
		TypeMicrosoftSynapseWorkspacesKustoPoolsAttachedDatabaseConfigurations,
	}
}

type VulnerabilityAssessmentName string

const (
	VulnerabilityAssessmentNameDefault VulnerabilityAssessmentName = "default"
)

// PossibleVulnerabilityAssessmentNameValues returns the possible values for the VulnerabilityAssessmentName const type.
func PossibleVulnerabilityAssessmentNameValues() []VulnerabilityAssessmentName {
	return []VulnerabilityAssessmentName{
		VulnerabilityAssessmentNameDefault,
	}
}

type VulnerabilityAssessmentPolicyBaselineName string

const (
	VulnerabilityAssessmentPolicyBaselineNameMaster  VulnerabilityAssessmentPolicyBaselineName = "master"
	VulnerabilityAssessmentPolicyBaselineNameDefault VulnerabilityAssessmentPolicyBaselineName = "default"
)

// PossibleVulnerabilityAssessmentPolicyBaselineNameValues returns the possible values for the VulnerabilityAssessmentPolicyBaselineName const type.
func PossibleVulnerabilityAssessmentPolicyBaselineNameValues() []VulnerabilityAssessmentPolicyBaselineName {
	return []VulnerabilityAssessmentPolicyBaselineName{
		VulnerabilityAssessmentPolicyBaselineNameMaster,
		VulnerabilityAssessmentPolicyBaselineNameDefault,
	}
}

// VulnerabilityAssessmentScanState - The scan status.
type VulnerabilityAssessmentScanState string

const (
	VulnerabilityAssessmentScanStateFailed      VulnerabilityAssessmentScanState = "Failed"
	VulnerabilityAssessmentScanStateFailedToRun VulnerabilityAssessmentScanState = "FailedToRun"
	VulnerabilityAssessmentScanStateInProgress  VulnerabilityAssessmentScanState = "InProgress"
	VulnerabilityAssessmentScanStatePassed      VulnerabilityAssessmentScanState = "Passed"
)

// PossibleVulnerabilityAssessmentScanStateValues returns the possible values for the VulnerabilityAssessmentScanState const type.
func PossibleVulnerabilityAssessmentScanStateValues() []VulnerabilityAssessmentScanState {
	return []VulnerabilityAssessmentScanState{
		VulnerabilityAssessmentScanStateFailed,
		VulnerabilityAssessmentScanStateFailedToRun,
		VulnerabilityAssessmentScanStateInProgress,
		VulnerabilityAssessmentScanStatePassed,
	}
}

// VulnerabilityAssessmentScanTriggerType - The scan trigger type.
type VulnerabilityAssessmentScanTriggerType string

const (
	VulnerabilityAssessmentScanTriggerTypeOnDemand  VulnerabilityAssessmentScanTriggerType = "OnDemand"
	VulnerabilityAssessmentScanTriggerTypeRecurring VulnerabilityAssessmentScanTriggerType = "Recurring"
)

// PossibleVulnerabilityAssessmentScanTriggerTypeValues returns the possible values for the VulnerabilityAssessmentScanTriggerType const type.
func PossibleVulnerabilityAssessmentScanTriggerTypeValues() []VulnerabilityAssessmentScanTriggerType {
	return []VulnerabilityAssessmentScanTriggerType{
		VulnerabilityAssessmentScanTriggerTypeOnDemand,
		VulnerabilityAssessmentScanTriggerTypeRecurring,
	}
}

// WorkspacePublicNetworkAccess - Enable or Disable public network access to workspace
type WorkspacePublicNetworkAccess string

const (
	WorkspacePublicNetworkAccessDisabled WorkspacePublicNetworkAccess = "Disabled"
	WorkspacePublicNetworkAccessEnabled  WorkspacePublicNetworkAccess = "Enabled"
)

// PossibleWorkspacePublicNetworkAccessValues returns the possible values for the WorkspacePublicNetworkAccess const type.
func PossibleWorkspacePublicNetworkAccessValues() []WorkspacePublicNetworkAccess {
	return []WorkspacePublicNetworkAccess{
		WorkspacePublicNetworkAccessDisabled,
		WorkspacePublicNetworkAccessEnabled,
	}
}
