// Code generated by smithy-go-codegen DO NOT EDIT.

package iotwireless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotwireless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Get estimated position information as a payload in GeoJSON format. The payload
// measurement data is resolved using solvers that are provided by third-party
// vendors.
func (c *Client) GetPositionEstimate(ctx context.Context, params *GetPositionEstimateInput, optFns ...func(*Options)) (*GetPositionEstimateOutput, error) {
	if params == nil {
		params = &GetPositionEstimateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPositionEstimate", params, optFns, c.addOperationGetPositionEstimateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPositionEstimateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetPositionEstimateInput struct {

	// Retrieves an estimated device position by resolving measurement data from
	// cellular radio towers. The position is resolved using HERE's cellular-based
	// solver.
	CellTowers *types.CellTowers

	// Retrieves an estimated device position by resolving the global navigation
	// satellite system (GNSS) scan data. The position is resolved using the GNSS
	// solver powered by LoRa Cloud.
	Gnss *types.Gnss

	// Retrieves an estimated device position by resolving the IP address information
	// from the device. The position is resolved using MaxMind's IP-based solver.
	Ip *types.Ip

	// Optional information that specifies the time when the position information will
	// be resolved. It uses the Unix timestamp format. If not specified, the time at
	// which the request was received will be used.
	Timestamp *time.Time

	// Retrieves an estimated device position by resolving WLAN measurement data. The
	// position is resolved using HERE's Wi-Fi based solver.
	WiFiAccessPoints []types.WiFiAccessPoint

	noSmithyDocumentSerde
}

type GetPositionEstimateOutput struct {

	// The position information of the resource, displayed as a JSON payload. The
	// payload is of type blob and uses the [GeoJSON]format, which a format that's used to
	// encode geographic data structures. A sample payload contains the timestamp
	// information, the WGS84 coordinates of the location, and the accuracy and
	// confidence level. For more information and examples, see [Resolve device location (console)].
	//
	// [Resolve device location (console)]: https://docs.aws.amazon.com/iot/latest/developerguide/location-resolve-console.html
	// [GeoJSON]: https://geojson.org/
	GeoJsonPayload []byte

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetPositionEstimateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetPositionEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetPositionEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetPositionEstimate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetPositionEstimateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetPositionEstimate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetPositionEstimate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetPositionEstimate",
	}
}
