// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/securitycenter/settings/v1beta1/component_settings.proto

package settingspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Valid states for a component
type ComponentEnablementState int32

const (
	// No state specified, equivalent of INHERIT
	ComponentEnablementState_COMPONENT_ENABLEMENT_STATE_UNSPECIFIED ComponentEnablementState = 0
	// Disable the component
	ComponentEnablementState_DISABLE ComponentEnablementState = 1
	// Enable the component
	ComponentEnablementState_ENABLE ComponentEnablementState = 2
	// Inherit the state from resources parent folder or organization.
	ComponentEnablementState_INHERIT ComponentEnablementState = 3
)

// Enum value maps for ComponentEnablementState.
var (
	ComponentEnablementState_name = map[int32]string{
		0: "COMPONENT_ENABLEMENT_STATE_UNSPECIFIED",
		1: "DISABLE",
		2: "ENABLE",
		3: "INHERIT",
	}
	ComponentEnablementState_value = map[string]int32{
		"COMPONENT_ENABLEMENT_STATE_UNSPECIFIED": 0,
		"DISABLE":                                1,
		"ENABLE":                                 2,
		"INHERIT":                                3,
	}
)

func (x ComponentEnablementState) Enum() *ComponentEnablementState {
	p := new(ComponentEnablementState)
	*p = x
	return p
}

func (x ComponentEnablementState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComponentEnablementState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_enumTypes[0].Descriptor()
}

func (ComponentEnablementState) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_enumTypes[0]
}

func (x ComponentEnablementState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComponentEnablementState.Descriptor instead.
func (ComponentEnablementState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescGZIP(), []int{0}
}

// Component Settings for Security Command Center
type ComponentSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The relative resource name of the component settings.
	// Formats:
	//   - `organizations/{organization}/components/{component}/settings`
	//   - `folders/{folder}/components/{component}/settings`
	//   - `projects/{project}/components/{component}/settings`
	//   - `projects/{project}/locations/{location}/clusters/{cluster}/components/{component}/settings`
	//   - `projects/{project}/regions/{region}/clusters/{cluster}/components/{component}/settings`
	//   - `projects/{project}/zones/{zone}/clusters/{cluster}/components/{component}/settings`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ENABLE to enable component, DISABLE to disable and INHERIT to inherit
	// setting from ancestors.
	State ComponentEnablementState `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.securitycenter.settings.v1beta1.ComponentEnablementState" json:"state,omitempty"`
	// Output only. The service account to be used for security center component.
	// The component must have permission to "act as" the service account.
	ProjectServiceAccount string `protobuf:"bytes,3,opt,name=project_service_account,json=projectServiceAccount,proto3" json:"project_service_account,omitempty"`
	// Settings for detectors.  Not all detectors must have settings present at
	// each and every level in the hierarchy.  If it is not present the setting
	// will be inherited from its ancestors folders, organizations or the
	// defaults.
	DetectorSettings map[string]*ComponentSettings_DetectorSettings `protobuf:"bytes,4,rep,name=detector_settings,json=detectorSettings,proto3" json:"detector_settings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. An fingerprint used for optimistic concurrency. If none is provided
	// on updates then the existing metadata will be blindly overwritten.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. The time these settings were last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Component specific settings.  This must match the component value.
	//
	// Types that are assignable to SpecificSettings:
	//
	//	*ComponentSettings_ContainerThreatDetectionSettings
	//	*ComponentSettings_EventThreatDetectionSettings
	//	*ComponentSettings_SecurityHealthAnalyticsSettings
	//	*ComponentSettings_WebSecurityScannerSettings
	SpecificSettings isComponentSettings_SpecificSettings `protobuf_oneof:"specific_settings"`
}

func (x *ComponentSettings) Reset() {
	*x = ComponentSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComponentSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComponentSettings) ProtoMessage() {}

func (x *ComponentSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComponentSettings.ProtoReflect.Descriptor instead.
func (*ComponentSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescGZIP(), []int{0}
}

func (x *ComponentSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ComponentSettings) GetState() ComponentEnablementState {
	if x != nil {
		return x.State
	}
	return ComponentEnablementState_COMPONENT_ENABLEMENT_STATE_UNSPECIFIED
}

func (x *ComponentSettings) GetProjectServiceAccount() string {
	if x != nil {
		return x.ProjectServiceAccount
	}
	return ""
}

func (x *ComponentSettings) GetDetectorSettings() map[string]*ComponentSettings_DetectorSettings {
	if x != nil {
		return x.DetectorSettings
	}
	return nil
}

func (x *ComponentSettings) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *ComponentSettings) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (m *ComponentSettings) GetSpecificSettings() isComponentSettings_SpecificSettings {
	if m != nil {
		return m.SpecificSettings
	}
	return nil
}

func (x *ComponentSettings) GetContainerThreatDetectionSettings() *ContainerThreatDetectionSettings {
	if x, ok := x.GetSpecificSettings().(*ComponentSettings_ContainerThreatDetectionSettings); ok {
		return x.ContainerThreatDetectionSettings
	}
	return nil
}

func (x *ComponentSettings) GetEventThreatDetectionSettings() *EventThreatDetectionSettings {
	if x, ok := x.GetSpecificSettings().(*ComponentSettings_EventThreatDetectionSettings); ok {
		return x.EventThreatDetectionSettings
	}
	return nil
}

func (x *ComponentSettings) GetSecurityHealthAnalyticsSettings() *SecurityHealthAnalyticsSettings {
	if x, ok := x.GetSpecificSettings().(*ComponentSettings_SecurityHealthAnalyticsSettings); ok {
		return x.SecurityHealthAnalyticsSettings
	}
	return nil
}

func (x *ComponentSettings) GetWebSecurityScannerSettings() *WebSecurityScanner {
	if x, ok := x.GetSpecificSettings().(*ComponentSettings_WebSecurityScannerSettings); ok {
		return x.WebSecurityScannerSettings
	}
	return nil
}

type isComponentSettings_SpecificSettings interface {
	isComponentSettings_SpecificSettings()
}

type ComponentSettings_ContainerThreatDetectionSettings struct {
	// Container Threate Detection specific settings
	// For component, expect CONTAINER_THREAT_DETECTION
	ContainerThreatDetectionSettings *ContainerThreatDetectionSettings `protobuf:"bytes,41,opt,name=container_threat_detection_settings,json=containerThreatDetectionSettings,proto3,oneof"`
}

type ComponentSettings_EventThreatDetectionSettings struct {
	// Event Threat Detection specific settings
	// For component, expect EVENT_THREAT_DETECTION
	EventThreatDetectionSettings *EventThreatDetectionSettings `protobuf:"bytes,42,opt,name=event_threat_detection_settings,json=eventThreatDetectionSettings,proto3,oneof"`
}

type ComponentSettings_SecurityHealthAnalyticsSettings struct {
	// Security Health Analytics specific settings
	// For component, expect SECURITY_HEALTH_ANALYTICS
	SecurityHealthAnalyticsSettings *SecurityHealthAnalyticsSettings `protobuf:"bytes,44,opt,name=security_health_analytics_settings,json=securityHealthAnalyticsSettings,proto3,oneof"`
}

type ComponentSettings_WebSecurityScannerSettings struct {
	// Web Security Scanner specific settings
	// For component, expect WEB_SECURITY_SCANNER
	WebSecurityScannerSettings *WebSecurityScanner `protobuf:"bytes,40,opt,name=web_security_scanner_settings,json=webSecurityScannerSettings,proto3,oneof"`
}

func (*ComponentSettings_ContainerThreatDetectionSettings) isComponentSettings_SpecificSettings() {}

func (*ComponentSettings_EventThreatDetectionSettings) isComponentSettings_SpecificSettings() {}

func (*ComponentSettings_SecurityHealthAnalyticsSettings) isComponentSettings_SpecificSettings() {}

func (*ComponentSettings_WebSecurityScannerSettings) isComponentSettings_SpecificSettings() {}

// User specified settings for Web Security Scanner
type WebSecurityScanner struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WebSecurityScanner) Reset() {
	*x = WebSecurityScanner{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebSecurityScanner) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebSecurityScanner) ProtoMessage() {}

func (x *WebSecurityScanner) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebSecurityScanner.ProtoReflect.Descriptor instead.
func (*WebSecurityScanner) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescGZIP(), []int{1}
}

// User specified settings for KTD
type ContainerThreatDetectionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ContainerThreatDetectionSettings) Reset() {
	*x = ContainerThreatDetectionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerThreatDetectionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerThreatDetectionSettings) ProtoMessage() {}

func (x *ContainerThreatDetectionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerThreatDetectionSettings.ProtoReflect.Descriptor instead.
func (*ContainerThreatDetectionSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescGZIP(), []int{2}
}

// User specified settings for ETD
type EventThreatDetectionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EventThreatDetectionSettings) Reset() {
	*x = EventThreatDetectionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventThreatDetectionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventThreatDetectionSettings) ProtoMessage() {}

func (x *EventThreatDetectionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventThreatDetectionSettings.ProtoReflect.Descriptor instead.
func (*EventThreatDetectionSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescGZIP(), []int{3}
}

// User specified settings for Security Health Analytics
type SecurityHealthAnalyticsSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Settings for "NON_ORG_IAM_MEMBER" scanner.
	NonOrgIamMemberSettings *SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings `protobuf:"bytes,1,opt,name=non_org_iam_member_settings,json=nonOrgIamMemberSettings,proto3" json:"non_org_iam_member_settings,omitempty"`
	// Settings for "ADMIN_SERVICE_ACCOUNT" scanner.
	AdminServiceAccountSettings *SecurityHealthAnalyticsSettings_AdminServiceAccountSettings `protobuf:"bytes,2,opt,name=admin_service_account_settings,json=adminServiceAccountSettings,proto3" json:"admin_service_account_settings,omitempty"`
}

func (x *SecurityHealthAnalyticsSettings) Reset() {
	*x = SecurityHealthAnalyticsSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityHealthAnalyticsSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityHealthAnalyticsSettings) ProtoMessage() {}

func (x *SecurityHealthAnalyticsSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityHealthAnalyticsSettings.ProtoReflect.Descriptor instead.
func (*SecurityHealthAnalyticsSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescGZIP(), []int{4}
}

func (x *SecurityHealthAnalyticsSettings) GetNonOrgIamMemberSettings() *SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings {
	if x != nil {
		return x.NonOrgIamMemberSettings
	}
	return nil
}

func (x *SecurityHealthAnalyticsSettings) GetAdminServiceAccountSettings() *SecurityHealthAnalyticsSettings_AdminServiceAccountSettings {
	if x != nil {
		return x.AdminServiceAccountSettings
	}
	return nil
}

// Settings for each detector.
type ComponentSettings_DetectorSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ENABLE to enable component, DISABLE to disable and INHERIT to inherit
	// setting from ancestors.
	State ComponentEnablementState `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.securitycenter.settings.v1beta1.ComponentEnablementState" json:"state,omitempty"`
}

func (x *ComponentSettings_DetectorSettings) Reset() {
	*x = ComponentSettings_DetectorSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComponentSettings_DetectorSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComponentSettings_DetectorSettings) ProtoMessage() {}

func (x *ComponentSettings_DetectorSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComponentSettings_DetectorSettings.ProtoReflect.Descriptor instead.
func (*ComponentSettings_DetectorSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ComponentSettings_DetectorSettings) GetState() ComponentEnablementState {
	if x != nil {
		return x.State
	}
	return ComponentEnablementState_COMPONENT_ENABLEMENT_STATE_UNSPECIFIED
}

// Settings for "NON_ORG_IAM_MEMBER" scanner.
type SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User emails ending in the provided identities are allowed to have IAM
	// permissions on a project or the organization. Otherwise a finding will
	// be created.
	// A valid identity can be:
	//   - a domain that starts with "@", e.g. "@yourdomain.com".
	//   - a fully specified email address that does not start with "@", e.g.
	//     "abc@gmail.com"
	//
	// Regular expressions are not supported.
	// Service accounts are not examined by the scanner and will be omitted if
	// added to the list.
	// If not specified, only Gmail accounts will be considered as non-approved.
	ApprovedIdentities []string `protobuf:"bytes,1,rep,name=approved_identities,json=approvedIdentities,proto3" json:"approved_identities,omitempty"`
}

func (x *SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings) Reset() {
	*x = SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings) ProtoMessage() {}

func (x *SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings.ProtoReflect.Descriptor instead.
func (*SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescGZIP(), []int{4, 0}
}

func (x *SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings) GetApprovedIdentities() []string {
	if x != nil {
		return x.ApprovedIdentities
	}
	return nil
}

// Settings for "ADMIN_SERVICE_ACCOUNT" scanner.
type SecurityHealthAnalyticsSettings_AdminServiceAccountSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User-created service accounts ending in the provided identities are
	// allowed to have Admin, Owner or Editor roles granted to them. Otherwise
	// a finding will be created.
	// A valid identity can be:
	//   - a partilly specified service account that starts with "@", e.g.
	//     "@myproject.iam.gserviceaccount.com". This approves all the service
	//     accounts suffixed with the specified identity.
	//   - a fully specified service account that does not start with "@", e.g.
	//     "myadmin@myproject.iam.gserviceaccount.com".
	//
	// Google-created service accounts are all approved.
	ApprovedIdentities []string `protobuf:"bytes,1,rep,name=approved_identities,json=approvedIdentities,proto3" json:"approved_identities,omitempty"`
}

func (x *SecurityHealthAnalyticsSettings_AdminServiceAccountSettings) Reset() {
	*x = SecurityHealthAnalyticsSettings_AdminServiceAccountSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityHealthAnalyticsSettings_AdminServiceAccountSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityHealthAnalyticsSettings_AdminServiceAccountSettings) ProtoMessage() {}

func (x *SecurityHealthAnalyticsSettings_AdminServiceAccountSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityHealthAnalyticsSettings_AdminServiceAccountSettings.ProtoReflect.Descriptor instead.
func (*SecurityHealthAnalyticsSettings_AdminServiceAccountSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescGZIP(), []int{4, 1}
}

func (x *SecurityHealthAnalyticsSettings_AdminServiceAccountSettings) GetApprovedIdentities() []string {
	if x != nil {
		return x.ApprovedIdentities
	}
	return nil
}

var File_google_cloud_securitycenter_settings_v1beta1_component_settings_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDesc = []byte{
	0x0a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x84, 0x0e, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x15, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x11, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x9f, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x93, 0x01, 0x0a, 0x1f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x2a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48,
	0x00, 0x52, 0x1c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x9c, 0x01, 0x0a, 0x22, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x1f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x85,
	0x01, 0x0a, 0x1d, 0x77, 0x65, 0x62, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x53, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x48, 0x00, 0x52, 0x1a, 0x77, 0x65, 0x62, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0x70, 0x0a, 0x10, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x5c, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x95, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x66, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0xe1, 0x03, 0xea, 0x41, 0xdd, 0x03, 0x0a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x30, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x7d, 0x2f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x5a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x7d, 0x2f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d,
	0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x52, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65,
	0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x13, 0x0a, 0x11, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x14, 0x0a, 0x12, 0x57, 0x65, 0x62,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x53, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x22,
	0x22, 0x0a, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x22, 0x1e, 0x0a, 0x1c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x22, 0x94, 0x04, 0x0a, 0x1f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xa3, 0x01, 0x0a, 0x1b, 0x6e, 0x6f, 0x6e, 0x5f,
	0x6f, 0x72, 0x67, 0x5f, 0x69, 0x61, 0x6d, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x4e, 0x6f, 0x6e,
	0x4f, 0x72, 0x67, 0x49, 0x61, 0x6d, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x17, 0x6e, 0x6f, 0x6e, 0x4f, 0x72, 0x67, 0x49, 0x61, 0x6d, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xae, 0x01,
	0x0a, 0x1e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x1b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0x4a,
	0x0a, 0x17, 0x4e, 0x6f, 0x6e, 0x4f, 0x72, 0x67, 0x49, 0x61, 0x6d, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x4e, 0x0a, 0x1b, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2a, 0x6c, 0x0a, 0x18, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x26, 0x43, 0x4f, 0x4d, 0x50, 0x4f, 0x4e,
	0x45, 0x4e, 0x54, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x49,
	0x4e, 0x48, 0x45, 0x52, 0x49, 0x54, 0x10, 0x03, 0x42, 0xae, 0x02, 0x0a, 0x30, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x16, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x2c, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x2c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5c, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x30, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescData = file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDesc
)

func file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDescData
}

var file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_goTypes = []interface{}{
	(ComponentEnablementState)(0),              // 0: google.cloud.securitycenter.settings.v1beta1.ComponentEnablementState
	(*ComponentSettings)(nil),                  // 1: google.cloud.securitycenter.settings.v1beta1.ComponentSettings
	(*WebSecurityScanner)(nil),                 // 2: google.cloud.securitycenter.settings.v1beta1.WebSecurityScanner
	(*ContainerThreatDetectionSettings)(nil),   // 3: google.cloud.securitycenter.settings.v1beta1.ContainerThreatDetectionSettings
	(*EventThreatDetectionSettings)(nil),       // 4: google.cloud.securitycenter.settings.v1beta1.EventThreatDetectionSettings
	(*SecurityHealthAnalyticsSettings)(nil),    // 5: google.cloud.securitycenter.settings.v1beta1.SecurityHealthAnalyticsSettings
	(*ComponentSettings_DetectorSettings)(nil), // 6: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.DetectorSettings
	nil, // 7: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.DetectorSettingsEntry
	(*SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings)(nil),     // 8: google.cloud.securitycenter.settings.v1beta1.SecurityHealthAnalyticsSettings.NonOrgIamMemberSettings
	(*SecurityHealthAnalyticsSettings_AdminServiceAccountSettings)(nil), // 9: google.cloud.securitycenter.settings.v1beta1.SecurityHealthAnalyticsSettings.AdminServiceAccountSettings
	(*timestamppb.Timestamp)(nil),                                       // 10: google.protobuf.Timestamp
}
var file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_depIdxs = []int32{
	0,  // 0: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.state:type_name -> google.cloud.securitycenter.settings.v1beta1.ComponentEnablementState
	7,  // 1: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.detector_settings:type_name -> google.cloud.securitycenter.settings.v1beta1.ComponentSettings.DetectorSettingsEntry
	10, // 2: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.update_time:type_name -> google.protobuf.Timestamp
	3,  // 3: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.container_threat_detection_settings:type_name -> google.cloud.securitycenter.settings.v1beta1.ContainerThreatDetectionSettings
	4,  // 4: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.event_threat_detection_settings:type_name -> google.cloud.securitycenter.settings.v1beta1.EventThreatDetectionSettings
	5,  // 5: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.security_health_analytics_settings:type_name -> google.cloud.securitycenter.settings.v1beta1.SecurityHealthAnalyticsSettings
	2,  // 6: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.web_security_scanner_settings:type_name -> google.cloud.securitycenter.settings.v1beta1.WebSecurityScanner
	8,  // 7: google.cloud.securitycenter.settings.v1beta1.SecurityHealthAnalyticsSettings.non_org_iam_member_settings:type_name -> google.cloud.securitycenter.settings.v1beta1.SecurityHealthAnalyticsSettings.NonOrgIamMemberSettings
	9,  // 8: google.cloud.securitycenter.settings.v1beta1.SecurityHealthAnalyticsSettings.admin_service_account_settings:type_name -> google.cloud.securitycenter.settings.v1beta1.SecurityHealthAnalyticsSettings.AdminServiceAccountSettings
	0,  // 9: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.DetectorSettings.state:type_name -> google.cloud.securitycenter.settings.v1beta1.ComponentEnablementState
	6,  // 10: google.cloud.securitycenter.settings.v1beta1.ComponentSettings.DetectorSettingsEntry.value:type_name -> google.cloud.securitycenter.settings.v1beta1.ComponentSettings.DetectorSettings
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_init() }
func file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_init() {
	if File_google_cloud_securitycenter_settings_v1beta1_component_settings_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComponentSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebSecurityScanner); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerThreatDetectionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventThreatDetectionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityHealthAnalyticsSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComponentSettings_DetectorSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityHealthAnalyticsSettings_NonOrgIamMemberSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityHealthAnalyticsSettings_AdminServiceAccountSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ComponentSettings_ContainerThreatDetectionSettings)(nil),
		(*ComponentSettings_EventThreatDetectionSettings)(nil),
		(*ComponentSettings_SecurityHealthAnalyticsSettings)(nil),
		(*ComponentSettings_WebSecurityScannerSettings)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_settings_v1beta1_component_settings_proto = out.File
	file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_rawDesc = nil
	file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_goTypes = nil
	file_google_cloud_securitycenter_settings_v1beta1_component_settings_proto_depIdxs = nil
}
