---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Content-Security-Policy analysis

## Description

A missing or invalid `Content-Security-Policy` (CSP) was identified on the target site. CSP can aid in
hardening a website against various client side attacks such as Cross-Site Scripting (XSS).

## Remediation

If the target site is missing a CSP, please investigate the relevant URLs for enabling CSP. Otherwise,
follow the recommendations to determine if any actions are necessary.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 16.8 | true | 16 | Passive | Info |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/16.html)
- [OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Content_Security_Policy_Cheat_Sheet.html)
- [MDN](https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP)
- [Content Security Policy Level 3](https://www.w3.org/TR/CSP3/)
- [CSP Evaluator](https://csp-evaluator.withgoogle.com/)
