# frozen_string_literal: true

require 'spec_helper'

RSpec.describe VulnerabilityFindingSignatureHelpers do
  let(:cls) do
    Class.new do
      include VulnerabilityFindingSignatureHelpers
      attr_accessor :algorithm_type

      def initialize(algorithm_type)
        @algorithm_type = algorithm_type
      end
    end
  end

  describe '#priority' do
    it 'returns numeric values of the priority string' do
      expect(cls.new('rule_value').priority).to eq(5)
      expect(cls.new('scope_offset_compressed').priority).to eq(4)
      expect(cls.new('scope_offset').priority).to eq(3)
      expect(cls.new('location').priority).to eq(2)
      expect(cls.new('hash').priority).to eq(1)
    end
  end

  describe '#self.priority' do
    it 'returns the numeric value of the provided string' do
      expect(cls.priority('rule_value')).to eq(5)
      expect(cls.priority('scope_offset_compressed')).to eq(4)
      expect(cls.priority('scope_offset')).to eq(3)
      expect(cls.priority('location')).to eq(2)
      expect(cls.priority('hash')).to eq(1)
    end
  end
end
