# Givaro: C++ library for arithmetic and algebraic computations

CI Inria: [![Build Status](https://ci.inria.fr/linbox/buildStatus/icon?job=Givaro)](https://ci.inria.fr/linbox/job/Givaro)
Travis: [![Build Status](https://travis-ci.org/linbox-team/givaro.svg?branch=master)](https://travis-ci.org/linbox-team/givaro/)

## License
Givaro is distributed unded the terms of the CeCILL-B free software
license (see COPYING).


## Purpose
Givaro main features are implementations of the basic arithmetic of
many mathematical entities: Primes fields, Extensions Fields, Finite
Fields, Finite Rings, Polynomials, Algebraic numbers, Arbitrary
precision integers and rationals (C++ wrappers over gmp), fixed
precision integers.
It also provides data-structures and templated classes for the
manipulation of basic algebraic objects, such as vectors, matrices,
univariate polynomials (and therefore recursive multivariate).
It contains different program modules and is fully compatible with the
[FFLAS-FFPACK](http://linbox-team.github.io/fflas-ffpack) and
[LinBox](http://linalg.org) linear algebra libraries.


## Download and install

For latest releases, please check out [the Github releases page](https://github.com/linbox-team/givaro/releases); older releases can be found on [the Givaro webpage](https://casys.gricad-pages.univ-grenoble-alpes.fr/givaro).
The installation process depends on your download method. If you downloaded an archive:

```
> tar xzvf givaro-*.tar.gz
> cd givaro-*
> ./configure --prefix=##GIVAROROOT##
> make
$ make install
```

If you cloned the git repository directly, replace `./configure` by `./autogen.sh`:
```
> git clone git@github.com:linbox-team/givaro.git
> cd givaro
> ./autogen.sh --prefix=##GIVAROROOT##
> make
$ make install
```
Running ./autogen.sh will create a configure file that can be used directly for later re-compilations.

*Configuration can be adapted. Check `configure --help` to print the parameter choices.*

*In particular if GMP is not installed to the default location you might need to add for instance `--with-gmp=##GMPROOT##/gmp-x-y-z` to the configure line.*

*Also, on non-Linux systems you might need to use `gmake` instead of `make`.*

## Compile your own files

Givaro uses pkgconfig to expose the compilation flags it requires.

You will get the compilation flags by calling
```
pkg-config --cflags givaro
```
and the linking flags by calling
```
pkg-config --libs givaro
```

If you have installed givaro in a non-standard directory (such as `/usr/local`), make sure to have added the path where to find givaro's .pc file to the PKG_CONFIG_PATH environment variable.
```
PKG_CONFIG_PATH=${PKG_CONFIG_PATH}:<path to your givaro install>/lib/pkgconfig
```

An alternative option is to just add the following line to your Makefile. Then a simple call will compile your C and C++ files.
```
include ##GIVAROROOT##/share/givaro/givaro-makefile
```


## Frequently Asked Questions

- **When compiling, I get error messages similar to**
```
/tmp/ccjZqIED.s: Assembler messages:
/tmp/ccjZqIED.s:142: Error: operand type mismatch for `vxorps'
/tmp/ccjZqIED.s:768: Error: no such instruction: `shlx %rax,%rdx,%rdx'
/tmp/ccjZqIED.s:1067: Error: no such instruction: `shlx %rax,%rdx,%rdx'
```


It means that the assembler is not capable of handling instructions generated by
the compiler. You should either upgrade your assembler (e.g., by upgrading
binutils on Linux) or use **CXXFLAGS** in `./configure` to controls the
instructions generated by the compiler (e.g., by adding -march=..., or
-mno-avx2 or similar, depending on your machine and assembler version).

For more information, see [this link](https://stackoverflow.com/a/51506666).
