/* $Id: samread.h 223146 2020-10-09 18:59:12Z twu $ */
#ifndef SAMREAD_INCLUDED
#define SAMREAD_INCLUDED
#include <stdio.h>
#include "types.h"		/* For HAVE_64_BIT */
#include "samflags.h"
#include "genomicpos.h"
#include "intlist.h"
#include "uintlist.h"
#include "iit-read-univ.h"


#ifdef HAVE_64_BIT
typedef UINT8 Hashseq_T;
#else
typedef UINT4 Hashseq_T;
#endif

extern char *
Samread_parse_line (int *acclength, unsigned int *flag, SAM_split_output_type *split_output,
		    char **hiti, Univcoord_T *genomicpos, Univcoord_T *mate_genomicpos,
		    int *initial_softclip, int *readlength, Hashseq_T *hashseq,
		    char *line, int linelength, Univ_IIT_T chromosome_iit, Univcoord_T *chroffsets,
		    bool need_mate_genomicpos_p);

extern char *
Samread_parse_read (char *line, int linelength, unsigned int flag);

extern char *
Samread_parse_read_and_hiti (char **hiti, char *line, int linelength, unsigned int flag);

extern char *
Samread_flag_duplicate (char *line, int linelength, unsigned int flag);

#endif

