/* music-tree.c generated by valac 0.12.0, the Vala compiler
 * generated from music-tree.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gmpc-extras.h"
#include <plugin.h>
#include <config1.h>
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <misc.h>
#include <metadata.h>
#include <gmpc-profiles.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _meta_data_free0(var) ((var == NULL) ? NULL : (var = (meta_data_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GmpcProviderMusicTreeCheckDirectoryForFilesData GmpcProviderMusicTreeCheckDirectoryForFilesData;
#define __g_list_free__meta_data_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__meta_data_free0_ (var), NULL)))
typedef struct _GmpcProviderMusicTreeWalkBackDirectoryData GmpcProviderMusicTreeWalkBackDirectoryData;
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
typedef struct _GmpcProviderMusicTreeGetArtistArtData GmpcProviderMusicTreeGetArtistArtData;
typedef struct _GmpcProviderMusicTreeGetAlbumCoverData GmpcProviderMusicTreeGetAlbumCoverData;
typedef struct _GmpcProviderMusicTreeGetBiographyData GmpcProviderMusicTreeGetBiographyData;
typedef struct _GmpcProviderMusicTreeGetAlbumInfoData GmpcProviderMusicTreeGetAlbumInfoData;

struct _GmpcProviderMusicTreePrivate {
	gchar* file_type_string;
};

struct _GmpcProviderMusicTreeCheckDirectoryForFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GmpcProviderMusicTree* self;
	GList* list;
	GFile* dir;
	GRegex* query;
	MetaDataType type;
	gchar* _tmp0_;
	gchar* path;
	const gchar* _tmp1_;
	GFileEnumerator* _tmp2_;
	GFileEnumerator* e;
	GList* _tmp3_;
	GList* files;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp4_;
	GFileInfo* info;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* name;
	gboolean _tmp7_;
	gchar _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	MetaData* _tmp11_;
	MetaData* item;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	MetaData* _tmp15_;
	GError * err;
	GError * _inner_error_;
};

struct _GmpcProviderMusicTreeWalkBackDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GmpcProviderMusicTree* self;
	GRegex* regex_query;
	gchar* mpd_directory;
	gchar* filename;
	GList* list;
	MetaDataType type;
	gchar* _tmp0_;
	gchar* base_path;
	gchar* _tmp1_;
	gchar* path;
	GFile* _tmp2_;
	GFile* dir;
	GList* temp;
	GList* _tmp3_;
	GList* _tmp4_;
	GFile* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	GFile* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
};

struct _GmpcProviderMusicTreeGetArtistArtData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GmpcProviderMusicTree* self;
	gchar* directory;
	mpd_Song* song;
	GmpcPluginMetaDataCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GList* list;
	GRegex* regex_query;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GRegex* _tmp4_;
	GRegex* _tmp5_;
	GRegex* _tmp6_;
	GError * erro;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GRegex* _tmp9_;
	GRegex* _tmp10_;
	GRegex* _tmp11_;
	GError * err1;
	GList* _tmp12_;
	guint _tmp13_;
	GList* _tmp14_;
	GError * _inner_error_;
};

struct _GmpcProviderMusicTreeGetAlbumCoverData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GmpcProviderMusicTree* self;
	gchar* directory;
	mpd_Song* song;
	GmpcPluginMetaDataCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GList* list;
	GRegex* regex_query;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GRegex* _tmp4_;
	GRegex* _tmp5_;
	GRegex* _tmp6_;
	GError * erro;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GRegex* _tmp9_;
	GRegex* _tmp10_;
	GRegex* _tmp11_;
	GError * err1;
	GList* _tmp12_;
	guint _tmp13_;
	GList* _tmp14_;
	GError * _inner_error_;
};

struct _GmpcProviderMusicTreeGetBiographyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GmpcProviderMusicTree* self;
	gchar* directory;
	mpd_Song* song;
	GmpcPluginMetaDataCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GList* list;
	GRegex* regex_query;
	GRegex* _tmp0_;
	GRegex* _tmp1_;
	GError * erro;
	GList* _tmp2_;
	guint _tmp3_;
	GList* _tmp4_;
	GError * _inner_error_;
};

struct _GmpcProviderMusicTreeGetAlbumInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GmpcProviderMusicTree* self;
	gchar* directory;
	mpd_Song* song;
	GmpcPluginMetaDataCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GList* list;
	GRegex* regex_query;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GRegex* _tmp2_;
	GRegex* _tmp3_;
	GRegex* _tmp4_;
	GError * erro;
	GList* _tmp5_;
	guint _tmp6_;
	GList* _tmp7_;
	GError * _inner_error_;
};


static gpointer gmpc_provider_music_tree_parent_class = NULL;
static GmpcPluginMetaDataIfaceIface* gmpc_provider_music_tree_gmpc_plugin_meta_data_iface_parent_iface = NULL;

#define use_transition_lp TRUE
#define some_unique_name_lp VERSION
#define log_domain_cp "Gmpc.Providers.MusicTree"
#define GMPC_PROVIDER_MUSIC_TREE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_PROVIDER_TYPE_MUSIC_TREE, GmpcProviderMusicTreePrivate))
enum  {
	GMPC_PROVIDER_MUSIC_TREE_DUMMY_PROPERTY
};
static gint* gmpc_provider_music_tree_real_get_version (GmpcPluginBase* base, int* result_length1);
static const gchar* gmpc_provider_music_tree_real_get_name (GmpcPluginBase* base);
static void gmpc_provider_music_tree_real_set_priority (GmpcPluginMetaDataIface* base, gint priority);
static gint gmpc_provider_music_tree_real_get_priority (GmpcPluginMetaDataIface* base);
static void gmpc_provider_music_tree_real_get_metadata (GmpcPluginMetaDataIface* base, const mpd_Song* song, MetaDataType type, GmpcPluginMetaDataCallback callback, void* callback_target);
static void gmpc_provider_music_tree_get_album_cover (GmpcProviderMusicTree* self, const gchar* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gmpc_provider_music_tree_get_album_cover_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_);
static void gmpc_provider_music_tree_get_artist_art (GmpcProviderMusicTree* self, const gchar* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gmpc_provider_music_tree_get_artist_art_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_);
static void gmpc_provider_music_tree_get_biography (GmpcProviderMusicTree* self, const gchar* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gmpc_provider_music_tree_get_biography_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_);
static void gmpc_provider_music_tree_get_album_info (GmpcProviderMusicTree* self, const gchar* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gmpc_provider_music_tree_get_album_info_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_);
static void gmpc_provider_music_tree_check_directory_for_files_data_free (gpointer _data);
static void gmpc_provider_music_tree_check_directory_for_files (GmpcProviderMusicTree* self, GFile* dir, GRegex* query, MetaDataType type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gmpc_provider_music_tree_check_directory_for_files_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_, GList** list);
static gboolean gmpc_provider_music_tree_check_directory_for_files_co (GmpcProviderMusicTreeCheckDirectoryForFilesData* data);
static void gmpc_provider_music_tree_check_directory_for_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void gmpc_provider_music_tree_walk_back_directory_data_free (gpointer _data);
static void gmpc_provider_music_tree_walk_back_directory (GmpcProviderMusicTree* self, GRegex* regex_query, const gchar* mpd_directory, const gchar* filename, MetaDataType type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gmpc_provider_music_tree_walk_back_directory_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_, GList** list);
static gboolean gmpc_provider_music_tree_walk_back_directory_co (GmpcProviderMusicTreeWalkBackDirectoryData* data);
static void gmpc_provider_music_tree_walk_back_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _meta_data_free0_ (gpointer var);
static void _g_list_free__meta_data_free0_ (GList* self);
static void gmpc_provider_music_tree_get_artist_art_data_free (gpointer _data);
static gboolean gmpc_provider_music_tree_get_artist_art_co (GmpcProviderMusicTreeGetArtistArtData* data);
static void gmpc_provider_music_tree_get_artist_art_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gmpc_provider_music_tree_get_album_cover_data_free (gpointer _data);
static gboolean gmpc_provider_music_tree_get_album_cover_co (GmpcProviderMusicTreeGetAlbumCoverData* data);
static void gmpc_provider_music_tree_get_album_cover_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gmpc_provider_music_tree_get_biography_data_free (gpointer _data);
static gboolean gmpc_provider_music_tree_get_biography_co (GmpcProviderMusicTreeGetBiographyData* data);
static void gmpc_provider_music_tree_get_biography_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gmpc_provider_music_tree_get_album_info_data_free (gpointer _data);
static gboolean gmpc_provider_music_tree_get_album_info_co (GmpcProviderMusicTreeGetAlbumInfoData* data);
static void gmpc_provider_music_tree_get_album_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GObject * gmpc_provider_music_tree_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_provider_music_tree_finalize (GObject* obj);

static const gint GMPC_PROVIDER_MUSIC_TREE_version[3] = {0, 0, 2};

static gint* gmpc_provider_music_tree_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcProviderMusicTree * self;
	gint* result = NULL;
	gint* _tmp0_;
	self = (GmpcProviderMusicTree*) base;
	_tmp0_ = GMPC_PROVIDER_MUSIC_TREE_version;
	*result_length1 = G_N_ELEMENTS (GMPC_PROVIDER_MUSIC_TREE_version);
	result = _tmp0_;
	return result;
}


static const gchar* gmpc_provider_music_tree_real_get_name (GmpcPluginBase* base) {
	GmpcProviderMusicTree * self;
	const gchar* result = NULL;
	self = (GmpcProviderMusicTree*) base;
	result = "Music Tree Provider";
	return result;
}


static void gmpc_provider_music_tree_real_set_priority (GmpcPluginMetaDataIface* base, gint priority) {
	GmpcProviderMusicTree * self;
	const gchar* _tmp0_ = NULL;
	self = (GmpcProviderMusicTree*) base;
	_tmp0_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	cfg_set_single_value_as_int (config, _tmp0_, "priority", priority);
}


static gint gmpc_provider_music_tree_real_get_priority (GmpcPluginMetaDataIface* base) {
	GmpcProviderMusicTree * self;
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	self = (GmpcProviderMusicTree*) base;
	_tmp0_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	_tmp1_ = cfg_get_single_value_as_int_with_default (config, _tmp0_, "priority", 0);
	result = _tmp1_;
	return result;
}


/********************************
 * metadata code                *
 ********************************/
static void gmpc_provider_music_tree_real_get_metadata (GmpcPluginMetaDataIface* base, const mpd_Song* song, MetaDataType type, GmpcPluginMetaDataCallback callback, void* callback_target) {
	GmpcProviderMusicTree * self;
	gchar* _tmp0_ = NULL;
	gchar* id;
	const gchar* directory;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gchar* _tmp6_ = NULL;
	gchar* scheme;
	self = (GmpcProviderMusicTree*) base;
	g_return_if_fail (song != NULL);
	_tmp0_ = gmpc_profiles_get_current (gmpc_profiles);
	id = _tmp0_;
	directory = NULL;
	if (id != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = gmpc_profiles_get_music_directory (gmpc_profiles, id);
		directory = _tmp1_;
	}
	if (directory == NULL) {
		_tmp2_ = "(null)";
	} else {
		_tmp2_ = directory;
	}
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:96: Got directory: %s", _tmp2_);
	if (directory == NULL) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = strlen (directory);
		_tmp3_ = _tmp4_ == 0;
	}
	if (_tmp3_) {
		g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:101: No Music directory specified");
		callback (NULL, callback_target);
		_g_free0 (id);
		return;
	}
	if (song == NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = song->file == NULL;
	}
	if (_tmp5_) {
		g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:113: No Song or no song path specified");
		callback (NULL, callback_target);
		_g_free0 (id);
		return;
	}
	_tmp6_ = g_uri_parse_scheme (song->file);
	scheme = _tmp6_;
	if (scheme != NULL) {
		g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:124: Scheme '%s' indicates no local file.", scheme);
		callback (NULL, callback_target);
		_g_free0 (scheme);
		_g_free0 (id);
		return;
	}
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:130: Music directory: %s", directory);
	switch (type) {
		case META_ALBUM_ART:
		{
			gmpc_provider_music_tree_get_album_cover (self, directory, song, callback, callback_target, NULL, NULL);
			_g_free0 (scheme);
			_g_free0 (id);
			return;
		}
		case META_ARTIST_ART:
		{
			gmpc_provider_music_tree_get_artist_art (self, directory, song, callback, callback_target, NULL, NULL);
			_g_free0 (scheme);
			_g_free0 (id);
			return;
		}
		case META_ARTIST_TXT:
		{
			gmpc_provider_music_tree_get_biography (self, directory, song, callback, callback_target, NULL, NULL);
			_g_free0 (scheme);
			_g_free0 (id);
			return;
		}
		case META_ALBUM_TXT:
		{
			gmpc_provider_music_tree_get_album_info (self, directory, song, callback, callback_target, NULL, NULL);
			_g_free0 (scheme);
			_g_free0 (id);
			return;
		}
		case META_SONG_TXT:
		case META_SONG_GUITAR_TAB:
		{
			break;
		}
		case META_ARTIST_SIMILAR:
		case META_SONG_SIMILAR:
		case META_GENRE_SIMILAR:
		{
			break;
		}
		default:
		case META_QUERY_DATA_TYPES:
		case META_QUERY_NO_CACHE:
		{
			break;
		}
	}
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:166: Unsupported metadata, doing nothing ");
	callback (NULL, callback_target);
	_g_free0 (scheme);
	_g_free0 (id);
}


static void gmpc_provider_music_tree_check_directory_for_files_data_free (gpointer _data) {
	GmpcProviderMusicTreeCheckDirectoryForFilesData* data;
	data = _data;
	_g_object_unref0 (data->dir);
	_g_regex_unref0 (data->query);
	_g_object_unref0 (data->self);
	g_slice_free (GmpcProviderMusicTreeCheckDirectoryForFilesData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


static void gmpc_provider_music_tree_check_directory_for_files (GmpcProviderMusicTree* self, GFile* dir, GRegex* query, MetaDataType type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GmpcProviderMusicTreeCheckDirectoryForFilesData* _data_;
	_data_ = g_slice_new0 (GmpcProviderMusicTreeCheckDirectoryForFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gmpc_provider_music_tree_check_directory_for_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gmpc_provider_music_tree_check_directory_for_files_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->dir = _g_object_ref0 (dir);
	_data_->query = _g_regex_ref0 (query);
	_data_->type = type;
	gmpc_provider_music_tree_check_directory_for_files_co (_data_);
}


static void gmpc_provider_music_tree_check_directory_for_files_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_, GList** list) {
	GmpcProviderMusicTreeCheckDirectoryForFilesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*list = _data_->list;
	_data_->list = NULL;
}


/**
 * Helper functions
 */
static void gmpc_provider_music_tree_check_directory_for_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GmpcProviderMusicTreeCheckDirectoryForFilesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gmpc_provider_music_tree_check_directory_for_files_co (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gboolean gmpc_provider_music_tree_check_directory_for_files_co (GmpcProviderMusicTreeCheckDirectoryForFilesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_get_path (data->dir);
	data->path = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_regex_get_pattern (data->query);
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:182: Checking %s with pattern: %s", data->path, data->_tmp1_);
	data->_state_ = 1;
	g_file_enumerate_children_async (data->dir, "standard,access::*", 0, G_PRIORITY_DEFAULT, NULL, gmpc_provider_music_tree_check_directory_for_files_ready, data);
	return FALSE;
	_state_1:
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_file_enumerate_children_finish (data->dir, data->_res_, &data->_inner_error_);
	data->e = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		goto __catch16_g_error;
	}
	while (TRUE) {
		data->_state_ = 2;
		g_file_enumerator_next_files_async (data->e, 10, G_PRIORITY_DEFAULT, NULL, gmpc_provider_music_tree_check_directory_for_files_ready, data);
		return FALSE;
		_state_2:
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_file_enumerator_next_files_finish (data->e, data->_res_, &data->_inner_error_);
		data->files = data->_tmp3_;
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->e);
			goto __catch16_g_error;
		}
		if (data->files == NULL) {
			__g_list_free__g_object_unref0_0 (data->files);
			break;
		}
		{
			data->info_collection = data->files;
			for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
				data->_tmp4_ = _g_object_ref0 ((GFileInfo*) data->info_it->data);
				data->info = data->_tmp4_;
				{
					data->_tmp5_ = NULL;
					data->_tmp5_ = g_file_info_get_name (data->info);
					data->_tmp6_ = g_strdup (data->_tmp5_);
					data->name = data->_tmp6_;
					g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:199: got file: %s", data->name);
					data->_tmp8_ = string_get (data->name, (glong) 0);
					if (data->_tmp8_ != '.') {
						data->_tmp9_ = g_regex_match (data->query, data->name, 0, NULL);
						data->_tmp7_ = data->_tmp9_;
					} else {
						data->_tmp7_ = FALSE;
					}
					if (data->_tmp7_) {
						g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:203: Got path: %s. Have info", data->name);
						data->_tmp10_ = g_file_info_get_attribute_boolean (data->info, "access::can-read");
						if (data->_tmp10_) {
							data->_tmp11_ = NULL;
							data->_tmp11_ = meta_data_new ();
							data->item = data->_tmp11_;
							data->item->type = data->type;
							data->_tmp12_ = NULL;
							data->_tmp12_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) data->self);
							data->item->plugin_name = data->_tmp12_;
							data->item->content_type = META_DATA_CONTENT_URI;
							data->_tmp13_ = NULL;
							data->_tmp13_ = g_build_filename (data->path, data->name, NULL);
							data->_tmp14_ = data->_tmp13_;
							meta_data_set_uri (data->item, data->_tmp14_);
							_g_free0 (data->_tmp14_);
							data->_tmp15_ = data->item;
							data->item = NULL;
							data->list = g_list_append (data->list, data->_tmp15_);
							g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:213: Found %s/%s, adding", data->path, data->name);
							_meta_data_free0 (data->item);
						}
					}
					_g_free0 (data->name);
					_g_object_unref0 (data->info);
				}
			}
		}
		__g_list_free__g_object_unref0_0 (data->files);
	}
	_g_object_unref0 (data->e);
	goto __finally16;
	__catch16_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_log (log_domain_cp, G_LOG_LEVEL_WARNING, "music-tree.vala:223: Error trying to walk directory '%s': %s\n", data->path, data->err->message);
		_g_error_free0 (data->err);
	}
	__finally16:
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_free0 (data->path);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void gmpc_provider_music_tree_walk_back_directory_data_free (gpointer _data) {
	GmpcProviderMusicTreeWalkBackDirectoryData* data;
	data = _data;
	_g_regex_unref0 (data->regex_query);
	_g_free0 (data->mpd_directory);
	_g_free0 (data->filename);
	_g_object_unref0 (data->self);
	g_slice_free (GmpcProviderMusicTreeWalkBackDirectoryData, data);
}


static void gmpc_provider_music_tree_walk_back_directory (GmpcProviderMusicTree* self, GRegex* regex_query, const gchar* mpd_directory, const gchar* filename, MetaDataType type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GmpcProviderMusicTreeWalkBackDirectoryData* _data_;
	_data_ = g_slice_new0 (GmpcProviderMusicTreeWalkBackDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gmpc_provider_music_tree_walk_back_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gmpc_provider_music_tree_walk_back_directory_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->regex_query = _g_regex_ref0 (regex_query);
	_data_->mpd_directory = g_strdup (mpd_directory);
	_data_->filename = g_strdup (filename);
	_data_->type = type;
	gmpc_provider_music_tree_walk_back_directory_co (_data_);
}


static void gmpc_provider_music_tree_walk_back_directory_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_, GList** list) {
	GmpcProviderMusicTreeWalkBackDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*list = _data_->list;
	_data_->list = NULL;
}


/**
 * Walks back the directory 3 levels.
 */
static void gmpc_provider_music_tree_walk_back_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GmpcProviderMusicTreeWalkBackDirectoryData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gmpc_provider_music_tree_walk_back_directory_co (data);
}


static void _meta_data_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (meta_data_free (var), NULL));
}


static void _g_list_free__meta_data_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _meta_data_free0_, NULL);
	g_list_free (self);
}


static gboolean gmpc_provider_music_tree_walk_back_directory_co (GmpcProviderMusicTreeWalkBackDirectoryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_path_get_dirname (data->filename);
	data->base_path = data->_tmp0_;
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:237: Got basename: %s", data->base_path);
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_build_filename (data->mpd_directory, data->base_path, NULL);
	data->path = data->_tmp1_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_file_new_for_path (data->path);
	data->dir = data->_tmp2_;
	data->temp = NULL;
	data->_tmp3_ = NULL;
	data->_state_ = 1;
	gmpc_provider_music_tree_check_directory_for_files (data->self, data->dir, data->regex_query, data->type, gmpc_provider_music_tree_walk_back_directory_ready, data);
	return FALSE;
	_state_1:
	gmpc_provider_music_tree_check_directory_for_files_finish (data->self, data->_res_, &data->_tmp3_);
	__g_list_free__meta_data_free0_0 (data->temp);
	data->temp = data->_tmp3_;
	data->_tmp4_ = data->temp;
	data->temp = NULL;
	data->list = g_list_concat (data->list, data->_tmp4_);
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_file_get_parent (data->dir);
	_g_object_unref0 (data->dir);
	data->dir = data->_tmp5_;
	if (data->dir != NULL) {
		data->_tmp6_ = NULL;
		data->_state_ = 2;
		gmpc_provider_music_tree_check_directory_for_files (data->self, data->dir, data->regex_query, data->type, gmpc_provider_music_tree_walk_back_directory_ready, data);
		return FALSE;
		_state_2:
		gmpc_provider_music_tree_check_directory_for_files_finish (data->self, data->_res_, &data->_tmp6_);
		__g_list_free__meta_data_free0_0 (data->temp);
		data->temp = data->_tmp6_;
		data->_tmp7_ = data->temp;
		data->temp = NULL;
		data->list = g_list_concat (data->list, data->_tmp7_);
		data->_tmp8_ = NULL;
		data->_tmp8_ = g_file_get_parent (data->dir);
		_g_object_unref0 (data->dir);
		data->dir = data->_tmp8_;
		if (data->dir != NULL) {
			data->_tmp9_ = NULL;
			data->_state_ = 3;
			gmpc_provider_music_tree_check_directory_for_files (data->self, data->dir, data->regex_query, data->type, gmpc_provider_music_tree_walk_back_directory_ready, data);
			return FALSE;
			_state_3:
			gmpc_provider_music_tree_check_directory_for_files_finish (data->self, data->_res_, &data->_tmp9_);
			__g_list_free__meta_data_free0_0 (data->temp);
			data->temp = data->_tmp9_;
			data->_tmp10_ = data->temp;
			data->temp = NULL;
			data->list = g_list_concat (data->list, data->_tmp10_);
		}
	}
	__g_list_free__meta_data_free0_0 (data->temp);
	_g_object_unref0 (data->dir);
	_g_free0 (data->path);
	_g_free0 (data->base_path);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void gmpc_provider_music_tree_get_artist_art_data_free (gpointer _data) {
	GmpcProviderMusicTreeGetArtistArtData* data;
	data = _data;
	_g_free0 (data->directory);
	_mpd_freeSong0 (data->song);
	_g_object_unref0 (data->self);
	g_slice_free (GmpcProviderMusicTreeGetArtistArtData, data);
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static void gmpc_provider_music_tree_get_artist_art (GmpcProviderMusicTree* self, const gchar* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetArtistArtData* _data_;
	_data_ = g_slice_new0 (GmpcProviderMusicTreeGetArtistArtData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gmpc_provider_music_tree_get_artist_art);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gmpc_provider_music_tree_get_artist_art_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->directory = g_strdup (directory);
	_data_->song = _mpd_songDup0 (song);
	_data_->callback = callback;
	_data_->callback_target = callback_target;
	gmpc_provider_music_tree_get_artist_art_co (_data_);
}


static void gmpc_provider_music_tree_get_artist_art_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_) {
	GmpcProviderMusicTreeGetArtistArtData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
 * Get artist art
 */
static void gmpc_provider_music_tree_get_artist_art_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetArtistArtData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gmpc_provider_music_tree_get_artist_art_co (data);
}


static gboolean gmpc_provider_music_tree_get_artist_art_co (GmpcProviderMusicTreeGetArtistArtData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->list = NULL;
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:266: Query artist art ");
	data->regex_query = NULL;
	if (data->song->artist != NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = g_regex_escape_string (data->song->artist, -1);
		data->_tmp1_ = data->_tmp0_;
		data->_tmp2_ = NULL;
		data->_tmp2_ = g_strdup_printf ("^(artist|%s)\\.%s$", data->_tmp1_, data->self->priv->file_type_string);
		data->_tmp3_ = data->_tmp2_;
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_regex_new (data->_tmp3_, G_REGEX_CASELESS | G_REGEX_DOTALL, 0, &data->_inner_error_);
		data->_tmp5_ = data->_tmp4_;
		_g_free0 (data->_tmp3_);
		_g_free0 (data->_tmp1_);
		data->_tmp6_ = data->_tmp5_;
		if (data->_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
		_g_regex_unref0 (data->regex_query);
		data->regex_query = data->_tmp6_;
		goto __finally17;
		__catch17_g_error:
		{
			data->erro = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:282: Failed to create regex: %s", data->erro->message);
			data->callback (NULL, data->callback_target);
			_g_error_free0 (data->erro);
			_g_regex_unref0 (data->regex_query);
			__g_list_free__meta_data_free0_0 (data->list);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		__finally17:
		if (data->_inner_error_ != NULL) {
			_g_regex_unref0 (data->regex_query);
			__g_list_free__meta_data_free0_0 (data->list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	} else {
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_strdup_printf ("^(artist)\\.%s$", data->self->priv->file_type_string);
		data->_tmp8_ = data->_tmp7_;
		data->_tmp9_ = NULL;
		data->_tmp9_ = g_regex_new (data->_tmp8_, G_REGEX_CASELESS | G_REGEX_DOTALL, 0, &data->_inner_error_);
		data->_tmp10_ = data->_tmp9_;
		_g_free0 (data->_tmp8_);
		data->_tmp11_ = data->_tmp10_;
		if (data->_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_g_regex_unref0 (data->regex_query);
		data->regex_query = data->_tmp11_;
		goto __finally18;
		__catch18_g_error:
		{
			data->err1 = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:299: Failed to create regex: %s", data->err1->message);
			data->callback (NULL, data->callback_target);
			_g_error_free0 (data->err1);
			_g_regex_unref0 (data->regex_query);
			__g_list_free__meta_data_free0_0 (data->list);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		__finally18:
		if (data->_inner_error_ != NULL) {
			_g_regex_unref0 (data->regex_query);
			__g_list_free__meta_data_free0_0 (data->list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp12_ = NULL;
	data->_state_ = 1;
	gmpc_provider_music_tree_walk_back_directory (data->self, data->regex_query, data->directory, data->song->file, META_ARTIST_ART, gmpc_provider_music_tree_get_artist_art_ready, data);
	return FALSE;
	_state_1:
	gmpc_provider_music_tree_walk_back_directory_finish (data->self, data->_res_, &data->_tmp12_);
	__g_list_free__meta_data_free0_0 (data->list);
	data->list = data->_tmp12_;
	data->_tmp13_ = g_list_length (data->list);
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:307: Query done, %u results", data->_tmp13_);
	g_list_first (data->list);
	data->_tmp14_ = data->list;
	data->list = NULL;
	data->callback (data->_tmp14_, data->callback_target);
	_g_regex_unref0 (data->regex_query);
	__g_list_free__meta_data_free0_0 (data->list);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_regex_unref0 (data->regex_query);
	__g_list_free__meta_data_free0_0 (data->list);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void gmpc_provider_music_tree_get_album_cover_data_free (gpointer _data) {
	GmpcProviderMusicTreeGetAlbumCoverData* data;
	data = _data;
	_g_free0 (data->directory);
	_mpd_freeSong0 (data->song);
	_g_object_unref0 (data->self);
	g_slice_free (GmpcProviderMusicTreeGetAlbumCoverData, data);
}


static void gmpc_provider_music_tree_get_album_cover (GmpcProviderMusicTree* self, const gchar* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetAlbumCoverData* _data_;
	_data_ = g_slice_new0 (GmpcProviderMusicTreeGetAlbumCoverData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gmpc_provider_music_tree_get_album_cover);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gmpc_provider_music_tree_get_album_cover_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->directory = g_strdup (directory);
	_data_->song = _mpd_songDup0 (song);
	_data_->callback = callback;
	_data_->callback_target = callback_target;
	gmpc_provider_music_tree_get_album_cover_co (_data_);
}


static void gmpc_provider_music_tree_get_album_cover_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_) {
	GmpcProviderMusicTreeGetAlbumCoverData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
 * Get album cover
 */
static void gmpc_provider_music_tree_get_album_cover_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetAlbumCoverData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gmpc_provider_music_tree_get_album_cover_co (data);
}


static gboolean gmpc_provider_music_tree_get_album_cover_co (GmpcProviderMusicTreeGetAlbumCoverData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->list = NULL;
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:319: Query album cover");
	data->regex_query = NULL;
	if (data->song->album != NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = g_regex_escape_string (data->song->album, -1);
		data->_tmp1_ = data->_tmp0_;
		data->_tmp2_ = NULL;
		data->_tmp2_ = g_strdup_printf ("^(folder|cover|.*%s.*)\\.%s$", data->_tmp1_, data->self->priv->file_type_string);
		data->_tmp3_ = data->_tmp2_;
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_regex_new (data->_tmp3_, G_REGEX_CASELESS | G_REGEX_DOTALL, 0, &data->_inner_error_);
		data->_tmp5_ = data->_tmp4_;
		_g_free0 (data->_tmp3_);
		_g_free0 (data->_tmp1_);
		data->_tmp6_ = data->_tmp5_;
		if (data->_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_g_regex_unref0 (data->regex_query);
		data->regex_query = data->_tmp6_;
		goto __finally19;
		__catch19_g_error:
		{
			data->erro = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:335: Failed to create regex: %s", data->erro->message);
			data->callback (NULL, data->callback_target);
			_g_error_free0 (data->erro);
			_g_regex_unref0 (data->regex_query);
			__g_list_free__meta_data_free0_0 (data->list);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		__finally19:
		if (data->_inner_error_ != NULL) {
			_g_regex_unref0 (data->regex_query);
			__g_list_free__meta_data_free0_0 (data->list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	} else {
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_strdup_printf ("^(folder|cover)\\.%s$", data->self->priv->file_type_string);
		data->_tmp8_ = data->_tmp7_;
		data->_tmp9_ = NULL;
		data->_tmp9_ = g_regex_new (data->_tmp8_, G_REGEX_CASELESS | G_REGEX_DOTALL, 0, &data->_inner_error_);
		data->_tmp10_ = data->_tmp9_;
		_g_free0 (data->_tmp8_);
		data->_tmp11_ = data->_tmp10_;
		if (data->_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
		_g_regex_unref0 (data->regex_query);
		data->regex_query = data->_tmp11_;
		goto __finally20;
		__catch20_g_error:
		{
			data->err1 = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:352: Failed to create regex: %s", data->err1->message);
			data->callback (NULL, data->callback_target);
			_g_error_free0 (data->err1);
			_g_regex_unref0 (data->regex_query);
			__g_list_free__meta_data_free0_0 (data->list);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		__finally20:
		if (data->_inner_error_ != NULL) {
			_g_regex_unref0 (data->regex_query);
			__g_list_free__meta_data_free0_0 (data->list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp12_ = NULL;
	data->_state_ = 1;
	gmpc_provider_music_tree_walk_back_directory (data->self, data->regex_query, data->directory, data->song->file, META_ALBUM_ART, gmpc_provider_music_tree_get_album_cover_ready, data);
	return FALSE;
	_state_1:
	gmpc_provider_music_tree_walk_back_directory_finish (data->self, data->_res_, &data->_tmp12_);
	__g_list_free__meta_data_free0_0 (data->list);
	data->list = data->_tmp12_;
	g_list_first (data->list);
	data->_tmp13_ = g_list_length (data->list);
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:361: Query done, %u results", data->_tmp13_);
	data->_tmp14_ = data->list;
	data->list = NULL;
	data->callback (data->_tmp14_, data->callback_target);
	_g_regex_unref0 (data->regex_query);
	__g_list_free__meta_data_free0_0 (data->list);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_regex_unref0 (data->regex_query);
	__g_list_free__meta_data_free0_0 (data->list);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void gmpc_provider_music_tree_get_biography_data_free (gpointer _data) {
	GmpcProviderMusicTreeGetBiographyData* data;
	data = _data;
	_g_free0 (data->directory);
	_mpd_freeSong0 (data->song);
	_g_object_unref0 (data->self);
	g_slice_free (GmpcProviderMusicTreeGetBiographyData, data);
}


static void gmpc_provider_music_tree_get_biography (GmpcProviderMusicTree* self, const gchar* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetBiographyData* _data_;
	_data_ = g_slice_new0 (GmpcProviderMusicTreeGetBiographyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gmpc_provider_music_tree_get_biography);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gmpc_provider_music_tree_get_biography_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->directory = g_strdup (directory);
	_data_->song = _mpd_songDup0 (song);
	_data_->callback = callback;
	_data_->callback_target = callback_target;
	gmpc_provider_music_tree_get_biography_co (_data_);
}


static void gmpc_provider_music_tree_get_biography_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_) {
	GmpcProviderMusicTreeGetBiographyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
 * Get biography
 */
static void gmpc_provider_music_tree_get_biography_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetBiographyData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gmpc_provider_music_tree_get_biography_co (data);
}


static gboolean gmpc_provider_music_tree_get_biography_co (GmpcProviderMusicTreeGetBiographyData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->list = NULL;
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:372: Query biography");
	data->regex_query = NULL;
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_regex_new ("^BIOGRAPHY(\\.txt)?$", G_REGEX_CASELESS | G_REGEX_DOTALL, 0, &data->_inner_error_);
	data->_tmp1_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		goto __catch21_g_error;
	}
	_g_regex_unref0 (data->regex_query);
	data->regex_query = data->_tmp1_;
	goto __finally21;
	__catch21_g_error:
	{
		data->erro = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:385: Failed to create regex: %s", data->erro->message);
		data->callback (NULL, data->callback_target);
		_g_error_free0 (data->erro);
		_g_regex_unref0 (data->regex_query);
		__g_list_free__meta_data_free0_0 (data->list);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally21:
	if (data->_inner_error_ != NULL) {
		_g_regex_unref0 (data->regex_query);
		__g_list_free__meta_data_free0_0 (data->list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp2_ = NULL;
	data->_state_ = 1;
	gmpc_provider_music_tree_walk_back_directory (data->self, data->regex_query, data->directory, data->song->file, META_ARTIST_TXT, gmpc_provider_music_tree_get_biography_ready, data);
	return FALSE;
	_state_1:
	gmpc_provider_music_tree_walk_back_directory_finish (data->self, data->_res_, &data->_tmp2_);
	__g_list_free__meta_data_free0_0 (data->list);
	data->list = data->_tmp2_;
	data->_tmp3_ = g_list_length (data->list);
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:392: Query done, %u results", data->_tmp3_);
	g_list_first (data->list);
	data->_tmp4_ = data->list;
	data->list = NULL;
	data->callback (data->_tmp4_, data->callback_target);
	_g_regex_unref0 (data->regex_query);
	__g_list_free__meta_data_free0_0 (data->list);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_regex_unref0 (data->regex_query);
	__g_list_free__meta_data_free0_0 (data->list);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void gmpc_provider_music_tree_get_album_info_data_free (gpointer _data) {
	GmpcProviderMusicTreeGetAlbumInfoData* data;
	data = _data;
	_g_free0 (data->directory);
	_mpd_freeSong0 (data->song);
	_g_object_unref0 (data->self);
	g_slice_free (GmpcProviderMusicTreeGetAlbumInfoData, data);
}


static void gmpc_provider_music_tree_get_album_info (GmpcProviderMusicTree* self, const gchar* directory, const mpd_Song* song, GmpcPluginMetaDataCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetAlbumInfoData* _data_;
	_data_ = g_slice_new0 (GmpcProviderMusicTreeGetAlbumInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gmpc_provider_music_tree_get_album_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gmpc_provider_music_tree_get_album_info_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->directory = g_strdup (directory);
	_data_->song = _mpd_songDup0 (song);
	_data_->callback = callback;
	_data_->callback_target = callback_target;
	gmpc_provider_music_tree_get_album_info_co (_data_);
}


static void gmpc_provider_music_tree_get_album_info_finish (GmpcProviderMusicTree* self, GAsyncResult* _res_) {
	GmpcProviderMusicTreeGetAlbumInfoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
 * Get album information
 */
static void gmpc_provider_music_tree_get_album_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GmpcProviderMusicTreeGetAlbumInfoData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gmpc_provider_music_tree_get_album_info_co (data);
}


static gboolean gmpc_provider_music_tree_get_album_info_co (GmpcProviderMusicTreeGetAlbumInfoData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->list = NULL;
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:404: Query biography");
	data->regex_query = NULL;
	if (data->song->album == NULL) {
		g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:410: Album is not set.");
		data->callback (NULL, data->callback_target);
		_g_regex_unref0 (data->regex_query);
		__g_list_free__meta_data_free0_0 (data->list);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_strdup_printf ("^.*%s.*\\.(txt|info)$", data->song->album);
	data->_tmp1_ = data->_tmp0_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_regex_new (data->_tmp1_, G_REGEX_CASELESS | G_REGEX_DOTALL, 0, &data->_inner_error_);
	data->_tmp3_ = data->_tmp2_;
	_g_free0 (data->_tmp1_);
	data->_tmp4_ = data->_tmp3_;
	if (data->_inner_error_ != NULL) {
		goto __catch22_g_error;
	}
	_g_regex_unref0 (data->regex_query);
	data->regex_query = data->_tmp4_;
	goto __finally22;
	__catch22_g_error:
	{
		data->erro = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:424: Failed to create regex: %s", data->erro->message);
		data->callback (NULL, data->callback_target);
		_g_error_free0 (data->erro);
		_g_regex_unref0 (data->regex_query);
		__g_list_free__meta_data_free0_0 (data->list);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally22:
	if (data->_inner_error_ != NULL) {
		_g_regex_unref0 (data->regex_query);
		__g_list_free__meta_data_free0_0 (data->list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp5_ = NULL;
	data->_state_ = 1;
	gmpc_provider_music_tree_walk_back_directory (data->self, data->regex_query, data->directory, data->song->file, META_ARTIST_TXT, gmpc_provider_music_tree_get_album_info_ready, data);
	return FALSE;
	_state_1:
	gmpc_provider_music_tree_walk_back_directory_finish (data->self, data->_res_, &data->_tmp5_);
	__g_list_free__meta_data_free0_0 (data->list);
	data->list = data->_tmp5_;
	data->_tmp6_ = g_list_length (data->list);
	g_log (log_domain_cp, G_LOG_LEVEL_DEBUG, "music-tree.vala:431: Query done, %u results", data->_tmp6_);
	g_list_first (data->list);
	data->_tmp7_ = data->list;
	data->list = NULL;
	data->callback (data->_tmp7_, data->callback_target);
	_g_regex_unref0 (data->regex_query);
	__g_list_free__meta_data_free0_0 (data->list);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_regex_unref0 (data->regex_query);
	__g_list_free__meta_data_free0_0 (data->list);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


GmpcProviderMusicTree* gmpc_provider_music_tree_construct (GType object_type) {
	GmpcProviderMusicTree * self = NULL;
	self = (GmpcProviderMusicTree*) gmpc_plugin_base_construct (object_type);
	return self;
}


GmpcProviderMusicTree* gmpc_provider_music_tree_new (void) {
	return gmpc_provider_music_tree_construct (GMPC_PROVIDER_TYPE_MUSIC_TREE);
}


static GObject * gmpc_provider_music_tree_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcProviderMusicTree * self;
	parent_class = G_OBJECT_CLASS (gmpc_provider_music_tree_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_PROVIDER_MUSIC_TREE (obj);
	((GmpcPluginBase*) self)->plugin_type = 8 + 32;
	return obj;
}


static void gmpc_provider_music_tree_class_init (GmpcProviderMusicTreeClass * klass) {
	gmpc_provider_music_tree_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcProviderMusicTreePrivate));
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_provider_music_tree_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_provider_music_tree_real_get_name;
	G_OBJECT_CLASS (klass)->constructor = gmpc_provider_music_tree_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_provider_music_tree_finalize;
}


static void gmpc_provider_music_tree_gmpc_plugin_meta_data_iface_interface_init (GmpcPluginMetaDataIfaceIface * iface) {
	gmpc_provider_music_tree_gmpc_plugin_meta_data_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_priority = (void (*)(GmpcPluginMetaDataIface* ,gint)) gmpc_provider_music_tree_real_set_priority;
	iface->get_priority = (gint (*)(GmpcPluginMetaDataIface*)) gmpc_provider_music_tree_real_get_priority;
	iface->get_metadata = (void (*)(GmpcPluginMetaDataIface* ,const mpd_Song* ,MetaDataType ,GmpcPluginMetaDataCallback ,void*)) gmpc_provider_music_tree_real_get_metadata;
}


static void gmpc_provider_music_tree_instance_init (GmpcProviderMusicTree * self) {
	gchar* _tmp0_;
	self->priv = GMPC_PROVIDER_MUSIC_TREE_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("(jpg|jpeg|png|gif)");
	self->priv->file_type_string = _tmp0_;
}


static void gmpc_provider_music_tree_finalize (GObject* obj) {
	GmpcProviderMusicTree * self;
	self = GMPC_PROVIDER_MUSIC_TREE (obj);
	_g_free0 (self->priv->file_type_string);
	G_OBJECT_CLASS (gmpc_provider_music_tree_parent_class)->finalize (obj);
}


GType gmpc_provider_music_tree_get_type (void) {
	static volatile gsize gmpc_provider_music_tree_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_provider_music_tree_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcProviderMusicTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_provider_music_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcProviderMusicTree), 0, (GInstanceInitFunc) gmpc_provider_music_tree_instance_init, NULL };
		static const GInterfaceInfo gmpc_plugin_meta_data_iface_info = { (GInterfaceInitFunc) gmpc_provider_music_tree_gmpc_plugin_meta_data_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gmpc_provider_music_tree_type_id;
		gmpc_provider_music_tree_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcProviderMusicTree", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_provider_music_tree_type_id, GMPC_PLUGIN_TYPE_META_DATA_IFACE, &gmpc_plugin_meta_data_iface_info);
		g_once_init_leave (&gmpc_provider_music_tree_type_id__volatile, gmpc_provider_music_tree_type_id);
	}
	return gmpc_provider_music_tree_type_id__volatile;
}



