// Code generated by smithy-go-codegen DO NOT EDIT.

package iotanalytics

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/iotanalytics/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpBatchPutMessage struct {
}

func (*awsRestjson1_serializeOpBatchPutMessage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchPutMessage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchPutMessageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/messages/batch")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchPutMessageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchPutMessageInput(v *BatchPutMessageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchPutMessageInput(v *BatchPutMessageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelName != nil {
		ok := object.Key("channelName")
		ok.String(*v.ChannelName)
	}

	if v.Messages != nil {
		ok := object.Key("messages")
		if err := awsRestjson1_serializeDocumentMessages(v.Messages, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCancelPipelineReprocessing struct {
}

func (*awsRestjson1_serializeOpCancelPipelineReprocessing) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelPipelineReprocessing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelPipelineReprocessingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pipelines/{pipelineName}/reprocessing/{reprocessingId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelPipelineReprocessingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelPipelineReprocessingInput(v *CancelPipelineReprocessingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PipelineName == nil || len(*v.PipelineName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pipelineName must not be empty")}
	}
	if v.PipelineName != nil {
		if err := encoder.SetURI("pipelineName").String(*v.PipelineName); err != nil {
			return err
		}
	}

	if v.ReprocessingId == nil || len(*v.ReprocessingId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member reprocessingId must not be empty")}
	}
	if v.ReprocessingId != nil {
		if err := encoder.SetURI("reprocessingId").String(*v.ReprocessingId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateChannel struct {
}

func (*awsRestjson1_serializeOpCreateChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateChannelInput(v *CreateChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateChannelInput(v *CreateChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelName != nil {
		ok := object.Key("channelName")
		ok.String(*v.ChannelName)
	}

	if v.ChannelStorage != nil {
		ok := object.Key("channelStorage")
		if err := awsRestjson1_serializeDocumentChannelStorage(v.ChannelStorage, ok); err != nil {
			return err
		}
	}

	if v.RetentionPeriod != nil {
		ok := object.Key("retentionPeriod")
		if err := awsRestjson1_serializeDocumentRetentionPeriod(v.RetentionPeriod, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataset struct {
}

func (*awsRestjson1_serializeOpCreateDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datasets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDatasetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDatasetInput(v *CreateDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDatasetInput(v *CreateDatasetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("actions")
		if err := awsRestjson1_serializeDocumentDatasetActions(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ContentDeliveryRules != nil {
		ok := object.Key("contentDeliveryRules")
		if err := awsRestjson1_serializeDocumentDatasetContentDeliveryRules(v.ContentDeliveryRules, ok); err != nil {
			return err
		}
	}

	if v.DatasetName != nil {
		ok := object.Key("datasetName")
		ok.String(*v.DatasetName)
	}

	if v.LateDataRules != nil {
		ok := object.Key("lateDataRules")
		if err := awsRestjson1_serializeDocumentLateDataRules(v.LateDataRules, ok); err != nil {
			return err
		}
	}

	if v.RetentionPeriod != nil {
		ok := object.Key("retentionPeriod")
		if err := awsRestjson1_serializeDocumentRetentionPeriod(v.RetentionPeriod, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Triggers != nil {
		ok := object.Key("triggers")
		if err := awsRestjson1_serializeDocumentDatasetTriggers(v.Triggers, ok); err != nil {
			return err
		}
	}

	if v.VersioningConfiguration != nil {
		ok := object.Key("versioningConfiguration")
		if err := awsRestjson1_serializeDocumentVersioningConfiguration(v.VersioningConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDatasetContent struct {
}

func (*awsRestjson1_serializeOpCreateDatasetContent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDatasetContent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDatasetContentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datasets/{datasetName}/content")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDatasetContentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDatasetContentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDatasetContentInput(v *CreateDatasetContentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member datasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("datasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDatasetContentInput(v *CreateDatasetContentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VersionId != nil {
		ok := object.Key("versionId")
		ok.String(*v.VersionId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateDatastore struct {
}

func (*awsRestjson1_serializeOpCreateDatastore) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDatastore) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDatastoreInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datastores")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDatastoreInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDatastoreInput(v *CreateDatastoreInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDatastoreInput(v *CreateDatastoreInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatastoreName != nil {
		ok := object.Key("datastoreName")
		ok.String(*v.DatastoreName)
	}

	if v.DatastorePartitions != nil {
		ok := object.Key("datastorePartitions")
		if err := awsRestjson1_serializeDocumentDatastorePartitions(v.DatastorePartitions, ok); err != nil {
			return err
		}
	}

	if v.DatastoreStorage != nil {
		ok := object.Key("datastoreStorage")
		if err := awsRestjson1_serializeDocumentDatastoreStorage(v.DatastoreStorage, ok); err != nil {
			return err
		}
	}

	if v.FileFormatConfiguration != nil {
		ok := object.Key("fileFormatConfiguration")
		if err := awsRestjson1_serializeDocumentFileFormatConfiguration(v.FileFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetentionPeriod != nil {
		ok := object.Key("retentionPeriod")
		if err := awsRestjson1_serializeDocumentRetentionPeriod(v.RetentionPeriod, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePipeline struct {
}

func (*awsRestjson1_serializeOpCreatePipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pipelines")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePipelineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePipelineInput(v *CreatePipelineInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePipelineInput(v *CreatePipelineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PipelineActivities != nil {
		ok := object.Key("pipelineActivities")
		if err := awsRestjson1_serializeDocumentPipelineActivities(v.PipelineActivities, ok); err != nil {
			return err
		}
	}

	if v.PipelineName != nil {
		ok := object.Key("pipelineName")
		ok.String(*v.PipelineName)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChannel struct {
}

func (*awsRestjson1_serializeOpDeleteChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{channelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChannelInput(v *DeleteChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member channelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("channelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataset struct {
}

func (*awsRestjson1_serializeOpDeleteDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datasets/{datasetName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDatasetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDatasetInput(v *DeleteDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member datasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("datasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDatasetContent struct {
}

func (*awsRestjson1_serializeOpDeleteDatasetContent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDatasetContent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDatasetContentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datasets/{datasetName}/content")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDatasetContentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDatasetContentInput(v *DeleteDatasetContentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member datasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("datasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDatastore struct {
}

func (*awsRestjson1_serializeOpDeleteDatastore) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDatastore) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDatastoreInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datastores/{datastoreName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDatastoreInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDatastoreInput(v *DeleteDatastoreInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatastoreName == nil || len(*v.DatastoreName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member datastoreName must not be empty")}
	}
	if v.DatastoreName != nil {
		if err := encoder.SetURI("datastoreName").String(*v.DatastoreName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePipeline struct {
}

func (*awsRestjson1_serializeOpDeletePipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pipelines/{pipelineName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePipelineInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePipelineInput(v *DeletePipelineInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PipelineName == nil || len(*v.PipelineName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pipelineName must not be empty")}
	}
	if v.PipelineName != nil {
		if err := encoder.SetURI("pipelineName").String(*v.PipelineName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeChannel struct {
}

func (*awsRestjson1_serializeOpDescribeChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{channelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeChannelInput(v *DescribeChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member channelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("channelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.IncludeStatistics {
		encoder.SetQuery("includeStatistics").Boolean(v.IncludeStatistics)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataset struct {
}

func (*awsRestjson1_serializeOpDescribeDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datasets/{datasetName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDatasetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDatasetInput(v *DescribeDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member datasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("datasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDatastore struct {
}

func (*awsRestjson1_serializeOpDescribeDatastore) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDatastore) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDatastoreInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datastores/{datastoreName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDatastoreInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDatastoreInput(v *DescribeDatastoreInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatastoreName == nil || len(*v.DatastoreName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member datastoreName must not be empty")}
	}
	if v.DatastoreName != nil {
		if err := encoder.SetURI("datastoreName").String(*v.DatastoreName); err != nil {
			return err
		}
	}

	if v.IncludeStatistics {
		encoder.SetQuery("includeStatistics").Boolean(v.IncludeStatistics)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeLoggingOptions struct {
}

func (*awsRestjson1_serializeOpDescribeLoggingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeLoggingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoggingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/logging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeLoggingOptionsInput(v *DescribeLoggingOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDescribePipeline struct {
}

func (*awsRestjson1_serializeOpDescribePipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribePipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pipelines/{pipelineName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribePipelineInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribePipelineInput(v *DescribePipelineInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PipelineName == nil || len(*v.PipelineName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pipelineName must not be empty")}
	}
	if v.PipelineName != nil {
		if err := encoder.SetURI("pipelineName").String(*v.PipelineName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDatasetContent struct {
}

func (*awsRestjson1_serializeOpGetDatasetContent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDatasetContent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDatasetContentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datasets/{datasetName}/content")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDatasetContentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDatasetContentInput(v *GetDatasetContentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member datasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("datasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestjson1_serializeOpListChannels struct {
}

func (*awsRestjson1_serializeOpListChannels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChannels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChannelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListChannelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChannelsInput(v *ListChannelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDatasetContents struct {
}

func (*awsRestjson1_serializeOpListDatasetContents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDatasetContents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDatasetContentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datasets/{datasetName}/contents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDatasetContentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDatasetContentsInput(v *ListDatasetContentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member datasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("datasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ScheduledBefore != nil {
		encoder.SetQuery("scheduledBefore").String(smithytime.FormatDateTime(*v.ScheduledBefore))
	}

	if v.ScheduledOnOrAfter != nil {
		encoder.SetQuery("scheduledOnOrAfter").String(smithytime.FormatDateTime(*v.ScheduledOnOrAfter))
	}

	return nil
}

type awsRestjson1_serializeOpListDatasets struct {
}

func (*awsRestjson1_serializeOpListDatasets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDatasets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDatasetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datasets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDatasetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDatasetsInput(v *ListDatasetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDatastores struct {
}

func (*awsRestjson1_serializeOpListDatastores) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDatastores) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDatastoresInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datastores")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDatastoresInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDatastoresInput(v *ListDatastoresInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListPipelines struct {
}

func (*awsRestjson1_serializeOpListPipelines) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPipelines) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPipelinesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pipelines")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPipelinesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPipelinesInput(v *ListPipelinesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpPutLoggingOptions struct {
}

func (*awsRestjson1_serializeOpPutLoggingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutLoggingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutLoggingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/logging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutLoggingOptionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutLoggingOptionsInput(v *PutLoggingOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutLoggingOptionsInput(v *PutLoggingOptionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LoggingOptions != nil {
		ok := object.Key("loggingOptions")
		if err := awsRestjson1_serializeDocumentLoggingOptions(v.LoggingOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRunPipelineActivity struct {
}

func (*awsRestjson1_serializeOpRunPipelineActivity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRunPipelineActivity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RunPipelineActivityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pipelineactivities/run")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRunPipelineActivityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRunPipelineActivityInput(v *RunPipelineActivityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRunPipelineActivityInput(v *RunPipelineActivityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Payloads != nil {
		ok := object.Key("payloads")
		if err := awsRestjson1_serializeDocumentMessagePayloads(v.Payloads, ok); err != nil {
			return err
		}
	}

	if v.PipelineActivity != nil {
		ok := object.Key("pipelineActivity")
		if err := awsRestjson1_serializeDocumentPipelineActivity(v.PipelineActivity, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSampleChannelData struct {
}

func (*awsRestjson1_serializeOpSampleChannelData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSampleChannelData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SampleChannelDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{channelName}/sample")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSampleChannelDataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSampleChannelDataInput(v *SampleChannelDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member channelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("channelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		encoder.SetQuery("endTime").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.MaxMessages != nil {
		encoder.SetQuery("maxMessages").Integer(*v.MaxMessages)
	}

	if v.StartTime != nil {
		encoder.SetQuery("startTime").String(smithytime.FormatDateTime(*v.StartTime))
	}

	return nil
}

type awsRestjson1_serializeOpStartPipelineReprocessing struct {
}

func (*awsRestjson1_serializeOpStartPipelineReprocessing) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartPipelineReprocessing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartPipelineReprocessingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pipelines/{pipelineName}/reprocessing")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartPipelineReprocessingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartPipelineReprocessingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartPipelineReprocessingInput(v *StartPipelineReprocessingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PipelineName == nil || len(*v.PipelineName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pipelineName must not be empty")}
	}
	if v.PipelineName != nil {
		if err := encoder.SetURI("pipelineName").String(*v.PipelineName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartPipelineReprocessingInput(v *StartPipelineReprocessingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelMessages != nil {
		ok := object.Key("channelMessages")
		if err := awsRestjson1_serializeDocumentChannelMessages(v.ChannelMessages, ok); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		ok := object.Key("endTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChannel struct {
}

func (*awsRestjson1_serializeOpUpdateChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/channels/{channelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChannelInput(v *UpdateChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ChannelName == nil || len(*v.ChannelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member channelName must not be empty")}
	}
	if v.ChannelName != nil {
		if err := encoder.SetURI("channelName").String(*v.ChannelName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChannelInput(v *UpdateChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelStorage != nil {
		ok := object.Key("channelStorage")
		if err := awsRestjson1_serializeDocumentChannelStorage(v.ChannelStorage, ok); err != nil {
			return err
		}
	}

	if v.RetentionPeriod != nil {
		ok := object.Key("retentionPeriod")
		if err := awsRestjson1_serializeDocumentRetentionPeriod(v.RetentionPeriod, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataset struct {
}

func (*awsRestjson1_serializeOpUpdateDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datasets/{datasetName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDatasetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDatasetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDatasetInput(v *UpdateDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member datasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("datasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDatasetInput(v *UpdateDatasetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("actions")
		if err := awsRestjson1_serializeDocumentDatasetActions(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ContentDeliveryRules != nil {
		ok := object.Key("contentDeliveryRules")
		if err := awsRestjson1_serializeDocumentDatasetContentDeliveryRules(v.ContentDeliveryRules, ok); err != nil {
			return err
		}
	}

	if v.LateDataRules != nil {
		ok := object.Key("lateDataRules")
		if err := awsRestjson1_serializeDocumentLateDataRules(v.LateDataRules, ok); err != nil {
			return err
		}
	}

	if v.RetentionPeriod != nil {
		ok := object.Key("retentionPeriod")
		if err := awsRestjson1_serializeDocumentRetentionPeriod(v.RetentionPeriod, ok); err != nil {
			return err
		}
	}

	if v.Triggers != nil {
		ok := object.Key("triggers")
		if err := awsRestjson1_serializeDocumentDatasetTriggers(v.Triggers, ok); err != nil {
			return err
		}
	}

	if v.VersioningConfiguration != nil {
		ok := object.Key("versioningConfiguration")
		if err := awsRestjson1_serializeDocumentVersioningConfiguration(v.VersioningConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDatastore struct {
}

func (*awsRestjson1_serializeOpUpdateDatastore) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDatastore) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDatastoreInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/datastores/{datastoreName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDatastoreInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDatastoreInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDatastoreInput(v *UpdateDatastoreInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatastoreName == nil || len(*v.DatastoreName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member datastoreName must not be empty")}
	}
	if v.DatastoreName != nil {
		if err := encoder.SetURI("datastoreName").String(*v.DatastoreName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDatastoreInput(v *UpdateDatastoreInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatastoreStorage != nil {
		ok := object.Key("datastoreStorage")
		if err := awsRestjson1_serializeDocumentDatastoreStorage(v.DatastoreStorage, ok); err != nil {
			return err
		}
	}

	if v.FileFormatConfiguration != nil {
		ok := object.Key("fileFormatConfiguration")
		if err := awsRestjson1_serializeDocumentFileFormatConfiguration(v.FileFormatConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RetentionPeriod != nil {
		ok := object.Key("retentionPeriod")
		if err := awsRestjson1_serializeDocumentRetentionPeriod(v.RetentionPeriod, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePipeline struct {
}

func (*awsRestjson1_serializeOpUpdatePipeline) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePipeline) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePipelineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/pipelines/{pipelineName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePipelineInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePipelineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePipelineInput(v *UpdatePipelineInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.PipelineName == nil || len(*v.PipelineName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pipelineName must not be empty")}
	}
	if v.PipelineName != nil {
		if err := encoder.SetURI("pipelineName").String(*v.PipelineName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePipelineInput(v *UpdatePipelineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PipelineActivities != nil {
		ok := object.Key("pipelineActivities")
		if err := awsRestjson1_serializeDocumentPipelineActivities(v.PipelineActivities, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAddAttributesActivity(v *types.AddAttributesActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentAttributeNameMapping(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Next != nil {
		ok := object.Key("next")
		ok.String(*v.Next)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeNameMapping(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAttributeNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentChannelActivity(v *types.ChannelActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelName != nil {
		ok := object.Key("channelName")
		ok.String(*v.ChannelName)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Next != nil {
		ok := object.Key("next")
		ok.String(*v.Next)
	}

	return nil
}

func awsRestjson1_serializeDocumentChannelMessages(v *types.ChannelMessages, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Paths != nil {
		ok := object.Key("s3Paths")
		if err := awsRestjson1_serializeDocumentS3PathChannelMessages(v.S3Paths, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentChannelStorage(v *types.ChannelStorage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomerManagedS3 != nil {
		ok := object.Key("customerManagedS3")
		if err := awsRestjson1_serializeDocumentCustomerManagedChannelS3Storage(v.CustomerManagedS3, ok); err != nil {
			return err
		}
	}

	if v.ServiceManagedS3 != nil {
		ok := object.Key("serviceManagedS3")
		if err := awsRestjson1_serializeDocumentServiceManagedChannelS3Storage(v.ServiceManagedS3, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColumn(v *types.Column, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentColumns(v []types.Column, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumn(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentContainerDatasetAction(v *types.ContainerDatasetAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExecutionRoleArn != nil {
		ok := object.Key("executionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.Image != nil {
		ok := object.Key("image")
		ok.String(*v.Image)
	}

	if v.ResourceConfiguration != nil {
		ok := object.Key("resourceConfiguration")
		if err := awsRestjson1_serializeDocumentResourceConfiguration(v.ResourceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Variables != nil {
		ok := object.Key("variables")
		if err := awsRestjson1_serializeDocumentVariables(v.Variables, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomerManagedChannelS3Storage(v *types.CustomerManagedChannelS3Storage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.KeyPrefix != nil {
		ok := object.Key("keyPrefix")
		ok.String(*v.KeyPrefix)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomerManagedDatastoreS3Storage(v *types.CustomerManagedDatastoreS3Storage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.KeyPrefix != nil {
		ok := object.Key("keyPrefix")
		ok.String(*v.KeyPrefix)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasetAction(v *types.DatasetAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionName != nil {
		ok := object.Key("actionName")
		ok.String(*v.ActionName)
	}

	if v.ContainerAction != nil {
		ok := object.Key("containerAction")
		if err := awsRestjson1_serializeDocumentContainerDatasetAction(v.ContainerAction, ok); err != nil {
			return err
		}
	}

	if v.QueryAction != nil {
		ok := object.Key("queryAction")
		if err := awsRestjson1_serializeDocumentSqlQueryDatasetAction(v.QueryAction, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasetActions(v []types.DatasetAction, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDatasetAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDatasetContentDeliveryDestination(v *types.DatasetContentDeliveryDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IotEventsDestinationConfiguration != nil {
		ok := object.Key("iotEventsDestinationConfiguration")
		if err := awsRestjson1_serializeDocumentIotEventsDestinationConfiguration(v.IotEventsDestinationConfiguration, ok); err != nil {
			return err
		}
	}

	if v.S3DestinationConfiguration != nil {
		ok := object.Key("s3DestinationConfiguration")
		if err := awsRestjson1_serializeDocumentS3DestinationConfiguration(v.S3DestinationConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasetContentDeliveryRule(v *types.DatasetContentDeliveryRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentDatasetContentDeliveryDestination(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.EntryName != nil {
		ok := object.Key("entryName")
		ok.String(*v.EntryName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasetContentDeliveryRules(v []types.DatasetContentDeliveryRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDatasetContentDeliveryRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDatasetContentVersionValue(v *types.DatasetContentVersionValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetName != nil {
		ok := object.Key("datasetName")
		ok.String(*v.DatasetName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasetTrigger(v *types.DatasetTrigger, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dataset != nil {
		ok := object.Key("dataset")
		if err := awsRestjson1_serializeDocumentTriggeringDataset(v.Dataset, ok); err != nil {
			return err
		}
	}

	if v.Schedule != nil {
		ok := object.Key("schedule")
		if err := awsRestjson1_serializeDocumentSchedule(v.Schedule, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasetTriggers(v []types.DatasetTrigger, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDatasetTrigger(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDatastoreActivity(v *types.DatastoreActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatastoreName != nil {
		ok := object.Key("datastoreName")
		ok.String(*v.DatastoreName)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentDatastoreIotSiteWiseMultiLayerStorage(v *types.DatastoreIotSiteWiseMultiLayerStorage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomerManagedS3Storage != nil {
		ok := object.Key("customerManagedS3Storage")
		if err := awsRestjson1_serializeDocumentIotSiteWiseCustomerManagedDatastoreS3Storage(v.CustomerManagedS3Storage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDatastorePartition(v *types.DatastorePartition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributePartition != nil {
		ok := object.Key("attributePartition")
		if err := awsRestjson1_serializeDocumentPartition(v.AttributePartition, ok); err != nil {
			return err
		}
	}

	if v.TimestampPartition != nil {
		ok := object.Key("timestampPartition")
		if err := awsRestjson1_serializeDocumentTimestampPartition(v.TimestampPartition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDatastorePartitions(v *types.DatastorePartitions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Partitions != nil {
		ok := object.Key("partitions")
		if err := awsRestjson1_serializeDocumentPartitions(v.Partitions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDatastoreStorage(v types.DatastoreStorage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DatastoreStorageMemberCustomerManagedS3:
		av := object.Key("customerManagedS3")
		if err := awsRestjson1_serializeDocumentCustomerManagedDatastoreS3Storage(&uv.Value, av); err != nil {
			return err
		}

	case *types.DatastoreStorageMemberIotSiteWiseMultiLayerStorage:
		av := object.Key("iotSiteWiseMultiLayerStorage")
		if err := awsRestjson1_serializeDocumentDatastoreIotSiteWiseMultiLayerStorage(&uv.Value, av); err != nil {
			return err
		}

	case *types.DatastoreStorageMemberServiceManagedS3:
		av := object.Key("serviceManagedS3")
		if err := awsRestjson1_serializeDocumentServiceManagedDatastoreS3Storage(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDeltaTime(v *types.DeltaTime, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OffsetSeconds != nil {
		ok := object.Key("offsetSeconds")
		ok.Integer(*v.OffsetSeconds)
	}

	if v.TimeExpression != nil {
		ok := object.Key("timeExpression")
		ok.String(*v.TimeExpression)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeltaTimeSessionWindowConfiguration(v *types.DeltaTimeSessionWindowConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimeoutInMinutes != nil {
		ok := object.Key("timeoutInMinutes")
		ok.Integer(*v.TimeoutInMinutes)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeviceRegistryEnrichActivity(v *types.DeviceRegistryEnrichActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attribute != nil {
		ok := object.Key("attribute")
		ok.String(*v.Attribute)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Next != nil {
		ok := object.Key("next")
		ok.String(*v.Next)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.ThingName != nil {
		ok := object.Key("thingName")
		ok.String(*v.ThingName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeviceShadowEnrichActivity(v *types.DeviceShadowEnrichActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attribute != nil {
		ok := object.Key("attribute")
		ok.String(*v.Attribute)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Next != nil {
		ok := object.Key("next")
		ok.String(*v.Next)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.ThingName != nil {
		ok := object.Key("thingName")
		ok.String(*v.ThingName)
	}

	return nil
}

func awsRestjson1_serializeDocumentFileFormatConfiguration(v *types.FileFormatConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JsonConfiguration != nil {
		ok := object.Key("jsonConfiguration")
		if err := awsRestjson1_serializeDocumentJsonConfiguration(v.JsonConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ParquetConfiguration != nil {
		ok := object.Key("parquetConfiguration")
		if err := awsRestjson1_serializeDocumentParquetConfiguration(v.ParquetConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterActivity(v *types.FilterActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("filter")
		ok.String(*v.Filter)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Next != nil {
		ok := object.Key("next")
		ok.String(*v.Next)
	}

	return nil
}

func awsRestjson1_serializeDocumentGlueConfiguration(v *types.GlueConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseName != nil {
		ok := object.Key("databaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("tableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsRestjson1_serializeDocumentIotEventsDestinationConfiguration(v *types.IotEventsDestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputName != nil {
		ok := object.Key("inputName")
		ok.String(*v.InputName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentIotSiteWiseCustomerManagedDatastoreS3Storage(v *types.IotSiteWiseCustomerManagedDatastoreS3Storage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.KeyPrefix != nil {
		ok := object.Key("keyPrefix")
		ok.String(*v.KeyPrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentJsonConfiguration(v *types.JsonConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentLambdaActivity(v *types.LambdaActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("batchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.LambdaName != nil {
		ok := object.Key("lambdaName")
		ok.String(*v.LambdaName)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Next != nil {
		ok := object.Key("next")
		ok.String(*v.Next)
	}

	return nil
}

func awsRestjson1_serializeDocumentLateDataRule(v *types.LateDataRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RuleConfiguration != nil {
		ok := object.Key("ruleConfiguration")
		if err := awsRestjson1_serializeDocumentLateDataRuleConfiguration(v.RuleConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RuleName != nil {
		ok := object.Key("ruleName")
		ok.String(*v.RuleName)
	}

	return nil
}

func awsRestjson1_serializeDocumentLateDataRuleConfiguration(v *types.LateDataRuleConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeltaTimeSessionWindowConfiguration != nil {
		ok := object.Key("deltaTimeSessionWindowConfiguration")
		if err := awsRestjson1_serializeDocumentDeltaTimeSessionWindowConfiguration(v.DeltaTimeSessionWindowConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLateDataRules(v []types.LateDataRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentLateDataRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLoggingOptions(v *types.LoggingOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if len(v.Level) > 0 {
		ok := object.Key("level")
		ok.String(string(v.Level))
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentMathActivity(v *types.MathActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attribute != nil {
		ok := object.Key("attribute")
		ok.String(*v.Attribute)
	}

	if v.Math != nil {
		ok := object.Key("math")
		ok.String(*v.Math)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Next != nil {
		ok := object.Key("next")
		ok.String(*v.Next)
	}

	return nil
}

func awsRestjson1_serializeDocumentMessage(v *types.Message, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MessageId != nil {
		ok := object.Key("messageId")
		ok.String(*v.MessageId)
	}

	if v.Payload != nil {
		ok := object.Key("payload")
		ok.Base64EncodeBytes(v.Payload)
	}

	return nil
}

func awsRestjson1_serializeDocumentMessagePayloads(v [][]byte, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		av.Base64EncodeBytes(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentMessages(v []types.Message, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMessage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentOutputFileUriValue(v *types.OutputFileUriValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileName != nil {
		ok := object.Key("fileName")
		ok.String(*v.FileName)
	}

	return nil
}

func awsRestjson1_serializeDocumentParquetConfiguration(v *types.ParquetConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SchemaDefinition != nil {
		ok := object.Key("schemaDefinition")
		if err := awsRestjson1_serializeDocumentSchemaDefinition(v.SchemaDefinition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPartition(v *types.Partition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeName != nil {
		ok := object.Key("attributeName")
		ok.String(*v.AttributeName)
	}

	return nil
}

func awsRestjson1_serializeDocumentPartitions(v []types.DatastorePartition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDatastorePartition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPipelineActivities(v []types.PipelineActivity, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPipelineActivity(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPipelineActivity(v *types.PipelineActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddAttributes != nil {
		ok := object.Key("addAttributes")
		if err := awsRestjson1_serializeDocumentAddAttributesActivity(v.AddAttributes, ok); err != nil {
			return err
		}
	}

	if v.Channel != nil {
		ok := object.Key("channel")
		if err := awsRestjson1_serializeDocumentChannelActivity(v.Channel, ok); err != nil {
			return err
		}
	}

	if v.Datastore != nil {
		ok := object.Key("datastore")
		if err := awsRestjson1_serializeDocumentDatastoreActivity(v.Datastore, ok); err != nil {
			return err
		}
	}

	if v.DeviceRegistryEnrich != nil {
		ok := object.Key("deviceRegistryEnrich")
		if err := awsRestjson1_serializeDocumentDeviceRegistryEnrichActivity(v.DeviceRegistryEnrich, ok); err != nil {
			return err
		}
	}

	if v.DeviceShadowEnrich != nil {
		ok := object.Key("deviceShadowEnrich")
		if err := awsRestjson1_serializeDocumentDeviceShadowEnrichActivity(v.DeviceShadowEnrich, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsRestjson1_serializeDocumentFilterActivity(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.Lambda != nil {
		ok := object.Key("lambda")
		if err := awsRestjson1_serializeDocumentLambdaActivity(v.Lambda, ok); err != nil {
			return err
		}
	}

	if v.Math != nil {
		ok := object.Key("math")
		if err := awsRestjson1_serializeDocumentMathActivity(v.Math, ok); err != nil {
			return err
		}
	}

	if v.RemoveAttributes != nil {
		ok := object.Key("removeAttributes")
		if err := awsRestjson1_serializeDocumentRemoveAttributesActivity(v.RemoveAttributes, ok); err != nil {
			return err
		}
	}

	if v.SelectAttributes != nil {
		ok := object.Key("selectAttributes")
		if err := awsRestjson1_serializeDocumentSelectAttributesActivity(v.SelectAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentQueryFilter(v *types.QueryFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeltaTime != nil {
		ok := object.Key("deltaTime")
		if err := awsRestjson1_serializeDocumentDeltaTime(v.DeltaTime, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentQueryFilters(v []types.QueryFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentQueryFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRemoveAttributesActivity(v *types.RemoveAttributesActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentAttributeNames(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Next != nil {
		ok := object.Key("next")
		ok.String(*v.Next)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceConfiguration(v *types.ResourceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ComputeType) > 0 {
		ok := object.Key("computeType")
		ok.String(string(v.ComputeType))
	}

	{
		ok := object.Key("volumeSizeInGB")
		ok.Integer(v.VolumeSizeInGB)
	}

	return nil
}

func awsRestjson1_serializeDocumentRetentionPeriod(v *types.RetentionPeriod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NumberOfDays != nil {
		ok := object.Key("numberOfDays")
		ok.Integer(*v.NumberOfDays)
	}

	if v.Unlimited {
		ok := object.Key("unlimited")
		ok.Boolean(v.Unlimited)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3DestinationConfiguration(v *types.S3DestinationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.GlueConfiguration != nil {
		ok := object.Key("glueConfiguration")
		if err := awsRestjson1_serializeDocumentGlueConfiguration(v.GlueConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3PathChannelMessages(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSchedule(v *types.Schedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Expression != nil {
		ok := object.Key("expression")
		ok.String(*v.Expression)
	}

	return nil
}

func awsRestjson1_serializeDocumentSchemaDefinition(v *types.SchemaDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Columns != nil {
		ok := object.Key("columns")
		if err := awsRestjson1_serializeDocumentColumns(v.Columns, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSelectAttributesActivity(v *types.SelectAttributesActivity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentAttributeNames(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Next != nil {
		ok := object.Key("next")
		ok.String(*v.Next)
	}

	return nil
}

func awsRestjson1_serializeDocumentServiceManagedChannelS3Storage(v *types.ServiceManagedChannelS3Storage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentServiceManagedDatastoreS3Storage(v *types.ServiceManagedDatastoreS3Storage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentSqlQueryDatasetAction(v *types.SqlQueryDatasetAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentQueryFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.SqlQuery != nil {
		ok := object.Key("sqlQuery")
		ok.String(*v.SqlQuery)
	}

	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTimestampPartition(v *types.TimestampPartition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeName != nil {
		ok := object.Key("attributeName")
		ok.String(*v.AttributeName)
	}

	if v.TimestampFormat != nil {
		ok := object.Key("timestampFormat")
		ok.String(*v.TimestampFormat)
	}

	return nil
}

func awsRestjson1_serializeDocumentTriggeringDataset(v *types.TriggeringDataset, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentVariable(v *types.Variable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetContentVersionValue != nil {
		ok := object.Key("datasetContentVersionValue")
		if err := awsRestjson1_serializeDocumentDatasetContentVersionValue(v.DatasetContentVersionValue, ok); err != nil {
			return err
		}
	}

	if v.DoubleValue != nil {
		ok := object.Key("doubleValue")
		switch {
		case math.IsNaN(*v.DoubleValue):
			ok.String("NaN")

		case math.IsInf(*v.DoubleValue, 1):
			ok.String("Infinity")

		case math.IsInf(*v.DoubleValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.DoubleValue)

		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.OutputFileUriValue != nil {
		ok := object.Key("outputFileUriValue")
		if err := awsRestjson1_serializeDocumentOutputFileUriValue(v.OutputFileUriValue, ok); err != nil {
			return err
		}
	}

	if v.StringValue != nil {
		ok := object.Key("stringValue")
		ok.String(*v.StringValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentVariables(v []types.Variable, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVariable(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentVersioningConfiguration(v *types.VersioningConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxVersions != nil {
		ok := object.Key("maxVersions")
		ok.Integer(*v.MaxVersions)
	}

	if v.Unlimited {
		ok := object.Key("unlimited")
		ok.Boolean(v.Unlimited)
	}

	return nil
}
