# Contributing Guidelines

Contributions are always welcome; however, please read this document in its
entirety before submitting a Pull Request or Reporting a bug.

### Table of Contents

- [Reporting a bug](#reporting-a-bug)
  - [Security disclosure](#security-disclosure)
- [Creating an issue](#creating-an-issue)
- [Feature requests](#feature-requests)
- [Opening a pull request](#opening-a-pull-request)
- [Code of Conduct](#code-of-conduct)
- [License](#license)
- [Contributor license agreement](#contributor-license-agreement)

---------------

# Reporting a Bug

Think you've found a bug? Let us know!

### Security disclosure

Security is a top priority for us. If you have encountered a security issue
please responsibly disclose it by following our [security
disclosure](../docs/security.md) document.

# Creating an Issue

Your issue must follow these guidelines for it to be considered:

#### Before submitting

- Check you’re on the latest version, we may have already fixed your bug!
- [Search our issue
  tracker](https://github.com/manifoldco/promptui/issues/search&type=issues)
  for your problem, someone may have already reported it

# Opening a Pull Request

To contribute, [fork](https://help.github.com/articles/fork-a-repo/)
`promptui`, commit your changes, and [open a pull
request](https://help.github.com/articles/using-pull-requests/).

Your request will be reviewed as soon as possible. You may be asked to make
changes to your submission during the review process.

#### Before submitting

- Test your change thoroughly
- you can run `make bootstrap && make` to ensure that the continuous integration
  build will succeed


# Code of Conduct

All community members are expected to adhere to our [code of
conduct](../CODE_OF_CONDUCT.md).


# License

Manifold's promptui is released under the [BSD 3-Clause
License](../LICENSE.md).


# Contributor license agreement

For legal purposes all contributors must sign a [contributor license
agreement](https://cla-assistant.io/manifoldco/promptui), either for an
individual or corporation, before a pull request can be accepted.

You will be prompted to sign the agreement by CLA Assistant (bot) when you open
a Pull Request for the first time.
