The Ahem font was developed by Todd Fahrner and Myles C. Maxfield to 
help test writers develop predictable tests. The units per em is 1000, 
the ascent is 800, and the descent is 200, thereby making the em 
square exactly square. The glyphs for most characters is simply a box 
which fills this square. The codepoints mapped to this full square 
with a full advance are the following ranges:

- U+20-U+26
- U+28-U+6F
- U+71-U+7E
- U+A0-U+C8
- U+CA-U+FF
- U+131
- U+152-U+153
- U+178
- U+192
- U+2C6-U+2C7
- U+2C9
- U+2D8-U+2DD
- U+394
- U+3A5
- U+3A7
- U+3A9
- U+3BC
- U+3C0
- U+2013-U+2014
- U+2018-U+201A
- U+201C-U+201E
- U+2020-U+2022
- U+2026
- U+2030
- U+2039-U+203A
- U+2044
- U+2122
- U+2126
- U+2202
- U+2206
- U+220F
- U+2211-U+2212
- U+2219-U+221A
- U+221E
- U+222B
- U+2248
- U+2260
- U+2264-U+2265
- U+22F2
- U+25CA
- U+3007
- U+4E00
- U+4E03
- U+4E09
- U+4E5D
- U+4E8C
- U+4E94
- U+516B
- U+516D
- U+5341
- U+56D7
- U+56DB
- U+571F
- U+6728
- U+6C34
- U+706B
- U+91D1
- U+F000-U+F002

The codepoints which are mapped to something else are the following:

- " " (U+20): No path but full advance
- "p" (U+70): Path has 0 ascent but full descent
- "É" (U+C9): Path has 0 descent but full ascent
- Non-breaking space (U+A0): No path but full advance
- Zero-width non-breaking space (U+FEFF): No path and 0 advance
- En space (U+2002): No path and half advance
- Em space (U+2003): No path but full advance
- Three-per-em space (U+2004): No path and one third advance
- Four-per-em space (U+2005): No path and one quarter advance
- Six-per-em space (U+2006): No path and one sixth advance
- Thin space (U+2009): No path and one fifth advance
- Hair space (U+200A): No path and one tenth advance
- Zero width space (U+200B): No path and no advance
- Ideographic space (U+3000): No path but full advance
- Zero width non-joiner (U+200C): No path and no advance
- Zero width joiner (U+200D): No path and no advance
- Greek capital letter Upsilon (U+3A5): Thin vertical stripe and full advance
- Greek capital letter Chi (U+3A7): Thin horizontal stripe and full advance
- "横" (U+6A2A): Thin horizontal stripe and full advance
- "橫" (U+6A6B): Thin horizontal stripe and full advance;
- "縦" (U+7E26): Thin vertical stripe and full advance;
- "縱" (U+7E31): Thin vertical stripe and full advance;
- "纵" (U+7EB5): Thin vertical stripe and full advance.

Source: https://www.w3.org/Style/CSS/Test/Fonts/Ahem/