# Changes since [4.3.0](./4.3.0.md)

## Breaking changes

- Remove partial sorting support (obsolete feature)
	- Remove `--sort-cache-size` flag in command line
	- (For library users) Remove `sortCacheSize` argument to `glos.write` and `glos.convert`

- Re-design sorting and `sortKey` parameters

	- Breaking change for library users, and user plugins that need sorting (`sortOnWrite = ALWAYS`)

	- Change `glos.convert`
		+ Replace argument `sortKey` (Callable) with `sortKeyName` (`str`)
		+ Add argument `sortEncoding` (str) defaulting to `utf-8`
	- Change `glos.write`
		+ Replace argument `sortKey` (Callable) with `namedSortKey` (`sort_keys.NamedSortKey`)
		+ Add argument `sortEncoding` (`str`) defaulting to `utf-8`
	- Change `glos.sortWords`
		+ Replace argument `key` (Callable) with `sortKeyName` (`str`)
		+ Add argument `sortEncoding` (`str`) defaulting to `utf-8`

	- Change API of plugins that use `sortOnWrite = ALWAYS`
		+ Replace `writer.sortKey` and `Writer.sqliteSortKey` with `sortKeyName` in plugin module.
		+ See the [stardict.py](https://github.com/ilius/pyglossary/blob/86eb03d/pyglossary/plugins/stardict.py#L30) for example.

	**Note 1**: All `sortKey` and `sortEncoding` arguments are optional.

	**Note 2**: Values of `sortKeyName` are documented in [doc/sort-key.md](../sort-key.md)


- Rename 2 files in `doc/`:

	+ Rename `doc/entry_filters.md` to `doc/entry-filters.md`
	+ Rename `doc/term_colors.md` to `doc/term-colors.md`


## Features

- `--sort-key` and `--sort-encoding` command line flags (as part of above re-design)
	- See [README.md](../../README.md#sorting) and [doc/sort-key.md](../sort-key.md).

- **Now SQLite mode works for all output formats.**


## Bug fixes

- Fix lack of Progress Bar while writing in indirect or SQLite mode
- Fix misleading message log about SQLite mode
- Fix unclosed files in XDXF and FreeDict plugins

## Improvements

- Show a 1-line log instead of `FileNotFoundError` traceback in `glos.read` and `glos.write`
- Close readers in `glos.convert` if `write` failed
- Fix some type annotations and comments
- (For library users) Change `Glossary.__str__`
- (For library users) `glos.setInfo`: convert non-str value to str, and add tests

## Unit testing

Add new tests and improve existing tests.

- Coverage of `glossary.py`: %89
- Overall coverage of codebase + plugins: %58

## Refactoring and design improvements

- Simplify by passing `glos` object to `EntryList()`
- Replace `SqList` with `SqEntryList`
- Change `__iter__` of `SqEntryList` and `EntryList` to give entry objects
- Simplify `Glossary` by moving `gc.collect` to `EntryList` and `SqEntryList`
- Remove unused function `xml_unescape`
- Remove unused import from FreeDict and JMDict plugins
- Use `operator.itemgetter` in `stardict.py`, `dict_cc.py`, `ebook_kobo.py`, `reverse.py`
- `glossary.py`: cleanup, simplify and optimize generators logic
	- Also remove `index` argument from `entryFilter.run` method and add some comments
- Remove redundant check in `glos.progress`
- Remove redundant check in `_getLangByStr`
- Remove redundant check in `Glossary.detectOutputFormat`
