val ( .@() ) : Py.Object.t -> Py.Object.t -> Py.Object.t
(** Equivalent to {!Py.Object.find_attr}. *)

val ( .@$() ) : Py.Object.t -> string -> Py.Object.t
(** Equivalent to {!Py.Object.find_attr_string}. *)

val ( .@()<- ) : Py.Object.t -> Py.Object.t -> Py.Object.t -> unit
(** Equivalent to {!Py.Object.set_attr}. *)

val ( .@$()<- ) : Py.Object.t -> string -> Py.Object.t -> unit
(** Equivalent to {!Py.Object.set_attr_string}. *)

val ( .![] ) : Py.Object.t -> Py.Object.t -> Py.Object.t
(** Equivalent to {!Py.Object.find}. *)

val ( .!$[] ) : Py.Object.t -> string -> Py.Object.t
(** Equivalent to {!Py.Object.find_string}. *)

val ( .![]<- ) : Py.Object.t -> Py.Object.t -> Py.Object.t -> unit
(** Equivalent to {!Py.Object.set_item}. *)

val ( .!$[]<- ) : Py.Object.t -> string -> Py.Object.t -> unit
(** Equivalent to {!Py.Object.set_item_string}. *)

val ( .%[] ) : Py.Object.t -> Py.Object.t -> Py.Object.t
(** Equivalent to {!Py.Dict.find}. *)

val ( .%$[] ) : Py.Object.t -> string -> Py.Object.t
(** Equivalent to {!Py.Dict.find_string}. *)

val ( .%[]<- ) : Py.Object.t -> Py.Object.t -> Py.Object.t -> unit
(** Equivalent to {!Py.Dict.set_item}. *)

val ( .%$[]<- ) : Py.Object.t -> string -> Py.Object.t -> unit
(** Equivalent to {!Py.Dict.set_item_string}. *)

val ( .&() ) : Py.Object.t -> string -> Py.Object.t array -> Py.Object.t
(** Equivalent to {!Py.Module.get_function}. *)

val ( .&()<- ) : Py.Object.t -> string -> (Py.Object.t array -> Py.Object.t)
  -> unit
(** Equivalent to {!Py.Module.set_function}. *)
