/**********************************************************************
 * $print_invoke_commands example -- PLI application using VPI routines
 *
 * C source to print all invocation commands used to invoke simulation,
 * including commands from within -f command files.
 *
 * Usage: reg flag;
          flag = $test_invoke_options("<invocation_option>");
 *   Where <invocation_option can be any + or - option.
 *
 * Debug tip: Uncomment the line "#define PLIbook_verbose" to enable
 * this application to list all simulation invocation options.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

/**********************************************************************
 * $print_invoke_commands example--C source code using ACC PLI routines
 *
 * C source to print all invocation commands used to invoke simulation,
 * including commands from within -f command files.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $print_invoke_commands;
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_InvokeCommands_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     0,                             /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_InvokeCommands_calltf, /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$print_invoke_commands",      /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include <stdio.h>            /* ANSI C standard I/O library */
#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * calltf routine
 *********************************************************************/
/* prototypes of subroutines used by calltf routine */
void PLIbook_ScanCommandFile();

int PLIbook_InvokeCommands_calltf()
{
  int    argc, i;
  char **argv;

  acc_initialize();
  acc_configure(accDisplayWarnings, "true");

  argc = acc_fetch_argc();
  argv = acc_fetch_argv();

  io_printf("\nSimulation invocation commands:\n");
  for (i=0; i<argc; i++) {
    io_printf("  %s\n", *argv); 
    if (strcmp(*argv, "-f") == 0) {
      argv++;  /* next arg is address to array of strings */
      i++;
      PLIbook_ScanCommandFile((char **)*argv);
    }
    argv++; /* increment to next argument */
  }
  io_printf("\n\n");
  acc_close();
  return(0);
}

int PLIbook_indent = 0;   /* global variable to format text indenting */

void PLIbook_ScanCommandFile(char **arg)
{
  int i;

  PLIbook_indent += 4; /* increase text indentation */
  while ( *arg != NULL ) { /* loop until null termination */
    for (i=0; i<=PLIbook_indent; i++)
      io_printf(" ");
    io_printf("%s\n", *arg); 
    if (strcmp(*arg, "-f") == 0) {
      arg++;  /* next arg is address to array of strings */
      PLIbook_ScanCommandFile((char **)*arg);
    }
    arg++;
  }
  PLIbook_indent -= 4; /* decrease text indentation */
  return;
}
/*********************************************************************/
