# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ActionRuleProperties(msrest.serialization.Model):
    """Action rule properties defining scope, conditions, suppression logic for action rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ActionGroup, Diagnostics, Suppression.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param scope: scope on which action rule will apply.
    :type scope: ~azure.mgmt.alertsmanagement.models.Scope
    :param conditions: conditions on which alerts will be filtered.
    :type conditions: ~azure.mgmt.alertsmanagement.models.Conditions
    :param description: Description of action rule.
    :type description: str
    :ivar created_at: Creation time of action rule. Date-Time in ISO-8601 format.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_at: Last updated time of action rule. Date-Time in ISO-8601 format.
    :vartype last_modified_at: ~datetime.datetime
    :ivar created_by: Created by user name.
    :vartype created_by: str
    :ivar last_modified_by: Last modified by user name.
    :vartype last_modified_by: str
    :param status: Indicates if the given action rule is enabled or disabled. Possible values
     include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.alertsmanagement.models.ActionRuleStatus
    :param type: Required. Indicates type of action rule.Constant filled by server.  Possible
     values include: "Suppression", "ActionGroup", "Diagnostics".
    :type type: str or ~azure.mgmt.alertsmanagement.models.ActionRuleType
    """

    _validation = {
        'created_at': {'readonly': True},
        'last_modified_at': {'readonly': True},
        'created_by': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'Scope'},
        'conditions': {'key': 'conditions', 'type': 'Conditions'},
        'description': {'key': 'description', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'ActionGroup': 'ActionGroup', 'Diagnostics': 'Diagnostics', 'Suppression': 'Suppression'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActionRuleProperties, self).__init__(**kwargs)
        self.scope = kwargs.get('scope', None)
        self.conditions = kwargs.get('conditions', None)
        self.description = kwargs.get('description', None)
        self.created_at = None
        self.last_modified_at = None
        self.created_by = None
        self.last_modified_by = None
        self.status = kwargs.get('status', None)
        self.type = None  # type: Optional[str]


class ActionGroup(ActionRuleProperties):
    """Action rule with action group configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param scope: scope on which action rule will apply.
    :type scope: ~azure.mgmt.alertsmanagement.models.Scope
    :param conditions: conditions on which alerts will be filtered.
    :type conditions: ~azure.mgmt.alertsmanagement.models.Conditions
    :param description: Description of action rule.
    :type description: str
    :ivar created_at: Creation time of action rule. Date-Time in ISO-8601 format.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_at: Last updated time of action rule. Date-Time in ISO-8601 format.
    :vartype last_modified_at: ~datetime.datetime
    :ivar created_by: Created by user name.
    :vartype created_by: str
    :ivar last_modified_by: Last modified by user name.
    :vartype last_modified_by: str
    :param status: Indicates if the given action rule is enabled or disabled. Possible values
     include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.alertsmanagement.models.ActionRuleStatus
    :param type: Required. Indicates type of action rule.Constant filled by server.  Possible
     values include: "Suppression", "ActionGroup", "Diagnostics".
    :type type: str or ~azure.mgmt.alertsmanagement.models.ActionRuleType
    :param action_group_id: Required. Action group to trigger if action rule matches.
    :type action_group_id: str
    """

    _validation = {
        'created_at': {'readonly': True},
        'last_modified_at': {'readonly': True},
        'created_by': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'type': {'required': True},
        'action_group_id': {'required': True},
    }

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'Scope'},
        'conditions': {'key': 'conditions', 'type': 'Conditions'},
        'description': {'key': 'description', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'action_group_id': {'key': 'actionGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActionGroup, self).__init__(**kwargs)
        self.type = 'ActionGroup'  # type: str
        self.action_group_id = kwargs['action_group_id']


class ActionGroupsInformation(msrest.serialization.Model):
    """The Action Groups information, used by the alert rule.

    All required parameters must be populated in order to send to Azure.

    :param custom_email_subject: An optional custom email subject to use in email notifications.
    :type custom_email_subject: str
    :param custom_webhook_payload: An optional custom web-hook payload to use in web-hook
     notifications.
    :type custom_webhook_payload: str
    :param group_ids: Required. The Action Group resource IDs.
    :type group_ids: list[str]
    """

    _validation = {
        'group_ids': {'required': True},
    }

    _attribute_map = {
        'custom_email_subject': {'key': 'customEmailSubject', 'type': 'str'},
        'custom_webhook_payload': {'key': 'customWebhookPayload', 'type': 'str'},
        'group_ids': {'key': 'groupIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActionGroupsInformation, self).__init__(**kwargs)
        self.custom_email_subject = kwargs.get('custom_email_subject', None)
        self.custom_webhook_payload = kwargs.get('custom_webhook_payload', None)
        self.group_ids = kwargs['group_ids']


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None


class ManagedResource(Resource):
    """An azure managed resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedResource, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class ActionRule(ManagedResource):
    """Action rule object containing target scope, conditions and suppression logic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param properties: action rule properties.
    :type properties: ~azure.mgmt.alertsmanagement.models.ActionRuleProperties
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ActionRuleProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActionRule, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ActionRulesList(msrest.serialization.Model):
    """List of action rules.

    :param next_link: URL to fetch the next set of action rules.
    :type next_link: str
    :param value: List of action rules.
    :type value: list[~azure.mgmt.alertsmanagement.models.ActionRule]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ActionRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActionRulesList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class Alert(Resource):
    """An alert created in alert management service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :param properties: Alert property bag.
    :type properties: ~azure.mgmt.alertsmanagement.models.AlertProperties
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AlertProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Alert, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AlertModification(Resource):
    """Alert Modification details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :param properties: Properties of the alert modification item.
    :type properties: ~azure.mgmt.alertsmanagement.models.AlertModificationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AlertModificationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertModification, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AlertModificationItem(msrest.serialization.Model):
    """Alert modification item.

    :param modification_event: Reason for the modification. Possible values include:
     "AlertCreated", "StateChange", "MonitorConditionChange", "SeverityChange",
     "ActionRuleTriggered", "ActionRuleSuppressed", "ActionsTriggered", "ActionsSuppressed",
     "ActionsFailed".
    :type modification_event: str or ~azure.mgmt.alertsmanagement.models.AlertModificationEvent
    :param old_value: Old value.
    :type old_value: str
    :param new_value: New value.
    :type new_value: str
    :param modified_at: Modified date and time.
    :type modified_at: str
    :param modified_by: Modified user details (Principal client name).
    :type modified_by: str
    :param comments: Modification comments.
    :type comments: str
    :param description: Description of the modification.
    :type description: str
    """

    _attribute_map = {
        'modification_event': {'key': 'modificationEvent', 'type': 'str'},
        'old_value': {'key': 'oldValue', 'type': 'str'},
        'new_value': {'key': 'newValue', 'type': 'str'},
        'modified_at': {'key': 'modifiedAt', 'type': 'str'},
        'modified_by': {'key': 'modifiedBy', 'type': 'str'},
        'comments': {'key': 'comments', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertModificationItem, self).__init__(**kwargs)
        self.modification_event = kwargs.get('modification_event', None)
        self.old_value = kwargs.get('old_value', None)
        self.new_value = kwargs.get('new_value', None)
        self.modified_at = kwargs.get('modified_at', None)
        self.modified_by = kwargs.get('modified_by', None)
        self.comments = kwargs.get('comments', None)
        self.description = kwargs.get('description', None)


class AlertModificationProperties(msrest.serialization.Model):
    """Properties of the alert modification item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_id: Unique Id of the alert for which the history is being retrieved.
    :vartype alert_id: str
    :param modifications: Modification details.
    :type modifications: list[~azure.mgmt.alertsmanagement.models.AlertModificationItem]
    """

    _validation = {
        'alert_id': {'readonly': True},
    }

    _attribute_map = {
        'alert_id': {'key': 'alertId', 'type': 'str'},
        'modifications': {'key': 'modifications', 'type': '[AlertModificationItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertModificationProperties, self).__init__(**kwargs)
        self.alert_id = None
        self.modifications = kwargs.get('modifications', None)


class AlertProperties(msrest.serialization.Model):
    """Alert property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param essentials: This object contains consistent fields across different monitor services.
    :type essentials: ~azure.mgmt.alertsmanagement.models.Essentials
    :ivar context: Any object.
    :vartype context: object
    :ivar egress_config: Any object.
    :vartype egress_config: object
    """

    _validation = {
        'context': {'readonly': True},
        'egress_config': {'readonly': True},
    }

    _attribute_map = {
        'essentials': {'key': 'essentials', 'type': 'Essentials'},
        'context': {'key': 'context', 'type': 'object'},
        'egress_config': {'key': 'egressConfig', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertProperties, self).__init__(**kwargs)
        self.essentials = kwargs.get('essentials', None)
        self.context = None
        self.egress_config = None


class AzureResource(msrest.serialization.Model):
    """An Azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar name: The resource name.
    :vartype name: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: object
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureResource, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.location = kwargs.get('location', "global")
        self.tags = kwargs.get('tags', None)


class AlertRule(AzureResource):
    """The alert rule information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar name: The resource name.
    :vartype name: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: object
    :param description: The alert rule description.
    :type description: str
    :param state: The alert rule state. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.alertsmanagement.models.AlertRuleState
    :param severity: The alert rule severity. Possible values include: "Sev0", "Sev1", "Sev2",
     "Sev3", "Sev4".
    :type severity: str or ~azure.mgmt.alertsmanagement.models.Severity
    :param frequency: The alert rule frequency in ISO8601 format. The time granularity must be in
     minutes and minimum value is 5 minutes.
    :type frequency: ~datetime.timedelta
    :param detector: The alert rule's detector.
    :type detector: ~azure.mgmt.alertsmanagement.models.Detector
    :param scope: The alert rule resources scope.
    :type scope: list[str]
    :param action_groups: The alert rule actions.
    :type action_groups: ~azure.mgmt.alertsmanagement.models.ActionGroupsInformation
    :param throttling: The alert rule throttling information.
    :type throttling: ~azure.mgmt.alertsmanagement.models.ThrottlingInformation
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': 'object'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'frequency': {'key': 'properties.frequency', 'type': 'duration'},
        'detector': {'key': 'properties.detector', 'type': 'Detector'},
        'scope': {'key': 'properties.scope', 'type': '[str]'},
        'action_groups': {'key': 'properties.actionGroups', 'type': 'ActionGroupsInformation'},
        'throttling': {'key': 'properties.throttling', 'type': 'ThrottlingInformation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertRule, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.state = kwargs.get('state', None)
        self.severity = kwargs.get('severity', None)
        self.frequency = kwargs.get('frequency', None)
        self.detector = kwargs.get('detector', None)
        self.scope = kwargs.get('scope', None)
        self.action_groups = kwargs.get('action_groups', None)
        self.throttling = kwargs.get('throttling', None)


class AlertRulePatchObject(msrest.serialization.Model):
    """The alert rule patch information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar name: The resource name.
    :vartype name: str
    :param tags: A set of tags. The resource tags.
    :type tags: object
    :param description: The alert rule description.
    :type description: str
    :param state: The alert rule state. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.alertsmanagement.models.AlertRuleState
    :param severity: The alert rule severity. Possible values include: "Sev0", "Sev1", "Sev2",
     "Sev3", "Sev4".
    :type severity: str or ~azure.mgmt.alertsmanagement.models.Severity
    :param frequency: The alert rule frequency in ISO8601 format. The time granularity must be in
     minutes and minimum value is 5 minutes.
    :type frequency: ~datetime.timedelta
    :param action_groups: The alert rule actions.
    :type action_groups: ~azure.mgmt.alertsmanagement.models.ActionGroupsInformation
    :param throttling: The alert rule throttling information.
    :type throttling: ~azure.mgmt.alertsmanagement.models.ThrottlingInformation
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': 'object'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'frequency': {'key': 'properties.frequency', 'type': 'duration'},
        'action_groups': {'key': 'properties.actionGroups', 'type': 'ActionGroupsInformation'},
        'throttling': {'key': 'properties.throttling', 'type': 'ThrottlingInformation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertRulePatchObject, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.tags = kwargs.get('tags', None)
        self.description = kwargs.get('description', None)
        self.state = kwargs.get('state', None)
        self.severity = kwargs.get('severity', None)
        self.frequency = kwargs.get('frequency', None)
        self.action_groups = kwargs.get('action_groups', None)
        self.throttling = kwargs.get('throttling', None)


class AlertRulesList(msrest.serialization.Model):
    """List of Smart Detector alert rules.

    :param value: List of Smart Detector alert rules.
    :type value: list[~azure.mgmt.alertsmanagement.models.AlertRule]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AlertRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertRulesList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AlertsList(msrest.serialization.Model):
    """List the alerts.

    :param next_link: URL to fetch the next set of alerts.
    :type next_link: str
    :param value: List of alerts.
    :type value: list[~azure.mgmt.alertsmanagement.models.Alert]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Alert]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertsList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class AlertsMetaData(msrest.serialization.Model):
    """alert meta data information.

    :param properties: alert meta data property bag.
    :type properties: ~azure.mgmt.alertsmanagement.models.AlertsMetaDataProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AlertsMetaDataProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertsMetaData, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AlertsMetaDataProperties(msrest.serialization.Model):
    """alert meta data property bag.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MonitorServiceList.

    All required parameters must be populated in order to send to Azure.

    :param metadata_identifier: Required. Identification of the information to be retrieved by API
     call.Constant filled by server.  Possible values include: "MonitorServiceList".
    :type metadata_identifier: str or ~azure.mgmt.alertsmanagement.models.MetadataIdentifier
    """

    _validation = {
        'metadata_identifier': {'required': True},
    }

    _attribute_map = {
        'metadata_identifier': {'key': 'metadataIdentifier', 'type': 'str'},
    }

    _subtype_map = {
        'metadata_identifier': {'MonitorServiceList': 'MonitorServiceList'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertsMetaDataProperties, self).__init__(**kwargs)
        self.metadata_identifier = None  # type: Optional[str]


class AlertsSummary(Resource):
    """Summary of alerts based on the input filters and 'groupby' parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :param properties: Group the result set.
    :type properties: ~azure.mgmt.alertsmanagement.models.AlertsSummaryGroup
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AlertsSummaryGroup'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertsSummary, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AlertsSummaryGroup(msrest.serialization.Model):
    """Group the result set.

    :param total: Total count of the result set.
    :type total: int
    :param smart_groups_count: Total count of the smart groups.
    :type smart_groups_count: int
    :param groupedby: Name of the field aggregated.
    :type groupedby: str
    :param values: List of the items.
    :type values: list[~azure.mgmt.alertsmanagement.models.AlertsSummaryGroupItem]
    """

    _attribute_map = {
        'total': {'key': 'total', 'type': 'int'},
        'smart_groups_count': {'key': 'smartGroupsCount', 'type': 'int'},
        'groupedby': {'key': 'groupedby', 'type': 'str'},
        'values': {'key': 'values', 'type': '[AlertsSummaryGroupItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertsSummaryGroup, self).__init__(**kwargs)
        self.total = kwargs.get('total', None)
        self.smart_groups_count = kwargs.get('smart_groups_count', None)
        self.groupedby = kwargs.get('groupedby', None)
        self.values = kwargs.get('values', None)


class AlertsSummaryGroupItem(msrest.serialization.Model):
    """Alerts summary group item.

    :param name: Value of the aggregated field.
    :type name: str
    :param count: Count of the aggregated field.
    :type count: int
    :param groupedby: Name of the field aggregated.
    :type groupedby: str
    :param values: List of the items.
    :type values: list[~azure.mgmt.alertsmanagement.models.AlertsSummaryGroupItem]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'groupedby': {'key': 'groupedby', 'type': 'str'},
        'values': {'key': 'values', 'type': '[AlertsSummaryGroupItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertsSummaryGroupItem, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.count = kwargs.get('count', None)
        self.groupedby = kwargs.get('groupedby', None)
        self.values = kwargs.get('values', None)


class Condition(msrest.serialization.Model):
    """condition to trigger an action rule.

    :param operator: operator for a given condition. Possible values include: "Equals",
     "NotEquals", "Contains", "DoesNotContain".
    :type operator: str or ~azure.mgmt.alertsmanagement.models.Operator
    :param values: list of values to match for a given condition.
    :type values: list[str]
    """

    _attribute_map = {
        'operator': {'key': 'operator', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Condition, self).__init__(**kwargs)
        self.operator = kwargs.get('operator', None)
        self.values = kwargs.get('values', None)


class Conditions(msrest.serialization.Model):
    """Conditions in alert instance to be matched for a given action rule. Default value is all. Multiple values could be provided with comma separation.

    :param severity: filter alerts by severity.
    :type severity: ~azure.mgmt.alertsmanagement.models.Condition
    :param monitor_service: filter alerts by monitor service.
    :type monitor_service: ~azure.mgmt.alertsmanagement.models.Condition
    :param monitor_condition: filter alerts by monitor condition.
    :type monitor_condition: ~azure.mgmt.alertsmanagement.models.Condition
    :param target_resource_type: filter alerts by target resource type.
    :type target_resource_type: ~azure.mgmt.alertsmanagement.models.Condition
    :param alert_rule_id: filter alerts by alert rule id.
    :type alert_rule_id: ~azure.mgmt.alertsmanagement.models.Condition
    :param description: filter alerts by alert rule description.
    :type description: ~azure.mgmt.alertsmanagement.models.Condition
    :param alert_context: filter alerts by alert context (payload).
    :type alert_context: ~azure.mgmt.alertsmanagement.models.Condition
    """

    _attribute_map = {
        'severity': {'key': 'severity', 'type': 'Condition'},
        'monitor_service': {'key': 'monitorService', 'type': 'Condition'},
        'monitor_condition': {'key': 'monitorCondition', 'type': 'Condition'},
        'target_resource_type': {'key': 'targetResourceType', 'type': 'Condition'},
        'alert_rule_id': {'key': 'alertRuleId', 'type': 'Condition'},
        'description': {'key': 'description', 'type': 'Condition'},
        'alert_context': {'key': 'alertContext', 'type': 'Condition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Conditions, self).__init__(**kwargs)
        self.severity = kwargs.get('severity', None)
        self.monitor_service = kwargs.get('monitor_service', None)
        self.monitor_condition = kwargs.get('monitor_condition', None)
        self.target_resource_type = kwargs.get('target_resource_type', None)
        self.alert_rule_id = kwargs.get('alert_rule_id', None)
        self.description = kwargs.get('description', None)
        self.alert_context = kwargs.get('alert_context', None)


class Detector(msrest.serialization.Model):
    """The detector information. By default this is not populated, unless it's specified in expandDetector.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The detector id.
    :type id: str
    :param parameters: The detector's parameters.'.
    :type parameters: dict[str, object]
    :param name: The Smart Detector name. By default this is not populated, unless it's specified
     in expandDetector.
    :type name: str
    :param description: The Smart Detector description. By default this is not populated, unless
     it's specified in expandDetector.
    :type description: str
    :param supported_resource_types: The Smart Detector supported resource types. By default this
     is not populated, unless it's specified in expandDetector.
    :type supported_resource_types: list[str]
    :param image_paths: The Smart Detector image path. By default this is not populated, unless
     it's specified in expandDetector.
    :type image_paths: list[str]
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'supported_resource_types': {'key': 'supportedResourceTypes', 'type': '[str]'},
        'image_paths': {'key': 'imagePaths', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Detector, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.parameters = kwargs.get('parameters', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.supported_resource_types = kwargs.get('supported_resource_types', None)
        self.image_paths = kwargs.get('image_paths', None)


class Diagnostics(ActionRuleProperties):
    """Action rule with diagnostics configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param scope: scope on which action rule will apply.
    :type scope: ~azure.mgmt.alertsmanagement.models.Scope
    :param conditions: conditions on which alerts will be filtered.
    :type conditions: ~azure.mgmt.alertsmanagement.models.Conditions
    :param description: Description of action rule.
    :type description: str
    :ivar created_at: Creation time of action rule. Date-Time in ISO-8601 format.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_at: Last updated time of action rule. Date-Time in ISO-8601 format.
    :vartype last_modified_at: ~datetime.datetime
    :ivar created_by: Created by user name.
    :vartype created_by: str
    :ivar last_modified_by: Last modified by user name.
    :vartype last_modified_by: str
    :param status: Indicates if the given action rule is enabled or disabled. Possible values
     include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.alertsmanagement.models.ActionRuleStatus
    :param type: Required. Indicates type of action rule.Constant filled by server.  Possible
     values include: "Suppression", "ActionGroup", "Diagnostics".
    :type type: str or ~azure.mgmt.alertsmanagement.models.ActionRuleType
    """

    _validation = {
        'created_at': {'readonly': True},
        'last_modified_at': {'readonly': True},
        'created_by': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'Scope'},
        'conditions': {'key': 'conditions', 'type': 'Conditions'},
        'description': {'key': 'description', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Diagnostics, self).__init__(**kwargs)
        self.type = 'Diagnostics'  # type: str


class ErrorResponse(msrest.serialization.Model):
    """An error response from the service.

    :param error: Details of error response.
    :type error: ~azure.mgmt.alertsmanagement.models.ErrorResponseBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseBody'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseAutoGenerated(msrest.serialization.Model):
    """An error response from the service.

    :param error: Details of error response.
    :type error: ~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseBodyAutoGenerated'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseAutoGenerated, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseAutoGenerated2(msrest.serialization.Model):
    """An error response from the service.

    :param error: Details of error response.
    :type error: ~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated2
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseBodyAutoGenerated2'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseAutoGenerated2, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseBody(msrest.serialization.Model):
    """Details of error response.

    :param code: Error code, intended to be consumed programmatically.
    :type code: str
    :param message: Description of the error, intended for display in user interface.
    :type message: str
    :param target: Target of the particular error, for example name of the property.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.alertsmanagement.models.ErrorResponseBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponseBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class ErrorResponseBodyAutoGenerated(msrest.serialization.Model):
    """Details of error response.

    :param code: Error code, intended to be consumed programmatically.
    :type code: str
    :param message: Description of the error, intended for display in user interface.
    :type message: str
    :param target: Target of the particular error, for example name of the property.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponseBodyAutoGenerated]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseBodyAutoGenerated, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class ErrorResponseBodyAutoGenerated2(msrest.serialization.Model):
    """Details of error response.

    :param code: Error code, intended to be consumed programmatically.
    :type code: str
    :param message: Description of the error, intended for display in user interface.
    :type message: str
    :param target: Target of the particular error, for example name of the property.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated2]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponseBodyAutoGenerated2]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseBodyAutoGenerated2, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class Essentials(msrest.serialization.Model):
    """This object contains consistent fields across different monitor services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar severity: Severity of alert Sev0 being highest and Sev4 being lowest. Possible values
     include: "Sev0", "Sev1", "Sev2", "Sev3", "Sev4".
    :vartype severity: str or ~azure.mgmt.alertsmanagement.models.Severity
    :ivar signal_type: The type of signal the alert is based on, which could be metrics, logs or
     activity logs. Possible values include: "Metric", "Log", "Unknown".
    :vartype signal_type: str or ~azure.mgmt.alertsmanagement.models.SignalType
    :ivar alert_state: Alert object state, which can be modified by the user. Possible values
     include: "New", "Acknowledged", "Closed".
    :vartype alert_state: str or ~azure.mgmt.alertsmanagement.models.AlertState
    :ivar monitor_condition: Condition of the rule at the monitor service. It represents whether
     the underlying conditions have crossed the defined alert rule thresholds. Possible values
     include: "Fired", "Resolved".
    :vartype monitor_condition: str or ~azure.mgmt.alertsmanagement.models.MonitorCondition
    :param target_resource: Target ARM resource, on which alert got created.
    :type target_resource: str
    :param target_resource_name: Name of the target ARM resource name, on which alert got created.
    :type target_resource_name: str
    :param target_resource_group: Resource group of target ARM resource, on which alert got
     created.
    :type target_resource_group: str
    :param target_resource_type: Resource type of target ARM resource, on which alert got created.
    :type target_resource_type: str
    :ivar monitor_service: Monitor service on which the rule(monitor) is set. Possible values
     include: "Application Insights", "ActivityLog Administrative", "ActivityLog Security",
     "ActivityLog Recommendation", "ActivityLog Policy", "ActivityLog Autoscale", "Log Analytics",
     "Nagios", "Platform", "SCOM", "ServiceHealth", "SmartDetector", "VM Insights", "Zabbix".
    :vartype monitor_service: str or ~azure.mgmt.alertsmanagement.models.MonitorService
    :ivar alert_rule: Rule(monitor) which fired alert instance. Depending on the monitor service,
     this would be ARM id or name of the rule.
    :vartype alert_rule: str
    :ivar source_created_id: Unique Id created by monitor service for each alert instance. This
     could be used to track the issue at the monitor service, in case of Nagios, Zabbix, SCOM etc.
    :vartype source_created_id: str
    :ivar smart_group_id: Unique Id of the smart group.
    :vartype smart_group_id: str
    :ivar smart_grouping_reason: Verbose reason describing the reason why this alert instance is
     added to a smart group.
    :vartype smart_grouping_reason: str
    :ivar start_date_time: Creation time(ISO-8601 format) of alert instance.
    :vartype start_date_time: ~datetime.datetime
    :ivar last_modified_date_time: Last modification time(ISO-8601 format) of alert instance.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar monitor_condition_resolved_date_time: Resolved time(ISO-8601 format) of alert instance.
     This will be updated when monitor service resolves the alert instance because the rule
     condition is no longer met.
    :vartype monitor_condition_resolved_date_time: ~datetime.datetime
    :ivar last_modified_user_name: User who last modified the alert, in case of monitor service
     updates user would be 'system', otherwise name of the user.
    :vartype last_modified_user_name: str
    """

    _validation = {
        'severity': {'readonly': True},
        'signal_type': {'readonly': True},
        'alert_state': {'readonly': True},
        'monitor_condition': {'readonly': True},
        'monitor_service': {'readonly': True},
        'alert_rule': {'readonly': True},
        'source_created_id': {'readonly': True},
        'smart_group_id': {'readonly': True},
        'smart_grouping_reason': {'readonly': True},
        'start_date_time': {'readonly': True},
        'last_modified_date_time': {'readonly': True},
        'monitor_condition_resolved_date_time': {'readonly': True},
        'last_modified_user_name': {'readonly': True},
    }

    _attribute_map = {
        'severity': {'key': 'severity', 'type': 'str'},
        'signal_type': {'key': 'signalType', 'type': 'str'},
        'alert_state': {'key': 'alertState', 'type': 'str'},
        'monitor_condition': {'key': 'monitorCondition', 'type': 'str'},
        'target_resource': {'key': 'targetResource', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'target_resource_type': {'key': 'targetResourceType', 'type': 'str'},
        'monitor_service': {'key': 'monitorService', 'type': 'str'},
        'alert_rule': {'key': 'alertRule', 'type': 'str'},
        'source_created_id': {'key': 'sourceCreatedId', 'type': 'str'},
        'smart_group_id': {'key': 'smartGroupId', 'type': 'str'},
        'smart_grouping_reason': {'key': 'smartGroupingReason', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'last_modified_date_time': {'key': 'lastModifiedDateTime', 'type': 'iso-8601'},
        'monitor_condition_resolved_date_time': {'key': 'monitorConditionResolvedDateTime', 'type': 'iso-8601'},
        'last_modified_user_name': {'key': 'lastModifiedUserName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Essentials, self).__init__(**kwargs)
        self.severity = None
        self.signal_type = None
        self.alert_state = None
        self.monitor_condition = None
        self.target_resource = kwargs.get('target_resource', None)
        self.target_resource_name = kwargs.get('target_resource_name', None)
        self.target_resource_group = kwargs.get('target_resource_group', None)
        self.target_resource_type = kwargs.get('target_resource_type', None)
        self.monitor_service = None
        self.alert_rule = None
        self.source_created_id = None
        self.smart_group_id = None
        self.smart_grouping_reason = None
        self.start_date_time = None
        self.last_modified_date_time = None
        self.monitor_condition_resolved_date_time = None
        self.last_modified_user_name = None


class MonitorServiceDetails(msrest.serialization.Model):
    """Details of a monitor service.

    :param name: Monitor service name.
    :type name: str
    :param display_name: Monitor service display name.
    :type display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MonitorServiceDetails, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)


class MonitorServiceList(AlertsMetaDataProperties):
    """Monitor service details.

    All required parameters must be populated in order to send to Azure.

    :param metadata_identifier: Required. Identification of the information to be retrieved by API
     call.Constant filled by server.  Possible values include: "MonitorServiceList".
    :type metadata_identifier: str or ~azure.mgmt.alertsmanagement.models.MetadataIdentifier
    :param data: Required. Array of operations.
    :type data: list[~azure.mgmt.alertsmanagement.models.MonitorServiceDetails]
    """

    _validation = {
        'metadata_identifier': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'metadata_identifier': {'key': 'metadataIdentifier', 'type': 'str'},
        'data': {'key': 'data', 'type': '[MonitorServiceDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MonitorServiceList, self).__init__(**kwargs)
        self.metadata_identifier = 'MonitorServiceList'  # type: str
        self.data = kwargs['data']


class Operation(msrest.serialization.Model):
    """Operation provided by provider.

    :param name: Name of the operation.
    :type name: str
    :param display: Properties of the operation.
    :type display: ~azure.mgmt.alertsmanagement.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """Properties of the operation.

    :param provider: Provider name.
    :type provider: str
    :param resource: Resource name.
    :type resource: str
    :param operation: Operation name.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationsList(msrest.serialization.Model):
    """Lists the operations available in the AlertsManagement RP.

    All required parameters must be populated in order to send to Azure.

    :param next_link: URL to fetch the next set of alerts.
    :type next_link: str
    :param value: Required. Array of operations.
    :type value: list[~azure.mgmt.alertsmanagement.models.Operation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationsList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs['value']


class PatchObject(msrest.serialization.Model):
    """Data contract for patch.

    :param tags: A set of tags. tags to be updated.
    :type tags: object
    :param status: Indicates if the given action rule is enabled or disabled. Possible values
     include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.alertsmanagement.models.ActionRuleStatus
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': 'object'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PatchObject, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.status = kwargs.get('status', None)


class Scope(msrest.serialization.Model):
    """Target scope for a given action rule. By default scope will be the subscription. User can also provide list of resource groups or list of resources from the scope subscription as well.

    :param scope_type: type of target scope. Possible values include: "ResourceGroup", "Resource",
     "Subscription".
    :type scope_type: str or ~azure.mgmt.alertsmanagement.models.ScopeType
    :param values: list of ARM IDs of the given scope type which will be the target of the given
     action rule.
    :type values: list[str]
    """

    _attribute_map = {
        'scope_type': {'key': 'scopeType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Scope, self).__init__(**kwargs)
        self.scope_type = kwargs.get('scope_type', None)
        self.values = kwargs.get('values', None)


class SmartDetectorErrorResponse(msrest.serialization.Model):
    """Describe the format of an Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SmartDetectorErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class SmartGroup(Resource):
    """Set of related alerts grouped together smartly by AMS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :param alerts_count: Total number of alerts in smart group.
    :type alerts_count: int
    :ivar smart_group_state: Smart group state. Possible values include: "New", "Acknowledged",
     "Closed".
    :vartype smart_group_state: str or ~azure.mgmt.alertsmanagement.models.State
    :ivar severity: Severity of smart group is the highest(Sev0 >... > Sev4) severity of all the
     alerts in the group. Possible values include: "Sev0", "Sev1", "Sev2", "Sev3", "Sev4".
    :vartype severity: str or ~azure.mgmt.alertsmanagement.models.Severity
    :ivar start_date_time: Creation time of smart group. Date-Time in ISO-8601 format.
    :vartype start_date_time: ~datetime.datetime
    :ivar last_modified_date_time: Last updated time of smart group. Date-Time in ISO-8601 format.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_modified_user_name: Last modified by user name.
    :vartype last_modified_user_name: str
    :param resources: Summary of target resources in the smart group.
    :type resources: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :param resource_types: Summary of target resource types in the smart group.
    :type resource_types: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :param resource_groups: Summary of target resource groups in the smart group.
    :type resource_groups: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :param monitor_services: Summary of monitorServices in the smart group.
    :type monitor_services: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :param monitor_conditions: Summary of monitorConditions in the smart group.
    :type monitor_conditions:
     list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :param alert_states: Summary of alertStates in the smart group.
    :type alert_states: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :param alert_severities: Summary of alertSeverities in the smart group.
    :type alert_severities: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :param next_link: The URI to fetch the next page of alerts. Call ListNext() with this URI to
     fetch the next page alerts.
    :type next_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'smart_group_state': {'readonly': True},
        'severity': {'readonly': True},
        'start_date_time': {'readonly': True},
        'last_modified_date_time': {'readonly': True},
        'last_modified_user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'alerts_count': {'key': 'properties.alertsCount', 'type': 'int'},
        'smart_group_state': {'key': 'properties.smartGroupState', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'last_modified_date_time': {'key': 'properties.lastModifiedDateTime', 'type': 'iso-8601'},
        'last_modified_user_name': {'key': 'properties.lastModifiedUserName', 'type': 'str'},
        'resources': {'key': 'properties.resources', 'type': '[SmartGroupAggregatedProperty]'},
        'resource_types': {'key': 'properties.resourceTypes', 'type': '[SmartGroupAggregatedProperty]'},
        'resource_groups': {'key': 'properties.resourceGroups', 'type': '[SmartGroupAggregatedProperty]'},
        'monitor_services': {'key': 'properties.monitorServices', 'type': '[SmartGroupAggregatedProperty]'},
        'monitor_conditions': {'key': 'properties.monitorConditions', 'type': '[SmartGroupAggregatedProperty]'},
        'alert_states': {'key': 'properties.alertStates', 'type': '[SmartGroupAggregatedProperty]'},
        'alert_severities': {'key': 'properties.alertSeverities', 'type': '[SmartGroupAggregatedProperty]'},
        'next_link': {'key': 'properties.nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SmartGroup, self).__init__(**kwargs)
        self.alerts_count = kwargs.get('alerts_count', None)
        self.smart_group_state = None
        self.severity = None
        self.start_date_time = None
        self.last_modified_date_time = None
        self.last_modified_user_name = None
        self.resources = kwargs.get('resources', None)
        self.resource_types = kwargs.get('resource_types', None)
        self.resource_groups = kwargs.get('resource_groups', None)
        self.monitor_services = kwargs.get('monitor_services', None)
        self.monitor_conditions = kwargs.get('monitor_conditions', None)
        self.alert_states = kwargs.get('alert_states', None)
        self.alert_severities = kwargs.get('alert_severities', None)
        self.next_link = kwargs.get('next_link', None)


class SmartGroupAggregatedProperty(msrest.serialization.Model):
    """Aggregated property of each type.

    :param name: Name of the type.
    :type name: str
    :param count: Total number of items of type.
    :type count: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SmartGroupAggregatedProperty, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.count = kwargs.get('count', None)


class SmartGroupModification(Resource):
    """Alert Modification details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :param properties: Properties of the smartGroup modification item.
    :type properties: ~azure.mgmt.alertsmanagement.models.SmartGroupModificationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'SmartGroupModificationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SmartGroupModification, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class SmartGroupModificationItem(msrest.serialization.Model):
    """smartGroup modification item.

    :param modification_event: Reason for the modification. Possible values include:
     "SmartGroupCreated", "StateChange", "AlertAdded", "AlertRemoved".
    :type modification_event: str or
     ~azure.mgmt.alertsmanagement.models.SmartGroupModificationEvent
    :param old_value: Old value.
    :type old_value: str
    :param new_value: New value.
    :type new_value: str
    :param modified_at: Modified date and time.
    :type modified_at: str
    :param modified_by: Modified user details (Principal client name).
    :type modified_by: str
    :param comments: Modification comments.
    :type comments: str
    :param description: Description of the modification.
    :type description: str
    """

    _attribute_map = {
        'modification_event': {'key': 'modificationEvent', 'type': 'str'},
        'old_value': {'key': 'oldValue', 'type': 'str'},
        'new_value': {'key': 'newValue', 'type': 'str'},
        'modified_at': {'key': 'modifiedAt', 'type': 'str'},
        'modified_by': {'key': 'modifiedBy', 'type': 'str'},
        'comments': {'key': 'comments', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SmartGroupModificationItem, self).__init__(**kwargs)
        self.modification_event = kwargs.get('modification_event', None)
        self.old_value = kwargs.get('old_value', None)
        self.new_value = kwargs.get('new_value', None)
        self.modified_at = kwargs.get('modified_at', None)
        self.modified_by = kwargs.get('modified_by', None)
        self.comments = kwargs.get('comments', None)
        self.description = kwargs.get('description', None)


class SmartGroupModificationProperties(msrest.serialization.Model):
    """Properties of the smartGroup modification item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar smart_group_id: Unique Id of the smartGroup for which the history is being retrieved.
    :vartype smart_group_id: str
    :param modifications: Modification details.
    :type modifications: list[~azure.mgmt.alertsmanagement.models.SmartGroupModificationItem]
    :param next_link: URL to fetch the next set of results.
    :type next_link: str
    """

    _validation = {
        'smart_group_id': {'readonly': True},
    }

    _attribute_map = {
        'smart_group_id': {'key': 'smartGroupId', 'type': 'str'},
        'modifications': {'key': 'modifications', 'type': '[SmartGroupModificationItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SmartGroupModificationProperties, self).__init__(**kwargs)
        self.smart_group_id = None
        self.modifications = kwargs.get('modifications', None)
        self.next_link = kwargs.get('next_link', None)


class SmartGroupsList(msrest.serialization.Model):
    """List the alerts.

    :param next_link: URL to fetch the next set of alerts.
    :type next_link: str
    :param value: List of alerts.
    :type value: list[~azure.mgmt.alertsmanagement.models.SmartGroup]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[SmartGroup]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SmartGroupsList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class Suppression(ActionRuleProperties):
    """Action rule with suppression configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param scope: scope on which action rule will apply.
    :type scope: ~azure.mgmt.alertsmanagement.models.Scope
    :param conditions: conditions on which alerts will be filtered.
    :type conditions: ~azure.mgmt.alertsmanagement.models.Conditions
    :param description: Description of action rule.
    :type description: str
    :ivar created_at: Creation time of action rule. Date-Time in ISO-8601 format.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_at: Last updated time of action rule. Date-Time in ISO-8601 format.
    :vartype last_modified_at: ~datetime.datetime
    :ivar created_by: Created by user name.
    :vartype created_by: str
    :ivar last_modified_by: Last modified by user name.
    :vartype last_modified_by: str
    :param status: Indicates if the given action rule is enabled or disabled. Possible values
     include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.alertsmanagement.models.ActionRuleStatus
    :param type: Required. Indicates type of action rule.Constant filled by server.  Possible
     values include: "Suppression", "ActionGroup", "Diagnostics".
    :type type: str or ~azure.mgmt.alertsmanagement.models.ActionRuleType
    :param suppression_config: Required. suppression configuration for the action rule.
    :type suppression_config: ~azure.mgmt.alertsmanagement.models.SuppressionConfig
    """

    _validation = {
        'created_at': {'readonly': True},
        'last_modified_at': {'readonly': True},
        'created_by': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'type': {'required': True},
        'suppression_config': {'required': True},
    }

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'Scope'},
        'conditions': {'key': 'conditions', 'type': 'Conditions'},
        'description': {'key': 'description', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'suppression_config': {'key': 'suppressionConfig', 'type': 'SuppressionConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Suppression, self).__init__(**kwargs)
        self.type = 'Suppression'  # type: str
        self.suppression_config = kwargs['suppression_config']


class SuppressionConfig(msrest.serialization.Model):
    """Suppression logic for a given action rule.

    All required parameters must be populated in order to send to Azure.

    :param recurrence_type: Required. Specifies when the suppression should be applied. Possible
     values include: "Always", "Once", "Daily", "Weekly", "Monthly".
    :type recurrence_type: str or ~azure.mgmt.alertsmanagement.models.SuppressionType
    :param schedule: suppression schedule configuration.
    :type schedule: ~azure.mgmt.alertsmanagement.models.SuppressionSchedule
    """

    _validation = {
        'recurrence_type': {'required': True},
    }

    _attribute_map = {
        'recurrence_type': {'key': 'recurrenceType', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'SuppressionSchedule'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SuppressionConfig, self).__init__(**kwargs)
        self.recurrence_type = kwargs['recurrence_type']
        self.schedule = kwargs.get('schedule', None)


class SuppressionSchedule(msrest.serialization.Model):
    """Schedule for a given suppression configuration.

    :param start_date: Start date for suppression.
    :type start_date: str
    :param end_date: End date for suppression.
    :type end_date: str
    :param start_time: Start time for suppression.
    :type start_time: str
    :param end_time: End date for suppression.
    :type end_time: str
    :param recurrence_values: Specifies the values for recurrence pattern.
    :type recurrence_values: list[int]
    """

    _attribute_map = {
        'start_date': {'key': 'startDate', 'type': 'str'},
        'end_date': {'key': 'endDate', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'recurrence_values': {'key': 'recurrenceValues', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SuppressionSchedule, self).__init__(**kwargs)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.recurrence_values = kwargs.get('recurrence_values', None)


class ThrottlingInformation(msrest.serialization.Model):
    """Optional throttling information for the alert rule.

    :param duration: The required duration (in ISO8601 format) to wait before notifying on the
     alert rule again. The time granularity must be in minutes and minimum value is 0 minutes.
    :type duration: ~datetime.timedelta
    """

    _attribute_map = {
        'duration': {'key': 'duration', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ThrottlingInformation, self).__init__(**kwargs)
        self.duration = kwargs.get('duration', None)
