# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class DatastoreCredentials(msrest.serialization.Model):
    """Base definition for datastore credentials.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccountKeyDatastoreCredentials, CertificateDatastoreCredentials, KerberosKeytabCredentials, KerberosPasswordCredentials, NoneDatastoreCredentials, SasDatastoreCredentials, ServicePrincipalDatastoreCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    """

    _validation = {
        'credentials_type': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
    }

    _subtype_map = {
        'credentials_type': {'AccountKey': 'AccountKeyDatastoreCredentials', 'Certificate': 'CertificateDatastoreCredentials', 'KerberosKeytab': 'KerberosKeytabCredentials', 'KerberosPassword': 'KerberosPasswordCredentials', 'None': 'NoneDatastoreCredentials', 'Sas': 'SasDatastoreCredentials', 'ServicePrincipal': 'ServicePrincipalDatastoreCredentials'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = None  # type: Optional[str]


class AccountKeyDatastoreCredentials(DatastoreCredentials):
    """Account key datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Storage account secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.AccountKeyDatastoreSecrets
    """

    _validation = {
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'AccountKeyDatastoreSecrets'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword secrets: Required. [Required] Storage account secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.AccountKeyDatastoreSecrets
        """
        super(AccountKeyDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'AccountKey'  # type: str
        self.secrets = kwargs['secrets']


class DatastoreSecrets(msrest.serialization.Model):
    """Base definition for datastore secrets.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AccountKeyDatastoreSecrets, CertificateDatastoreSecrets, KerberosKeytabSecrets, KerberosPasswordSecrets, SasDatastoreSecrets, ServicePrincipalDatastoreSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
    }

    _subtype_map = {
        'secrets_type': {'AccountKey': 'AccountKeyDatastoreSecrets', 'Certificate': 'CertificateDatastoreSecrets', 'KerberosKeytab': 'KerberosKeytabSecrets', 'KerberosPassword': 'KerberosPasswordSecrets', 'Sas': 'SasDatastoreSecrets', 'ServicePrincipal': 'ServicePrincipalDatastoreSecrets'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = None  # type: Optional[str]


class AccountKeyDatastoreSecrets(DatastoreSecrets):
    """Datastore account key secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar key: Storage account key.
    :vartype key: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key: Storage account key.
        :paramtype key: str
        """
        super(AccountKeyDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'AccountKey'  # type: str
        self.key = kwargs.get('key', None)


class IdentityConfiguration(msrest.serialization.Model):
    """Base definition for identity configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmlToken, ManagedIdentity, UserIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
    }

    _subtype_map = {
        'identity_type': {'AMLToken': 'AmlToken', 'Managed': 'ManagedIdentity', 'UserIdentity': 'UserIdentity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IdentityConfiguration, self).__init__(**kwargs)
        self.identity_type = None  # type: Optional[str]


class AmlToken(IdentityConfiguration):
    """AML Token identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlToken, self).__init__(**kwargs)
        self.identity_type = 'AMLToken'  # type: str


class ResourceBase(msrest.serialization.Model):
    """ResourceBase.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        """
        super(ResourceBase, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.properties = kwargs.get('properties', None)
        self.tags = kwargs.get('tags', None)


class AssetBase(ResourceBase):
    """AssetBase.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(AssetBase, self).__init__(**kwargs)
        self.is_anonymous = kwargs.get('is_anonymous', False)
        self.is_archived = kwargs.get('is_archived', False)


class AssetContainer(ResourceBase):
    """AssetContainer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(AssetContainer, self).__init__(**kwargs)
        self.is_archived = kwargs.get('is_archived', False)
        self.latest_version = None
        self.next_version = None


class AssetJobInput(msrest.serialization.Model):
    """Asset input type.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        """
        super(AssetJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']


class AssetJobOutput(msrest.serialization.Model):
    """Asset output type.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        """
        super(AssetJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)


class AssetReferenceBase(msrest.serialization.Model):
    """Base definition for asset references.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataPathAssetReference, IdAssetReference, OutputPathAssetReference.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
    }

    _subtype_map = {
        'reference_type': {'DataPath': 'DataPathAssetReference', 'Id': 'IdAssetReference', 'OutputPath': 'OutputPathAssetReference'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AssetReferenceBase, self).__init__(**kwargs)
        self.reference_type = None  # type: Optional[str]


class ForecastHorizon(msrest.serialization.Model):
    """The desired maximum forecast horizon in units of time-series frequency.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoForecastHorizon, CustomForecastHorizon.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set forecast horizon value selection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoForecastHorizon', 'Custom': 'CustomForecastHorizon'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ForecastHorizon, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoForecastHorizon(ForecastHorizon):
    """Forecast horizon determined automatically by system.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set forecast horizon value selection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoForecastHorizon, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class JobBaseDetails(ResourceBase):
    """Base definition for a job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoMLJob, CommandJob, PipelineJob, SweepJob.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Sweep", "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar schedule: Schedule definition of job.
     If no schedule is provided, the job is run once and immediately after submission.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'ScheduleBase'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
    }

    _subtype_map = {
        'job_type': {'AutoML': 'AutoMLJob', 'Command': 'CommandJob', 'Pipeline': 'PipelineJob', 'Sweep': 'SweepJob'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword schedule: Schedule definition of job.
         If no schedule is provided, the job is run once and immediately after submission.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        """
        super(JobBaseDetails, self).__init__(**kwargs)
        self.compute_id = kwargs.get('compute_id', None)
        self.display_name = kwargs.get('display_name', None)
        self.experiment_name = kwargs.get('experiment_name', "Default")
        self.identity = kwargs.get('identity', None)
        self.is_archived = kwargs.get('is_archived', False)
        self.job_type = 'JobBaseDetails'  # type: str
        self.schedule = kwargs.get('schedule', None)
        self.services = kwargs.get('services', None)
        self.status = None


class AutoMLJob(JobBaseDetails):
    """AutoMLJob class.
Use this class for executing AutoML tasks like Classification/Regression etc.
See TaskType enum for all the tasks supported.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Sweep", "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar schedule: Schedule definition of job.
     If no schedule is provided, the job is run once and immediately after submission.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar environment_id: The ARM resource ID of the Environment specification for the job.
     This is optional value to provide, if not provided, AutoML will default this to Production
     AutoML curated environment version when running the job.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
    :ivar task_details: Required. [Required] This represents scenario which can be one of
     Tables/NLP/Image.
    :vartype task_details: ~azure.mgmt.machinelearningservices.models.AutoMLVertical
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'task_details': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'ScheduleBase'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'resources': {'key': 'resources', 'type': 'ResourceConfiguration'},
        'task_details': {'key': 'taskDetails', 'type': 'AutoMLVertical'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword schedule: Schedule definition of job.
         If no schedule is provided, the job is run once and immediately after submission.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword environment_id: The ARM resource ID of the Environment specification for the job.
         This is optional value to provide, if not provided, AutoML will default this to Production
         AutoML curated environment version when running the job.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
        :keyword task_details: Required. [Required] This represents scenario which can be one of
         Tables/NLP/Image.
        :paramtype task_details: ~azure.mgmt.machinelearningservices.models.AutoMLVertical
        """
        super(AutoMLJob, self).__init__(**kwargs)
        self.job_type = 'AutoML'  # type: str
        self.environment_id = kwargs.get('environment_id', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.outputs = kwargs.get('outputs', None)
        self.resources = kwargs.get('resources', None)
        self.task_details = kwargs['task_details']


class AutoMLVertical(msrest.serialization.Model):
    """AutoML vertical class.
Base class for AutoML verticals - TableVertical/ImageVertical/NLPVertical.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Classification, Forecasting, ImageClassification, ImageClassificationMultilabel, ImageInstanceSegmentation, ImageObjectDetection, Regression, TextClassification, TextClassificationMultilabel, TextNer.

    All required parameters must be populated in order to send to Azure.

    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    """

    _validation = {
        'task_type': {'required': True},
    }

    _attribute_map = {
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
    }

    _subtype_map = {
        'task_type': {'Classification': 'Classification', 'Forecasting': 'Forecasting', 'ImageClassification': 'ImageClassification', 'ImageClassificationMultilabel': 'ImageClassificationMultilabel', 'ImageInstanceSegmentation': 'ImageInstanceSegmentation', 'ImageObjectDetection': 'ImageObjectDetection', 'Regression': 'Regression', 'TextClassification': 'TextClassification', 'TextClassificationMultilabel': 'TextClassificationMultilabel', 'TextNER': 'TextNer'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        """
        super(AutoMLVertical, self).__init__(**kwargs)
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = None  # type: Optional[str]


class NCrossValidations(msrest.serialization.Model):
    """N-Cross validations value.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoNCrossValidations, CustomNCrossValidations.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Mode for determining N-Cross validations.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoNCrossValidations', 'Custom': 'CustomNCrossValidations'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NCrossValidations, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoNCrossValidations(NCrossValidations):
    """N-Cross validations determined automatically.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Mode for determining N-Cross validations.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoNCrossValidations, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class Seasonality(msrest.serialization.Model):
    """Forecasting seasonality.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoSeasonality, CustomSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Seasonality mode.Constant filled by server. Possible values
     include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoSeasonality', 'Custom': 'CustomSeasonality'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Seasonality, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoSeasonality(Seasonality):
    """AutoSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Seasonality mode.Constant filled by server. Possible values
     include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoSeasonality, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class TargetLags(msrest.serialization.Model):
    """The number of past periods to lag from the target column.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoTargetLags, CustomTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set target lags mode - Auto/Custom.Constant filled by server.
     Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoTargetLags', 'Custom': 'CustomTargetLags'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TargetLags, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoTargetLags(TargetLags):
    """AutoTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set target lags mode - Auto/Custom.Constant filled by server.
     Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoTargetLags, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class TargetRollingWindowSize(msrest.serialization.Model):
    """Forecasting target rolling window size.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutoTargetRollingWindowSize, CustomTargetRollingWindowSize.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] TargetRollingWindowSiz detection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    _subtype_map = {
        'mode': {'Auto': 'AutoTargetRollingWindowSize', 'Custom': 'CustomTargetRollingWindowSize'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(TargetRollingWindowSize, self).__init__(**kwargs)
        self.mode = None  # type: Optional[str]


class AutoTargetRollingWindowSize(TargetRollingWindowSize):
    """Target lags rolling window determined automatically.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] TargetRollingWindowSiz detection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AutoTargetRollingWindowSize, self).__init__(**kwargs)
        self.mode = 'Auto'  # type: str


class DatastoreDetails(ResourceBase):
    """Base definition for datastore contents configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBlobDatastore, AzureDataLakeGen1Datastore, AzureDataLakeGen2Datastore, AzureFileDatastore, HdfsDatastore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
    }

    _subtype_map = {
        'datastore_type': {'AzureBlob': 'AzureBlobDatastore', 'AzureDataLakeGen1': 'AzureDataLakeGen1Datastore', 'AzureDataLakeGen2': 'AzureDataLakeGen2Datastore', 'AzureFile': 'AzureFileDatastore', 'Hdfs': 'HdfsDatastore'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        """
        super(DatastoreDetails, self).__init__(**kwargs)
        self.credentials = kwargs['credentials']
        self.datastore_type = 'DatastoreDetails'  # type: str
        self.is_default = None


class AzureBlobDatastore(DatastoreDetails):
    """Azure Blob datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Storage account name.
    :vartype account_name: str
    :ivar container_name: Storage account container name.
    :vartype container_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword account_name: Storage account name.
        :paramtype account_name: str
        :keyword container_name: Storage account container name.
        :paramtype container_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureBlobDatastore, self).__init__(**kwargs)
        self.datastore_type = 'AzureBlob'  # type: str
        self.account_name = kwargs.get('account_name', None)
        self.container_name = kwargs.get('container_name', None)
        self.endpoint = kwargs.get('endpoint', None)
        self.protocol = kwargs.get('protocol', None)
        self.service_data_access_auth_identity = kwargs.get('service_data_access_auth_identity', None)


class AzureDataLakeGen1Datastore(DatastoreDetails):
    """Azure Data Lake Gen1 datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    :ivar store_name: Required. [Required] Azure Data Lake store name.
    :vartype store_name: str
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'store_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
        'store_name': {'key': 'storeName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        :keyword store_name: Required. [Required] Azure Data Lake store name.
        :paramtype store_name: str
        """
        super(AzureDataLakeGen1Datastore, self).__init__(**kwargs)
        self.datastore_type = 'AzureDataLakeGen1'  # type: str
        self.service_data_access_auth_identity = kwargs.get('service_data_access_auth_identity', None)
        self.store_name = kwargs['store_name']


class AzureDataLakeGen2Datastore(DatastoreDetails):
    """Azure Data Lake Gen2 datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Required. [Required] Storage account name.
    :vartype account_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar filesystem: Required. [Required] The name of the Data Lake Gen2 filesystem.
    :vartype filesystem: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'account_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'filesystem': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'filesystem': {'key': 'filesystem', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword account_name: Required. [Required] Storage account name.
        :paramtype account_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword filesystem: Required. [Required] The name of the Data Lake Gen2 filesystem.
        :paramtype filesystem: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureDataLakeGen2Datastore, self).__init__(**kwargs)
        self.datastore_type = 'AzureDataLakeGen2'  # type: str
        self.account_name = kwargs['account_name']
        self.endpoint = kwargs.get('endpoint', None)
        self.filesystem = kwargs['filesystem']
        self.protocol = kwargs.get('protocol', None)
        self.service_data_access_auth_identity = kwargs.get('service_data_access_auth_identity', None)


class AzureFileDatastore(DatastoreDetails):
    """Azure File datastore configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar account_name: Required. [Required] Storage account name.
    :vartype account_name: str
    :ivar endpoint: Azure cloud endpoint for the storage account.
    :vartype endpoint: str
    :ivar file_share_name: Required. [Required] The name of the Azure file share that the datastore
     points to.
    :vartype file_share_name: str
    :ivar protocol: Protocol used to communicate with the storage account.
    :vartype protocol: str
    :ivar service_data_access_auth_identity: Indicates which identity to use to authenticate
     service data access to customer's storage. Possible values include: "None",
     "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
    :vartype service_data_access_auth_identity: str or
     ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'account_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'file_share_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'file_share_name': {'key': 'fileShareName', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'service_data_access_auth_identity': {'key': 'serviceDataAccessAuthIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword account_name: Required. [Required] Storage account name.
        :paramtype account_name: str
        :keyword endpoint: Azure cloud endpoint for the storage account.
        :paramtype endpoint: str
        :keyword file_share_name: Required. [Required] The name of the Azure file share that the
         datastore points to.
        :paramtype file_share_name: str
        :keyword protocol: Protocol used to communicate with the storage account.
        :paramtype protocol: str
        :keyword service_data_access_auth_identity: Indicates which identity to use to authenticate
         service data access to customer's storage. Possible values include: "None",
         "WorkspaceSystemAssignedIdentity", "WorkspaceUserAssignedIdentity".
        :paramtype service_data_access_auth_identity: str or
         ~azure.mgmt.machinelearningservices.models.ServiceDataAccessAuthIdentity
        """
        super(AzureFileDatastore, self).__init__(**kwargs)
        self.datastore_type = 'AzureFile'  # type: str
        self.account_name = kwargs['account_name']
        self.endpoint = kwargs.get('endpoint', None)
        self.file_share_name = kwargs['file_share_name']
        self.protocol = kwargs.get('protocol', None)
        self.service_data_access_auth_identity = kwargs.get('service_data_access_auth_identity', None)


class EarlyTerminationPolicy(msrest.serialization.Model):
    """Early termination policies enable canceling poor-performing runs before they complete.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BanditPolicy, MedianStoppingPolicy, TruncationSelectionPolicy.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
    }

    _subtype_map = {
        'policy_type': {'Bandit': 'BanditPolicy', 'MedianStopping': 'MedianStoppingPolicy', 'TruncationSelection': 'TruncationSelectionPolicy'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        """
        super(EarlyTerminationPolicy, self).__init__(**kwargs)
        self.delay_evaluation = kwargs.get('delay_evaluation', 0)
        self.evaluation_interval = kwargs.get('evaluation_interval', 0)
        self.policy_type = None  # type: Optional[str]


class BanditPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    :ivar slack_amount: Absolute distance allowed from the best performing run.
    :vartype slack_amount: float
    :ivar slack_factor: Ratio of the allowed distance from the best performing run.
    :vartype slack_factor: float
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'slack_amount': {'key': 'slackAmount', 'type': 'float'},
        'slack_factor': {'key': 'slackFactor', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        :keyword slack_amount: Absolute distance allowed from the best performing run.
        :paramtype slack_amount: float
        :keyword slack_factor: Ratio of the allowed distance from the best performing run.
        :paramtype slack_factor: float
        """
        super(BanditPolicy, self).__init__(**kwargs)
        self.policy_type = 'Bandit'  # type: str
        self.slack_amount = kwargs.get('slack_amount', 0)
        self.slack_factor = kwargs.get('slack_factor', 0)


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class BatchDeploymentData(TrackedResource):
    """BatchDeploymentData.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchDeploymentDetails
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BatchDeploymentDetails'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchDeploymentDetails
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(BatchDeploymentData, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.properties = kwargs['properties']
        self.sku = kwargs.get('sku', None)


class EndpointDeploymentPropertiesBase(msrest.serialization.Model):
    """Base definition for endpoint deployment.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    """

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super(EndpointDeploymentPropertiesBase, self).__init__(**kwargs)
        self.code_configuration = kwargs.get('code_configuration', None)
        self.description = kwargs.get('description', None)
        self.environment_id = kwargs.get('environment_id', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.properties = kwargs.get('properties', None)


class BatchDeploymentDetails(EndpointDeploymentPropertiesBase):
    """Batch inference settings per deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar compute: Compute target for batch inference operation.
    :vartype compute: str
    :ivar error_threshold: Error threshold, if the error count for the entire input goes above this
     value,
     the batch inference will be aborted. Range is [-1, int.MaxValue].
     For FileDataset, this value is the count of file failures.
     For TabularDataset, this value is the count of record failures.
     If set to -1 (the lower bound), all failures during batch inference will be ignored.
    :vartype error_threshold: int
    :ivar logging_level: Logging level for batch inference operation. Possible values include:
     "Info", "Warning", "Debug".
    :vartype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
    :ivar max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
    :vartype max_concurrency_per_instance: int
    :ivar mini_batch_size: Size of the mini-batch passed to each batch invocation.
     For FileDataset, this is the number of files per mini-batch.
     For TabularDataset, this is the size of the records in bytes, per mini-batch.
    :vartype mini_batch_size: long
    :ivar model: Reference to the model asset for the endpoint deployment.
    :vartype model: ~azure.mgmt.machinelearningservices.models.AssetReferenceBase
    :ivar output_action: Indicates how the output will be organized. Possible values include:
     "SummaryOnly", "AppendRow".
    :vartype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
    :ivar output_file_name: Customized output file name for append_row output action.
    :vartype output_file_name: str
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar resources: Indicates compute configuration for the job.
     If not provided, will default to the defaults defined in ResourceConfiguration.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
    :ivar retry_settings: Retry Settings for the batch inference operation.
     If not provided, will default to the defaults defined in BatchRetrySettings.
    :vartype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'compute': {'key': 'compute', 'type': 'str'},
        'error_threshold': {'key': 'errorThreshold', 'type': 'int'},
        'logging_level': {'key': 'loggingLevel', 'type': 'str'},
        'max_concurrency_per_instance': {'key': 'maxConcurrencyPerInstance', 'type': 'int'},
        'mini_batch_size': {'key': 'miniBatchSize', 'type': 'long'},
        'model': {'key': 'model', 'type': 'AssetReferenceBase'},
        'output_action': {'key': 'outputAction', 'type': 'str'},
        'output_file_name': {'key': 'outputFileName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'resources': {'key': 'resources', 'type': 'ResourceConfiguration'},
        'retry_settings': {'key': 'retrySettings', 'type': 'BatchRetrySettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword compute: Compute target for batch inference operation.
        :paramtype compute: str
        :keyword error_threshold: Error threshold, if the error count for the entire input goes above
         this value,
         the batch inference will be aborted. Range is [-1, int.MaxValue].
         For FileDataset, this value is the count of file failures.
         For TabularDataset, this value is the count of record failures.
         If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :paramtype error_threshold: int
        :keyword logging_level: Logging level for batch inference operation. Possible values include:
         "Info", "Warning", "Debug".
        :paramtype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
        :keyword max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
        :paramtype max_concurrency_per_instance: int
        :keyword mini_batch_size: Size of the mini-batch passed to each batch invocation.
         For FileDataset, this is the number of files per mini-batch.
         For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :paramtype mini_batch_size: long
        :keyword model: Reference to the model asset for the endpoint deployment.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.AssetReferenceBase
        :keyword output_action: Indicates how the output will be organized. Possible values include:
         "SummaryOnly", "AppendRow".
        :paramtype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
        :keyword output_file_name: Customized output file name for append_row output action.
        :paramtype output_file_name: str
        :keyword resources: Indicates compute configuration for the job.
         If not provided, will default to the defaults defined in ResourceConfiguration.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
        :keyword retry_settings: Retry Settings for the batch inference operation.
         If not provided, will default to the defaults defined in BatchRetrySettings.
        :paramtype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
        """
        super(BatchDeploymentDetails, self).__init__(**kwargs)
        self.compute = kwargs.get('compute', None)
        self.error_threshold = kwargs.get('error_threshold', -1)
        self.logging_level = kwargs.get('logging_level', None)
        self.max_concurrency_per_instance = kwargs.get('max_concurrency_per_instance', 1)
        self.mini_batch_size = kwargs.get('mini_batch_size', 10)
        self.model = kwargs.get('model', None)
        self.output_action = kwargs.get('output_action', None)
        self.output_file_name = kwargs.get('output_file_name', "predictions.csv")
        self.provisioning_state = None
        self.resources = kwargs.get('resources', None)
        self.retry_settings = kwargs.get('retry_settings', None)


class BatchDeploymentTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of BatchDeployment entities.

    :ivar next_link: The link to the next page of BatchDeployment objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchDeployment.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchDeploymentData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BatchDeploymentData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of BatchDeployment objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchDeployment.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchDeploymentData]
        """
        super(BatchDeploymentTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class BatchEndpointData(TrackedResource):
    """BatchEndpointData.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchEndpointDetails
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BatchEndpointDetails'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchEndpointDetails
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(BatchEndpointData, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.properties = kwargs['properties']
        self.sku = kwargs.get('sku', None)


class BatchEndpointDefaults(msrest.serialization.Model):
    """Batch endpoint default values.

    :ivar deployment_name: Name of the deployment that will be default for the endpoint.
     This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
    :vartype deployment_name: str
    """

    _attribute_map = {
        'deployment_name': {'key': 'deploymentName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword deployment_name: Name of the deployment that will be default for the endpoint.
         This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        :paramtype deployment_name: str
        """
        super(BatchEndpointDefaults, self).__init__(**kwargs)
        self.deployment_name = kwargs.get('deployment_name', None)


class EndpointPropertiesBase(msrest.serialization.Model):
    """Inference Endpoint base definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        """
        super(EndpointPropertiesBase, self).__init__(**kwargs)
        self.auth_mode = kwargs['auth_mode']
        self.description = kwargs.get('description', None)
        self.keys = kwargs.get('keys', None)
        self.properties = kwargs.get('properties', None)
        self.scoring_uri = None
        self.swagger_uri = None


class BatchEndpointDetails(EndpointPropertiesBase):
    """Batch endpoint configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    :ivar defaults: Default values for Batch Endpoint.
    :vartype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
    :ivar provisioning_state: Provisioning state for the endpoint. Possible values include:
     "Creating", "Deleting", "Succeeded", "Failed", "Updating", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.EndpointProvisioningState
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
        'defaults': {'key': 'defaults', 'type': 'BatchEndpointDefaults'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword defaults: Default values for Batch Endpoint.
        :paramtype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
        """
        super(BatchEndpointDetails, self).__init__(**kwargs)
        self.defaults = kwargs.get('defaults', None)
        self.provisioning_state = None


class BatchEndpointTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of BatchEndpoint entities.

    :ivar next_link: The link to the next page of BatchEndpoint objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchEndpoint.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchEndpointData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BatchEndpointData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of BatchEndpoint objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchEndpoint.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchEndpointData]
        """
        super(BatchEndpointTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class BatchRetrySettings(msrest.serialization.Model):
    """Retry settings for a batch inference operation.

    :ivar max_retries: Maximum retry count for a mini-batch.
    :vartype max_retries: int
    :ivar timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_retries': {'key': 'maxRetries', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_retries: Maximum retry count for a mini-batch.
        :paramtype max_retries: int
        :keyword timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super(BatchRetrySettings, self).__init__(**kwargs)
        self.max_retries = kwargs.get('max_retries', 3)
        self.timeout = kwargs.get('timeout', "PT30S")


class SamplingAlgorithm(msrest.serialization.Model):
    """The Sampling Algorithm used to generate hyperparameter values, along with properties to
configure the algorithm.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BayesianSamplingAlgorithm, GridSamplingAlgorithm, RandomSamplingAlgorithm.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    _subtype_map = {
        'sampling_algorithm_type': {'Bayesian': 'BayesianSamplingAlgorithm', 'Grid': 'GridSamplingAlgorithm', 'Random': 'RandomSamplingAlgorithm'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = None  # type: Optional[str]


class BayesianSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that generates values based on previous values.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BayesianSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Bayesian'  # type: str


class BuildContext(msrest.serialization.Model):
    """Configuration settings for Docker build context.

    All required parameters must be populated in order to send to Azure.

    :ivar context_uri: Required. [Required] URI of the Docker build context used to build the
     image. Supports blob URIs on environment creation and may return blob or Git URIs.
    
    
     .. raw:: html
    
        <seealso
     href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />.
    :vartype context_uri: str
    :ivar dockerfile_path: Path to the Dockerfile in the build context.
    
    
     .. raw:: html
    
        <seealso href="https://docs.docker.com/engine/reference/builder/" />.
    :vartype dockerfile_path: str
    """

    _validation = {
        'context_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'context_uri': {'key': 'contextUri', 'type': 'str'},
        'dockerfile_path': {'key': 'dockerfilePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword context_uri: Required. [Required] URI of the Docker build context used to build the
         image. Supports blob URIs on environment creation and may return blob or Git URIs.
        
        
         .. raw:: html
        
            <seealso
         href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />.
        :paramtype context_uri: str
        :keyword dockerfile_path: Path to the Dockerfile in the build context.
        
        
         .. raw:: html
        
            <seealso href="https://docs.docker.com/engine/reference/builder/" />.
        :paramtype dockerfile_path: str
        """
        super(BuildContext, self).__init__(**kwargs)
        self.context_uri = kwargs['context_uri']
        self.dockerfile_path = kwargs.get('dockerfile_path', "Dockerfile")


class CertificateDatastoreCredentials(DatastoreCredentials):
    """Certificate datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar authority_url: Authority URL used for authentication.
    :vartype authority_url: str
    :ivar client_id: Required. [Required] Service principal client ID.
    :vartype client_id: str
    :ivar resource_url: Resource the service principal has access to.
    :vartype resource_url: str
    :ivar secrets: Required. [Required] Service principal secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.CertificateDatastoreSecrets
    :ivar tenant_id: Required. [Required] ID of the tenant to which the service principal belongs.
    :vartype tenant_id: str
    :ivar thumbprint: Required. [Required] Thumbprint of the certificate used for authentication.
    :vartype thumbprint: str
    """

    _validation = {
        'credentials_type': {'required': True},
        'client_id': {'required': True},
        'secrets': {'required': True},
        'tenant_id': {'required': True},
        'thumbprint': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'authority_url': {'key': 'authorityUrl', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'resource_url': {'key': 'resourceUrl', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'CertificateDatastoreSecrets'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword authority_url: Authority URL used for authentication.
        :paramtype authority_url: str
        :keyword client_id: Required. [Required] Service principal client ID.
        :paramtype client_id: str
        :keyword resource_url: Resource the service principal has access to.
        :paramtype resource_url: str
        :keyword secrets: Required. [Required] Service principal secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.CertificateDatastoreSecrets
        :keyword tenant_id: Required. [Required] ID of the tenant to which the service principal
         belongs.
        :paramtype tenant_id: str
        :keyword thumbprint: Required. [Required] Thumbprint of the certificate used for
         authentication.
        :paramtype thumbprint: str
        """
        super(CertificateDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'Certificate'  # type: str
        self.authority_url = kwargs.get('authority_url', None)
        self.client_id = kwargs['client_id']
        self.resource_url = kwargs.get('resource_url', None)
        self.secrets = kwargs['secrets']
        self.tenant_id = kwargs['tenant_id']
        self.thumbprint = kwargs['thumbprint']


class CertificateDatastoreSecrets(DatastoreSecrets):
    """Datastore certificate secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar certificate: Service principal certificate.
    :vartype certificate: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword certificate: Service principal certificate.
        :paramtype certificate: str
        """
        super(CertificateDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'Certificate'  # type: str
        self.certificate = kwargs.get('certificate', None)


class TableVertical(msrest.serialization.Model):
    """Abstract class for AutoML tasks that use table dataset as input - such as Classification/Regression/Forecasting.

    :ivar data_settings: Data inputs for AutoMLJob.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalDataSettings
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings: ~azure.mgmt.machinelearningservices.models.TrainingSettings
    """

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'TableVerticalDataSettings'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'training_settings': {'key': 'trainingSettings', 'type': 'TrainingSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Data inputs for AutoMLJob.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalDataSettings
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings: ~azure.mgmt.machinelearningservices.models.TrainingSettings
        """
        super(TableVertical, self).__init__(**kwargs)
        self.data_settings = kwargs.get('data_settings', None)
        self.featurization_settings = kwargs.get('featurization_settings', None)
        self.limit_settings = kwargs.get('limit_settings', None)
        self.training_settings = kwargs.get('training_settings', None)


class Classification(AutoMLVertical, TableVertical):
    """Classification task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Data inputs for AutoMLJob.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalDataSettings
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings: ~azure.mgmt.machinelearningservices.models.TrainingSettings
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar allowed_models: Allowed models for classification task.
    :vartype allowed_models: list[str or
     ~azure.mgmt.machinelearningservices.models.ClassificationModels]
    :ivar blocked_models: Blocked models for classification task.
    :vartype blocked_models: list[str or
     ~azure.mgmt.machinelearningservices.models.ClassificationModels]
    :ivar primary_metric: Primary metric for the task. Possible values include: "AUCWeighted",
     "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted", "PrecisionScoreWeighted".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
    """

    _validation = {
        'task_type': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'TableVerticalDataSettings'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'training_settings': {'key': 'trainingSettings', 'type': 'TrainingSettings'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'allowed_models': {'key': 'allowedModels', 'type': '[str]'},
        'blocked_models': {'key': 'blockedModels', 'type': '[str]'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Data inputs for AutoMLJob.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalDataSettings
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings: ~azure.mgmt.machinelearningservices.models.TrainingSettings
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword allowed_models: Allowed models for classification task.
        :paramtype allowed_models: list[str or
         ~azure.mgmt.machinelearningservices.models.ClassificationModels]
        :keyword blocked_models: Blocked models for classification task.
        :paramtype blocked_models: list[str or
         ~azure.mgmt.machinelearningservices.models.ClassificationModels]
        :keyword primary_metric: Primary metric for the task. Possible values include: "AUCWeighted",
         "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted", "PrecisionScoreWeighted".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
        """
        super(Classification, self).__init__(**kwargs)
        self.data_settings = kwargs.get('data_settings', None)
        self.featurization_settings = kwargs.get('featurization_settings', None)
        self.limit_settings = kwargs.get('limit_settings', None)
        self.training_settings = kwargs.get('training_settings', None)
        self.task_type = 'Classification'  # type: str
        self.allowed_models = kwargs.get('allowed_models', None)
        self.blocked_models = kwargs.get('blocked_models', None)
        self.primary_metric = kwargs.get('primary_metric', None)
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = 'Classification'  # type: str
        self.allowed_models = kwargs.get('allowed_models', None)
        self.blocked_models = kwargs.get('blocked_models', None)
        self.primary_metric = kwargs.get('primary_metric', None)


class CodeConfiguration(msrest.serialization.Model):
    """Configuration for a scoring code asset.

    All required parameters must be populated in order to send to Azure.

    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar scoring_script: Required. [Required] The script to execute on startup. eg. "score.py".
    :vartype scoring_script: str
    """

    _validation = {
        'scoring_script': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'code_id': {'key': 'codeId', 'type': 'str'},
        'scoring_script': {'key': 'scoringScript', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword scoring_script: Required. [Required] The script to execute on startup. eg. "score.py".
        :paramtype scoring_script: str
        """
        super(CodeConfiguration, self).__init__(**kwargs)
        self.code_id = kwargs.get('code_id', None)
        self.scoring_script = kwargs['scoring_script']


class CodeContainerData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.CodeContainerDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'CodeContainerDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.CodeContainerDetails
        """
        super(CodeContainerData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class CodeContainerDetails(AssetContainer):
    """Container for code asset versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(CodeContainerDetails, self).__init__(**kwargs)


class CodeContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of CodeContainer entities.

    :ivar next_link: The link to the next page of CodeContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CodeContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CodeContainerData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[CodeContainerData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of CodeContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CodeContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CodeContainerData]
        """
        super(CodeContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class CodeVersionData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.CodeVersionDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'CodeVersionDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.CodeVersionDetails
        """
        super(CodeVersionData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class CodeVersionDetails(AssetBase):
    """Code asset version details.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar code_uri: Uri where code is located.
    :vartype code_uri: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'code_uri': {'key': 'codeUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword code_uri: Uri where code is located.
        :paramtype code_uri: str
        """
        super(CodeVersionDetails, self).__init__(**kwargs)
        self.code_uri = kwargs.get('code_uri', None)


class CodeVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of CodeVersion entities.

    :ivar next_link: The link to the next page of CodeVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type CodeVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.CodeVersionData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[CodeVersionData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of CodeVersion objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type CodeVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.CodeVersionData]
        """
        super(CodeVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ColumnTransformer(msrest.serialization.Model):
    """Column transformer parameters.

    :ivar fields: Fields to apply transformer logic on.
    :vartype fields: list[str]
    :ivar parameters: Different properties to be passed to transformer.
     Input expected is dictionary of key,value pairs in JSON format.
    :vartype parameters: any
    """

    _attribute_map = {
        'fields': {'key': 'fields', 'type': '[str]'},
        'parameters': {'key': 'parameters', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword fields: Fields to apply transformer logic on.
        :paramtype fields: list[str]
        :keyword parameters: Different properties to be passed to transformer.
         Input expected is dictionary of key,value pairs in JSON format.
        :paramtype parameters: any
        """
        super(ColumnTransformer, self).__init__(**kwargs)
        self.fields = kwargs.get('fields', None)
        self.parameters = kwargs.get('parameters', None)


class CommandJob(JobBaseDetails):
    """Command job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Sweep", "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar schedule: Schedule definition of job.
     If no schedule is provided, the job is run once and immediately after submission.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar command: Required. [Required] The command to execute on startup of the job. eg. "python
     train.py".
    :vartype command: str
    :ivar distribution: Distribution configuration of the job. If set, this should be one of Mpi,
     Tensorflow, PyTorch, or null.
    :vartype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
    :ivar environment_id: Required. [Required] The ARM resource ID of the Environment specification
     for the job.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar inputs: Mapping of input data bindings used in the job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar limits: Command Job limit.
    :vartype limits: ~azure.mgmt.machinelearningservices.models.CommandJobLimits
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar parameters: Input parameters.
    :vartype parameters: any
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'command': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'environment_id': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'parameters': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'ScheduleBase'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'code_id': {'key': 'codeId', 'type': 'str'},
        'command': {'key': 'command', 'type': 'str'},
        'distribution': {'key': 'distribution', 'type': 'DistributionConfiguration'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'limits': {'key': 'limits', 'type': 'CommandJobLimits'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'resources': {'key': 'resources', 'type': 'ResourceConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword schedule: Schedule definition of job.
         If no schedule is provided, the job is run once and immediately after submission.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword command: Required. [Required] The command to execute on startup of the job. eg.
         "python train.py".
        :paramtype command: str
        :keyword distribution: Distribution configuration of the job. If set, this should be one of
         Mpi, Tensorflow, PyTorch, or null.
        :paramtype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
        :keyword environment_id: Required. [Required] The ARM resource ID of the Environment
         specification for the job.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword inputs: Mapping of input data bindings used in the job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword limits: Command Job limit.
        :paramtype limits: ~azure.mgmt.machinelearningservices.models.CommandJobLimits
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
        """
        super(CommandJob, self).__init__(**kwargs)
        self.job_type = 'Command'  # type: str
        self.code_id = kwargs.get('code_id', None)
        self.command = kwargs['command']
        self.distribution = kwargs.get('distribution', None)
        self.environment_id = kwargs['environment_id']
        self.environment_variables = kwargs.get('environment_variables', None)
        self.inputs = kwargs.get('inputs', None)
        self.limits = kwargs.get('limits', None)
        self.outputs = kwargs.get('outputs', None)
        self.parameters = None
        self.resources = kwargs.get('resources', None)


class JobLimits(msrest.serialization.Model):
    """JobLimits.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CommandJobLimits, SweepJobLimits.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    _subtype_map = {
        'job_limits_type': {'Command': 'CommandJobLimits', 'Sweep': 'SweepJobLimits'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        """
        super(JobLimits, self).__init__(**kwargs)
        self.job_limits_type = None  # type: Optional[str]
        self.timeout = kwargs.get('timeout', None)


class CommandJobLimits(JobLimits):
    """Command Job limit class.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        """
        super(CommandJobLimits, self).__init__(**kwargs)
        self.job_limits_type = 'Command'  # type: str


class ComponentContainerData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComponentContainerDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ComponentContainerDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComponentContainerDetails
        """
        super(ComponentContainerData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class ComponentContainerDetails(AssetContainer):
    """Component container definition.


.. raw:: html

   <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(ComponentContainerDetails, self).__init__(**kwargs)


class ComponentContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ComponentContainer entities.

    :ivar next_link: The link to the next page of ComponentContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ComponentContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComponentContainerData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ComponentContainerData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ComponentContainer objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ComponentContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComponentContainerData]
        """
        super(ComponentContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ComponentVersionData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComponentVersionDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ComponentVersionDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComponentVersionDetails
        """
        super(ComponentVersionData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class ComponentVersionDetails(AssetBase):
    """Definition of a component version: defines resources that span component types.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar component_spec: Defines Component definition details.
    
    
     .. raw:: html
    
        <see
     href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command"
     />.
    :vartype component_spec: any
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'component_spec': {'key': 'componentSpec', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword component_spec: Defines Component definition details.
        
        
         .. raw:: html
        
            <see
         href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command"
         />.
        :paramtype component_spec: any
        """
        super(ComponentVersionDetails, self).__init__(**kwargs)
        self.component_spec = kwargs.get('component_spec', None)


class ComponentVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ComponentVersion entities.

    :ivar next_link: The link to the next page of ComponentVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ComponentVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComponentVersionData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ComponentVersionData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ComponentVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ComponentVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComponentVersionData]
        """
        super(ComponentVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ContainerResourceRequirements(msrest.serialization.Model):
    """Resource requirements for each container instance within an online deployment.

    :ivar container_resource_limits: Container resource limit info:.
    :vartype container_resource_limits:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
    :ivar container_resource_requests: Container resource request info:.
    :vartype container_resource_requests:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
    """

    _attribute_map = {
        'container_resource_limits': {'key': 'containerResourceLimits', 'type': 'ContainerResourceSettings'},
        'container_resource_requests': {'key': 'containerResourceRequests', 'type': 'ContainerResourceSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword container_resource_limits: Container resource limit info:.
        :paramtype container_resource_limits:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
        :keyword container_resource_requests: Container resource request info:.
        :paramtype container_resource_requests:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceSettings
        """
        super(ContainerResourceRequirements, self).__init__(**kwargs)
        self.container_resource_limits = kwargs.get('container_resource_limits', None)
        self.container_resource_requests = kwargs.get('container_resource_requests', None)


class ContainerResourceSettings(msrest.serialization.Model):
    """ContainerResourceSettings.

    :ivar cpu: Number of vCPUs request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype cpu: str
    :ivar gpu: Number of Nvidia GPU cards request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype gpu: str
    :ivar memory: Memory size request/limit for container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype memory: str
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'str'},
        'gpu': {'key': 'gpu', 'type': 'str'},
        'memory': {'key': 'memory', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword cpu: Number of vCPUs request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype cpu: str
        :keyword gpu: Number of Nvidia GPU cards request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype gpu: str
        :keyword memory: Memory size request/limit for container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype memory: str
        """
        super(ContainerResourceSettings, self).__init__(**kwargs)
        self.cpu = kwargs.get('cpu', None)
        self.gpu = kwargs.get('gpu', None)
        self.memory = kwargs.get('memory', None)


class ScheduleBase(msrest.serialization.Model):
    """Base definition of a schedule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CronSchedule, RecurrenceSchedule.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601 format.
     If not present, the schedule will run indefinitely.
    :vartype end_time: ~datetime.datetime
    :ivar schedule_status: Specifies the schedule's status. Possible values include: "Enabled",
     "Disabled".
    :vartype schedule_status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
    :ivar schedule_type: Required. [Required] Specifies the schedule type.Constant filled by
     server. Possible values include: "Cron", "Recurrence".
    :vartype schedule_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleType
    :ivar start_time: Specifies start time of schedule in ISO 8601 format.
    :vartype start_time: ~datetime.datetime
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format.
    :vartype time_zone: str
    """

    _validation = {
        'schedule_type': {'required': True},
    }

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'schedule_status': {'key': 'scheduleStatus', 'type': 'str'},
        'schedule_type': {'key': 'scheduleType', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
    }

    _subtype_map = {
        'schedule_type': {'Cron': 'CronSchedule', 'Recurrence': 'RecurrenceSchedule'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601 format.
         If not present, the schedule will run indefinitely.
        :paramtype end_time: ~datetime.datetime
        :keyword schedule_status: Specifies the schedule's status. Possible values include: "Enabled",
         "Disabled".
        :paramtype schedule_status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
        :keyword start_time: Specifies start time of schedule in ISO 8601 format.
        :paramtype start_time: ~datetime.datetime
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format.
        :paramtype time_zone: str
        """
        super(ScheduleBase, self).__init__(**kwargs)
        self.end_time = kwargs.get('end_time', None)
        self.schedule_status = kwargs.get('schedule_status', None)
        self.schedule_type = None  # type: Optional[str]
        self.start_time = kwargs.get('start_time', None)
        self.time_zone = kwargs.get('time_zone', "UTC")


class CronSchedule(ScheduleBase):
    """Cron schedule definition.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601 format.
     If not present, the schedule will run indefinitely.
    :vartype end_time: ~datetime.datetime
    :ivar schedule_status: Specifies the schedule's status. Possible values include: "Enabled",
     "Disabled".
    :vartype schedule_status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
    :ivar schedule_type: Required. [Required] Specifies the schedule type.Constant filled by
     server. Possible values include: "Cron", "Recurrence".
    :vartype schedule_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleType
    :ivar start_time: Specifies start time of schedule in ISO 8601 format.
    :vartype start_time: ~datetime.datetime
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format.
    :vartype time_zone: str
    :ivar expression: Required. [Required] Specifies cron expression of schedule.
     The expression should follow NCronTab format.
    :vartype expression: str
    """

    _validation = {
        'schedule_type': {'required': True},
        'expression': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'schedule_status': {'key': 'scheduleStatus', 'type': 'str'},
        'schedule_type': {'key': 'scheduleType', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'expression': {'key': 'expression', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601 format.
         If not present, the schedule will run indefinitely.
        :paramtype end_time: ~datetime.datetime
        :keyword schedule_status: Specifies the schedule's status. Possible values include: "Enabled",
         "Disabled".
        :paramtype schedule_status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
        :keyword start_time: Specifies start time of schedule in ISO 8601 format.
        :paramtype start_time: ~datetime.datetime
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format.
        :paramtype time_zone: str
        :keyword expression: Required. [Required] Specifies cron expression of schedule.
         The expression should follow NCronTab format.
        :paramtype expression: str
        """
        super(CronSchedule, self).__init__(**kwargs)
        self.schedule_type = 'Cron'  # type: str
        self.expression = kwargs['expression']


class CustomForecastHorizon(ForecastHorizon):
    """The desired maximum forecast horizon in units of time-series frequency.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set forecast horizon value selection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.ForecastHorizonMode
    :ivar value: Required. [Required] Forecast horizon value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] Forecast horizon value.
        :paramtype value: int
        """
        super(CustomForecastHorizon, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = kwargs['value']


class JobInput(msrest.serialization.Model):
    """Command job definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomModelJobInput, LiteralJobInput, MLFlowModelJobInput, MLTableJobInput, TritonModelJobInput, UriFileJobInput, UriFolderJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Literal", "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    _subtype_map = {
        'job_input_type': {'CustomModel': 'CustomModelJobInput', 'Literal': 'LiteralJobInput', 'MLFlowModel': 'MLFlowModelJobInput', 'MLTable': 'MLTableJobInput', 'TritonModel': 'TritonModelJobInput', 'UriFile': 'UriFileJobInput', 'UriFolder': 'UriFolderJobInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(JobInput, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.job_input_type = None  # type: Optional[str]


class CustomModelJobInput(JobInput, AssetJobInput):
    """CustomModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Literal", "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(CustomModelJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'CustomModel'  # type: str
        self.description = kwargs.get('description', None)
        self.job_input_type = 'CustomModel'  # type: str


class JobOutput(msrest.serialization.Model):
    """Job output definition container information on where to find job output/logs.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomModelJobOutput, MLFlowModelJobOutput, MLTableJobOutput, TritonModelJobOutput, UriFileJobOutput, UriFolderJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    _subtype_map = {
        'job_output_type': {'CustomModel': 'CustomModelJobOutput', 'MLFlowModel': 'MLFlowModelJobOutput', 'MLTable': 'MLTableJobOutput', 'TritonModel': 'TritonModelJobOutput', 'UriFile': 'UriFileJobOutput', 'UriFolder': 'UriFolderJobOutput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(JobOutput, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.job_output_type = None  # type: Optional[str]


class CustomModelJobOutput(JobOutput, AssetJobOutput):
    """CustomModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(CustomModelJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'CustomModel'  # type: str
        self.description = kwargs.get('description', None)
        self.job_output_type = 'CustomModel'  # type: str


class CustomNCrossValidations(NCrossValidations):
    """N-Cross validations are specified by user.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Mode for determining N-Cross validations.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.NCrossValidationsMode
    :ivar value: Required. [Required] N-Cross validations value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] N-Cross validations value.
        :paramtype value: int
        """
        super(CustomNCrossValidations, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = kwargs['value']


class CustomSeasonality(Seasonality):
    """CustomSeasonality.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Seasonality mode.Constant filled by server. Possible values
     include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.SeasonalityMode
    :ivar value: Required. [Required] Seasonality value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] Seasonality value.
        :paramtype value: int
        """
        super(CustomSeasonality, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = kwargs['value']


class CustomTargetLags(TargetLags):
    """CustomTargetLags.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] Set target lags mode - Auto/Custom.Constant filled by server.
     Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetLagsMode
    :ivar values: Required. [Required] Set target lags values.
    :vartype values: list[int]
    """

    _validation = {
        'mode': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'values': {'key': 'values', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword values: Required. [Required] Set target lags values.
        :paramtype values: list[int]
        """
        super(CustomTargetLags, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.values = kwargs['values']


class CustomTargetRollingWindowSize(TargetRollingWindowSize):
    """CustomTargetRollingWindowSize.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Required. [Required] TargetRollingWindowSiz detection mode.Constant filled by
     server. Possible values include: "Auto", "Custom".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSizeMode
    :ivar value: Required. [Required] TargetRollingWindowSize value.
    :vartype value: int
    """

    _validation = {
        'mode': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword value: Required. [Required] TargetRollingWindowSize value.
        :paramtype value: int
        """
        super(CustomTargetRollingWindowSize, self).__init__(**kwargs)
        self.mode = 'Custom'  # type: str
        self.value = kwargs['value']


class DataContainerData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataContainerDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DataContainerDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataContainerDetails
        """
        super(DataContainerData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class DataContainerDetails(AssetContainer):
    """Container for data asset versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    :ivar data_type: Required. [Required] Specifies the type of data. Possible values include:
     "UriFile", "UriFolder", "MLTable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
        'data_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_type: Required. [Required] Specifies the type of data. Possible values include:
         "UriFile", "UriFolder", "MLTable".
        :paramtype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
        """
        super(DataContainerDetails, self).__init__(**kwargs)
        self.data_type = kwargs['data_type']


class DataContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of DataContainer entities.

    :ivar next_link: The link to the next page of DataContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type DataContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataContainerData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataContainerData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of DataContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type DataContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataContainerData]
        """
        super(DataContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class DataPathAssetReference(AssetReferenceBase):
    """Reference to an asset via its path in a datastore.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar datastore_id: ARM resource ID of the datastore where the asset is located.
    :vartype datastore_id: str
    :ivar path: The path of the file/directory in the datastore.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'datastore_id': {'key': 'datastoreId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword datastore_id: ARM resource ID of the datastore where the asset is located.
        :paramtype datastore_id: str
        :keyword path: The path of the file/directory in the datastore.
        :paramtype path: str
        """
        super(DataPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'DataPath'  # type: str
        self.datastore_id = kwargs.get('datastore_id', None)
        self.path = kwargs.get('path', None)


class DataSettings(msrest.serialization.Model):
    """Collection of registered Tabular Dataset Ids and other data settings required for training and validating models.

    All required parameters must be populated in order to send to Azure.

    :ivar target_column_name: Required. [Required] Target column name: This is prediction values
     column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.TestDataSettings
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.TrainingDataSettings
    """

    _validation = {
        'target_column_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'test_data': {'key': 'testData', 'type': 'TestDataSettings'},
        'training_data': {'key': 'trainingData', 'type': 'TrainingDataSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword target_column_name: Required. [Required] Target column name: This is prediction values
         column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.TestDataSettings
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.TrainingDataSettings
        """
        super(DataSettings, self).__init__(**kwargs)
        self.target_column_name = kwargs['target_column_name']
        self.test_data = kwargs.get('test_data', None)
        self.training_data = kwargs['training_data']


class DatastoreData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatastoreDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DatastoreDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatastoreDetails
        """
        super(DatastoreData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class DatastoreResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of Datastore entities.

    :ivar next_link: The link to the next page of Datastore objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type Datastore.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DatastoreData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DatastoreData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of Datastore objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type Datastore.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DatastoreData]
        """
        super(DatastoreResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class DataVersionBaseData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataVersionBaseDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'DataVersionBaseDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataVersionBaseDetails
        """
        super(DataVersionBaseData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class DataVersionBaseDetails(AssetBase):
    """Data version base definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MLTableData, UriFileDataVersion, UriFolderDataVersion.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "UriFile", "UriFolder", "MLTable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
     Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220201Preview.Assets.DataVersionBase.DataType.
    :vartype data_uri: str
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
    }

    _subtype_map = {
        'data_type': {'MLTable': 'MLTableData', 'UriFile': 'UriFileDataVersion', 'UriFolder': 'UriFolderDataVersion'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
         Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220201Preview.Assets.DataVersionBase.DataType.
        :paramtype data_uri: str
        """
        super(DataVersionBaseDetails, self).__init__(**kwargs)
        self.data_type = 'DataVersionBaseDetails'  # type: str
        self.data_uri = kwargs['data_uri']


class DataVersionBaseResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of DataVersionBase entities.

    :ivar next_link: The link to the next page of DataVersionBase objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type DataVersionBase.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DataVersionBaseData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DataVersionBaseData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of DataVersionBase objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type DataVersionBase.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DataVersionBaseData]
        """
        super(DataVersionBaseResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class OnlineScaleSettings(msrest.serialization.Model):
    """Online deployment scaling configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DefaultScaleSettings, TargetUtilizationScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: Required. [Required] Type of deployment scaling algorithm.Constant filled by
     server. Possible values include: "Default", "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    """

    _validation = {
        'scale_type': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    _subtype_map = {
        'scale_type': {'Default': 'DefaultScaleSettings', 'TargetUtilization': 'TargetUtilizationScaleSettings'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OnlineScaleSettings, self).__init__(**kwargs)
        self.scale_type = None  # type: Optional[str]


class DefaultScaleSettings(OnlineScaleSettings):
    """DefaultScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: Required. [Required] Type of deployment scaling algorithm.Constant filled by
     server. Possible values include: "Default", "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    """

    _validation = {
        'scale_type': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DefaultScaleSettings, self).__init__(**kwargs)
        self.scale_type = 'Default'  # type: str


class DeploymentLogs(msrest.serialization.Model):
    """DeploymentLogs.

    :ivar content: The retrieved online deployment logs.
    :vartype content: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword content: The retrieved online deployment logs.
        :paramtype content: str
        """
        super(DeploymentLogs, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)


class DeploymentLogsRequest(msrest.serialization.Model):
    """DeploymentLogsRequest.

    :ivar container_type: The type of container to retrieve logs from. Possible values include:
     "StorageInitializer", "InferenceServer".
    :vartype container_type: str or ~azure.mgmt.machinelearningservices.models.ContainerType
    :ivar tail: The maximum number of lines to tail.
    :vartype tail: int
    """

    _attribute_map = {
        'container_type': {'key': 'containerType', 'type': 'str'},
        'tail': {'key': 'tail', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword container_type: The type of container to retrieve logs from. Possible values include:
         "StorageInitializer", "InferenceServer".
        :paramtype container_type: str or ~azure.mgmt.machinelearningservices.models.ContainerType
        :keyword tail: The maximum number of lines to tail.
        :paramtype tail: int
        """
        super(DeploymentLogsRequest, self).__init__(**kwargs)
        self.container_type = kwargs.get('container_type', None)
        self.tail = kwargs.get('tail', None)


class DistributionConfiguration(msrest.serialization.Model):
    """Base definition for job distribution configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Mpi, PyTorch, TensorFlow.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
    }

    _subtype_map = {
        'distribution_type': {'Mpi': 'Mpi', 'PyTorch': 'PyTorch', 'TensorFlow': 'TensorFlow'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DistributionConfiguration, self).__init__(**kwargs)
        self.distribution_type = None  # type: Optional[str]


class EndpointAuthKeys(msrest.serialization.Model):
    """Keys for endpoint authentication.

    :ivar primary_key: The primary key.
    :vartype primary_key: str
    :ivar secondary_key: The secondary key.
    :vartype secondary_key: str
    """

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword primary_key: The primary key.
        :paramtype primary_key: str
        :keyword secondary_key: The secondary key.
        :paramtype secondary_key: str
        """
        super(EndpointAuthKeys, self).__init__(**kwargs)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)


class EndpointAuthToken(msrest.serialization.Model):
    """Service Token.

    :ivar access_token: Access token for endpoint authentication.
    :vartype access_token: str
    :ivar expiry_time_utc: Access token expiry time (UTC).
    :vartype expiry_time_utc: long
    :ivar refresh_after_time_utc: Refresh access token after time (UTC).
    :vartype refresh_after_time_utc: long
    :ivar token_type: Access token type.
    :vartype token_type: str
    """

    _attribute_map = {
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'expiry_time_utc': {'key': 'expiryTimeUtc', 'type': 'long'},
        'refresh_after_time_utc': {'key': 'refreshAfterTimeUtc', 'type': 'long'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword access_token: Access token for endpoint authentication.
        :paramtype access_token: str
        :keyword expiry_time_utc: Access token expiry time (UTC).
        :paramtype expiry_time_utc: long
        :keyword refresh_after_time_utc: Refresh access token after time (UTC).
        :paramtype refresh_after_time_utc: long
        :keyword token_type: Access token type.
        :paramtype token_type: str
        """
        super(EndpointAuthToken, self).__init__(**kwargs)
        self.access_token = kwargs.get('access_token', None)
        self.expiry_time_utc = kwargs.get('expiry_time_utc', 0)
        self.refresh_after_time_utc = kwargs.get('refresh_after_time_utc', 0)
        self.token_type = kwargs.get('token_type', None)


class EnvironmentContainerData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentContainerDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'EnvironmentContainerDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentContainerDetails
        """
        super(EnvironmentContainerData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class EnvironmentContainerDetails(AssetContainer):
    """Container for environment specification versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(EnvironmentContainerDetails, self).__init__(**kwargs)


class EnvironmentContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of EnvironmentContainer entities.

    :ivar next_link: The link to the next page of EnvironmentContainer objects. If null, there are
     no additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type EnvironmentContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentContainerData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EnvironmentContainerData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of EnvironmentContainer objects. If null, there
         are no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type EnvironmentContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentContainerData]
        """
        super(EnvironmentContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class EnvironmentVersionData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentVersionDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'EnvironmentVersionDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.EnvironmentVersionDetails
        """
        super(EnvironmentVersionData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class EnvironmentVersionDetails(AssetBase):
    """Environment version details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar build: Configuration settings for Docker build context.
    :vartype build: ~azure.mgmt.machinelearningservices.models.BuildContext
    :ivar conda_file: Standard configuration file used by Conda that lets you install any kind of
     package, including Python, R, and C/C++ packages.
    
    
     .. raw:: html
    
        <see
     href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment"
     />.
    :vartype conda_file: str
    :ivar environment_type: Environment type is either user managed or curated by the Azure ML
     service
    
    
     .. raw:: html
    
        <see
     href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments"
     />. Possible values include: "Curated", "UserCreated".
    :vartype environment_type: str or ~azure.mgmt.machinelearningservices.models.EnvironmentType
    :ivar image: Name of the image that will be used for the environment.
    
    
     .. raw:: html
    
        <seealso
     href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image"
     />.
    :vartype image: str
    :ivar inference_config: Defines configuration specific to inference.
    :vartype inference_config:
     ~azure.mgmt.machinelearningservices.models.InferenceContainerProperties
    :ivar os_type: The OS type of the environment. Possible values include: "Linux", "Windows".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.OperatingSystemType
    """

    _validation = {
        'environment_type': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'build': {'key': 'build', 'type': 'BuildContext'},
        'conda_file': {'key': 'condaFile', 'type': 'str'},
        'environment_type': {'key': 'environmentType', 'type': 'str'},
        'image': {'key': 'image', 'type': 'str'},
        'inference_config': {'key': 'inferenceConfig', 'type': 'InferenceContainerProperties'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword build: Configuration settings for Docker build context.
        :paramtype build: ~azure.mgmt.machinelearningservices.models.BuildContext
        :keyword conda_file: Standard configuration file used by Conda that lets you install any kind
         of package, including Python, R, and C/C++ packages.
        
        
         .. raw:: html
        
            <see
         href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment"
         />.
        :paramtype conda_file: str
        :keyword image: Name of the image that will be used for the environment.
        
        
         .. raw:: html
        
            <seealso
         href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image"
         />.
        :paramtype image: str
        :keyword inference_config: Defines configuration specific to inference.
        :paramtype inference_config:
         ~azure.mgmt.machinelearningservices.models.InferenceContainerProperties
        :keyword os_type: The OS type of the environment. Possible values include: "Linux", "Windows".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.OperatingSystemType
        """
        super(EnvironmentVersionDetails, self).__init__(**kwargs)
        self.build = kwargs.get('build', None)
        self.conda_file = kwargs.get('conda_file', None)
        self.environment_type = None
        self.image = kwargs.get('image', None)
        self.inference_config = kwargs.get('inference_config', None)
        self.os_type = kwargs.get('os_type', None)


class EnvironmentVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of EnvironmentVersion entities.

    :ivar next_link: The link to the next page of EnvironmentVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type EnvironmentVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentVersionData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[EnvironmentVersionData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of EnvironmentVersion objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type EnvironmentVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.EnvironmentVersionData]
        """
        super(EnvironmentVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.machinelearningservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.machinelearningservices.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class FeaturizationSettings(msrest.serialization.Model):
    """Featurization Configuration.

    :ivar dataset_language: Dataset language, useful for the text data.
    :vartype dataset_language: str
    """

    _attribute_map = {
        'dataset_language': {'key': 'datasetLanguage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword dataset_language: Dataset language, useful for the text data.
        :paramtype dataset_language: str
        """
        super(FeaturizationSettings, self).__init__(**kwargs)
        self.dataset_language = kwargs.get('dataset_language', None)


class FlavorData(msrest.serialization.Model):
    """FlavorData.

    :ivar data: Model flavor-specific data.
    :vartype data: dict[str, str]
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data: Model flavor-specific data.
        :paramtype data: dict[str, str]
        """
        super(FlavorData, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)


class Forecasting(AutoMLVertical, TableVertical):
    """Forecasting task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Data inputs for AutoMLJob.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalDataSettings
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings: ~azure.mgmt.machinelearningservices.models.TrainingSettings
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar allowed_models: Allowed models for forecasting task.
    :vartype allowed_models: list[str or
     ~azure.mgmt.machinelearningservices.models.ForecastingModels]
    :ivar blocked_models: Blocked models for forecasting task.
    :vartype blocked_models: list[str or
     ~azure.mgmt.machinelearningservices.models.ForecastingModels]
    :ivar forecasting_settings: Forecasting task specific inputs.
    :vartype forecasting_settings: ~azure.mgmt.machinelearningservices.models.ForecastingSettings
    :ivar primary_metric: Primary metric for forecasting task. Possible values include:
     "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score",
     "NormalizedMeanAbsoluteError".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ForecastingPrimaryMetrics
    """

    _validation = {
        'task_type': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'TableVerticalDataSettings'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'training_settings': {'key': 'trainingSettings', 'type': 'TrainingSettings'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'allowed_models': {'key': 'allowedModels', 'type': '[str]'},
        'blocked_models': {'key': 'blockedModels', 'type': '[str]'},
        'forecasting_settings': {'key': 'forecastingSettings', 'type': 'ForecastingSettings'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Data inputs for AutoMLJob.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalDataSettings
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings: ~azure.mgmt.machinelearningservices.models.TrainingSettings
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword allowed_models: Allowed models for forecasting task.
        :paramtype allowed_models: list[str or
         ~azure.mgmt.machinelearningservices.models.ForecastingModels]
        :keyword blocked_models: Blocked models for forecasting task.
        :paramtype blocked_models: list[str or
         ~azure.mgmt.machinelearningservices.models.ForecastingModels]
        :keyword forecasting_settings: Forecasting task specific inputs.
        :paramtype forecasting_settings: ~azure.mgmt.machinelearningservices.models.ForecastingSettings
        :keyword primary_metric: Primary metric for forecasting task. Possible values include:
         "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score",
         "NormalizedMeanAbsoluteError".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ForecastingPrimaryMetrics
        """
        super(Forecasting, self).__init__(**kwargs)
        self.data_settings = kwargs.get('data_settings', None)
        self.featurization_settings = kwargs.get('featurization_settings', None)
        self.limit_settings = kwargs.get('limit_settings', None)
        self.training_settings = kwargs.get('training_settings', None)
        self.task_type = 'Forecasting'  # type: str
        self.allowed_models = kwargs.get('allowed_models', None)
        self.blocked_models = kwargs.get('blocked_models', None)
        self.forecasting_settings = kwargs.get('forecasting_settings', None)
        self.primary_metric = kwargs.get('primary_metric', None)
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = 'Forecasting'  # type: str
        self.allowed_models = kwargs.get('allowed_models', None)
        self.blocked_models = kwargs.get('blocked_models', None)
        self.forecasting_settings = kwargs.get('forecasting_settings', None)
        self.primary_metric = kwargs.get('primary_metric', None)


class ForecastingSettings(msrest.serialization.Model):
    """Forecasting specific parameters.

    :ivar country_or_region_for_holidays: Country or region for holidays for forecasting tasks.
     These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
    :vartype country_or_region_for_holidays: str
    :ivar cv_step_size: Number of periods between the origin time of one CV fold and the next fold.
     For
     example, if ``CVStepSize`` = 3 for daily data, the origin time for each fold will be
     three days apart.
    :vartype cv_step_size: int
    :ivar feature_lags: Flag for generating lags for the numeric features with 'auto' or null.
     Possible values include: "None", "Auto".
    :vartype feature_lags: str or ~azure.mgmt.machinelearningservices.models.FeatureLags
    :ivar forecast_horizon: The desired maximum forecast horizon in units of time-series frequency.
    :vartype forecast_horizon: ~azure.mgmt.machinelearningservices.models.ForecastHorizon
    :ivar frequency: When forecasting, this parameter represents the period with which the forecast
     is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency
     by default.
    :vartype frequency: str
    :ivar seasonality: Set time series seasonality as an integer multiple of the series frequency.
     If seasonality is set to 'auto', it will be inferred.
    :vartype seasonality: ~azure.mgmt.machinelearningservices.models.Seasonality
    :ivar short_series_handling_config: The parameter defining how if AutoML should handle short
     time series. Possible values include: "None", "Auto", "Pad", "Drop".
    :vartype short_series_handling_config: str or
     ~azure.mgmt.machinelearningservices.models.ShortSeriesHandlingConfiguration
    :ivar target_aggregate_function: The function to be used to aggregate the time series target
     column to conform to a user specified frequency.
     If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the
     error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
     Possible values include: "None", "Sum", "Max", "Min", "Mean".
    :vartype target_aggregate_function: str or
     ~azure.mgmt.machinelearningservices.models.TargetAggregationFunction
    :ivar target_lags: The number of past periods to lag from the target column.
    :vartype target_lags: ~azure.mgmt.machinelearningservices.models.TargetLags
    :ivar target_rolling_window_size: The number of past periods used to create a rolling window
     average of the target column.
    :vartype target_rolling_window_size:
     ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSize
    :ivar time_column_name: The name of the time column. This parameter is required when
     forecasting to specify the datetime column in the input data used for building the time series
     and inferring its frequency.
    :vartype time_column_name: str
    :ivar time_series_id_column_names: The names of columns used to group a timeseries. It can be
     used to create multiple series.
     If grain is not defined, the data set is assumed to be one time-series. This parameter is used
     with task type forecasting.
    :vartype time_series_id_column_names: list[str]
    :ivar use_stl: Configure STL Decomposition of the time-series target column. Possible values
     include: "None", "Season", "SeasonTrend".
    :vartype use_stl: str or ~azure.mgmt.machinelearningservices.models.UseStl
    """

    _attribute_map = {
        'country_or_region_for_holidays': {'key': 'countryOrRegionForHolidays', 'type': 'str'},
        'cv_step_size': {'key': 'cvStepSize', 'type': 'int'},
        'feature_lags': {'key': 'featureLags', 'type': 'str'},
        'forecast_horizon': {'key': 'forecastHorizon', 'type': 'ForecastHorizon'},
        'frequency': {'key': 'frequency', 'type': 'str'},
        'seasonality': {'key': 'seasonality', 'type': 'Seasonality'},
        'short_series_handling_config': {'key': 'shortSeriesHandlingConfig', 'type': 'str'},
        'target_aggregate_function': {'key': 'targetAggregateFunction', 'type': 'str'},
        'target_lags': {'key': 'targetLags', 'type': 'TargetLags'},
        'target_rolling_window_size': {'key': 'targetRollingWindowSize', 'type': 'TargetRollingWindowSize'},
        'time_column_name': {'key': 'timeColumnName', 'type': 'str'},
        'time_series_id_column_names': {'key': 'timeSeriesIdColumnNames', 'type': '[str]'},
        'use_stl': {'key': 'useStl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword country_or_region_for_holidays: Country or region for holidays for forecasting tasks.
         These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
        :paramtype country_or_region_for_holidays: str
        :keyword cv_step_size: Number of periods between the origin time of one CV fold and the next
         fold. For
         example, if ``CVStepSize`` = 3 for daily data, the origin time for each fold will be
         three days apart.
        :paramtype cv_step_size: int
        :keyword feature_lags: Flag for generating lags for the numeric features with 'auto' or null.
         Possible values include: "None", "Auto".
        :paramtype feature_lags: str or ~azure.mgmt.machinelearningservices.models.FeatureLags
        :keyword forecast_horizon: The desired maximum forecast horizon in units of time-series
         frequency.
        :paramtype forecast_horizon: ~azure.mgmt.machinelearningservices.models.ForecastHorizon
        :keyword frequency: When forecasting, this parameter represents the period with which the
         forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset
         frequency by default.
        :paramtype frequency: str
        :keyword seasonality: Set time series seasonality as an integer multiple of the series
         frequency.
         If seasonality is set to 'auto', it will be inferred.
        :paramtype seasonality: ~azure.mgmt.machinelearningservices.models.Seasonality
        :keyword short_series_handling_config: The parameter defining how if AutoML should handle short
         time series. Possible values include: "None", "Auto", "Pad", "Drop".
        :paramtype short_series_handling_config: str or
         ~azure.mgmt.machinelearningservices.models.ShortSeriesHandlingConfiguration
        :keyword target_aggregate_function: The function to be used to aggregate the time series target
         column to conform to a user specified frequency.
         If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the
         error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
         Possible values include: "None", "Sum", "Max", "Min", "Mean".
        :paramtype target_aggregate_function: str or
         ~azure.mgmt.machinelearningservices.models.TargetAggregationFunction
        :keyword target_lags: The number of past periods to lag from the target column.
        :paramtype target_lags: ~azure.mgmt.machinelearningservices.models.TargetLags
        :keyword target_rolling_window_size: The number of past periods used to create a rolling window
         average of the target column.
        :paramtype target_rolling_window_size:
         ~azure.mgmt.machinelearningservices.models.TargetRollingWindowSize
        :keyword time_column_name: The name of the time column. This parameter is required when
         forecasting to specify the datetime column in the input data used for building the time series
         and inferring its frequency.
        :paramtype time_column_name: str
        :keyword time_series_id_column_names: The names of columns used to group a timeseries. It can
         be used to create multiple series.
         If grain is not defined, the data set is assumed to be one time-series. This parameter is used
         with task type forecasting.
        :paramtype time_series_id_column_names: list[str]
        :keyword use_stl: Configure STL Decomposition of the time-series target column. Possible values
         include: "None", "Season", "SeasonTrend".
        :paramtype use_stl: str or ~azure.mgmt.machinelearningservices.models.UseStl
        """
        super(ForecastingSettings, self).__init__(**kwargs)
        self.country_or_region_for_holidays = kwargs.get('country_or_region_for_holidays', None)
        self.cv_step_size = kwargs.get('cv_step_size', None)
        self.feature_lags = kwargs.get('feature_lags', None)
        self.forecast_horizon = kwargs.get('forecast_horizon', None)
        self.frequency = kwargs.get('frequency', None)
        self.seasonality = kwargs.get('seasonality', None)
        self.short_series_handling_config = kwargs.get('short_series_handling_config', None)
        self.target_aggregate_function = kwargs.get('target_aggregate_function', None)
        self.target_lags = kwargs.get('target_lags', None)
        self.target_rolling_window_size = kwargs.get('target_rolling_window_size', None)
        self.time_column_name = kwargs.get('time_column_name', None)
        self.time_series_id_column_names = kwargs.get('time_series_id_column_names', None)
        self.use_stl = kwargs.get('use_stl', None)


class GridSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that exhaustively generates every value combination in the space.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GridSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Grid'  # type: str


class HdfsDatastore(DatastoreDetails):
    """HdfsDatastore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar credentials: Required. [Required] Account credentials.
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
    :ivar datastore_type: Required. [Required] Storage type backing the datastore.Constant filled
     by server. Possible values include: "AzureBlob", "AzureDataLakeGen1", "AzureDataLakeGen2",
     "AzureFile", "Hdfs".
    :vartype datastore_type: str or ~azure.mgmt.machinelearningservices.models.DatastoreType
    :ivar is_default: Readonly property to indicate if datastore is the workspace default
     datastore.
    :vartype is_default: bool
    :ivar hdfs_server_certificate: The TLS cert of the HDFS server. Needs to be a base64 encoded
     string. Required if "Https" protocol is selected.
    :vartype hdfs_server_certificate: str
    :ivar name_node_address: Required. [Required] IP Address or DNS HostName.
    :vartype name_node_address: str
    :ivar protocol: Protocol used to communicate with the storage account (Https/Http).
    :vartype protocol: str
    """

    _validation = {
        'credentials': {'required': True},
        'datastore_type': {'required': True},
        'is_default': {'readonly': True},
        'name_node_address': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'credentials': {'key': 'credentials', 'type': 'DatastoreCredentials'},
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'hdfs_server_certificate': {'key': 'hdfsServerCertificate', 'type': 'str'},
        'name_node_address': {'key': 'nameNodeAddress', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword credentials: Required. [Required] Account credentials.
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.DatastoreCredentials
        :keyword hdfs_server_certificate: The TLS cert of the HDFS server. Needs to be a base64 encoded
         string. Required if "Https" protocol is selected.
        :paramtype hdfs_server_certificate: str
        :keyword name_node_address: Required. [Required] IP Address or DNS HostName.
        :paramtype name_node_address: str
        :keyword protocol: Protocol used to communicate with the storage account (Https/Http).
        :paramtype protocol: str
        """
        super(HdfsDatastore, self).__init__(**kwargs)
        self.datastore_type = 'Hdfs'  # type: str
        self.hdfs_server_certificate = kwargs.get('hdfs_server_certificate', None)
        self.name_node_address = kwargs['name_node_address']
        self.protocol = kwargs.get('protocol', "http")


class IdAssetReference(AssetReferenceBase):
    """Reference to an asset via its ARM resource ID.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar asset_id: Required. [Required] ARM resource ID of the asset.
    :vartype asset_id: str
    """

    _validation = {
        'reference_type': {'required': True},
        'asset_id': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword asset_id: Required. [Required] ARM resource ID of the asset.
        :paramtype asset_id: str
        """
        super(IdAssetReference, self).__init__(**kwargs)
        self.reference_type = 'Id'  # type: str
        self.asset_id = kwargs['asset_id']


class ImageVertical(msrest.serialization.Model):
    """Abstract class for AutoML tasks that train image (computer vision) models -
such as Image Classification / Image Classification Multilabel / Image Object Detection / Image Instance Segmentation.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
     other data settings required for training and validating models.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    """

    _validation = {
        'data_settings': {'required': True},
        'limit_settings': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'ImageVerticalDataSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
         other data settings required for training and validating models.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        """
        super(ImageVertical, self).__init__(**kwargs)
        self.data_settings = kwargs['data_settings']
        self.limit_settings = kwargs['limit_settings']
        self.sweep_settings = kwargs.get('sweep_settings', None)


class ImageClassificationBase(ImageVertical):
    """ImageClassificationBase.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
     other data settings required for training and validating models.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    """

    _validation = {
        'data_settings': {'required': True},
        'limit_settings': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'ImageVerticalDataSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsClassification'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsClassification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
         other data settings required for training and validating models.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        """
        super(ImageClassificationBase, self).__init__(**kwargs)
        self.model_settings = kwargs.get('model_settings', None)
        self.search_space = kwargs.get('search_space', None)


class ImageClassification(AutoMLVertical, ImageClassificationBase):
    """Image Classification. Multi-class image classification is used when an image is classified with only a single label
from a set of classes - e.g. each image is classified as either an image of a 'cat' or a 'dog' or a 'duck'.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
     other data settings required for training and validating models.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
     "PrecisionScoreWeighted".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
    """

    _validation = {
        'data_settings': {'required': True},
        'limit_settings': {'required': True},
        'task_type': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'ImageVerticalDataSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsClassification'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsClassification]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
         other data settings required for training and validating models.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
         "PrecisionScoreWeighted".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
        """
        super(ImageClassification, self).__init__(**kwargs)
        self.data_settings = kwargs['data_settings']
        self.limit_settings = kwargs['limit_settings']
        self.sweep_settings = kwargs.get('sweep_settings', None)
        self.model_settings = kwargs.get('model_settings', None)
        self.search_space = kwargs.get('search_space', None)
        self.task_type = 'ImageClassification'  # type: str
        self.primary_metric = kwargs.get('primary_metric', None)
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = 'ImageClassification'  # type: str
        self.primary_metric = kwargs.get('primary_metric', None)


class ImageClassificationMultilabel(AutoMLVertical, ImageClassificationBase):
    """Image Classification Multilabel. Multi-label image classification is used when an image could have one or more labels
from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
     other data settings required for training and validating models.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
     "PrecisionScoreWeighted", "IOU".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationMultilabelPrimaryMetrics
    """

    _validation = {
        'data_settings': {'required': True},
        'limit_settings': {'required': True},
        'task_type': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'ImageVerticalDataSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsClassification'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsClassification]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
         other data settings required for training and validating models.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsClassification
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsClassification]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
         "PrecisionScoreWeighted", "IOU".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationMultilabelPrimaryMetrics
        """
        super(ImageClassificationMultilabel, self).__init__(**kwargs)
        self.data_settings = kwargs['data_settings']
        self.limit_settings = kwargs['limit_settings']
        self.sweep_settings = kwargs.get('sweep_settings', None)
        self.model_settings = kwargs.get('model_settings', None)
        self.search_space = kwargs.get('search_space', None)
        self.task_type = 'ImageClassificationMultilabel'  # type: str
        self.primary_metric = kwargs.get('primary_metric', None)
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = 'ImageClassificationMultilabel'  # type: str
        self.primary_metric = kwargs.get('primary_metric', None)


class ImageObjectDetectionBase(ImageVertical):
    """ImageObjectDetectionBase.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
     other data settings required for training and validating models.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    """

    _validation = {
        'data_settings': {'required': True},
        'limit_settings': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'ImageVerticalDataSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsObjectDetection'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsObjectDetection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
         other data settings required for training and validating models.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        """
        super(ImageObjectDetectionBase, self).__init__(**kwargs)
        self.model_settings = kwargs.get('model_settings', None)
        self.search_space = kwargs.get('search_space', None)


class ImageInstanceSegmentation(AutoMLVertical, ImageObjectDetectionBase):
    """Image Instance Segmentation. Instance segmentation is used to identify objects in an image at the pixel level,
drawing a polygon around each object in the image.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
     other data settings required for training and validating models.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "MeanAveragePrecision".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.InstanceSegmentationPrimaryMetrics
    """

    _validation = {
        'data_settings': {'required': True},
        'limit_settings': {'required': True},
        'task_type': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'ImageVerticalDataSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsObjectDetection'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsObjectDetection]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
         other data settings required for training and validating models.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "MeanAveragePrecision".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.InstanceSegmentationPrimaryMetrics
        """
        super(ImageInstanceSegmentation, self).__init__(**kwargs)
        self.data_settings = kwargs['data_settings']
        self.limit_settings = kwargs['limit_settings']
        self.sweep_settings = kwargs.get('sweep_settings', None)
        self.model_settings = kwargs.get('model_settings', None)
        self.search_space = kwargs.get('search_space', None)
        self.task_type = 'ImageInstanceSegmentation'  # type: str
        self.primary_metric = kwargs.get('primary_metric', None)
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = 'ImageInstanceSegmentation'  # type: str
        self.primary_metric = kwargs.get('primary_metric', None)


class ImageLimitSettings(msrest.serialization.Model):
    """Limit settings for the AutoML job.

    :ivar max_concurrent_trials: Maximum number of concurrent AutoML iterations.
    :vartype max_concurrent_trials: int
    :ivar max_trials: Maximum number of AutoML iterations.
    :vartype max_trials: int
    :ivar timeout: AutoML job timeout.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_concurrent_trials': {'key': 'maxConcurrentTrials', 'type': 'int'},
        'max_trials': {'key': 'maxTrials', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_concurrent_trials: Maximum number of concurrent AutoML iterations.
        :paramtype max_concurrent_trials: int
        :keyword max_trials: Maximum number of AutoML iterations.
        :paramtype max_trials: int
        :keyword timeout: AutoML job timeout.
        :paramtype timeout: ~datetime.timedelta
        """
        super(ImageLimitSettings, self).__init__(**kwargs)
        self.max_concurrent_trials = kwargs.get('max_concurrent_trials', 1)
        self.max_trials = kwargs.get('max_trials', 1)
        self.timeout = kwargs.get('timeout', None)


class ImageModelDistributionSettings(msrest.serialization.Model):
    """Distribution expressions to sweep over values of model settings.

:code:`<example>
Some examples are:
<code>
ModelName = "choice('seresnext', 'resnest50')";
LearningRate = "uniform(0.001, 0.01)";
LayersToFreeze = "choice(0, 2)";
</code></example>`
All distributions can be specified as distribution_name(min, max) or choice(val1, val2, ..., valn)
where distribution name can be: uniform, quniform, loguniform, etc
For more details on how to compose distribution expressions please check the documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar split_ratio: If validation data is not defined, this specifies the split ratio for
     splitting
     train data into random train and validation subsets. Must be a float in the range [0, 1].
    :vartype split_ratio: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    """

    _attribute_map = {
        'ams_gradient': {'key': 'amsGradient', 'type': 'str'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'str'},
        'beta2': {'key': 'beta2', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'str'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'str'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'str'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'str'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'str'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'str'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'str'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'str'},
        'learning_rate': {'key': 'learningRate', 'type': 'str'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'str'},
        'nesterov': {'key': 'nesterov', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'str'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'str'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'str'},
        'split_ratio': {'key': 'splitRatio', 'type': 'str'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'str'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'str'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'str'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'str'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'str'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'str'},
        'weight_decay': {'key': 'weightDecay', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword split_ratio: If validation data is not defined, this specifies the split ratio for
         splitting
         train data into random train and validation subsets. Must be a float in the range [0, 1].
        :paramtype split_ratio: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        """
        super(ImageModelDistributionSettings, self).__init__(**kwargs)
        self.ams_gradient = kwargs.get('ams_gradient', None)
        self.augmentations = kwargs.get('augmentations', None)
        self.beta1 = kwargs.get('beta1', None)
        self.beta2 = kwargs.get('beta2', None)
        self.distributed = kwargs.get('distributed', None)
        self.early_stopping = kwargs.get('early_stopping', None)
        self.early_stopping_delay = kwargs.get('early_stopping_delay', None)
        self.early_stopping_patience = kwargs.get('early_stopping_patience', None)
        self.enable_onnx_normalization = kwargs.get('enable_onnx_normalization', None)
        self.evaluation_frequency = kwargs.get('evaluation_frequency', None)
        self.gradient_accumulation_step = kwargs.get('gradient_accumulation_step', None)
        self.layers_to_freeze = kwargs.get('layers_to_freeze', None)
        self.learning_rate = kwargs.get('learning_rate', None)
        self.learning_rate_scheduler = kwargs.get('learning_rate_scheduler', None)
        self.model_name = kwargs.get('model_name', None)
        self.momentum = kwargs.get('momentum', None)
        self.nesterov = kwargs.get('nesterov', None)
        self.number_of_epochs = kwargs.get('number_of_epochs', None)
        self.number_of_workers = kwargs.get('number_of_workers', None)
        self.optimizer = kwargs.get('optimizer', None)
        self.random_seed = kwargs.get('random_seed', None)
        self.split_ratio = kwargs.get('split_ratio', None)
        self.step_lr_gamma = kwargs.get('step_lr_gamma', None)
        self.step_lr_step_size = kwargs.get('step_lr_step_size', None)
        self.training_batch_size = kwargs.get('training_batch_size', None)
        self.validation_batch_size = kwargs.get('validation_batch_size', None)
        self.warmup_cosine_lr_cycles = kwargs.get('warmup_cosine_lr_cycles', None)
        self.warmup_cosine_lr_warmup_epochs = kwargs.get('warmup_cosine_lr_warmup_epochs', None)
        self.weight_decay = kwargs.get('weight_decay', None)


class ImageModelDistributionSettingsClassification(ImageModelDistributionSettings):
    """Distribution expressions to sweep over values of model settings.

:code:`<example>
Some examples are:
<code>
ModelName = "choice('seresnext', 'resnest50')";
LearningRate = "uniform(0.001, 0.01)";
LayersToFreeze = "choice(0, 2)";
</code></example>`
For more details on how to compose distribution expressions please check the documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar split_ratio: If validation data is not defined, this specifies the split ratio for
     splitting
     train data into random train and validation subsets. Must be a float in the range [0, 1].
    :vartype split_ratio: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    :ivar training_crop_size: Image crop size that is input to the neural network for the training
     dataset. Must be a positive integer.
    :vartype training_crop_size: str
    :ivar validation_crop_size: Image crop size that is input to the neural network for the
     validation dataset. Must be a positive integer.
    :vartype validation_crop_size: str
    :ivar validation_resize_size: Image size to which to resize before cropping for validation
     dataset. Must be a positive integer.
    :vartype validation_resize_size: str
    :ivar weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
     1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
     0 or 1 or 2.
    :vartype weighted_loss: str
    """

    _attribute_map = {
        'ams_gradient': {'key': 'amsGradient', 'type': 'str'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'str'},
        'beta2': {'key': 'beta2', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'str'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'str'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'str'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'str'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'str'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'str'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'str'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'str'},
        'learning_rate': {'key': 'learningRate', 'type': 'str'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'str'},
        'nesterov': {'key': 'nesterov', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'str'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'str'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'str'},
        'split_ratio': {'key': 'splitRatio', 'type': 'str'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'str'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'str'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'str'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'str'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'str'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'str'},
        'weight_decay': {'key': 'weightDecay', 'type': 'str'},
        'training_crop_size': {'key': 'trainingCropSize', 'type': 'str'},
        'validation_crop_size': {'key': 'validationCropSize', 'type': 'str'},
        'validation_resize_size': {'key': 'validationResizeSize', 'type': 'str'},
        'weighted_loss': {'key': 'weightedLoss', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword split_ratio: If validation data is not defined, this specifies the split ratio for
         splitting
         train data into random train and validation subsets. Must be a float in the range [0, 1].
        :paramtype split_ratio: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        :keyword training_crop_size: Image crop size that is input to the neural network for the
         training dataset. Must be a positive integer.
        :paramtype training_crop_size: str
        :keyword validation_crop_size: Image crop size that is input to the neural network for the
         validation dataset. Must be a positive integer.
        :paramtype validation_crop_size: str
        :keyword validation_resize_size: Image size to which to resize before cropping for validation
         dataset. Must be a positive integer.
        :paramtype validation_resize_size: str
        :keyword weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
         1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
         0 or 1 or 2.
        :paramtype weighted_loss: str
        """
        super(ImageModelDistributionSettingsClassification, self).__init__(**kwargs)
        self.training_crop_size = kwargs.get('training_crop_size', None)
        self.validation_crop_size = kwargs.get('validation_crop_size', None)
        self.validation_resize_size = kwargs.get('validation_resize_size', None)
        self.weighted_loss = kwargs.get('weighted_loss', None)


class ImageModelDistributionSettingsObjectDetection(ImageModelDistributionSettings):
    """Distribution expressions to sweep over values of model settings.

:code:`<example>
Some examples are:
<code>
ModelName = "choice('seresnext', 'resnest50')";
LearningRate = "uniform(0.001, 0.01)";
LayersToFreeze = "choice(0, 2)";
</code></example>`
For more details on how to compose distribution expressions please check the documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: str
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: str
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: str
    :ivar distributed: Whether to use distributer training.
    :vartype distributed: str
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: str
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: str
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: str
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: str
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: str
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: str
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: str
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: str
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'.
    :vartype learning_rate_scheduler: str
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: str
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: str
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: str
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: str
    :ivar optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
    :vartype optimizer: str
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: str
    :ivar split_ratio: If validation data is not defined, this specifies the split ratio for
     splitting
     train data into random train and validation subsets. Must be a float in the range [0, 1].
    :vartype split_ratio: str
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: str
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: str
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: str
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: str
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: str
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: str
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: str
    :ivar box_detections_per_image: Maximum number of detections per image, for all classes. Must
     be a positive integer.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype box_detections_per_image: str
    :ivar box_score_threshold: During inference, only return proposals with a classification score
     greater than
     BoxScoreThreshold. Must be a float in the range[0, 1].
    :vartype box_score_threshold: str
    :ivar image_size: Image size for train and validation. Must be a positive integer.
     Note: The training run may get into CUDA OOM if the size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype image_size: str
    :ivar max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype max_size: str
    :ivar min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype min_size: str
    :ivar model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     Note: training run may get into CUDA OOM if the model size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype model_size: str
    :ivar multi_scale: Enable multi-scale image by varying image size by +/- 50%.
     Note: training run may get into CUDA OOM if no sufficient GPU memory.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype multi_scale: str
    :ivar nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
     float in the range [0, 1].
    :vartype nms_iou_threshold: str
    :ivar tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not
     be
     None to enable small object detection logic. A string containing two integers in mxn format.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_grid_size: str
    :ivar tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float
     in the range [0, 1).
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_overlap_ratio: str
    :ivar tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
     predictions from tiles and image.
     Used in validation/ inference. Must be float in the range [0, 1].
     Note: This settings is not supported for the 'yolov5' algorithm.
     NMS: Non-maximum suppression.
    :vartype tile_predictions_nms_threshold: str
    :ivar validation_iou_threshold: IOU threshold to use when computing validation metric. Must be
     float in the range [0, 1].
    :vartype validation_iou_threshold: str
    :ivar validation_metric_type: Metric computation method to use for validation metrics. Must be
     'none', 'coco', 'voc', or 'coco_voc'.
    :vartype validation_metric_type: str
    """

    _attribute_map = {
        'ams_gradient': {'key': 'amsGradient', 'type': 'str'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'str'},
        'beta2': {'key': 'beta2', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'str'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'str'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'str'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'str'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'str'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'str'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'str'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'str'},
        'learning_rate': {'key': 'learningRate', 'type': 'str'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'str'},
        'nesterov': {'key': 'nesterov', 'type': 'str'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'str'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'str'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'str'},
        'split_ratio': {'key': 'splitRatio', 'type': 'str'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'str'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'str'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'str'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'str'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'str'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'str'},
        'weight_decay': {'key': 'weightDecay', 'type': 'str'},
        'box_detections_per_image': {'key': 'boxDetectionsPerImage', 'type': 'str'},
        'box_score_threshold': {'key': 'boxScoreThreshold', 'type': 'str'},
        'image_size': {'key': 'imageSize', 'type': 'str'},
        'max_size': {'key': 'maxSize', 'type': 'str'},
        'min_size': {'key': 'minSize', 'type': 'str'},
        'model_size': {'key': 'modelSize', 'type': 'str'},
        'multi_scale': {'key': 'multiScale', 'type': 'str'},
        'nms_iou_threshold': {'key': 'nmsIouThreshold', 'type': 'str'},
        'tile_grid_size': {'key': 'tileGridSize', 'type': 'str'},
        'tile_overlap_ratio': {'key': 'tileOverlapRatio', 'type': 'str'},
        'tile_predictions_nms_threshold': {'key': 'tilePredictionsNmsThreshold', 'type': 'str'},
        'validation_iou_threshold': {'key': 'validationIouThreshold', 'type': 'str'},
        'validation_metric_type': {'key': 'validationMetricType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: str
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: str
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: str
        :keyword distributed: Whether to use distributer training.
        :paramtype distributed: str
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: str
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: str
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: str
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: str
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: str
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: str
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: str
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: str
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'.
        :paramtype learning_rate_scheduler: str
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: str
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: str
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: str
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: str
        :keyword optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :paramtype optimizer: str
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: str
        :keyword split_ratio: If validation data is not defined, this specifies the split ratio for
         splitting
         train data into random train and validation subsets. Must be a float in the range [0, 1].
        :paramtype split_ratio: str
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: str
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: str
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: str
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: str
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: str
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: str
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: str
        :keyword box_detections_per_image: Maximum number of detections per image, for all classes.
         Must be a positive integer.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype box_detections_per_image: str
        :keyword box_score_threshold: During inference, only return proposals with a classification
         score greater than
         BoxScoreThreshold. Must be a float in the range[0, 1].
        :paramtype box_score_threshold: str
        :keyword image_size: Image size for train and validation. Must be a positive integer.
         Note: The training run may get into CUDA OOM if the size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype image_size: str
        :keyword max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype max_size: str
        :keyword min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype min_size: str
        :keyword model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
         Note: training run may get into CUDA OOM if the model size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype model_size: str
        :keyword multi_scale: Enable multi-scale image by varying image size by +/- 50%.
         Note: training run may get into CUDA OOM if no sufficient GPU memory.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype multi_scale: str
        :keyword nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
         float in the range [0, 1].
        :paramtype nms_iou_threshold: str
        :keyword tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must
         not be
         None to enable small object detection logic. A string containing two integers in mxn format.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_grid_size: str
        :keyword tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be
         float in the range [0, 1).
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_overlap_ratio: str
        :keyword tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
         predictions from tiles and image.
         Used in validation/ inference. Must be float in the range [0, 1].
         Note: This settings is not supported for the 'yolov5' algorithm.
         NMS: Non-maximum suppression.
        :paramtype tile_predictions_nms_threshold: str
        :keyword validation_iou_threshold: IOU threshold to use when computing validation metric. Must
         be float in the range [0, 1].
        :paramtype validation_iou_threshold: str
        :keyword validation_metric_type: Metric computation method to use for validation metrics. Must
         be 'none', 'coco', 'voc', or 'coco_voc'.
        :paramtype validation_metric_type: str
        """
        super(ImageModelDistributionSettingsObjectDetection, self).__init__(**kwargs)
        self.box_detections_per_image = kwargs.get('box_detections_per_image', None)
        self.box_score_threshold = kwargs.get('box_score_threshold', None)
        self.image_size = kwargs.get('image_size', None)
        self.max_size = kwargs.get('max_size', None)
        self.min_size = kwargs.get('min_size', None)
        self.model_size = kwargs.get('model_size', None)
        self.multi_scale = kwargs.get('multi_scale', None)
        self.nms_iou_threshold = kwargs.get('nms_iou_threshold', None)
        self.tile_grid_size = kwargs.get('tile_grid_size', None)
        self.tile_overlap_ratio = kwargs.get('tile_overlap_ratio', None)
        self.tile_predictions_nms_threshold = kwargs.get('tile_predictions_nms_threshold', None)
        self.validation_iou_threshold = kwargs.get('validation_iou_threshold', None)
        self.validation_metric_type = kwargs.get('validation_metric_type', None)


class ImageModelSettings(msrest.serialization.Model):
    """Settings used for training the model.
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_dataset_id: FileDataset id for pretrained checkpoint(s) for incremental
     training.
     Make sure to pass CheckpointFilename along with CheckpointDatasetId.
    :vartype checkpoint_dataset_id: str
    :ivar checkpoint_filename: The pretrained checkpoint filename in FileDataset for incremental
     training.
     Make sure to pass CheckpointDatasetId along with CheckpointFilename.
    :vartype checkpoint_filename: str
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Possible values include: "None", "WarmupCosine", "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar split_ratio: If validation data is not defined, this specifies the split ratio for
     splitting
     train data into random train and validation subsets. Must be a float in the range [0, 1].
    :vartype split_ratio: float
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    """

    _attribute_map = {
        'advanced_settings': {'key': 'advancedSettings', 'type': 'str'},
        'ams_gradient': {'key': 'amsGradient', 'type': 'bool'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'float'},
        'beta2': {'key': 'beta2', 'type': 'float'},
        'checkpoint_dataset_id': {'key': 'checkpointDatasetId', 'type': 'str'},
        'checkpoint_filename': {'key': 'checkpointFilename', 'type': 'str'},
        'checkpoint_frequency': {'key': 'checkpointFrequency', 'type': 'int'},
        'checkpoint_run_id': {'key': 'checkpointRunId', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'bool'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'bool'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'int'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'int'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'bool'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'int'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'int'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'int'},
        'learning_rate': {'key': 'learningRate', 'type': 'float'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'float'},
        'nesterov': {'key': 'nesterov', 'type': 'bool'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'int'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'int'},
        'split_ratio': {'key': 'splitRatio', 'type': 'float'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'float'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'int'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'int'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'int'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'float'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'int'},
        'weight_decay': {'key': 'weightDecay', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_dataset_id: FileDataset id for pretrained checkpoint(s) for incremental
         training.
         Make sure to pass CheckpointFilename along with CheckpointDatasetId.
        :paramtype checkpoint_dataset_id: str
        :keyword checkpoint_filename: The pretrained checkpoint filename in FileDataset for incremental
         training.
         Make sure to pass CheckpointDatasetId along with CheckpointFilename.
        :paramtype checkpoint_filename: str
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Possible values include: "None", "WarmupCosine", "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword split_ratio: If validation data is not defined, this specifies the split ratio for
         splitting
         train data into random train and validation subsets. Must be a float in the range [0, 1].
        :paramtype split_ratio: float
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        """
        super(ImageModelSettings, self).__init__(**kwargs)
        self.advanced_settings = kwargs.get('advanced_settings', None)
        self.ams_gradient = kwargs.get('ams_gradient', None)
        self.augmentations = kwargs.get('augmentations', None)
        self.beta1 = kwargs.get('beta1', None)
        self.beta2 = kwargs.get('beta2', None)
        self.checkpoint_dataset_id = kwargs.get('checkpoint_dataset_id', None)
        self.checkpoint_filename = kwargs.get('checkpoint_filename', None)
        self.checkpoint_frequency = kwargs.get('checkpoint_frequency', None)
        self.checkpoint_run_id = kwargs.get('checkpoint_run_id', None)
        self.distributed = kwargs.get('distributed', None)
        self.early_stopping = kwargs.get('early_stopping', None)
        self.early_stopping_delay = kwargs.get('early_stopping_delay', None)
        self.early_stopping_patience = kwargs.get('early_stopping_patience', None)
        self.enable_onnx_normalization = kwargs.get('enable_onnx_normalization', None)
        self.evaluation_frequency = kwargs.get('evaluation_frequency', None)
        self.gradient_accumulation_step = kwargs.get('gradient_accumulation_step', None)
        self.layers_to_freeze = kwargs.get('layers_to_freeze', None)
        self.learning_rate = kwargs.get('learning_rate', None)
        self.learning_rate_scheduler = kwargs.get('learning_rate_scheduler', None)
        self.model_name = kwargs.get('model_name', None)
        self.momentum = kwargs.get('momentum', None)
        self.nesterov = kwargs.get('nesterov', None)
        self.number_of_epochs = kwargs.get('number_of_epochs', None)
        self.number_of_workers = kwargs.get('number_of_workers', None)
        self.optimizer = kwargs.get('optimizer', None)
        self.random_seed = kwargs.get('random_seed', None)
        self.split_ratio = kwargs.get('split_ratio', None)
        self.step_lr_gamma = kwargs.get('step_lr_gamma', None)
        self.step_lr_step_size = kwargs.get('step_lr_step_size', None)
        self.training_batch_size = kwargs.get('training_batch_size', None)
        self.validation_batch_size = kwargs.get('validation_batch_size', None)
        self.warmup_cosine_lr_cycles = kwargs.get('warmup_cosine_lr_cycles', None)
        self.warmup_cosine_lr_warmup_epochs = kwargs.get('warmup_cosine_lr_warmup_epochs', None)
        self.weight_decay = kwargs.get('weight_decay', None)


class ImageModelSettingsClassification(ImageModelSettings):
    """Settings used for training the model.
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_dataset_id: FileDataset id for pretrained checkpoint(s) for incremental
     training.
     Make sure to pass CheckpointFilename along with CheckpointDatasetId.
    :vartype checkpoint_dataset_id: str
    :ivar checkpoint_filename: The pretrained checkpoint filename in FileDataset for incremental
     training.
     Make sure to pass CheckpointDatasetId along with CheckpointFilename.
    :vartype checkpoint_filename: str
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Possible values include: "None", "WarmupCosine", "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar split_ratio: If validation data is not defined, this specifies the split ratio for
     splitting
     train data into random train and validation subsets. Must be a float in the range [0, 1].
    :vartype split_ratio: float
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    :ivar training_crop_size: Image crop size that is input to the neural network for the training
     dataset. Must be a positive integer.
    :vartype training_crop_size: int
    :ivar validation_crop_size: Image crop size that is input to the neural network for the
     validation dataset. Must be a positive integer.
    :vartype validation_crop_size: int
    :ivar validation_resize_size: Image size to which to resize before cropping for validation
     dataset. Must be a positive integer.
    :vartype validation_resize_size: int
    :ivar weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
     1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
     0 or 1 or 2.
    :vartype weighted_loss: int
    """

    _attribute_map = {
        'advanced_settings': {'key': 'advancedSettings', 'type': 'str'},
        'ams_gradient': {'key': 'amsGradient', 'type': 'bool'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'float'},
        'beta2': {'key': 'beta2', 'type': 'float'},
        'checkpoint_dataset_id': {'key': 'checkpointDatasetId', 'type': 'str'},
        'checkpoint_filename': {'key': 'checkpointFilename', 'type': 'str'},
        'checkpoint_frequency': {'key': 'checkpointFrequency', 'type': 'int'},
        'checkpoint_run_id': {'key': 'checkpointRunId', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'bool'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'bool'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'int'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'int'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'bool'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'int'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'int'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'int'},
        'learning_rate': {'key': 'learningRate', 'type': 'float'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'float'},
        'nesterov': {'key': 'nesterov', 'type': 'bool'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'int'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'int'},
        'split_ratio': {'key': 'splitRatio', 'type': 'float'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'float'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'int'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'int'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'int'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'float'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'int'},
        'weight_decay': {'key': 'weightDecay', 'type': 'float'},
        'training_crop_size': {'key': 'trainingCropSize', 'type': 'int'},
        'validation_crop_size': {'key': 'validationCropSize', 'type': 'int'},
        'validation_resize_size': {'key': 'validationResizeSize', 'type': 'int'},
        'weighted_loss': {'key': 'weightedLoss', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_dataset_id: FileDataset id for pretrained checkpoint(s) for incremental
         training.
         Make sure to pass CheckpointFilename along with CheckpointDatasetId.
        :paramtype checkpoint_dataset_id: str
        :keyword checkpoint_filename: The pretrained checkpoint filename in FileDataset for incremental
         training.
         Make sure to pass CheckpointDatasetId along with CheckpointFilename.
        :paramtype checkpoint_filename: str
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Possible values include: "None", "WarmupCosine", "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword split_ratio: If validation data is not defined, this specifies the split ratio for
         splitting
         train data into random train and validation subsets. Must be a float in the range [0, 1].
        :paramtype split_ratio: float
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        :keyword training_crop_size: Image crop size that is input to the neural network for the
         training dataset. Must be a positive integer.
        :paramtype training_crop_size: int
        :keyword validation_crop_size: Image crop size that is input to the neural network for the
         validation dataset. Must be a positive integer.
        :paramtype validation_crop_size: int
        :keyword validation_resize_size: Image size to which to resize before cropping for validation
         dataset. Must be a positive integer.
        :paramtype validation_resize_size: int
        :keyword weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
         1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be
         0 or 1 or 2.
        :paramtype weighted_loss: int
        """
        super(ImageModelSettingsClassification, self).__init__(**kwargs)
        self.training_crop_size = kwargs.get('training_crop_size', None)
        self.validation_crop_size = kwargs.get('validation_crop_size', None)
        self.validation_resize_size = kwargs.get('validation_resize_size', None)
        self.weighted_loss = kwargs.get('weighted_loss', None)


class ImageModelSettingsObjectDetection(ImageModelSettings):
    """Settings used for training the model.
For more information on the available settings please visit the official documentation:
https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.

    :ivar advanced_settings: Settings for advanced scenarios.
    :vartype advanced_settings: str
    :ivar ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
    :vartype ams_gradient: bool
    :ivar augmentations: Settings for using Augmentations.
    :vartype augmentations: str
    :ivar beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta1: float
    :ivar beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range
     [0, 1].
    :vartype beta2: float
    :ivar checkpoint_dataset_id: FileDataset id for pretrained checkpoint(s) for incremental
     training.
     Make sure to pass CheckpointFilename along with CheckpointDatasetId.
    :vartype checkpoint_dataset_id: str
    :ivar checkpoint_filename: The pretrained checkpoint filename in FileDataset for incremental
     training.
     Make sure to pass CheckpointDatasetId along with CheckpointFilename.
    :vartype checkpoint_filename: str
    :ivar checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
    :vartype checkpoint_frequency: int
    :ivar checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
     incremental training.
    :vartype checkpoint_run_id: str
    :ivar distributed: Whether to use distributed training.
    :vartype distributed: bool
    :ivar early_stopping: Enable early stopping logic during training.
    :vartype early_stopping: bool
    :ivar early_stopping_delay: Minimum number of epochs or validation evaluations to wait before
     primary metric improvement
     is tracked for early stopping. Must be a positive integer.
    :vartype early_stopping_delay: int
    :ivar early_stopping_patience: Minimum number of epochs or validation evaluations with no
     primary metric improvement before
     the run is stopped. Must be a positive integer.
    :vartype early_stopping_patience: int
    :ivar enable_onnx_normalization: Enable normalization when exporting ONNX model.
    :vartype enable_onnx_normalization: bool
    :ivar evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must
     be a positive integer.
    :vartype evaluation_frequency: int
    :ivar gradient_accumulation_step: Gradient accumulation means running a configured number of
     "GradAccumulationStep" steps without
     updating the model weights while accumulating the gradients of those steps, and then using
     the accumulated gradients to compute the weight updates. Must be a positive integer.
    :vartype gradient_accumulation_step: int
    :ivar layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
     For instance, passing 2 as value for 'seresnext' means
     freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
     please
     see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype layers_to_freeze: int
    :ivar learning_rate: Initial learning rate. Must be a float in the range [0, 1].
    :vartype learning_rate: float
    :ivar learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
     'step'. Possible values include: "None", "WarmupCosine", "Step".
    :vartype learning_rate_scheduler: str or
     ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
    :ivar model_name: Name of the model to use for training.
     For more information on the available models please visit the official documentation:
     https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
    :vartype model_name: str
    :ivar momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
    :vartype momentum: float
    :ivar nesterov: Enable nesterov when optimizer is 'sgd'.
    :vartype nesterov: bool
    :ivar number_of_epochs: Number of training epochs. Must be a positive integer.
    :vartype number_of_epochs: int
    :ivar number_of_workers: Number of data loader workers. Must be a non-negative integer.
    :vartype number_of_workers: int
    :ivar optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
    :vartype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
    :ivar random_seed: Random seed to be used when using deterministic training.
    :vartype random_seed: int
    :ivar split_ratio: If validation data is not defined, this specifies the split ratio for
     splitting
     train data into random train and validation subsets. Must be a float in the range [0, 1].
    :vartype split_ratio: float
    :ivar step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in
     the range [0, 1].
    :vartype step_lr_gamma: float
    :ivar step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a
     positive integer.
    :vartype step_lr_step_size: int
    :ivar training_batch_size: Training batch size. Must be a positive integer.
    :vartype training_batch_size: int
    :ivar validation_batch_size: Validation batch size. Must be a positive integer.
    :vartype validation_batch_size: int
    :ivar warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
     'warmup_cosine'. Must be a float in the range [0, 1].
    :vartype warmup_cosine_lr_cycles: float
    :ivar warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
     'warmup_cosine'. Must be a positive integer.
    :vartype warmup_cosine_lr_warmup_epochs: int
    :ivar weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be
     a float in the range[0, 1].
    :vartype weight_decay: float
    :ivar box_detections_per_image: Maximum number of detections per image, for all classes. Must
     be a positive integer.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype box_detections_per_image: int
    :ivar box_score_threshold: During inference, only return proposals with a classification score
     greater than
     BoxScoreThreshold. Must be a float in the range[0, 1].
    :vartype box_score_threshold: float
    :ivar image_size: Image size for train and validation. Must be a positive integer.
     Note: The training run may get into CUDA OOM if the size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype image_size: int
    :ivar max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype max_size: int
    :ivar min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
     Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype min_size: int
    :ivar model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
     Note: training run may get into CUDA OOM if the model size is too big.
     Note: This settings is only supported for the 'yolov5' algorithm. Possible values include:
     "None", "Small", "Medium", "Large", "ExtraLarge".
    :vartype model_size: str or ~azure.mgmt.machinelearningservices.models.ModelSize
    :ivar multi_scale: Enable multi-scale image by varying image size by +/- 50%.
     Note: training run may get into CUDA OOM if no sufficient GPU memory.
     Note: This settings is only supported for the 'yolov5' algorithm.
    :vartype multi_scale: bool
    :ivar nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be a
     float in the range [0, 1].
    :vartype nms_iou_threshold: float
    :ivar tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not
     be
     None to enable small object detection logic. A string containing two integers in mxn format.
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_grid_size: str
    :ivar tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float
     in the range [0, 1).
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_overlap_ratio: float
    :ivar tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
     predictions from tiles and image.
     Used in validation/ inference. Must be float in the range [0, 1].
     Note: This settings is not supported for the 'yolov5' algorithm.
    :vartype tile_predictions_nms_threshold: float
    :ivar validation_iou_threshold: IOU threshold to use when computing validation metric. Must be
     float in the range [0, 1].
    :vartype validation_iou_threshold: float
    :ivar validation_metric_type: Metric computation method to use for validation metrics. Possible
     values include: "None", "Coco", "Voc", "CocoVoc".
    :vartype validation_metric_type: str or
     ~azure.mgmt.machinelearningservices.models.ValidationMetricType
    """

    _attribute_map = {
        'advanced_settings': {'key': 'advancedSettings', 'type': 'str'},
        'ams_gradient': {'key': 'amsGradient', 'type': 'bool'},
        'augmentations': {'key': 'augmentations', 'type': 'str'},
        'beta1': {'key': 'beta1', 'type': 'float'},
        'beta2': {'key': 'beta2', 'type': 'float'},
        'checkpoint_dataset_id': {'key': 'checkpointDatasetId', 'type': 'str'},
        'checkpoint_filename': {'key': 'checkpointFilename', 'type': 'str'},
        'checkpoint_frequency': {'key': 'checkpointFrequency', 'type': 'int'},
        'checkpoint_run_id': {'key': 'checkpointRunId', 'type': 'str'},
        'distributed': {'key': 'distributed', 'type': 'bool'},
        'early_stopping': {'key': 'earlyStopping', 'type': 'bool'},
        'early_stopping_delay': {'key': 'earlyStoppingDelay', 'type': 'int'},
        'early_stopping_patience': {'key': 'earlyStoppingPatience', 'type': 'int'},
        'enable_onnx_normalization': {'key': 'enableOnnxNormalization', 'type': 'bool'},
        'evaluation_frequency': {'key': 'evaluationFrequency', 'type': 'int'},
        'gradient_accumulation_step': {'key': 'gradientAccumulationStep', 'type': 'int'},
        'layers_to_freeze': {'key': 'layersToFreeze', 'type': 'int'},
        'learning_rate': {'key': 'learningRate', 'type': 'float'},
        'learning_rate_scheduler': {'key': 'learningRateScheduler', 'type': 'str'},
        'model_name': {'key': 'modelName', 'type': 'str'},
        'momentum': {'key': 'momentum', 'type': 'float'},
        'nesterov': {'key': 'nesterov', 'type': 'bool'},
        'number_of_epochs': {'key': 'numberOfEpochs', 'type': 'int'},
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'optimizer': {'key': 'optimizer', 'type': 'str'},
        'random_seed': {'key': 'randomSeed', 'type': 'int'},
        'split_ratio': {'key': 'splitRatio', 'type': 'float'},
        'step_lr_gamma': {'key': 'stepLRGamma', 'type': 'float'},
        'step_lr_step_size': {'key': 'stepLRStepSize', 'type': 'int'},
        'training_batch_size': {'key': 'trainingBatchSize', 'type': 'int'},
        'validation_batch_size': {'key': 'validationBatchSize', 'type': 'int'},
        'warmup_cosine_lr_cycles': {'key': 'warmupCosineLRCycles', 'type': 'float'},
        'warmup_cosine_lr_warmup_epochs': {'key': 'warmupCosineLRWarmupEpochs', 'type': 'int'},
        'weight_decay': {'key': 'weightDecay', 'type': 'float'},
        'box_detections_per_image': {'key': 'boxDetectionsPerImage', 'type': 'int'},
        'box_score_threshold': {'key': 'boxScoreThreshold', 'type': 'float'},
        'image_size': {'key': 'imageSize', 'type': 'int'},
        'max_size': {'key': 'maxSize', 'type': 'int'},
        'min_size': {'key': 'minSize', 'type': 'int'},
        'model_size': {'key': 'modelSize', 'type': 'str'},
        'multi_scale': {'key': 'multiScale', 'type': 'bool'},
        'nms_iou_threshold': {'key': 'nmsIouThreshold', 'type': 'float'},
        'tile_grid_size': {'key': 'tileGridSize', 'type': 'str'},
        'tile_overlap_ratio': {'key': 'tileOverlapRatio', 'type': 'float'},
        'tile_predictions_nms_threshold': {'key': 'tilePredictionsNmsThreshold', 'type': 'float'},
        'validation_iou_threshold': {'key': 'validationIouThreshold', 'type': 'float'},
        'validation_metric_type': {'key': 'validationMetricType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword advanced_settings: Settings for advanced scenarios.
        :paramtype advanced_settings: str
        :keyword ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :paramtype ams_gradient: bool
        :keyword augmentations: Settings for using Augmentations.
        :paramtype augmentations: str
        :keyword beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta1: float
        :keyword beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the
         range [0, 1].
        :paramtype beta2: float
        :keyword checkpoint_dataset_id: FileDataset id for pretrained checkpoint(s) for incremental
         training.
         Make sure to pass CheckpointFilename along with CheckpointDatasetId.
        :paramtype checkpoint_dataset_id: str
        :keyword checkpoint_filename: The pretrained checkpoint filename in FileDataset for incremental
         training.
         Make sure to pass CheckpointDatasetId along with CheckpointFilename.
        :paramtype checkpoint_filename: str
        :keyword checkpoint_frequency: Frequency to store model checkpoints. Must be a positive
         integer.
        :paramtype checkpoint_frequency: int
        :keyword checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for
         incremental training.
        :paramtype checkpoint_run_id: str
        :keyword distributed: Whether to use distributed training.
        :paramtype distributed: bool
        :keyword early_stopping: Enable early stopping logic during training.
        :paramtype early_stopping: bool
        :keyword early_stopping_delay: Minimum number of epochs or validation evaluations to wait
         before primary metric improvement
         is tracked for early stopping. Must be a positive integer.
        :paramtype early_stopping_delay: int
        :keyword early_stopping_patience: Minimum number of epochs or validation evaluations with no
         primary metric improvement before
         the run is stopped. Must be a positive integer.
        :paramtype early_stopping_patience: int
        :keyword enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :paramtype enable_onnx_normalization: bool
        :keyword evaluation_frequency: Frequency to evaluate validation dataset to get metric scores.
         Must be a positive integer.
        :paramtype evaluation_frequency: int
        :keyword gradient_accumulation_step: Gradient accumulation means running a configured number of
         "GradAccumulationStep" steps without
         updating the model weights while accumulating the gradients of those steps, and then using
         the accumulated gradients to compute the weight updates. Must be a positive integer.
        :paramtype gradient_accumulation_step: int
        :keyword layers_to_freeze: Number of layers to freeze for the model. Must be a positive
         integer.
         For instance, passing 2 as value for 'seresnext' means
         freezing layer0 and layer1. For a full list of models supported and details on layer freeze,
         please
         see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype layers_to_freeze: int
        :keyword learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :paramtype learning_rate: float
        :keyword learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or
         'step'. Possible values include: "None", "WarmupCosine", "Step".
        :paramtype learning_rate_scheduler: str or
         ~azure.mgmt.machinelearningservices.models.LearningRateScheduler
        :keyword model_name: Name of the model to use for training.
         For more information on the available models please visit the official documentation:
         https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :paramtype model_name: str
        :keyword momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0,
         1].
        :paramtype momentum: float
        :keyword nesterov: Enable nesterov when optimizer is 'sgd'.
        :paramtype nesterov: bool
        :keyword number_of_epochs: Number of training epochs. Must be a positive integer.
        :paramtype number_of_epochs: int
        :keyword number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :paramtype number_of_workers: int
        :keyword optimizer: Type of optimizer. Possible values include: "None", "Sgd", "Adam", "Adamw".
        :paramtype optimizer: str or ~azure.mgmt.machinelearningservices.models.StochasticOptimizer
        :keyword random_seed: Random seed to be used when using deterministic training.
        :paramtype random_seed: int
        :keyword split_ratio: If validation data is not defined, this specifies the split ratio for
         splitting
         train data into random train and validation subsets. Must be a float in the range [0, 1].
        :paramtype split_ratio: float
        :keyword step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float
         in the range [0, 1].
        :paramtype step_lr_gamma: float
        :keyword step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be
         a positive integer.
        :paramtype step_lr_step_size: int
        :keyword training_batch_size: Training batch size. Must be a positive integer.
        :paramtype training_batch_size: int
        :keyword validation_batch_size: Validation batch size. Must be a positive integer.
        :paramtype validation_batch_size: int
        :keyword warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is
         'warmup_cosine'. Must be a float in the range [0, 1].
        :paramtype warmup_cosine_lr_cycles: float
        :keyword warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is
         'warmup_cosine'. Must be a positive integer.
        :paramtype warmup_cosine_lr_warmup_epochs: int
        :keyword weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must
         be a float in the range[0, 1].
        :paramtype weight_decay: float
        :keyword box_detections_per_image: Maximum number of detections per image, for all classes.
         Must be a positive integer.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype box_detections_per_image: int
        :keyword box_score_threshold: During inference, only return proposals with a classification
         score greater than
         BoxScoreThreshold. Must be a float in the range[0, 1].
        :paramtype box_score_threshold: float
        :keyword image_size: Image size for train and validation. Must be a positive integer.
         Note: The training run may get into CUDA OOM if the size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype image_size: int
        :keyword max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype max_size: int
        :keyword min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
         Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype min_size: int
        :keyword model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
         Note: training run may get into CUDA OOM if the model size is too big.
         Note: This settings is only supported for the 'yolov5' algorithm. Possible values include:
         "None", "Small", "Medium", "Large", "ExtraLarge".
        :paramtype model_size: str or ~azure.mgmt.machinelearningservices.models.ModelSize
        :keyword multi_scale: Enable multi-scale image by varying image size by +/- 50%.
         Note: training run may get into CUDA OOM if no sufficient GPU memory.
         Note: This settings is only supported for the 'yolov5' algorithm.
        :paramtype multi_scale: bool
        :keyword nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be
         a float in the range [0, 1].
        :paramtype nms_iou_threshold: float
        :keyword tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must
         not be
         None to enable small object detection logic. A string containing two integers in mxn format.
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_grid_size: str
        :keyword tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be
         float in the range [0, 1).
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_overlap_ratio: float
        :keyword tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging
         predictions from tiles and image.
         Used in validation/ inference. Must be float in the range [0, 1].
         Note: This settings is not supported for the 'yolov5' algorithm.
        :paramtype tile_predictions_nms_threshold: float
        :keyword validation_iou_threshold: IOU threshold to use when computing validation metric. Must
         be float in the range [0, 1].
        :paramtype validation_iou_threshold: float
        :keyword validation_metric_type: Metric computation method to use for validation metrics.
         Possible values include: "None", "Coco", "Voc", "CocoVoc".
        :paramtype validation_metric_type: str or
         ~azure.mgmt.machinelearningservices.models.ValidationMetricType
        """
        super(ImageModelSettingsObjectDetection, self).__init__(**kwargs)
        self.box_detections_per_image = kwargs.get('box_detections_per_image', None)
        self.box_score_threshold = kwargs.get('box_score_threshold', None)
        self.image_size = kwargs.get('image_size', None)
        self.max_size = kwargs.get('max_size', None)
        self.min_size = kwargs.get('min_size', None)
        self.model_size = kwargs.get('model_size', None)
        self.multi_scale = kwargs.get('multi_scale', None)
        self.nms_iou_threshold = kwargs.get('nms_iou_threshold', None)
        self.tile_grid_size = kwargs.get('tile_grid_size', None)
        self.tile_overlap_ratio = kwargs.get('tile_overlap_ratio', None)
        self.tile_predictions_nms_threshold = kwargs.get('tile_predictions_nms_threshold', None)
        self.validation_iou_threshold = kwargs.get('validation_iou_threshold', None)
        self.validation_metric_type = kwargs.get('validation_metric_type', None)


class ImageObjectDetection(AutoMLVertical, ImageObjectDetectionBase):
    """Image Object Detection. Object detection is used to identify objects in an image and locate each object with a
bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
     other data settings required for training and validating models.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
    :ivar limit_settings: Required. [Required] Limit settings for the AutoML job.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
    :ivar sweep_settings: Model sweeping and hyperparameter sweeping related settings.
    :vartype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
    :ivar model_settings: Settings used for training the model.
    :vartype model_settings:
     ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
    :ivar search_space: Search space for sampling different combinations of models and their
     hyperparameters.
    :vartype search_space:
     list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar primary_metric: Primary metric to optimize for this task. Possible values include:
     "MeanAveragePrecision".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ObjectDetectionPrimaryMetrics
    """

    _validation = {
        'data_settings': {'required': True},
        'limit_settings': {'required': True},
        'task_type': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'ImageVerticalDataSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'ImageLimitSettings'},
        'sweep_settings': {'key': 'sweepSettings', 'type': 'ImageSweepSettings'},
        'model_settings': {'key': 'modelSettings', 'type': 'ImageModelSettingsObjectDetection'},
        'search_space': {'key': 'searchSpace', 'type': '[ImageModelDistributionSettingsObjectDetection]'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Required. [Required] Collection of registered Tabular Dataset Ids and
         other data settings required for training and validating models.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.ImageVerticalDataSettings
        :keyword limit_settings: Required. [Required] Limit settings for the AutoML job.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.ImageLimitSettings
        :keyword sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :paramtype sweep_settings: ~azure.mgmt.machinelearningservices.models.ImageSweepSettings
        :keyword model_settings: Settings used for training the model.
        :paramtype model_settings:
         ~azure.mgmt.machinelearningservices.models.ImageModelSettingsObjectDetection
        :keyword search_space: Search space for sampling different combinations of models and their
         hyperparameters.
        :paramtype search_space:
         list[~azure.mgmt.machinelearningservices.models.ImageModelDistributionSettingsObjectDetection]
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword primary_metric: Primary metric to optimize for this task. Possible values include:
         "MeanAveragePrecision".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ObjectDetectionPrimaryMetrics
        """
        super(ImageObjectDetection, self).__init__(**kwargs)
        self.data_settings = kwargs['data_settings']
        self.limit_settings = kwargs['limit_settings']
        self.sweep_settings = kwargs.get('sweep_settings', None)
        self.model_settings = kwargs.get('model_settings', None)
        self.search_space = kwargs.get('search_space', None)
        self.task_type = 'ImageObjectDetection'  # type: str
        self.primary_metric = kwargs.get('primary_metric', None)
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = 'ImageObjectDetection'  # type: str
        self.primary_metric = kwargs.get('primary_metric', None)


class ImageSweepLimitSettings(msrest.serialization.Model):
    """Limit settings for model sweeping and hyperparameter sweeping.

    :ivar max_concurrent_trials: Maximum number of concurrent iterations for the underlying Sweep
     job.
    :vartype max_concurrent_trials: int
    :ivar max_trials: Maximum number of iterations for the underlying Sweep job.
    :vartype max_trials: int
    """

    _attribute_map = {
        'max_concurrent_trials': {'key': 'maxConcurrentTrials', 'type': 'int'},
        'max_trials': {'key': 'maxTrials', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_concurrent_trials: Maximum number of concurrent iterations for the underlying
         Sweep job.
        :paramtype max_concurrent_trials: int
        :keyword max_trials: Maximum number of iterations for the underlying Sweep job.
        :paramtype max_trials: int
        """
        super(ImageSweepLimitSettings, self).__init__(**kwargs)
        self.max_concurrent_trials = kwargs.get('max_concurrent_trials', None)
        self.max_trials = kwargs.get('max_trials', None)


class ImageSweepSettings(msrest.serialization.Model):
    """Model sweeping and hyperparameter sweeping related settings.

    All required parameters must be populated in order to send to Azure.

    :ivar early_termination: Type of early termination policy.
    :vartype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
    :ivar limits: Required. [Required] Limit settings for model sweeping and hyperparameter
     sweeping.
    :vartype limits: ~azure.mgmt.machinelearningservices.models.ImageSweepLimitSettings
    :ivar sampling_algorithm: Required. [Required] Type of the hyperparameter sampling algorithms.
     Possible values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    """

    _validation = {
        'limits': {'required': True},
        'sampling_algorithm': {'required': True},
    }

    _attribute_map = {
        'early_termination': {'key': 'earlyTermination', 'type': 'EarlyTerminationPolicy'},
        'limits': {'key': 'limits', 'type': 'ImageSweepLimitSettings'},
        'sampling_algorithm': {'key': 'samplingAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword early_termination: Type of early termination policy.
        :paramtype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
        :keyword limits: Required. [Required] Limit settings for model sweeping and hyperparameter
         sweeping.
        :paramtype limits: ~azure.mgmt.machinelearningservices.models.ImageSweepLimitSettings
        :keyword sampling_algorithm: Required. [Required] Type of the hyperparameter sampling
         algorithms. Possible values include: "Grid", "Random", "Bayesian".
        :paramtype sampling_algorithm: str or
         ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
        """
        super(ImageSweepSettings, self).__init__(**kwargs)
        self.early_termination = kwargs.get('early_termination', None)
        self.limits = kwargs['limits']
        self.sampling_algorithm = kwargs['sampling_algorithm']


class ImageVerticalDataSettings(DataSettings):
    """Collection of registered Tabular Dataset Ids and other data settings required for training and validating models.

    All required parameters must be populated in order to send to Azure.

    :ivar target_column_name: Required. [Required] Target column name: This is prediction values
     column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.TestDataSettings
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.TrainingDataSettings
    :ivar validation_data: Settings for the validation dataset.
    :vartype validation_data:
     ~azure.mgmt.machinelearningservices.models.ImageVerticalValidationDataSettings
    """

    _validation = {
        'target_column_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'test_data': {'key': 'testData', 'type': 'TestDataSettings'},
        'training_data': {'key': 'trainingData', 'type': 'TrainingDataSettings'},
        'validation_data': {'key': 'validationData', 'type': 'ImageVerticalValidationDataSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword target_column_name: Required. [Required] Target column name: This is prediction values
         column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.TestDataSettings
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.TrainingDataSettings
        :keyword validation_data: Settings for the validation dataset.
        :paramtype validation_data:
         ~azure.mgmt.machinelearningservices.models.ImageVerticalValidationDataSettings
        """
        super(ImageVerticalDataSettings, self).__init__(**kwargs)
        self.validation_data = kwargs.get('validation_data', None)


class ValidationDataSettings(msrest.serialization.Model):
    """Validation settings.

    :ivar data: Validation data MLTable.
    :vartype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data: Validation data MLTable.
        :paramtype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        """
        super(ValidationDataSettings, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.validation_data_size = kwargs.get('validation_data_size', None)


class ImageVerticalValidationDataSettings(ValidationDataSettings):
    """ImageVerticalValidationDataSettings.

    :ivar data: Validation data MLTable.
    :vartype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data: Validation data MLTable.
        :paramtype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        """
        super(ImageVerticalValidationDataSettings, self).__init__(**kwargs)


class InferenceContainerProperties(msrest.serialization.Model):
    """InferenceContainerProperties.

    :ivar liveness_route: The route to check the liveness of the inference server container.
    :vartype liveness_route: ~azure.mgmt.machinelearningservices.models.Route
    :ivar readiness_route: The route to check the readiness of the inference server container.
    :vartype readiness_route: ~azure.mgmt.machinelearningservices.models.Route
    :ivar scoring_route: The port to send the scoring requests to, within the inference server
     container.
    :vartype scoring_route: ~azure.mgmt.machinelearningservices.models.Route
    """

    _attribute_map = {
        'liveness_route': {'key': 'livenessRoute', 'type': 'Route'},
        'readiness_route': {'key': 'readinessRoute', 'type': 'Route'},
        'scoring_route': {'key': 'scoringRoute', 'type': 'Route'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword liveness_route: The route to check the liveness of the inference server container.
        :paramtype liveness_route: ~azure.mgmt.machinelearningservices.models.Route
        :keyword readiness_route: The route to check the readiness of the inference server container.
        :paramtype readiness_route: ~azure.mgmt.machinelearningservices.models.Route
        :keyword scoring_route: The port to send the scoring requests to, within the inference server
         container.
        :paramtype scoring_route: ~azure.mgmt.machinelearningservices.models.Route
        """
        super(InferenceContainerProperties, self).__init__(**kwargs)
        self.liveness_route = kwargs.get('liveness_route', None)
        self.readiness_route = kwargs.get('readiness_route', None)
        self.scoring_route = kwargs.get('scoring_route', None)


class JobBaseData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.JobBaseDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'JobBaseDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.JobBaseDetails
        """
        super(JobBaseData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class JobBaseResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of JobBase entities.

    :ivar next_link: The link to the next page of JobBase objects. If null, there are no additional
     pages.
    :vartype next_link: str
    :ivar value: An array of objects of type JobBase.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.JobBaseData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[JobBaseData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of JobBase objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type JobBase.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.JobBaseData]
        """
        super(JobBaseResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class JobService(msrest.serialization.Model):
    """Job endpoint definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: Url for endpoint.
    :vartype endpoint: str
    :ivar error_message: Any error in the service.
    :vartype error_message: str
    :ivar job_service_type: Endpoint type.
    :vartype job_service_type: str
    :ivar port: Port for endpoint.
    :vartype port: int
    :ivar properties: Additional properties to set on the endpoint.
    :vartype properties: dict[str, str]
    :ivar status: Status of endpoint.
    :vartype status: str
    """

    _validation = {
        'error_message': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'job_service_type': {'key': 'jobServiceType', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword endpoint: Url for endpoint.
        :paramtype endpoint: str
        :keyword job_service_type: Endpoint type.
        :paramtype job_service_type: str
        :keyword port: Port for endpoint.
        :paramtype port: int
        :keyword properties: Additional properties to set on the endpoint.
        :paramtype properties: dict[str, str]
        """
        super(JobService, self).__init__(**kwargs)
        self.endpoint = kwargs.get('endpoint', None)
        self.error_message = None
        self.job_service_type = kwargs.get('job_service_type', None)
        self.port = kwargs.get('port', None)
        self.properties = kwargs.get('properties', None)
        self.status = None


class KerberosCredentials(msrest.serialization.Model):
    """KerberosCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
    :vartype kerberos_kdc_address: str
    :ivar kerberos_principal: Required. [Required] Kerberos Username.
    :vartype kerberos_principal: str
    :ivar kerberos_realm: Required. [Required] Domain over which a Kerberos authentication server
     has the authority to authenticate a user, host or service.
    :vartype kerberos_realm: str
    """

    _validation = {
        'kerberos_kdc_address': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_principal': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_realm': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'kerberos_kdc_address': {'key': 'kerberosKdcAddress', 'type': 'str'},
        'kerberos_principal': {'key': 'kerberosPrincipal', 'type': 'str'},
        'kerberos_realm': {'key': 'kerberosRealm', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
        :paramtype kerberos_kdc_address: str
        :keyword kerberos_principal: Required. [Required] Kerberos Username.
        :paramtype kerberos_principal: str
        :keyword kerberos_realm: Required. [Required] Domain over which a Kerberos authentication
         server has the authority to authenticate a user, host or service.
        :paramtype kerberos_realm: str
        """
        super(KerberosCredentials, self).__init__(**kwargs)
        self.kerberos_kdc_address = kwargs['kerberos_kdc_address']
        self.kerberos_principal = kwargs['kerberos_principal']
        self.kerberos_realm = kwargs['kerberos_realm']


class KerberosKeytabCredentials(DatastoreCredentials, KerberosCredentials):
    """KerberosKeytabCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
    :vartype kerberos_kdc_address: str
    :ivar kerberos_principal: Required. [Required] Kerberos Username.
    :vartype kerberos_principal: str
    :ivar kerberos_realm: Required. [Required] Domain over which a Kerberos authentication server
     has the authority to authenticate a user, host or service.
    :vartype kerberos_realm: str
    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Keytab secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.KerberosKeytabSecrets
    """

    _validation = {
        'kerberos_kdc_address': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_principal': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_realm': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'kerberos_kdc_address': {'key': 'kerberosKdcAddress', 'type': 'str'},
        'kerberos_principal': {'key': 'kerberosPrincipal', 'type': 'str'},
        'kerberos_realm': {'key': 'kerberosRealm', 'type': 'str'},
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'KerberosKeytabSecrets'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
        :paramtype kerberos_kdc_address: str
        :keyword kerberos_principal: Required. [Required] Kerberos Username.
        :paramtype kerberos_principal: str
        :keyword kerberos_realm: Required. [Required] Domain over which a Kerberos authentication
         server has the authority to authenticate a user, host or service.
        :paramtype kerberos_realm: str
        :keyword secrets: Required. [Required] Keytab secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.KerberosKeytabSecrets
        """
        super(KerberosKeytabCredentials, self).__init__(**kwargs)
        self.kerberos_kdc_address = kwargs['kerberos_kdc_address']
        self.kerberos_principal = kwargs['kerberos_principal']
        self.kerberos_realm = kwargs['kerberos_realm']
        self.credentials_type = 'KerberosKeytab'  # type: str
        self.secrets = kwargs['secrets']
        self.credentials_type = 'KerberosKeytab'  # type: str
        self.secrets = kwargs['secrets']


class KerberosKeytabSecrets(DatastoreSecrets):
    """KerberosKeytabSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar kerberos_keytab: Kerberos keytab secret.
    :vartype kerberos_keytab: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'kerberos_keytab': {'key': 'kerberosKeytab', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword kerberos_keytab: Kerberos keytab secret.
        :paramtype kerberos_keytab: str
        """
        super(KerberosKeytabSecrets, self).__init__(**kwargs)
        self.secrets_type = 'KerberosKeytab'  # type: str
        self.kerberos_keytab = kwargs.get('kerberos_keytab', None)


class KerberosPasswordCredentials(DatastoreCredentials, KerberosCredentials):
    """KerberosPasswordCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
    :vartype kerberos_kdc_address: str
    :ivar kerberos_principal: Required. [Required] Kerberos Username.
    :vartype kerberos_principal: str
    :ivar kerberos_realm: Required. [Required] Domain over which a Kerberos authentication server
     has the authority to authenticate a user, host or service.
    :vartype kerberos_realm: str
    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Kerberos password secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.KerberosPasswordSecrets
    """

    _validation = {
        'kerberos_kdc_address': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_principal': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'kerberos_realm': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'kerberos_kdc_address': {'key': 'kerberosKdcAddress', 'type': 'str'},
        'kerberos_principal': {'key': 'kerberosPrincipal', 'type': 'str'},
        'kerberos_realm': {'key': 'kerberosRealm', 'type': 'str'},
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'KerberosPasswordSecrets'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword kerberos_kdc_address: Required. [Required] IP Address or DNS HostName.
        :paramtype kerberos_kdc_address: str
        :keyword kerberos_principal: Required. [Required] Kerberos Username.
        :paramtype kerberos_principal: str
        :keyword kerberos_realm: Required. [Required] Domain over which a Kerberos authentication
         server has the authority to authenticate a user, host or service.
        :paramtype kerberos_realm: str
        :keyword secrets: Required. [Required] Kerberos password secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.KerberosPasswordSecrets
        """
        super(KerberosPasswordCredentials, self).__init__(**kwargs)
        self.kerberos_kdc_address = kwargs['kerberos_kdc_address']
        self.kerberos_principal = kwargs['kerberos_principal']
        self.kerberos_realm = kwargs['kerberos_realm']
        self.credentials_type = 'KerberosPassword'  # type: str
        self.secrets = kwargs['secrets']
        self.credentials_type = 'KerberosPassword'  # type: str
        self.secrets = kwargs['secrets']


class KerberosPasswordSecrets(DatastoreSecrets):
    """KerberosPasswordSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar kerberos_password: Kerberos password secret.
    :vartype kerberos_password: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'kerberos_password': {'key': 'kerberosPassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword kerberos_password: Kerberos password secret.
        :paramtype kerberos_password: str
        """
        super(KerberosPasswordSecrets, self).__init__(**kwargs)
        self.secrets_type = 'KerberosPassword'  # type: str
        self.kerberos_password = kwargs.get('kerberos_password', None)


class OnlineDeploymentDetails(EndpointDeploymentPropertiesBase):
    """OnlineDeploymentDetails.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: KubernetesOnlineDeployment, ManagedOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar egress_public_network_access: If Enabled, allow egress public network access. If
     Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
     "Disabled".
    :vartype egress_public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar private_network_connection: If true, enable private network connection.
     DEPRECATED for future API versions. Use EgressPublicNetworkAccess.
    :vartype private_network_connection: bool
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'app_insights_enabled': {'key': 'appInsightsEnabled', 'type': 'bool'},
        'egress_public_network_access': {'key': 'egressPublicNetworkAccess', 'type': 'str'},
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'liveness_probe': {'key': 'livenessProbe', 'type': 'ProbeSettings'},
        'model': {'key': 'model', 'type': 'str'},
        'model_mount_path': {'key': 'modelMountPath', 'type': 'str'},
        'private_network_connection': {'key': 'privateNetworkConnection', 'type': 'bool'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'readiness_probe': {'key': 'readinessProbe', 'type': 'ProbeSettings'},
        'request_settings': {'key': 'requestSettings', 'type': 'OnlineRequestSettings'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'OnlineScaleSettings'},
    }

    _subtype_map = {
        'endpoint_compute_type': {'Kubernetes': 'KubernetesOnlineDeployment', 'Managed': 'ManagedOnlineDeployment'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword egress_public_network_access: If Enabled, allow egress public network access. If
         Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
         "Disabled".
        :paramtype egress_public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword private_network_connection: If true, enable private network connection.
         DEPRECATED for future API versions. Use EgressPublicNetworkAccess.
        :paramtype private_network_connection: bool
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        """
        super(OnlineDeploymentDetails, self).__init__(**kwargs)
        self.app_insights_enabled = kwargs.get('app_insights_enabled', False)
        self.egress_public_network_access = kwargs.get('egress_public_network_access', None)
        self.endpoint_compute_type = 'OnlineDeploymentDetails'  # type: str
        self.instance_type = kwargs.get('instance_type', None)
        self.liveness_probe = kwargs.get('liveness_probe', None)
        self.model = kwargs.get('model', None)
        self.model_mount_path = kwargs.get('model_mount_path', None)
        self.private_network_connection = kwargs.get('private_network_connection', False)
        self.provisioning_state = None
        self.readiness_probe = kwargs.get('readiness_probe', None)
        self.request_settings = kwargs.get('request_settings', None)
        self.scale_settings = kwargs.get('scale_settings', None)


class KubernetesOnlineDeployment(OnlineDeploymentDetails):
    """Properties specific to a KubernetesOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar egress_public_network_access: If Enabled, allow egress public network access. If
     Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
     "Disabled".
    :vartype egress_public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar private_network_connection: If true, enable private network connection.
     DEPRECATED for future API versions. Use EgressPublicNetworkAccess.
    :vartype private_network_connection: bool
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    :ivar container_resource_requirements: The resource requirements for the container (cpu and
     memory).
    :vartype container_resource_requirements:
     ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'app_insights_enabled': {'key': 'appInsightsEnabled', 'type': 'bool'},
        'egress_public_network_access': {'key': 'egressPublicNetworkAccess', 'type': 'str'},
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'liveness_probe': {'key': 'livenessProbe', 'type': 'ProbeSettings'},
        'model': {'key': 'model', 'type': 'str'},
        'model_mount_path': {'key': 'modelMountPath', 'type': 'str'},
        'private_network_connection': {'key': 'privateNetworkConnection', 'type': 'bool'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'readiness_probe': {'key': 'readinessProbe', 'type': 'ProbeSettings'},
        'request_settings': {'key': 'requestSettings', 'type': 'OnlineRequestSettings'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'OnlineScaleSettings'},
        'container_resource_requirements': {'key': 'containerResourceRequirements', 'type': 'ContainerResourceRequirements'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword egress_public_network_access: If Enabled, allow egress public network access. If
         Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
         "Disabled".
        :paramtype egress_public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword private_network_connection: If true, enable private network connection.
         DEPRECATED for future API versions. Use EgressPublicNetworkAccess.
        :paramtype private_network_connection: bool
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        :keyword container_resource_requirements: The resource requirements for the container (cpu and
         memory).
        :paramtype container_resource_requirements:
         ~azure.mgmt.machinelearningservices.models.ContainerResourceRequirements
        """
        super(KubernetesOnlineDeployment, self).__init__(**kwargs)
        self.endpoint_compute_type = 'Kubernetes'  # type: str
        self.container_resource_requirements = kwargs.get('container_resource_requirements', None)


class LiteralJobInput(JobInput):
    """Literal input type.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Literal", "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar value: Required. [Required] Literal value for the input.
    :vartype value: str
    """

    _validation = {
        'job_input_type': {'required': True},
        'value': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Description for the input.
        :paramtype description: str
        :keyword value: Required. [Required] Literal value for the input.
        :paramtype value: str
        """
        super(LiteralJobInput, self).__init__(**kwargs)
        self.job_input_type = 'Literal'  # type: str
        self.value = kwargs['value']


class ManagedIdentity(IdentityConfiguration):
    """Managed identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    :ivar client_id: Specifies a user-assigned identity by client ID. For system-assigned, do not
     set this field.
    :vartype client_id: str
    :ivar object_id: Specifies a user-assigned identity by object ID. For system-assigned, do not
     set this field.
    :vartype object_id: str
    :ivar resource_id: Specifies a user-assigned identity by ARM resource ID. For system-assigned,
     do not set this field.
    :vartype resource_id: str
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword client_id: Specifies a user-assigned identity by client ID. For system-assigned, do
         not set this field.
        :paramtype client_id: str
        :keyword object_id: Specifies a user-assigned identity by object ID. For system-assigned, do
         not set this field.
        :paramtype object_id: str
        :keyword resource_id: Specifies a user-assigned identity by ARM resource ID. For
         system-assigned, do not set this field.
        :paramtype resource_id: str
        """
        super(ManagedIdentity, self).__init__(**kwargs)
        self.identity_type = 'Managed'  # type: str
        self.client_id = kwargs.get('client_id', None)
        self.object_id = kwargs.get('object_id', None)
        self.resource_id = kwargs.get('resource_id', None)


class ManagedOnlineDeployment(OnlineDeploymentDetails):
    """Properties specific to a ManagedOnlineDeployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar app_insights_enabled: If true, enables Application Insights logging.
    :vartype app_insights_enabled: bool
    :ivar egress_public_network_access: If Enabled, allow egress public network access. If
     Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
     "Disabled".
    :vartype egress_public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    :ivar instance_type: Compute instance type.
    :vartype instance_type: str
    :ivar liveness_probe: Liveness probe monitors the health of the container regularly.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar model: The URI path to the model.
    :vartype model: str
    :ivar model_mount_path: The path to mount the model in custom container.
    :vartype model_mount_path: str
    :ivar private_network_connection: If true, enable private network connection.
     DEPRECATED for future API versions. Use EgressPublicNetworkAccess.
    :vartype private_network_connection: bool
    :ivar provisioning_state: Provisioning state for the endpoint deployment. Possible values
     include: "Creating", "Deleting", "Scaling", "Updating", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.DeploymentProvisioningState
    :ivar readiness_probe: Readiness probe validates if the container is ready to serve traffic.
     The properties and defaults are the same as liveness probe.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar request_settings: Request settings for the deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar scale_settings: Scale settings for the deployment.
     If it is null or not provided,
     it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
     and to DefaultScaleSettings for ManagedOnlineDeployment.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'CodeConfiguration'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'app_insights_enabled': {'key': 'appInsightsEnabled', 'type': 'bool'},
        'egress_public_network_access': {'key': 'egressPublicNetworkAccess', 'type': 'str'},
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'liveness_probe': {'key': 'livenessProbe', 'type': 'ProbeSettings'},
        'model': {'key': 'model', 'type': 'str'},
        'model_mount_path': {'key': 'modelMountPath', 'type': 'str'},
        'private_network_connection': {'key': 'privateNetworkConnection', 'type': 'bool'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'readiness_probe': {'key': 'readinessProbe', 'type': 'ProbeSettings'},
        'request_settings': {'key': 'requestSettings', 'type': 'OnlineRequestSettings'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'OnlineScaleSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration: ~azure.mgmt.machinelearningservices.models.CodeConfiguration
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword app_insights_enabled: If true, enables Application Insights logging.
        :paramtype app_insights_enabled: bool
        :keyword egress_public_network_access: If Enabled, allow egress public network access. If
         Disabled, this will create secure egress. Default: Enabled. Possible values include: "Enabled",
         "Disabled".
        :paramtype egress_public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.EgressPublicNetworkAccessType
        :keyword instance_type: Compute instance type.
        :paramtype instance_type: str
        :keyword liveness_probe: Liveness probe monitors the health of the container regularly.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword model: The URI path to the model.
        :paramtype model: str
        :keyword model_mount_path: The path to mount the model in custom container.
        :paramtype model_mount_path: str
        :keyword private_network_connection: If true, enable private network connection.
         DEPRECATED for future API versions. Use EgressPublicNetworkAccess.
        :paramtype private_network_connection: bool
        :keyword readiness_probe: Readiness probe validates if the container is ready to serve traffic.
         The properties and defaults are the same as liveness probe.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword request_settings: Request settings for the deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword scale_settings: Scale settings for the deployment.
         If it is null or not provided,
         it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
         and to DefaultScaleSettings for ManagedOnlineDeployment.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.OnlineScaleSettings
        """
        super(ManagedOnlineDeployment, self).__init__(**kwargs)
        self.endpoint_compute_type = 'Managed'  # type: str


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Required. Type of managed service identity (where both SystemAssigned and
     UserAssigned types are allowed). Possible values include: "None", "SystemAssigned",
     "UserAssigned", "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Required. Type of managed service identity (where both SystemAssigned and
         UserAssigned types are allowed). Possible values include: "None", "SystemAssigned",
         "UserAssigned", "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
        """
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs['type']
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class MedianStoppingPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy based on running averages of the primary metric of all runs.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        """
        super(MedianStoppingPolicy, self).__init__(**kwargs)
        self.policy_type = 'MedianStopping'  # type: str


class MLFlowModelJobInput(JobInput, AssetJobInput):
    """MLFlowModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Literal", "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(MLFlowModelJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'MLFlowModel'  # type: str
        self.description = kwargs.get('description', None)
        self.job_input_type = 'MLFlowModel'  # type: str


class MLFlowModelJobOutput(JobOutput, AssetJobOutput):
    """MLFlowModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(MLFlowModelJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'MLFlowModel'  # type: str
        self.description = kwargs.get('description', None)
        self.job_output_type = 'MLFlowModel'  # type: str


class MLTableData(DataVersionBaseDetails):
    """MLTable data definition.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "UriFile", "UriFolder", "MLTable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
     Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220201Preview.Assets.DataVersionBase.DataType.
    :vartype data_uri: str
    :ivar referenced_uris: Uris referenced in the MLTable definition (required for lineage).
    :vartype referenced_uris: list[str]
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
        'referenced_uris': {'key': 'referencedUris', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
         Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220201Preview.Assets.DataVersionBase.DataType.
        :paramtype data_uri: str
        :keyword referenced_uris: Uris referenced in the MLTable definition (required for lineage).
        :paramtype referenced_uris: list[str]
        """
        super(MLTableData, self).__init__(**kwargs)
        self.data_type = 'MLTable'  # type: str
        self.referenced_uris = kwargs.get('referenced_uris', None)


class MLTableJobInput(JobInput, AssetJobInput):
    """MLTableJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Literal", "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(MLTableJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'MLTable'  # type: str
        self.description = kwargs.get('description', None)
        self.job_input_type = 'MLTable'  # type: str


class MLTableJobOutput(JobOutput, AssetJobOutput):
    """MLTableJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(MLTableJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'MLTable'  # type: str
        self.description = kwargs.get('description', None)
        self.job_output_type = 'MLTable'  # type: str


class ModelContainerData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ModelContainerDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ModelContainerDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ModelContainerDetails
        """
        super(ModelContainerData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class ModelContainerDetails(AssetContainer):
    """ModelContainerDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar latest_version: The latest version inside this container.
    :vartype latest_version: str
    :ivar next_version: The next auto incremental version.
    :vartype next_version: str
    """

    _validation = {
        'latest_version': {'readonly': True},
        'next_version': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
        'next_version': {'key': 'nextVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        """
        super(ModelContainerDetails, self).__init__(**kwargs)


class ModelContainerResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ModelContainer entities.

    :ivar next_link: The link to the next page of ModelContainer objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ModelContainer.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ModelContainerData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ModelContainerData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ModelContainer objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ModelContainer.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ModelContainerData]
        """
        super(ModelContainerResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ModelVersionData(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ModelVersionDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ModelVersionDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ModelVersionDetails
        """
        super(ModelVersionData, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class ModelVersionDetails(AssetBase):
    """Model asset version details.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar flavors: Mapping of model flavors to their properties.
    :vartype flavors: dict[str, ~azure.mgmt.machinelearningservices.models.FlavorData]
    :ivar job_name: Name of the training job which produced this model.
    :vartype job_name: str
    :ivar model_type: The storage format for this entity. Used for NCD. Possible values include:
     "CustomModel", "MLFlowModel", "TritonModel".
    :vartype model_type: str or ~azure.mgmt.machinelearningservices.models.ModelType
    :ivar model_uri: The URI path to the model contents.
    :vartype model_uri: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'flavors': {'key': 'flavors', 'type': '{FlavorData}'},
        'job_name': {'key': 'jobName', 'type': 'str'},
        'model_type': {'key': 'modelType', 'type': 'str'},
        'model_uri': {'key': 'modelUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword flavors: Mapping of model flavors to their properties.
        :paramtype flavors: dict[str, ~azure.mgmt.machinelearningservices.models.FlavorData]
        :keyword job_name: Name of the training job which produced this model.
        :paramtype job_name: str
        :keyword model_type: The storage format for this entity. Used for NCD. Possible values include:
         "CustomModel", "MLFlowModel", "TritonModel".
        :paramtype model_type: str or ~azure.mgmt.machinelearningservices.models.ModelType
        :keyword model_uri: The URI path to the model contents.
        :paramtype model_uri: str
        """
        super(ModelVersionDetails, self).__init__(**kwargs)
        self.flavors = kwargs.get('flavors', None)
        self.job_name = kwargs.get('job_name', None)
        self.model_type = kwargs.get('model_type', None)
        self.model_uri = kwargs.get('model_uri', None)


class ModelVersionResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of ModelVersion entities.

    :ivar next_link: The link to the next page of ModelVersion objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type ModelVersion.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ModelVersionData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ModelVersionData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of ModelVersion objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type ModelVersion.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ModelVersionData]
        """
        super(ModelVersionResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class Mpi(DistributionConfiguration):
    """MPI distribution configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    :ivar process_count_per_instance: Number of processes per MPI node.
    :vartype process_count_per_instance: int
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
        'process_count_per_instance': {'key': 'processCountPerInstance', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword process_count_per_instance: Number of processes per MPI node.
        :paramtype process_count_per_instance: int
        """
        super(Mpi, self).__init__(**kwargs)
        self.distribution_type = 'Mpi'  # type: str
        self.process_count_per_instance = kwargs.get('process_count_per_instance', None)


class NlpVertical(msrest.serialization.Model):
    """Abstract class for NLP related AutoML tasks.
NLP - Natural Language Processing.

    :ivar data_settings: Data inputs for AutoMLJob.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalDataSettings
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
    """

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'NlpVerticalDataSettings'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'NlpVerticalFeaturizationSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'NlpVerticalLimitSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Data inputs for AutoMLJob.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalDataSettings
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
        """
        super(NlpVertical, self).__init__(**kwargs)
        self.data_settings = kwargs.get('data_settings', None)
        self.featurization_settings = kwargs.get('featurization_settings', None)
        self.limit_settings = kwargs.get('limit_settings', None)


class NlpVerticalDataSettings(DataSettings):
    """Class for data inputs.
NLP - Natural Language Processing.

    All required parameters must be populated in order to send to Azure.

    :ivar target_column_name: Required. [Required] Target column name: This is prediction values
     column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.TestDataSettings
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.TrainingDataSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data:
     ~azure.mgmt.machinelearningservices.models.NlpVerticalValidationDataSettings
    """

    _validation = {
        'target_column_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'test_data': {'key': 'testData', 'type': 'TestDataSettings'},
        'training_data': {'key': 'trainingData', 'type': 'TrainingDataSettings'},
        'validation_data': {'key': 'validationData', 'type': 'NlpVerticalValidationDataSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword target_column_name: Required. [Required] Target column name: This is prediction values
         column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.TestDataSettings
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.TrainingDataSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data:
         ~azure.mgmt.machinelearningservices.models.NlpVerticalValidationDataSettings
        """
        super(NlpVerticalDataSettings, self).__init__(**kwargs)
        self.validation_data = kwargs.get('validation_data', None)


class NlpVerticalFeaturizationSettings(FeaturizationSettings):
    """NlpVerticalFeaturizationSettings.

    :ivar dataset_language: Dataset language, useful for the text data.
    :vartype dataset_language: str
    """

    _attribute_map = {
        'dataset_language': {'key': 'datasetLanguage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword dataset_language: Dataset language, useful for the text data.
        :paramtype dataset_language: str
        """
        super(NlpVerticalFeaturizationSettings, self).__init__(**kwargs)


class NlpVerticalLimitSettings(msrest.serialization.Model):
    """Job execution constraints.

    :ivar max_concurrent_trials: Maximum Concurrent AutoML iterations.
    :vartype max_concurrent_trials: int
    :ivar max_trials: Number of AutoML iterations.
    :vartype max_trials: int
    :ivar timeout: AutoML job timeout.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_concurrent_trials': {'key': 'maxConcurrentTrials', 'type': 'int'},
        'max_trials': {'key': 'maxTrials', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_concurrent_trials: Maximum Concurrent AutoML iterations.
        :paramtype max_concurrent_trials: int
        :keyword max_trials: Number of AutoML iterations.
        :paramtype max_trials: int
        :keyword timeout: AutoML job timeout.
        :paramtype timeout: ~datetime.timedelta
        """
        super(NlpVerticalLimitSettings, self).__init__(**kwargs)
        self.max_concurrent_trials = kwargs.get('max_concurrent_trials', 1)
        self.max_trials = kwargs.get('max_trials', 1)
        self.timeout = kwargs.get('timeout', None)


class NlpVerticalValidationDataSettings(ValidationDataSettings):
    """NlpVerticalValidationDataSettings.

    :ivar data: Validation data MLTable.
    :vartype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data: Validation data MLTable.
        :paramtype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        """
        super(NlpVerticalValidationDataSettings, self).__init__(**kwargs)


class NoneDatastoreCredentials(DatastoreCredentials):
    """Empty/none datastore credentials.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    """

    _validation = {
        'credentials_type': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NoneDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'None'  # type: str


class Objective(msrest.serialization.Model):
    """Optimization objective.

    All required parameters must be populated in order to send to Azure.

    :ivar goal: Required. [Required] Defines supported metric goals for hyperparameter tuning.
     Possible values include: "Minimize", "Maximize".
    :vartype goal: str or ~azure.mgmt.machinelearningservices.models.Goal
    :ivar primary_metric: Required. [Required] Name of the metric to optimize.
    :vartype primary_metric: str
    """

    _validation = {
        'goal': {'required': True},
        'primary_metric': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'goal': {'key': 'goal', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword goal: Required. [Required] Defines supported metric goals for hyperparameter tuning.
         Possible values include: "Minimize", "Maximize".
        :paramtype goal: str or ~azure.mgmt.machinelearningservices.models.Goal
        :keyword primary_metric: Required. [Required] Name of the metric to optimize.
        :paramtype primary_metric: str
        """
        super(Objective, self).__init__(**kwargs)
        self.goal = kwargs['goal']
        self.primary_metric = kwargs['primary_metric']


class OnlineDeploymentData(TrackedResource):
    """OnlineDeploymentData.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.OnlineDeploymentDetails
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OnlineDeploymentDetails'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.OnlineDeploymentDetails
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(OnlineDeploymentData, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.properties = kwargs['properties']
        self.sku = kwargs.get('sku', None)


class OnlineDeploymentTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of OnlineDeployment entities.

    :ivar next_link: The link to the next page of OnlineDeployment objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type OnlineDeployment.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.OnlineDeploymentData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OnlineDeploymentData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of OnlineDeployment objects. If null, there are
         no additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type OnlineDeployment.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.OnlineDeploymentData]
        """
        super(OnlineDeploymentTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class OnlineEndpointData(TrackedResource):
    """OnlineEndpointData.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.OnlineEndpointDetails
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OnlineEndpointDetails'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.OnlineEndpointDetails
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(OnlineEndpointData, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.properties = kwargs['properties']
        self.sku = kwargs.get('sku', None)


class OnlineEndpointDetails(EndpointPropertiesBase):
    """Online endpoint configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken' for
     Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
     Possible values include: "AMLToken", "Key", "AADToken".
    :vartype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
    :ivar description: Description of the inference endpoint.
    :vartype description: str
    :ivar keys: EndpointAuthKeys to set initially on an Endpoint.
     This property will always be returned as null. AuthKey values must be retrieved using the
     ListKeys API.
    :vartype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar scoring_uri: Endpoint URI.
    :vartype scoring_uri: str
    :ivar swagger_uri: Endpoint Swagger URI.
    :vartype swagger_uri: str
    :ivar compute: ARM resource ID of the compute if it exists.
     optional.
    :vartype compute: str
    :ivar mirror_traffic: Percentage of traffic to be mirrored to each deployment without using
     returned scoring. Traffic values need to sum to utmost 50.
    :vartype mirror_traffic: dict[str, int]
    :ivar provisioning_state: Provisioning state for the endpoint. Possible values include:
     "Creating", "Deleting", "Succeeded", "Failed", "Updating", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.EndpointProvisioningState
    :ivar public_network_access: Set to "Enabled" for endpoints that should allow public access
     when Private Link is enabled. Possible values include: "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
    :ivar traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic values
     need to sum to 100.
    :vartype traffic: dict[str, int]
    """

    _validation = {
        'auth_mode': {'required': True},
        'scoring_uri': {'readonly': True},
        'swagger_uri': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'auth_mode': {'key': 'authMode', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'keys': {'key': 'keys', 'type': 'EndpointAuthKeys'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'scoring_uri': {'key': 'scoringUri', 'type': 'str'},
        'swagger_uri': {'key': 'swaggerUri', 'type': 'str'},
        'compute': {'key': 'compute', 'type': 'str'},
        'mirror_traffic': {'key': 'mirrorTraffic', 'type': '{int}'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'traffic': {'key': 'traffic', 'type': '{int}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword auth_mode: Required. [Required] Use 'Key' for key based authentication and 'AMLToken'
         for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken'
         does. Possible values include: "AMLToken", "Key", "AADToken".
        :paramtype auth_mode: str or ~azure.mgmt.machinelearningservices.models.EndpointAuthMode
        :keyword description: Description of the inference endpoint.
        :paramtype description: str
        :keyword keys: EndpointAuthKeys to set initially on an Endpoint.
         This property will always be returned as null. AuthKey values must be retrieved using the
         ListKeys API.
        :paramtype keys: ~azure.mgmt.machinelearningservices.models.EndpointAuthKeys
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword compute: ARM resource ID of the compute if it exists.
         optional.
        :paramtype compute: str
        :keyword mirror_traffic: Percentage of traffic to be mirrored to each deployment without using
         returned scoring. Traffic values need to sum to utmost 50.
        :paramtype mirror_traffic: dict[str, int]
        :keyword public_network_access: Set to "Enabled" for endpoints that should allow public access
         when Private Link is enabled. Possible values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
        :keyword traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic
         values need to sum to 100.
        :paramtype traffic: dict[str, int]
        """
        super(OnlineEndpointDetails, self).__init__(**kwargs)
        self.compute = kwargs.get('compute', None)
        self.mirror_traffic = kwargs.get('mirror_traffic', None)
        self.provisioning_state = None
        self.public_network_access = kwargs.get('public_network_access', None)
        self.traffic = kwargs.get('traffic', None)


class OnlineEndpointTrackedResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of OnlineEndpoint entities.

    :ivar next_link: The link to the next page of OnlineEndpoint objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type OnlineEndpoint.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.OnlineEndpointData]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OnlineEndpointData]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of OnlineEndpoint objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type OnlineEndpoint.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.OnlineEndpointData]
        """
        super(OnlineEndpointTrackedResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class OnlineRequestSettings(msrest.serialization.Model):
    """Online deployment scoring requests configuration.

    :ivar max_concurrent_requests_per_instance: The number of maximum concurrent requests per node
     allowed per deployment. Defaults to 1.
    :vartype max_concurrent_requests_per_instance: int
    :ivar max_queue_wait: The maximum amount of time a request will stay in the queue in ISO 8601
     format.
     Defaults to 500ms.
    :vartype max_queue_wait: ~datetime.timedelta
    :ivar request_timeout: The scoring timeout in ISO 8601 format.
     Defaults to 5000ms.
    :vartype request_timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_concurrent_requests_per_instance': {'key': 'maxConcurrentRequestsPerInstance', 'type': 'int'},
        'max_queue_wait': {'key': 'maxQueueWait', 'type': 'duration'},
        'request_timeout': {'key': 'requestTimeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_concurrent_requests_per_instance: The number of maximum concurrent requests per
         node allowed per deployment. Defaults to 1.
        :paramtype max_concurrent_requests_per_instance: int
        :keyword max_queue_wait: The maximum amount of time a request will stay in the queue in ISO
         8601 format.
         Defaults to 500ms.
        :paramtype max_queue_wait: ~datetime.timedelta
        :keyword request_timeout: The scoring timeout in ISO 8601 format.
         Defaults to 5000ms.
        :paramtype request_timeout: ~datetime.timedelta
        """
        super(OnlineRequestSettings, self).__init__(**kwargs)
        self.max_concurrent_requests_per_instance = kwargs.get('max_concurrent_requests_per_instance', 1)
        self.max_queue_wait = kwargs.get('max_queue_wait', "PT0.5S")
        self.request_timeout = kwargs.get('request_timeout', "PT5S")


class OutputPathAssetReference(AssetReferenceBase):
    """Reference to an asset via its path in a job output.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar job_id: ARM resource ID of the job.
    :vartype job_id: str
    :ivar path: The path of the file/directory in the job output.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword job_id: ARM resource ID of the job.
        :paramtype job_id: str
        :keyword path: The path of the file/directory in the job output.
        :paramtype path: str
        """
        super(OutputPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'OutputPath'  # type: str
        self.job_id = kwargs.get('job_id', None)
        self.path = kwargs.get('path', None)


class PartialAssetReferenceBase(msrest.serialization.Model):
    """Base definition for asset references.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PartialDataPathAssetReference, PartialIdAssetReference, PartialOutputPathAssetReference.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
    }

    _subtype_map = {
        'reference_type': {'DataPath': 'PartialDataPathAssetReference', 'Id': 'PartialIdAssetReference', 'OutputPath': 'PartialOutputPathAssetReference'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PartialAssetReferenceBase, self).__init__(**kwargs)
        self.reference_type = None  # type: Optional[str]


class PartialBatchDeployment(msrest.serialization.Model):
    """Mutable batch inference settings per deployment.

    :ivar code_configuration: Code configuration for the endpoint deployment.
    :vartype code_configuration:
     ~azure.mgmt.machinelearningservices.models.PartialCodeConfiguration
    :ivar compute: Compute binding definition.
    :vartype compute: str
    :ivar description: Description of the endpoint deployment.
    :vartype description: str
    :ivar environment_id: ARM resource ID of the environment specification for the endpoint
     deployment.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables configuration for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar error_threshold: Error threshold, if the error count for the entire input goes above this
     value,
     the batch inference will be aborted. Range is [-1, int.MaxValue].
     For FileDataset, this value is the count of file failures.
     For TabularDataset, this value is the count of record failures.
     If set to -1 (the lower bound), all failures during batch inference will be ignored.
    :vartype error_threshold: int
    :ivar logging_level: Logging level for batch inference operation. Possible values include:
     "Info", "Warning", "Debug".
    :vartype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
    :ivar max_concurrency_per_instance: Indicates number of processes per instance.
    :vartype max_concurrency_per_instance: int
    :ivar mini_batch_size: Size of the mini-batch passed to each batch invocation.
     For FileDataset, this is the number of files per mini-batch.
     For TabularDataset, this is the size of the records in bytes, per mini-batch.
    :vartype mini_batch_size: long
    :ivar model: Reference to the model asset for the endpoint deployment.
    :vartype model: ~azure.mgmt.machinelearningservices.models.PartialAssetReferenceBase
    :ivar output_action: Indicates how the output will be organized. Possible values include:
     "SummaryOnly", "AppendRow".
    :vartype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
    :ivar output_file_name: Customized output file name for append_row output action.
    :vartype output_file_name: str
    :ivar properties: Property dictionary. Properties can be added, but not removed or altered.
    :vartype properties: dict[str, str]
    :ivar retry_settings: Retry Settings for the batch inference operation.
    :vartype retry_settings: ~azure.mgmt.machinelearningservices.models.PartialBatchRetrySettings
    """

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'PartialCodeConfiguration'},
        'compute': {'key': 'compute', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'error_threshold': {'key': 'errorThreshold', 'type': 'int'},
        'logging_level': {'key': 'loggingLevel', 'type': 'str'},
        'max_concurrency_per_instance': {'key': 'maxConcurrencyPerInstance', 'type': 'int'},
        'mini_batch_size': {'key': 'miniBatchSize', 'type': 'long'},
        'model': {'key': 'model', 'type': 'PartialAssetReferenceBase'},
        'output_action': {'key': 'outputAction', 'type': 'str'},
        'output_file_name': {'key': 'outputFileName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'retry_settings': {'key': 'retrySettings', 'type': 'PartialBatchRetrySettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_configuration: Code configuration for the endpoint deployment.
        :paramtype code_configuration:
         ~azure.mgmt.machinelearningservices.models.PartialCodeConfiguration
        :keyword compute: Compute binding definition.
        :paramtype compute: str
        :keyword description: Description of the endpoint deployment.
        :paramtype description: str
        :keyword environment_id: ARM resource ID of the environment specification for the endpoint
         deployment.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables configuration for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword error_threshold: Error threshold, if the error count for the entire input goes above
         this value,
         the batch inference will be aborted. Range is [-1, int.MaxValue].
         For FileDataset, this value is the count of file failures.
         For TabularDataset, this value is the count of record failures.
         If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :paramtype error_threshold: int
        :keyword logging_level: Logging level for batch inference operation. Possible values include:
         "Info", "Warning", "Debug".
        :paramtype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
        :keyword max_concurrency_per_instance: Indicates number of processes per instance.
        :paramtype max_concurrency_per_instance: int
        :keyword mini_batch_size: Size of the mini-batch passed to each batch invocation.
         For FileDataset, this is the number of files per mini-batch.
         For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :paramtype mini_batch_size: long
        :keyword model: Reference to the model asset for the endpoint deployment.
        :paramtype model: ~azure.mgmt.machinelearningservices.models.PartialAssetReferenceBase
        :keyword output_action: Indicates how the output will be organized. Possible values include:
         "SummaryOnly", "AppendRow".
        :paramtype output_action: str or ~azure.mgmt.machinelearningservices.models.BatchOutputAction
        :keyword output_file_name: Customized output file name for append_row output action.
        :paramtype output_file_name: str
        :keyword properties: Property dictionary. Properties can be added, but not removed or altered.
        :paramtype properties: dict[str, str]
        :keyword retry_settings: Retry Settings for the batch inference operation.
        :paramtype retry_settings: ~azure.mgmt.machinelearningservices.models.PartialBatchRetrySettings
        """
        super(PartialBatchDeployment, self).__init__(**kwargs)
        self.code_configuration = kwargs.get('code_configuration', None)
        self.compute = kwargs.get('compute', None)
        self.description = kwargs.get('description', None)
        self.environment_id = kwargs.get('environment_id', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.error_threshold = kwargs.get('error_threshold', None)
        self.logging_level = kwargs.get('logging_level', None)
        self.max_concurrency_per_instance = kwargs.get('max_concurrency_per_instance', None)
        self.mini_batch_size = kwargs.get('mini_batch_size', None)
        self.model = kwargs.get('model', None)
        self.output_action = kwargs.get('output_action', None)
        self.output_file_name = kwargs.get('output_file_name', None)
        self.properties = kwargs.get('properties', None)
        self.retry_settings = kwargs.get('retry_settings', None)


class PartialBatchDeploymentPartialTrackedResource(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchDeployment
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'PartialManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PartialBatchDeployment'},
        'sku': {'key': 'sku', 'type': 'PartialSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchDeployment
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialBatchDeploymentPartialTrackedResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)


class PartialBatchEndpoint(msrest.serialization.Model):
    """Mutable Batch endpoint configuration.

    :ivar defaults: Default values for Batch Endpoint.
    :vartype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
    """

    _attribute_map = {
        'defaults': {'key': 'defaults', 'type': 'BatchEndpointDefaults'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword defaults: Default values for Batch Endpoint.
        :paramtype defaults: ~azure.mgmt.machinelearningservices.models.BatchEndpointDefaults
        """
        super(PartialBatchEndpoint, self).__init__(**kwargs)
        self.defaults = kwargs.get('defaults', None)


class PartialBatchEndpointPartialTrackedResource(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchEndpoint
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'PartialManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PartialBatchEndpoint'},
        'sku': {'key': 'sku', 'type': 'PartialSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.PartialBatchEndpoint
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialBatchEndpointPartialTrackedResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)


class PartialBatchRetrySettings(msrest.serialization.Model):
    """Retry settings for a batch inference operation.

    :ivar max_retries: Maximum retry count for a mini-batch.
    :vartype max_retries: int
    :ivar timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_retries': {'key': 'maxRetries', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_retries: Maximum retry count for a mini-batch.
        :paramtype max_retries: int
        :keyword timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super(PartialBatchRetrySettings, self).__init__(**kwargs)
        self.max_retries = kwargs.get('max_retries', None)
        self.timeout = kwargs.get('timeout', None)


class PartialCodeConfiguration(msrest.serialization.Model):
    """Configuration for a scoring code asset.

    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar scoring_script: The script to execute on startup. eg. "score.py".
    :vartype scoring_script: str
    """

    _validation = {
        'scoring_script': {'min_length': 1},
    }

    _attribute_map = {
        'code_id': {'key': 'codeId', 'type': 'str'},
        'scoring_script': {'key': 'scoringScript', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword scoring_script: The script to execute on startup. eg. "score.py".
        :paramtype scoring_script: str
        """
        super(PartialCodeConfiguration, self).__init__(**kwargs)
        self.code_id = kwargs.get('code_id', None)
        self.scoring_script = kwargs.get('scoring_script', None)


class PartialDataPathAssetReference(PartialAssetReferenceBase):
    """Reference to an asset via its path in a datastore.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar datastore_id: ARM resource ID of the datastore where the asset is located.
    :vartype datastore_id: str
    :ivar path: The path of the file/directory in the datastore.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'datastore_id': {'key': 'datastoreId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword datastore_id: ARM resource ID of the datastore where the asset is located.
        :paramtype datastore_id: str
        :keyword path: The path of the file/directory in the datastore.
        :paramtype path: str
        """
        super(PartialDataPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'DataPath'  # type: str
        self.datastore_id = kwargs.get('datastore_id', None)
        self.path = kwargs.get('path', None)


class PartialIdAssetReference(PartialAssetReferenceBase):
    """Reference to an asset via its ARM resource ID.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar asset_id: ARM resource ID of the asset.
    :vartype asset_id: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword asset_id: ARM resource ID of the asset.
        :paramtype asset_id: str
        """
        super(PartialIdAssetReference, self).__init__(**kwargs)
        self.reference_type = 'Id'  # type: str
        self.asset_id = kwargs.get('asset_id', None)


class PartialOnlineDeployment(msrest.serialization.Model):
    """Mutable online deployment configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: PartialKubernetesOnlineDeployment, PartialManagedOnlineDeployment.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_compute_type': {'Kubernetes': 'PartialKubernetesOnlineDeployment', 'Managed': 'PartialManagedOnlineDeployment'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PartialOnlineDeployment, self).__init__(**kwargs)
        self.endpoint_compute_type = None  # type: Optional[str]


class PartialKubernetesOnlineDeployment(PartialOnlineDeployment):
    """Properties specific to a KubernetesOnlineDeployment.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PartialKubernetesOnlineDeployment, self).__init__(**kwargs)
        self.endpoint_compute_type = 'Kubernetes'  # type: str


class PartialManagedOnlineDeployment(PartialOnlineDeployment):
    """Properties specific to a ManagedOnlineDeployment.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_compute_type: Required. [Required] The compute type of the endpoint.Constant
     filled by server. Possible values include: "Managed", "Kubernetes", "AzureMLCompute".
    :vartype endpoint_compute_type: str or
     ~azure.mgmt.machinelearningservices.models.EndpointComputeType
    """

    _validation = {
        'endpoint_compute_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_compute_type': {'key': 'endpointComputeType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PartialManagedOnlineDeployment, self).__init__(**kwargs)
        self.endpoint_compute_type = 'Managed'  # type: str


class PartialManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar type: Managed service identity (system assigned and/or user assigned identities).
     Possible values include: "None", "SystemAssigned", "UserAssigned",
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, any]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Managed service identity (system assigned and/or user assigned identities).
         Possible values include: "None", "SystemAssigned", "UserAssigned",
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str, any]
        """
        super(PartialManagedServiceIdentity, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class PartialOnlineDeploymentPartialTrackedResource(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.PartialOnlineDeployment
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'PartialManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PartialOnlineDeployment'},
        'sku': {'key': 'sku', 'type': 'PartialSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.PartialOnlineDeployment
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialOnlineDeploymentPartialTrackedResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)


class PartialOnlineEndpoint(msrest.serialization.Model):
    """Mutable online endpoint configuration.

    :ivar mirror_traffic: Percentage of traffic to be mirrored to each deployment without using
     returned scoring. Traffic values need to sum to utmost 50.
    :vartype mirror_traffic: dict[str, int]
    :ivar public_network_access: Set to "Enabled" for endpoints that should allow public access
     when Private Link is enabled. Possible values include: "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
    :ivar traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic values
     need to sum to 100.
    :vartype traffic: dict[str, int]
    """

    _attribute_map = {
        'mirror_traffic': {'key': 'mirrorTraffic', 'type': '{int}'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'traffic': {'key': 'traffic', 'type': '{int}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mirror_traffic: Percentage of traffic to be mirrored to each deployment without using
         returned scoring. Traffic values need to sum to utmost 50.
        :paramtype mirror_traffic: dict[str, int]
        :keyword public_network_access: Set to "Enabled" for endpoints that should allow public access
         when Private Link is enabled. Possible values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.PublicNetworkAccessType
        :keyword traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic
         values need to sum to 100.
        :paramtype traffic: dict[str, int]
        """
        super(PartialOnlineEndpoint, self).__init__(**kwargs)
        self.mirror_traffic = kwargs.get('mirror_traffic', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.traffic = kwargs.get('traffic', None)


class PartialOnlineEndpointPartialTrackedResource(msrest.serialization.Model):
    """Strictly used in update requests.

    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
    :ivar kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type.
    :vartype kind: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.PartialOnlineEndpoint
    :ivar sku: Sku details required for ARM contract for Autoscaling.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'PartialManagedServiceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PartialOnlineEndpoint'},
        'sku': {'key': 'sku', 'type': 'PartialSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.PartialManagedServiceIdentity
        :keyword kind: Metadata used by portal/tooling/etc to render different UX experiences for
         resources of the same type.
        :paramtype kind: str
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.PartialOnlineEndpoint
        :keyword sku: Sku details required for ARM contract for Autoscaling.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.PartialSku
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PartialOnlineEndpointPartialTrackedResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)


class PartialOutputPathAssetReference(PartialAssetReferenceBase):
    """Reference to an asset via its path in a job output.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_type: Required. [Required] Specifies the type of asset reference.Constant
     filled by server. Possible values include: "Id", "DataPath", "OutputPath".
    :vartype reference_type: str or ~azure.mgmt.machinelearningservices.models.ReferenceType
    :ivar job_id: ARM resource ID of the job.
    :vartype job_id: str
    :ivar path: The path of the file/directory in the job output.
    :vartype path: str
    """

    _validation = {
        'reference_type': {'required': True},
    }

    _attribute_map = {
        'reference_type': {'key': 'referenceType', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword job_id: ARM resource ID of the job.
        :paramtype job_id: str
        :keyword path: The path of the file/directory in the job output.
        :paramtype path: str
        """
        super(PartialOutputPathAssetReference, self).__init__(**kwargs)
        self.reference_type = 'OutputPath'  # type: str
        self.job_id = kwargs.get('job_id', None)
        self.path = kwargs.get('path', None)


class PartialSku(msrest.serialization.Model):
    """Common SKU definition.

    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar name: The name of the SKU. Ex - P3. It is typically a letter+number code.
    :vartype name: str
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
    """

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'int'},
        'family': {'key': 'family', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword name: The name of the SKU. Ex - P3. It is typically a letter+number code.
        :paramtype name: str
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
         "Standard", "Premium".
        :paramtype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
        """
        super(PartialSku, self).__init__(**kwargs)
        self.capacity = kwargs.get('capacity', None)
        self.family = kwargs.get('family', None)
        self.name = kwargs.get('name', None)
        self.size = kwargs.get('size', None)
        self.tier = kwargs.get('tier', None)


class PipelineJob(JobBaseDetails):
    """Pipeline Job definition: defines generic to MFE attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Sweep", "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar schedule: Schedule definition of job.
     If no schedule is provided, the job is run once and immediately after submission.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar inputs: Inputs for the pipeline job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar jobs: Jobs construct the Pipeline Job.
    :vartype jobs: dict[str, any]
    :ivar outputs: Outputs for the pipeline job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
    :vartype settings: any
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'ScheduleBase'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'jobs': {'key': 'jobs', 'type': '{object}'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'settings': {'key': 'settings', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword schedule: Schedule definition of job.
         If no schedule is provided, the job is run once and immediately after submission.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword inputs: Inputs for the pipeline job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword jobs: Jobs construct the Pipeline Job.
        :paramtype jobs: dict[str, any]
        :keyword outputs: Outputs for the pipeline job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
        :paramtype settings: any
        """
        super(PipelineJob, self).__init__(**kwargs)
        self.job_type = 'Pipeline'  # type: str
        self.inputs = kwargs.get('inputs', None)
        self.jobs = kwargs.get('jobs', None)
        self.outputs = kwargs.get('outputs', None)
        self.settings = kwargs.get('settings', None)


class ProbeSettings(msrest.serialization.Model):
    """Deployment container liveness/readiness probe configuration.

    :ivar failure_threshold: The number of failures to allow before returning an unhealthy status.
    :vartype failure_threshold: int
    :ivar initial_delay: The delay before the first probe in ISO 8601 format.
    :vartype initial_delay: ~datetime.timedelta
    :ivar period: The length of time between probes in ISO 8601 format.
    :vartype period: ~datetime.timedelta
    :ivar success_threshold: The number of successful probes before returning a healthy status.
    :vartype success_threshold: int
    :ivar timeout: The probe timeout in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'failure_threshold': {'key': 'failureThreshold', 'type': 'int'},
        'initial_delay': {'key': 'initialDelay', 'type': 'duration'},
        'period': {'key': 'period', 'type': 'duration'},
        'success_threshold': {'key': 'successThreshold', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword failure_threshold: The number of failures to allow before returning an unhealthy
         status.
        :paramtype failure_threshold: int
        :keyword initial_delay: The delay before the first probe in ISO 8601 format.
        :paramtype initial_delay: ~datetime.timedelta
        :keyword period: The length of time between probes in ISO 8601 format.
        :paramtype period: ~datetime.timedelta
        :keyword success_threshold: The number of successful probes before returning a healthy status.
        :paramtype success_threshold: int
        :keyword timeout: The probe timeout in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super(ProbeSettings, self).__init__(**kwargs)
        self.failure_threshold = kwargs.get('failure_threshold', 30)
        self.initial_delay = kwargs.get('initial_delay', None)
        self.period = kwargs.get('period', "PT10S")
        self.success_threshold = kwargs.get('success_threshold', 1)
        self.timeout = kwargs.get('timeout', "PT2S")


class PyTorch(DistributionConfiguration):
    """PyTorch distribution configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    :ivar process_count_per_instance: Number of processes per node.
    :vartype process_count_per_instance: int
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
        'process_count_per_instance': {'key': 'processCountPerInstance', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword process_count_per_instance: Number of processes per node.
        :paramtype process_count_per_instance: int
        """
        super(PyTorch, self).__init__(**kwargs)
        self.distribution_type = 'PyTorch'  # type: str
        self.process_count_per_instance = kwargs.get('process_count_per_instance', None)


class RandomSamplingAlgorithm(SamplingAlgorithm):
    """Defines a Sampling Algorithm that generates values randomly.

    All required parameters must be populated in order to send to Azure.

    :ivar sampling_algorithm_type: Required. [Required] The algorithm used for generating
     hyperparameter values, along with configuration properties.Constant filled by server. Possible
     values include: "Grid", "Random", "Bayesian".
    :vartype sampling_algorithm_type: str or
     ~azure.mgmt.machinelearningservices.models.SamplingAlgorithmType
    :ivar rule: The specific type of random algorithm. Possible values include: "Random", "Sobol".
    :vartype rule: str or ~azure.mgmt.machinelearningservices.models.RandomSamplingAlgorithmRule
    :ivar seed: An optional integer to use as the seed for random number generation.
    :vartype seed: int
    """

    _validation = {
        'sampling_algorithm_type': {'required': True},
    }

    _attribute_map = {
        'sampling_algorithm_type': {'key': 'samplingAlgorithmType', 'type': 'str'},
        'rule': {'key': 'rule', 'type': 'str'},
        'seed': {'key': 'seed', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword rule: The specific type of random algorithm. Possible values include: "Random",
         "Sobol".
        :paramtype rule: str or ~azure.mgmt.machinelearningservices.models.RandomSamplingAlgorithmRule
        :keyword seed: An optional integer to use as the seed for random number generation.
        :paramtype seed: int
        """
        super(RandomSamplingAlgorithm, self).__init__(**kwargs)
        self.sampling_algorithm_type = 'Random'  # type: str
        self.rule = kwargs.get('rule', None)
        self.seed = kwargs.get('seed', None)


class RecurrencePattern(msrest.serialization.Model):
    """Recurrence schedule pattern definition.

    All required parameters must be populated in order to send to Azure.

    :ivar hours: Required. [Required] List of hours for recurrence schedule pattern.
    :vartype hours: list[int]
    :ivar minutes: Required. [Required] List of minutes for recurrence schedule pattern.
    :vartype minutes: list[int]
    :ivar weekdays: List of weekdays for recurrence schedule pattern.
    :vartype weekdays: list[str or ~azure.mgmt.machinelearningservices.models.Weekday]
    """

    _validation = {
        'hours': {'required': True},
        'minutes': {'required': True},
    }

    _attribute_map = {
        'hours': {'key': 'hours', 'type': '[int]'},
        'minutes': {'key': 'minutes', 'type': '[int]'},
        'weekdays': {'key': 'weekdays', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword hours: Required. [Required] List of hours for recurrence schedule pattern.
        :paramtype hours: list[int]
        :keyword minutes: Required. [Required] List of minutes for recurrence schedule pattern.
        :paramtype minutes: list[int]
        :keyword weekdays: List of weekdays for recurrence schedule pattern.
        :paramtype weekdays: list[str or ~azure.mgmt.machinelearningservices.models.Weekday]
        """
        super(RecurrencePattern, self).__init__(**kwargs)
        self.hours = kwargs['hours']
        self.minutes = kwargs['minutes']
        self.weekdays = kwargs.get('weekdays', None)


class RecurrenceSchedule(ScheduleBase):
    """Recurrence schedule definition.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: Specifies end time of schedule in ISO 8601 format.
     If not present, the schedule will run indefinitely.
    :vartype end_time: ~datetime.datetime
    :ivar schedule_status: Specifies the schedule's status. Possible values include: "Enabled",
     "Disabled".
    :vartype schedule_status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
    :ivar schedule_type: Required. [Required] Specifies the schedule type.Constant filled by
     server. Possible values include: "Cron", "Recurrence".
    :vartype schedule_type: str or ~azure.mgmt.machinelearningservices.models.ScheduleType
    :ivar start_time: Specifies start time of schedule in ISO 8601 format.
    :vartype start_time: ~datetime.datetime
    :ivar time_zone: Specifies time zone in which the schedule runs.
     TimeZone should follow Windows time zone format.
    :vartype time_zone: str
    :ivar frequency: Required. [Required] Specifies frequency with with which to trigger schedule.
     Possible values include: "Minute", "Hour", "Day", "Week", "Month".
    :vartype frequency: str or ~azure.mgmt.machinelearningservices.models.RecurrenceFrequency
    :ivar interval: Required. [Required] Specifies schedule interval in conjunction with frequency.
    :vartype interval: int
    :ivar pattern: Specifies the recurrence schedule pattern.
    :vartype pattern: ~azure.mgmt.machinelearningservices.models.RecurrencePattern
    """

    _validation = {
        'schedule_type': {'required': True},
        'frequency': {'required': True},
        'interval': {'required': True},
    }

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'schedule_status': {'key': 'scheduleStatus', 'type': 'str'},
        'schedule_type': {'key': 'scheduleType', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'frequency': {'key': 'frequency', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'int'},
        'pattern': {'key': 'pattern', 'type': 'RecurrencePattern'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword end_time: Specifies end time of schedule in ISO 8601 format.
         If not present, the schedule will run indefinitely.
        :paramtype end_time: ~datetime.datetime
        :keyword schedule_status: Specifies the schedule's status. Possible values include: "Enabled",
         "Disabled".
        :paramtype schedule_status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
        :keyword start_time: Specifies start time of schedule in ISO 8601 format.
        :paramtype start_time: ~datetime.datetime
        :keyword time_zone: Specifies time zone in which the schedule runs.
         TimeZone should follow Windows time zone format.
        :paramtype time_zone: str
        :keyword frequency: Required. [Required] Specifies frequency with with which to trigger
         schedule. Possible values include: "Minute", "Hour", "Day", "Week", "Month".
        :paramtype frequency: str or ~azure.mgmt.machinelearningservices.models.RecurrenceFrequency
        :keyword interval: Required. [Required] Specifies schedule interval in conjunction with
         frequency.
        :paramtype interval: int
        :keyword pattern: Specifies the recurrence schedule pattern.
        :paramtype pattern: ~azure.mgmt.machinelearningservices.models.RecurrencePattern
        """
        super(RecurrenceSchedule, self).__init__(**kwargs)
        self.schedule_type = 'Recurrence'  # type: str
        self.frequency = kwargs['frequency']
        self.interval = kwargs['interval']
        self.pattern = kwargs.get('pattern', None)


class RegenerateEndpointKeysRequest(msrest.serialization.Model):
    """RegenerateEndpointKeysRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar key_type: Required. [Required] Specification for which type of key to generate. Primary
     or Secondary. Possible values include: "Primary", "Secondary".
    :vartype key_type: str or ~azure.mgmt.machinelearningservices.models.KeyType
    :ivar key_value: The value the key is set to.
    :vartype key_value: str
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
        'key_value': {'key': 'keyValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key_type: Required. [Required] Specification for which type of key to generate.
         Primary or Secondary. Possible values include: "Primary", "Secondary".
        :paramtype key_type: str or ~azure.mgmt.machinelearningservices.models.KeyType
        :keyword key_value: The value the key is set to.
        :paramtype key_value: str
        """
        super(RegenerateEndpointKeysRequest, self).__init__(**kwargs)
        self.key_type = kwargs['key_type']
        self.key_value = kwargs.get('key_value', None)


class Regression(AutoMLVertical, TableVertical):
    """Regression task in AutoML Table vertical.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Data inputs for AutoMLJob.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalDataSettings
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
    :ivar training_settings: Inputs for training phase for an AutoML Job.
    :vartype training_settings: ~azure.mgmt.machinelearningservices.models.TrainingSettings
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar allowed_models: Allowed models for regression task.
    :vartype allowed_models: list[str or
     ~azure.mgmt.machinelearningservices.models.RegressionModels]
    :ivar blocked_models: Blocked models for regression task.
    :vartype blocked_models: list[str or
     ~azure.mgmt.machinelearningservices.models.RegressionModels]
    :ivar primary_metric: Primary metric for regression task. Possible values include:
     "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score",
     "NormalizedMeanAbsoluteError".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.RegressionPrimaryMetrics
    """

    _validation = {
        'task_type': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'TableVerticalDataSettings'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'TableVerticalFeaturizationSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'TableVerticalLimitSettings'},
        'training_settings': {'key': 'trainingSettings', 'type': 'TrainingSettings'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'allowed_models': {'key': 'allowedModels', 'type': '[str]'},
        'blocked_models': {'key': 'blockedModels', 'type': '[str]'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Data inputs for AutoMLJob.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.TableVerticalDataSettings
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings:
         ~azure.mgmt.machinelearningservices.models.TableVerticalLimitSettings
        :keyword training_settings: Inputs for training phase for an AutoML Job.
        :paramtype training_settings: ~azure.mgmt.machinelearningservices.models.TrainingSettings
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword allowed_models: Allowed models for regression task.
        :paramtype allowed_models: list[str or
         ~azure.mgmt.machinelearningservices.models.RegressionModels]
        :keyword blocked_models: Blocked models for regression task.
        :paramtype blocked_models: list[str or
         ~azure.mgmt.machinelearningservices.models.RegressionModels]
        :keyword primary_metric: Primary metric for regression task. Possible values include:
         "SpearmanCorrelation", "NormalizedRootMeanSquaredError", "R2Score",
         "NormalizedMeanAbsoluteError".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.RegressionPrimaryMetrics
        """
        super(Regression, self).__init__(**kwargs)
        self.data_settings = kwargs.get('data_settings', None)
        self.featurization_settings = kwargs.get('featurization_settings', None)
        self.limit_settings = kwargs.get('limit_settings', None)
        self.training_settings = kwargs.get('training_settings', None)
        self.task_type = 'Regression'  # type: str
        self.allowed_models = kwargs.get('allowed_models', None)
        self.blocked_models = kwargs.get('blocked_models', None)
        self.primary_metric = kwargs.get('primary_metric', None)
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = 'Regression'  # type: str
        self.allowed_models = kwargs.get('allowed_models', None)
        self.blocked_models = kwargs.get('blocked_models', None)
        self.primary_metric = kwargs.get('primary_metric', None)


class ResourceConfiguration(msrest.serialization.Model):
    """ResourceConfiguration.

    :ivar instance_count: Optional number of instances or nodes used by the compute target.
    :vartype instance_count: int
    :ivar instance_type: Optional type of VM used as supported by the compute target.
    :vartype instance_type: str
    :ivar properties: Additional properties bag.
    :vartype properties: dict[str, any]
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword instance_count: Optional number of instances or nodes used by the compute target.
        :paramtype instance_count: int
        :keyword instance_type: Optional type of VM used as supported by the compute target.
        :paramtype instance_type: str
        :keyword properties: Additional properties bag.
        :paramtype properties: dict[str, any]
        """
        super(ResourceConfiguration, self).__init__(**kwargs)
        self.instance_count = kwargs.get('instance_count', 1)
        self.instance_type = kwargs.get('instance_type', None)
        self.properties = kwargs.get('properties', None)


class Route(msrest.serialization.Model):
    """Route.

    All required parameters must be populated in order to send to Azure.

    :ivar path: Required. [Required] The path for the route.
    :vartype path: str
    :ivar port: Required. [Required] The port for the route.
    :vartype port: int
    """

    _validation = {
        'path': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'port': {'required': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword path: Required. [Required] The path for the route.
        :paramtype path: str
        :keyword port: Required. [Required] The port for the route.
        :paramtype port: int
        """
        super(Route, self).__init__(**kwargs)
        self.path = kwargs['path']
        self.port = kwargs['port']


class SasDatastoreCredentials(DatastoreCredentials):
    """SAS datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar secrets: Required. [Required] Storage container secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.SasDatastoreSecrets
    """

    _validation = {
        'credentials_type': {'required': True},
        'secrets': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'SasDatastoreSecrets'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword secrets: Required. [Required] Storage container secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.SasDatastoreSecrets
        """
        super(SasDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'Sas'  # type: str
        self.secrets = kwargs['secrets']


class SasDatastoreSecrets(DatastoreSecrets):
    """Datastore SAS secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar sas_token: Storage container SAS token.
    :vartype sas_token: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'sas_token': {'key': 'sasToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword sas_token: Storage container SAS token.
        :paramtype sas_token: str
        """
        super(SasDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'Sas'  # type: str
        self.sas_token = kwargs.get('sas_token', None)


class ServicePrincipalDatastoreCredentials(DatastoreCredentials):
    """Service Principal datastore credentials configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar credentials_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate",
     "None", "Sas", "ServicePrincipal", "KerberosKeytab", "KerberosPassword".
    :vartype credentials_type: str or ~azure.mgmt.machinelearningservices.models.CredentialsType
    :ivar authority_url: Authority URL used for authentication.
    :vartype authority_url: str
    :ivar client_id: Required. [Required] Service principal client ID.
    :vartype client_id: str
    :ivar resource_url: Resource the service principal has access to.
    :vartype resource_url: str
    :ivar secrets: Required. [Required] Service principal secrets.
    :vartype secrets: ~azure.mgmt.machinelearningservices.models.ServicePrincipalDatastoreSecrets
    :ivar tenant_id: Required. [Required] ID of the tenant to which the service principal belongs.
    :vartype tenant_id: str
    """

    _validation = {
        'credentials_type': {'required': True},
        'client_id': {'required': True},
        'secrets': {'required': True},
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'credentials_type': {'key': 'credentialsType', 'type': 'str'},
        'authority_url': {'key': 'authorityUrl', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'resource_url': {'key': 'resourceUrl', 'type': 'str'},
        'secrets': {'key': 'secrets', 'type': 'ServicePrincipalDatastoreSecrets'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword authority_url: Authority URL used for authentication.
        :paramtype authority_url: str
        :keyword client_id: Required. [Required] Service principal client ID.
        :paramtype client_id: str
        :keyword resource_url: Resource the service principal has access to.
        :paramtype resource_url: str
        :keyword secrets: Required. [Required] Service principal secrets.
        :paramtype secrets: ~azure.mgmt.machinelearningservices.models.ServicePrincipalDatastoreSecrets
        :keyword tenant_id: Required. [Required] ID of the tenant to which the service principal
         belongs.
        :paramtype tenant_id: str
        """
        super(ServicePrincipalDatastoreCredentials, self).__init__(**kwargs)
        self.credentials_type = 'ServicePrincipal'  # type: str
        self.authority_url = kwargs.get('authority_url', None)
        self.client_id = kwargs['client_id']
        self.resource_url = kwargs.get('resource_url', None)
        self.secrets = kwargs['secrets']
        self.tenant_id = kwargs['tenant_id']


class ServicePrincipalDatastoreSecrets(DatastoreSecrets):
    """Datastore Service Principal secrets.

    All required parameters must be populated in order to send to Azure.

    :ivar secrets_type: Required. [Required] Credential type used to authentication with
     storage.Constant filled by server. Possible values include: "AccountKey", "Certificate", "Sas",
     "ServicePrincipal", "KerberosPassword", "KerberosKeytab".
    :vartype secrets_type: str or ~azure.mgmt.machinelearningservices.models.SecretsType
    :ivar client_secret: Service principal secret.
    :vartype client_secret: str
    """

    _validation = {
        'secrets_type': {'required': True},
    }

    _attribute_map = {
        'secrets_type': {'key': 'secretsType', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword client_secret: Service principal secret.
        :paramtype client_secret: str
        """
        super(ServicePrincipalDatastoreSecrets, self).__init__(**kwargs)
        self.secrets_type = 'ServicePrincipal'  # type: str
        self.client_secret = kwargs.get('client_secret', None)


class Sku(msrest.serialization.Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the SKU. Ex - P3. It is typically a letter+number code.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the SKU. Ex - P3. It is typically a letter+number code.
        :paramtype name: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
         "Standard", "Premium".
        :paramtype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        """
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs.get('tier', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)


class SkuCapacity(msrest.serialization.Model):
    """SKU capacity information.

    :ivar default: Gets or sets the default capacity.
    :vartype default: int
    :ivar maximum: Gets or sets the maximum.
    :vartype maximum: int
    :ivar minimum: Gets or sets the minimum.
    :vartype minimum: int
    :ivar scale_type: Gets or sets the type of the scale. Possible values include: "Automatic",
     "Manual", "None".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.SkuScaleType
    """

    _attribute_map = {
        'default': {'key': 'default', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'minimum': {'key': 'minimum', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword default: Gets or sets the default capacity.
        :paramtype default: int
        :keyword maximum: Gets or sets the maximum.
        :paramtype maximum: int
        :keyword minimum: Gets or sets the minimum.
        :paramtype minimum: int
        :keyword scale_type: Gets or sets the type of the scale. Possible values include: "Automatic",
         "Manual", "None".
        :paramtype scale_type: str or ~azure.mgmt.machinelearningservices.models.SkuScaleType
        """
        super(SkuCapacity, self).__init__(**kwargs)
        self.default = kwargs.get('default', 0)
        self.maximum = kwargs.get('maximum', 0)
        self.minimum = kwargs.get('minimum', 0)
        self.scale_type = kwargs.get('scale_type', None)


class SkuResource(msrest.serialization.Model):
    """Fulfills ARM Contract requirement to list all available SKUS for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar capacity: Gets or sets the Sku Capacity.
    :vartype capacity: ~azure.mgmt.machinelearningservices.models.SkuCapacity
    :ivar resource_type: The resource type name.
    :vartype resource_type: str
    :ivar sku: Gets or sets the Sku.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.SkuSetting
    """

    _validation = {
        'resource_type': {'readonly': True},
    }

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuSetting'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword capacity: Gets or sets the Sku Capacity.
        :paramtype capacity: ~azure.mgmt.machinelearningservices.models.SkuCapacity
        :keyword sku: Gets or sets the Sku.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.SkuSetting
        """
        super(SkuResource, self).__init__(**kwargs)
        self.capacity = kwargs.get('capacity', None)
        self.resource_type = None
        self.sku = kwargs.get('sku', None)


class SkuResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of SkuResource entities.

    :ivar next_link: The link to the next page of SkuResource objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type SkuResource.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.SkuResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[SkuResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of SkuResource objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type SkuResource.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.SkuResource]
        """
        super(SkuResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class SkuSetting(msrest.serialization.Model):
    """SkuSetting fulfills the need for stripped down SKU info in ARM contract.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. [Required] The name of the SKU. Ex - P3. It is typically a letter+number
     code.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
    """

    _validation = {
        'name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. [Required] The name of the SKU. Ex - P3. It is typically a
         letter+number code.
        :paramtype name: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
         "Standard", "Premium".
        :paramtype tier: str or ~azure.mgmt.machinelearningservices.models.SkuTier
        """
        super(SkuSetting, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs.get('tier', None)


class StackEnsembleSettings(msrest.serialization.Model):
    """Advances setting to customize StackEnsemble run.

    :ivar stack_meta_learner_k_wargs: Optional parameters to pass to the initializer of the
     meta-learner.
    :vartype stack_meta_learner_k_wargs: any
    :ivar stack_meta_learner_train_percentage: Specifies the proportion of the training set (when
     choosing train and validation type of training) to be reserved for training the meta-learner.
     Default value is 0.2.
    :vartype stack_meta_learner_train_percentage: float
    :ivar stack_meta_learner_type: The meta-learner is a model trained on the output of the
     individual heterogeneous models. Possible values include: "None", "LogisticRegression",
     "LogisticRegressionCV", "LightGBMClassifier", "ElasticNet", "ElasticNetCV",
     "LightGBMRegressor", "LinearRegression".
    :vartype stack_meta_learner_type: str or
     ~azure.mgmt.machinelearningservices.models.StackMetaLearnerType
    """

    _attribute_map = {
        'stack_meta_learner_k_wargs': {'key': 'stackMetaLearnerKWargs', 'type': 'object'},
        'stack_meta_learner_train_percentage': {'key': 'stackMetaLearnerTrainPercentage', 'type': 'float'},
        'stack_meta_learner_type': {'key': 'stackMetaLearnerType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword stack_meta_learner_k_wargs: Optional parameters to pass to the initializer of the
         meta-learner.
        :paramtype stack_meta_learner_k_wargs: any
        :keyword stack_meta_learner_train_percentage: Specifies the proportion of the training set
         (when choosing train and validation type of training) to be reserved for training the
         meta-learner. Default value is 0.2.
        :paramtype stack_meta_learner_train_percentage: float
        :keyword stack_meta_learner_type: The meta-learner is a model trained on the output of the
         individual heterogeneous models. Possible values include: "None", "LogisticRegression",
         "LogisticRegressionCV", "LightGBMClassifier", "ElasticNet", "ElasticNetCV",
         "LightGBMRegressor", "LinearRegression".
        :paramtype stack_meta_learner_type: str or
         ~azure.mgmt.machinelearningservices.models.StackMetaLearnerType
        """
        super(StackEnsembleSettings, self).__init__(**kwargs)
        self.stack_meta_learner_k_wargs = kwargs.get('stack_meta_learner_k_wargs', None)
        self.stack_meta_learner_train_percentage = kwargs.get('stack_meta_learner_train_percentage', 0.2)
        self.stack_meta_learner_type = kwargs.get('stack_meta_learner_type', None)


class SweepJob(JobBaseDetails):
    """Sweep job definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar compute_id: ARM resource ID of the compute resource.
    :vartype compute_id: str
    :ivar display_name: Display name of job.
    :vartype display_name: str
    :ivar experiment_name: The name of the experiment the job belongs to. If not set, the job is
     placed in the "Default" experiment.
    :vartype experiment_name: str
    :ivar identity: Identity configuration. If set, this should be one of AmlToken,
     ManagedIdentity, UserIdentity or null.
     Defaults to AmlToken if null.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar job_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "AutoML", "Command", "Sweep", "Pipeline".
    :vartype job_type: str or ~azure.mgmt.machinelearningservices.models.JobType
    :ivar schedule: Schedule definition of job.
     If no schedule is provided, the job is run once and immediately after submission.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
    :ivar services: List of JobEndpoints.
     For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
    :vartype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown", "Scheduled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar early_termination: Early termination policies enable canceling poor-performing runs
     before they complete.
    :vartype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
    :ivar inputs: Mapping of input data bindings used in the job.
    :vartype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar limits: Sweep Job limit.
    :vartype limits: ~azure.mgmt.machinelearningservices.models.SweepJobLimits
    :ivar objective: Required. [Required] Optimization objective.
    :vartype objective: ~azure.mgmt.machinelearningservices.models.Objective
    :ivar outputs: Mapping of output data bindings used in the job.
    :vartype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
    :ivar sampling_algorithm: Required. [Required] The hyperparameter sampling algorithm.
    :vartype sampling_algorithm: ~azure.mgmt.machinelearningservices.models.SamplingAlgorithm
    :ivar search_space: Required. [Required] A dictionary containing each parameter and its
     distribution. The dictionary key is the name of the parameter.
    :vartype search_space: any
    :ivar trial: Required. [Required] Trial component definition.
    :vartype trial: ~azure.mgmt.machinelearningservices.models.TrialComponent
    """

    _validation = {
        'job_type': {'required': True},
        'status': {'readonly': True},
        'objective': {'required': True},
        'sampling_algorithm': {'required': True},
        'search_space': {'required': True},
        'trial': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'compute_id': {'key': 'computeId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'experiment_name': {'key': 'experimentName', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityConfiguration'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'ScheduleBase'},
        'services': {'key': 'services', 'type': '{JobService}'},
        'status': {'key': 'status', 'type': 'str'},
        'early_termination': {'key': 'earlyTermination', 'type': 'EarlyTerminationPolicy'},
        'inputs': {'key': 'inputs', 'type': '{JobInput}'},
        'limits': {'key': 'limits', 'type': 'SweepJobLimits'},
        'objective': {'key': 'objective', 'type': 'Objective'},
        'outputs': {'key': 'outputs', 'type': '{JobOutput}'},
        'sampling_algorithm': {'key': 'samplingAlgorithm', 'type': 'SamplingAlgorithm'},
        'search_space': {'key': 'searchSpace', 'type': 'object'},
        'trial': {'key': 'trial', 'type': 'TrialComponent'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword compute_id: ARM resource ID of the compute resource.
        :paramtype compute_id: str
        :keyword display_name: Display name of job.
        :paramtype display_name: str
        :keyword experiment_name: The name of the experiment the job belongs to. If not set, the job is
         placed in the "Default" experiment.
        :paramtype experiment_name: str
        :keyword identity: Identity configuration. If set, this should be one of AmlToken,
         ManagedIdentity, UserIdentity or null.
         Defaults to AmlToken if null.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityConfiguration
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword schedule: Schedule definition of job.
         If no schedule is provided, the job is run once and immediately after submission.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.ScheduleBase
        :keyword services: List of JobEndpoints.
         For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :paramtype services: dict[str, ~azure.mgmt.machinelearningservices.models.JobService]
        :keyword early_termination: Early termination policies enable canceling poor-performing runs
         before they complete.
        :paramtype early_termination: ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicy
        :keyword inputs: Mapping of input data bindings used in the job.
        :paramtype inputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword limits: Sweep Job limit.
        :paramtype limits: ~azure.mgmt.machinelearningservices.models.SweepJobLimits
        :keyword objective: Required. [Required] Optimization objective.
        :paramtype objective: ~azure.mgmt.machinelearningservices.models.Objective
        :keyword outputs: Mapping of output data bindings used in the job.
        :paramtype outputs: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutput]
        :keyword sampling_algorithm: Required. [Required] The hyperparameter sampling algorithm.
        :paramtype sampling_algorithm: ~azure.mgmt.machinelearningservices.models.SamplingAlgorithm
        :keyword search_space: Required. [Required] A dictionary containing each parameter and its
         distribution. The dictionary key is the name of the parameter.
        :paramtype search_space: any
        :keyword trial: Required. [Required] Trial component definition.
        :paramtype trial: ~azure.mgmt.machinelearningservices.models.TrialComponent
        """
        super(SweepJob, self).__init__(**kwargs)
        self.job_type = 'Sweep'  # type: str
        self.early_termination = kwargs.get('early_termination', None)
        self.inputs = kwargs.get('inputs', None)
        self.limits = kwargs.get('limits', None)
        self.objective = kwargs['objective']
        self.outputs = kwargs.get('outputs', None)
        self.sampling_algorithm = kwargs['sampling_algorithm']
        self.search_space = kwargs['search_space']
        self.trial = kwargs['trial']


class SweepJobLimits(JobLimits):
    """Sweep Job limit class.

    All required parameters must be populated in order to send to Azure.

    :ivar job_limits_type: Required. [Required] JobLimit type.Constant filled by server. Possible
     values include: "Command", "Sweep".
    :vartype job_limits_type: str or ~azure.mgmt.machinelearningservices.models.JobLimitsType
    :ivar timeout: The max run duration in ISO 8601 format, after which the job will be cancelled.
     Only supports duration with precision as low as Seconds.
    :vartype timeout: ~datetime.timedelta
    :ivar max_concurrent_trials: Sweep Job max concurrent trials.
    :vartype max_concurrent_trials: int
    :ivar max_total_trials: Sweep Job max total trials.
    :vartype max_total_trials: int
    :ivar trial_timeout: Sweep Job Trial timeout value.
    :vartype trial_timeout: ~datetime.timedelta
    """

    _validation = {
        'job_limits_type': {'required': True},
    }

    _attribute_map = {
        'job_limits_type': {'key': 'jobLimitsType', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
        'max_concurrent_trials': {'key': 'maxConcurrentTrials', 'type': 'int'},
        'max_total_trials': {'key': 'maxTotalTrials', 'type': 'int'},
        'trial_timeout': {'key': 'trialTimeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword timeout: The max run duration in ISO 8601 format, after which the job will be
         cancelled. Only supports duration with precision as low as Seconds.
        :paramtype timeout: ~datetime.timedelta
        :keyword max_concurrent_trials: Sweep Job max concurrent trials.
        :paramtype max_concurrent_trials: int
        :keyword max_total_trials: Sweep Job max total trials.
        :paramtype max_total_trials: int
        :keyword trial_timeout: Sweep Job Trial timeout value.
        :paramtype trial_timeout: ~datetime.timedelta
        """
        super(SweepJobLimits, self).__init__(**kwargs)
        self.job_limits_type = 'Sweep'  # type: str
        self.max_concurrent_trials = kwargs.get('max_concurrent_trials', None)
        self.max_total_trials = kwargs.get('max_total_trials', None)
        self.trial_timeout = kwargs.get('trial_timeout', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.machinelearningservices.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class TableVerticalDataSettings(DataSettings):
    """Class for data inputs.

    All required parameters must be populated in order to send to Azure.

    :ivar target_column_name: Required. [Required] Target column name: This is prediction values
     column.
     Also known as label column name in context of classification tasks.
    :vartype target_column_name: str
    :ivar test_data: Test data input.
    :vartype test_data: ~azure.mgmt.machinelearningservices.models.TestDataSettings
    :ivar training_data: Required. [Required] Training data input.
    :vartype training_data: ~azure.mgmt.machinelearningservices.models.TrainingDataSettings
    :ivar validation_data: Validation data inputs.
    :vartype validation_data:
     ~azure.mgmt.machinelearningservices.models.TableVerticalValidationDataSettings
    :ivar weight_column_name: The name of the sample weight column. Automated ML supports a
     weighted column as an input, causing rows in the data to be weighted up or down.
    :vartype weight_column_name: str
    """

    _validation = {
        'target_column_name': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'training_data': {'required': True},
    }

    _attribute_map = {
        'target_column_name': {'key': 'targetColumnName', 'type': 'str'},
        'test_data': {'key': 'testData', 'type': 'TestDataSettings'},
        'training_data': {'key': 'trainingData', 'type': 'TrainingDataSettings'},
        'validation_data': {'key': 'validationData', 'type': 'TableVerticalValidationDataSettings'},
        'weight_column_name': {'key': 'weightColumnName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword target_column_name: Required. [Required] Target column name: This is prediction values
         column.
         Also known as label column name in context of classification tasks.
        :paramtype target_column_name: str
        :keyword test_data: Test data input.
        :paramtype test_data: ~azure.mgmt.machinelearningservices.models.TestDataSettings
        :keyword training_data: Required. [Required] Training data input.
        :paramtype training_data: ~azure.mgmt.machinelearningservices.models.TrainingDataSettings
        :keyword validation_data: Validation data inputs.
        :paramtype validation_data:
         ~azure.mgmt.machinelearningservices.models.TableVerticalValidationDataSettings
        :keyword weight_column_name: The name of the sample weight column. Automated ML supports a
         weighted column as an input, causing rows in the data to be weighted up or down.
        :paramtype weight_column_name: str
        """
        super(TableVerticalDataSettings, self).__init__(**kwargs)
        self.validation_data = kwargs.get('validation_data', None)
        self.weight_column_name = kwargs.get('weight_column_name', None)


class TableVerticalFeaturizationSettings(FeaturizationSettings):
    """Featurization Configuration.

    :ivar dataset_language: Dataset language, useful for the text data.
    :vartype dataset_language: str
    :ivar blocked_transformers: These transformers shall not be used in featurization.
    :vartype blocked_transformers: list[str]
    :ivar column_name_and_types: Dictionary of column name and its type (int, float, string,
     datetime etc).
    :vartype column_name_and_types: dict[str, str]
    :ivar drop_columns: Columns to be dropped from data during featurization.
    :vartype drop_columns: list[str]
    :ivar enable_dnn_featurization: Determines whether to use Dnn based featurizers for data
     featurization.
    :vartype enable_dnn_featurization: bool
    :ivar mode: Featurization mode - User can keep the default 'Auto' mode and AutoML will take
     care of necessary transformation of the data in featurization phase.
     If 'Off' is selected then no featurization is done.
     If 'Custom' is selected then user can specify additional inputs to customize how featurization
     is done. Possible values include: "Auto", "Custom", "Off".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.FeaturizationMode
    :ivar transformer_params: User can specify additional transformers to be used along with the
     columns to which it would be applied and parameters for the transformer constructor.
    :vartype transformer_params: dict[str,
     list[~azure.mgmt.machinelearningservices.models.ColumnTransformer]]
    """

    _attribute_map = {
        'dataset_language': {'key': 'datasetLanguage', 'type': 'str'},
        'blocked_transformers': {'key': 'blockedTransformers', 'type': '[str]'},
        'column_name_and_types': {'key': 'columnNameAndTypes', 'type': '{str}'},
        'drop_columns': {'key': 'dropColumns', 'type': '[str]'},
        'enable_dnn_featurization': {'key': 'enableDnnFeaturization', 'type': 'bool'},
        'mode': {'key': 'mode', 'type': 'str'},
        'transformer_params': {'key': 'transformerParams', 'type': '{[ColumnTransformer]}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword dataset_language: Dataset language, useful for the text data.
        :paramtype dataset_language: str
        :keyword blocked_transformers: These transformers shall not be used in featurization.
        :paramtype blocked_transformers: list[str]
        :keyword column_name_and_types: Dictionary of column name and its type (int, float, string,
         datetime etc).
        :paramtype column_name_and_types: dict[str, str]
        :keyword drop_columns: Columns to be dropped from data during featurization.
        :paramtype drop_columns: list[str]
        :keyword enable_dnn_featurization: Determines whether to use Dnn based featurizers for data
         featurization.
        :paramtype enable_dnn_featurization: bool
        :keyword mode: Featurization mode - User can keep the default 'Auto' mode and AutoML will take
         care of necessary transformation of the data in featurization phase.
         If 'Off' is selected then no featurization is done.
         If 'Custom' is selected then user can specify additional inputs to customize how featurization
         is done. Possible values include: "Auto", "Custom", "Off".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.FeaturizationMode
        :keyword transformer_params: User can specify additional transformers to be used along with the
         columns to which it would be applied and parameters for the transformer constructor.
        :paramtype transformer_params: dict[str,
         list[~azure.mgmt.machinelearningservices.models.ColumnTransformer]]
        """
        super(TableVerticalFeaturizationSettings, self).__init__(**kwargs)
        self.blocked_transformers = kwargs.get('blocked_transformers', None)
        self.column_name_and_types = kwargs.get('column_name_and_types', None)
        self.drop_columns = kwargs.get('drop_columns', None)
        self.enable_dnn_featurization = kwargs.get('enable_dnn_featurization', False)
        self.mode = kwargs.get('mode', None)
        self.transformer_params = kwargs.get('transformer_params', None)


class TableVerticalLimitSettings(msrest.serialization.Model):
    """Job execution constraints.

    :ivar enable_early_termination: Enable early termination, determines whether or not if
     AutoMLJob will terminate early if there is no score improvement in last 20 iterations.
    :vartype enable_early_termination: bool
    :ivar exit_score: Exit score for the AutoML job.
    :vartype exit_score: float
    :ivar max_concurrent_trials: Maximum Concurrent iterations.
    :vartype max_concurrent_trials: int
    :ivar max_cores_per_trial: Max cores per iteration.
    :vartype max_cores_per_trial: int
    :ivar max_trials: Number of iterations.
    :vartype max_trials: int
    :ivar timeout: AutoML job timeout.
    :vartype timeout: ~datetime.timedelta
    :ivar trial_timeout: Iteration timeout.
    :vartype trial_timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'enable_early_termination': {'key': 'enableEarlyTermination', 'type': 'bool'},
        'exit_score': {'key': 'exitScore', 'type': 'float'},
        'max_concurrent_trials': {'key': 'maxConcurrentTrials', 'type': 'int'},
        'max_cores_per_trial': {'key': 'maxCoresPerTrial', 'type': 'int'},
        'max_trials': {'key': 'maxTrials', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
        'trial_timeout': {'key': 'trialTimeout', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword enable_early_termination: Enable early termination, determines whether or not if
         AutoMLJob will terminate early if there is no score improvement in last 20 iterations.
        :paramtype enable_early_termination: bool
        :keyword exit_score: Exit score for the AutoML job.
        :paramtype exit_score: float
        :keyword max_concurrent_trials: Maximum Concurrent iterations.
        :paramtype max_concurrent_trials: int
        :keyword max_cores_per_trial: Max cores per iteration.
        :paramtype max_cores_per_trial: int
        :keyword max_trials: Number of iterations.
        :paramtype max_trials: int
        :keyword timeout: AutoML job timeout.
        :paramtype timeout: ~datetime.timedelta
        :keyword trial_timeout: Iteration timeout.
        :paramtype trial_timeout: ~datetime.timedelta
        """
        super(TableVerticalLimitSettings, self).__init__(**kwargs)
        self.enable_early_termination = kwargs.get('enable_early_termination', True)
        self.exit_score = kwargs.get('exit_score', None)
        self.max_concurrent_trials = kwargs.get('max_concurrent_trials', 1)
        self.max_cores_per_trial = kwargs.get('max_cores_per_trial', -1)
        self.max_trials = kwargs.get('max_trials', 1000)
        self.timeout = kwargs.get('timeout', "PT6H")
        self.trial_timeout = kwargs.get('trial_timeout', "PT30M")


class TableVerticalValidationDataSettings(ValidationDataSettings):
    """Validation settings for AutoML Table vertical tasks - Classification/Regression/Forecasting.

    :ivar data: Validation data MLTable.
    :vartype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar validation_data_size: The fraction of training dataset that needs to be set aside for
     validation purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype validation_data_size: float
    :ivar cv_split_column_names: Columns to use for CVSplit data.
    :vartype cv_split_column_names: list[str]
    :ivar n_cross_validations: Number of cross validation folds to be applied on training dataset
     when validation dataset is not provided.
    :vartype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'MLTableJobInput'},
        'validation_data_size': {'key': 'validationDataSize', 'type': 'float'},
        'cv_split_column_names': {'key': 'cvSplitColumnNames', 'type': '[str]'},
        'n_cross_validations': {'key': 'nCrossValidations', 'type': 'NCrossValidations'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data: Validation data MLTable.
        :paramtype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword validation_data_size: The fraction of training dataset that needs to be set aside for
         validation purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype validation_data_size: float
        :keyword cv_split_column_names: Columns to use for CVSplit data.
        :paramtype cv_split_column_names: list[str]
        :keyword n_cross_validations: Number of cross validation folds to be applied on training
         dataset
         when validation dataset is not provided.
        :paramtype n_cross_validations: ~azure.mgmt.machinelearningservices.models.NCrossValidations
        """
        super(TableVerticalValidationDataSettings, self).__init__(**kwargs)
        self.cv_split_column_names = kwargs.get('cv_split_column_names', None)
        self.n_cross_validations = kwargs.get('n_cross_validations', None)


class TargetUtilizationScaleSettings(OnlineScaleSettings):
    """TargetUtilizationScaleSettings.

    All required parameters must be populated in order to send to Azure.

    :ivar scale_type: Required. [Required] Type of deployment scaling algorithm.Constant filled by
     server. Possible values include: "Default", "TargetUtilization".
    :vartype scale_type: str or ~azure.mgmt.machinelearningservices.models.ScaleType
    :ivar max_instances: The maximum number of instances that the deployment can scale to. The
     quota will be reserved for max_instances.
    :vartype max_instances: int
    :ivar min_instances: The minimum number of instances to always be present.
    :vartype min_instances: int
    :ivar polling_interval: The polling interval in ISO 8691 format. Only supports duration with
     precision as low as Seconds.
    :vartype polling_interval: ~datetime.timedelta
    :ivar target_utilization_percentage: Target CPU usage for the autoscaler.
    :vartype target_utilization_percentage: int
    """

    _validation = {
        'scale_type': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
        'max_instances': {'key': 'maxInstances', 'type': 'int'},
        'min_instances': {'key': 'minInstances', 'type': 'int'},
        'polling_interval': {'key': 'pollingInterval', 'type': 'duration'},
        'target_utilization_percentage': {'key': 'targetUtilizationPercentage', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_instances: The maximum number of instances that the deployment can scale to. The
         quota will be reserved for max_instances.
        :paramtype max_instances: int
        :keyword min_instances: The minimum number of instances to always be present.
        :paramtype min_instances: int
        :keyword polling_interval: The polling interval in ISO 8691 format. Only supports duration with
         precision as low as Seconds.
        :paramtype polling_interval: ~datetime.timedelta
        :keyword target_utilization_percentage: Target CPU usage for the autoscaler.
        :paramtype target_utilization_percentage: int
        """
        super(TargetUtilizationScaleSettings, self).__init__(**kwargs)
        self.scale_type = 'TargetUtilization'  # type: str
        self.max_instances = kwargs.get('max_instances', 1)
        self.min_instances = kwargs.get('min_instances', 1)
        self.polling_interval = kwargs.get('polling_interval', "PT1S")
        self.target_utilization_percentage = kwargs.get('target_utilization_percentage', 70)


class TensorFlow(DistributionConfiguration):
    """TensorFlow distribution configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar distribution_type: Required. [Required] Specifies the type of distribution
     framework.Constant filled by server. Possible values include: "PyTorch", "TensorFlow", "Mpi".
    :vartype distribution_type: str or ~azure.mgmt.machinelearningservices.models.DistributionType
    :ivar parameter_server_count: Number of parameter server tasks.
    :vartype parameter_server_count: int
    :ivar worker_count: Number of workers. If not specified, will default to the instance count.
    :vartype worker_count: int
    """

    _validation = {
        'distribution_type': {'required': True},
    }

    _attribute_map = {
        'distribution_type': {'key': 'distributionType', 'type': 'str'},
        'parameter_server_count': {'key': 'parameterServerCount', 'type': 'int'},
        'worker_count': {'key': 'workerCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword parameter_server_count: Number of parameter server tasks.
        :paramtype parameter_server_count: int
        :keyword worker_count: Number of workers. If not specified, will default to the instance count.
        :paramtype worker_count: int
        """
        super(TensorFlow, self).__init__(**kwargs)
        self.distribution_type = 'TensorFlow'  # type: str
        self.parameter_server_count = kwargs.get('parameter_server_count', 0)
        self.worker_count = kwargs.get('worker_count', None)


class TestDataSettings(msrest.serialization.Model):
    """Test data inputs.

    :ivar data: Test data MLTable.
    :vartype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    :ivar test_data_size: The fraction of test dataset that needs to be set aside for validation
     purpose.
     Values between (0.0 , 1.0)
     Applied when validation dataset is not provided.
    :vartype test_data_size: float
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'MLTableJobInput'},
        'test_data_size': {'key': 'testDataSize', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data: Test data MLTable.
        :paramtype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        :keyword test_data_size: The fraction of test dataset that needs to be set aside for validation
         purpose.
         Values between (0.0 , 1.0)
         Applied when validation dataset is not provided.
        :paramtype test_data_size: float
        """
        super(TestDataSettings, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.test_data_size = kwargs.get('test_data_size', None)


class TextClassification(AutoMLVertical, NlpVertical):
    """Text Classification task in AutoML NLP vertical.
NLP - Natural Language Processing.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Data inputs for AutoMLJob.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalDataSettings
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar primary_metric: Primary metric for Text-Classification task. Possible values include:
     "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
     "PrecisionScoreWeighted".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
    """

    _validation = {
        'task_type': {'required': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'NlpVerticalDataSettings'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'NlpVerticalFeaturizationSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'NlpVerticalLimitSettings'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Data inputs for AutoMLJob.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalDataSettings
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        :keyword primary_metric: Primary metric for Text-Classification task. Possible values include:
         "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
         "PrecisionScoreWeighted".
        :paramtype primary_metric: str or
         ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
        """
        super(TextClassification, self).__init__(**kwargs)
        self.data_settings = kwargs.get('data_settings', None)
        self.featurization_settings = kwargs.get('featurization_settings', None)
        self.limit_settings = kwargs.get('limit_settings', None)
        self.task_type = 'TextClassification'  # type: str
        self.primary_metric = kwargs.get('primary_metric', None)
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = 'TextClassification'  # type: str
        self.primary_metric = kwargs.get('primary_metric', None)


class TextClassificationMultilabel(AutoMLVertical, NlpVertical):
    """Text Classification Multilabel task in AutoML NLP vertical.
NLP - Natural Language Processing.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Data inputs for AutoMLJob.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalDataSettings
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar primary_metric: Primary metric for Text-Classification-Multilabel task.
     Currently only Accuracy is supported as primary metric, hence user need not set it explicitly.
     Possible values include: "AUCWeighted", "Accuracy", "NormMacroRecall",
     "AveragePrecisionScoreWeighted", "PrecisionScoreWeighted", "IOU".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationMultilabelPrimaryMetrics
    """

    _validation = {
        'task_type': {'required': True},
        'primary_metric': {'readonly': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'NlpVerticalDataSettings'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'NlpVerticalFeaturizationSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'NlpVerticalLimitSettings'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Data inputs for AutoMLJob.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalDataSettings
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        """
        super(TextClassificationMultilabel, self).__init__(**kwargs)
        self.data_settings = kwargs.get('data_settings', None)
        self.featurization_settings = kwargs.get('featurization_settings', None)
        self.limit_settings = kwargs.get('limit_settings', None)
        self.task_type = 'TextClassificationMultilabel'  # type: str
        self.primary_metric = None
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = 'TextClassificationMultilabel'  # type: str
        self.primary_metric = None


class TextNer(AutoMLVertical, NlpVertical):
    """Text-NER task in AutoML NLP vertical.
NER - Named Entity Recognition.
NLP - Natural Language Processing.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar data_settings: Data inputs for AutoMLJob.
    :vartype data_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalDataSettings
    :ivar featurization_settings: Featurization inputs needed for AutoML job.
    :vartype featurization_settings:
     ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
    :ivar limit_settings: Execution constraints for AutoMLJob.
    :vartype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
    :ivar log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
     "Info", "Warning", "Error", "Critical".
    :vartype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
    :ivar task_type: Required. [Required] Task type for AutoMLJob.Constant filled by server.
     Possible values include: "Classification", "Regression", "Forecasting", "ImageClassification",
     "ImageClassificationMultilabel", "ImageObjectDetection", "ImageInstanceSegmentation",
     "TextClassification", "TextClassificationMultilabel", "TextNER".
    :vartype task_type: str or ~azure.mgmt.machinelearningservices.models.TaskType
    :ivar primary_metric: Primary metric for Text-NER task.
     Only 'Accuracy' is supported for Text-NER, so user need not set this explicitly. Possible
     values include: "AUCWeighted", "Accuracy", "NormMacroRecall", "AveragePrecisionScoreWeighted",
     "PrecisionScoreWeighted".
    :vartype primary_metric: str or
     ~azure.mgmt.machinelearningservices.models.ClassificationPrimaryMetrics
    """

    _validation = {
        'task_type': {'required': True},
        'primary_metric': {'readonly': True},
    }

    _attribute_map = {
        'data_settings': {'key': 'dataSettings', 'type': 'NlpVerticalDataSettings'},
        'featurization_settings': {'key': 'featurizationSettings', 'type': 'NlpVerticalFeaturizationSettings'},
        'limit_settings': {'key': 'limitSettings', 'type': 'NlpVerticalLimitSettings'},
        'log_verbosity': {'key': 'logVerbosity', 'type': 'str'},
        'task_type': {'key': 'taskType', 'type': 'str'},
        'primary_metric': {'key': 'primaryMetric', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data_settings: Data inputs for AutoMLJob.
        :paramtype data_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalDataSettings
        :keyword featurization_settings: Featurization inputs needed for AutoML job.
        :paramtype featurization_settings:
         ~azure.mgmt.machinelearningservices.models.NlpVerticalFeaturizationSettings
        :keyword limit_settings: Execution constraints for AutoMLJob.
        :paramtype limit_settings: ~azure.mgmt.machinelearningservices.models.NlpVerticalLimitSettings
        :keyword log_verbosity: Log verbosity for the job. Possible values include: "NotSet", "Debug",
         "Info", "Warning", "Error", "Critical".
        :paramtype log_verbosity: str or ~azure.mgmt.machinelearningservices.models.LogVerbosity
        """
        super(TextNer, self).__init__(**kwargs)
        self.data_settings = kwargs.get('data_settings', None)
        self.featurization_settings = kwargs.get('featurization_settings', None)
        self.limit_settings = kwargs.get('limit_settings', None)
        self.task_type = 'TextNER'  # type: str
        self.primary_metric = None
        self.log_verbosity = kwargs.get('log_verbosity', None)
        self.task_type = 'TextNER'  # type: str
        self.primary_metric = None


class TrainingDataSettings(msrest.serialization.Model):
    """Training data input.

    All required parameters must be populated in order to send to Azure.

    :ivar data: Required. [Required] Training data MLTable.
    :vartype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
    """

    _validation = {
        'data': {'required': True},
    }

    _attribute_map = {
        'data': {'key': 'data', 'type': 'MLTableJobInput'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword data: Required. [Required] Training data MLTable.
        :paramtype data: ~azure.mgmt.machinelearningservices.models.MLTableJobInput
        """
        super(TrainingDataSettings, self).__init__(**kwargs)
        self.data = kwargs['data']


class TrainingSettings(msrest.serialization.Model):
    """Training related configuration.

    :ivar enable_dnn_training: Enable recommendation of DNN models.
    :vartype enable_dnn_training: bool
    :ivar enable_model_explainability: Flag to turn on explainability on best model.
    :vartype enable_model_explainability: bool
    :ivar enable_onnx_compatible_models: Flag for enabling onnx compatible models.
    :vartype enable_onnx_compatible_models: bool
    :ivar enable_stack_ensemble: Enable stack ensemble run.
    :vartype enable_stack_ensemble: bool
    :ivar enable_vote_ensemble: Enable voting ensemble run.
    :vartype enable_vote_ensemble: bool
    :ivar ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
     generation, multiple fitted models from the previous child runs are downloaded.
     Configure this parameter with a higher value than 300 secs, if more time is needed.
    :vartype ensemble_model_download_timeout: ~datetime.timedelta
    :ivar stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
    :vartype stack_ensemble_settings:
     ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
    """

    _attribute_map = {
        'enable_dnn_training': {'key': 'enableDnnTraining', 'type': 'bool'},
        'enable_model_explainability': {'key': 'enableModelExplainability', 'type': 'bool'},
        'enable_onnx_compatible_models': {'key': 'enableOnnxCompatibleModels', 'type': 'bool'},
        'enable_stack_ensemble': {'key': 'enableStackEnsemble', 'type': 'bool'},
        'enable_vote_ensemble': {'key': 'enableVoteEnsemble', 'type': 'bool'},
        'ensemble_model_download_timeout': {'key': 'ensembleModelDownloadTimeout', 'type': 'duration'},
        'stack_ensemble_settings': {'key': 'stackEnsembleSettings', 'type': 'StackEnsembleSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword enable_dnn_training: Enable recommendation of DNN models.
        :paramtype enable_dnn_training: bool
        :keyword enable_model_explainability: Flag to turn on explainability on best model.
        :paramtype enable_model_explainability: bool
        :keyword enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :paramtype enable_onnx_compatible_models: bool
        :keyword enable_stack_ensemble: Enable stack ensemble run.
        :paramtype enable_stack_ensemble: bool
        :keyword enable_vote_ensemble: Enable voting ensemble run.
        :paramtype enable_vote_ensemble: bool
        :keyword ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model
         generation, multiple fitted models from the previous child runs are downloaded.
         Configure this parameter with a higher value than 300 secs, if more time is needed.
        :paramtype ensemble_model_download_timeout: ~datetime.timedelta
        :keyword stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :paramtype stack_ensemble_settings:
         ~azure.mgmt.machinelearningservices.models.StackEnsembleSettings
        """
        super(TrainingSettings, self).__init__(**kwargs)
        self.enable_dnn_training = kwargs.get('enable_dnn_training', False)
        self.enable_model_explainability = kwargs.get('enable_model_explainability', False)
        self.enable_onnx_compatible_models = kwargs.get('enable_onnx_compatible_models', False)
        self.enable_stack_ensemble = kwargs.get('enable_stack_ensemble', True)
        self.enable_vote_ensemble = kwargs.get('enable_vote_ensemble', True)
        self.ensemble_model_download_timeout = kwargs.get('ensemble_model_download_timeout', "PT5M")
        self.stack_ensemble_settings = kwargs.get('stack_ensemble_settings', None)


class TrialComponent(msrest.serialization.Model):
    """Trial component definition.

    All required parameters must be populated in order to send to Azure.

    :ivar code_id: ARM resource ID of the code asset.
    :vartype code_id: str
    :ivar command: Required. [Required] The command to execute on startup of the job. eg. "python
     train.py".
    :vartype command: str
    :ivar distribution: Distribution configuration of the job. If set, this should be one of Mpi,
     Tensorflow, PyTorch, or null.
    :vartype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
    :ivar environment_id: Required. [Required] The ARM resource ID of the Environment specification
     for the job.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables included in the job.
    :vartype environment_variables: dict[str, str]
    :ivar resources: Compute Resource configuration for the job.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
    """

    _validation = {
        'command': {'required': True, 'min_length': 1, 'pattern': r'[a-zA-Z0-9_]'},
        'environment_id': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'code_id': {'key': 'codeId', 'type': 'str'},
        'command': {'key': 'command', 'type': 'str'},
        'distribution': {'key': 'distribution', 'type': 'DistributionConfiguration'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'resources': {'key': 'resources', 'type': 'ResourceConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword code_id: ARM resource ID of the code asset.
        :paramtype code_id: str
        :keyword command: Required. [Required] The command to execute on startup of the job. eg.
         "python train.py".
        :paramtype command: str
        :keyword distribution: Distribution configuration of the job. If set, this should be one of
         Mpi, Tensorflow, PyTorch, or null.
        :paramtype distribution: ~azure.mgmt.machinelearningservices.models.DistributionConfiguration
        :keyword environment_id: Required. [Required] The ARM resource ID of the Environment
         specification for the job.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables included in the job.
        :paramtype environment_variables: dict[str, str]
        :keyword resources: Compute Resource configuration for the job.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.ResourceConfiguration
        """
        super(TrialComponent, self).__init__(**kwargs)
        self.code_id = kwargs.get('code_id', None)
        self.command = kwargs['command']
        self.distribution = kwargs.get('distribution', None)
        self.environment_id = kwargs['environment_id']
        self.environment_variables = kwargs.get('environment_variables', None)
        self.resources = kwargs.get('resources', None)


class TritonModelJobInput(JobInput, AssetJobInput):
    """TritonModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Literal", "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(TritonModelJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'TritonModel'  # type: str
        self.description = kwargs.get('description', None)
        self.job_input_type = 'TritonModel'  # type: str


class TritonModelJobOutput(JobOutput, AssetJobOutput):
    """TritonModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(TritonModelJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'TritonModel'  # type: str
        self.description = kwargs.get('description', None)
        self.job_output_type = 'TritonModel'  # type: str


class TruncationSelectionPolicy(EarlyTerminationPolicy):
    """Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.

    All required parameters must be populated in order to send to Azure.

    :ivar delay_evaluation: Number of intervals by which to delay the first evaluation.
    :vartype delay_evaluation: int
    :ivar evaluation_interval: Interval (number of runs) between policy evaluations.
    :vartype evaluation_interval: int
    :ivar policy_type: Required. [Required] Name of policy configuration.Constant filled by server.
     Possible values include: "Bandit", "MedianStopping", "TruncationSelection".
    :vartype policy_type: str or
     ~azure.mgmt.machinelearningservices.models.EarlyTerminationPolicyType
    :ivar truncation_percentage: The percentage of runs to cancel at each evaluation interval.
    :vartype truncation_percentage: int
    """

    _validation = {
        'policy_type': {'required': True},
    }

    _attribute_map = {
        'delay_evaluation': {'key': 'delayEvaluation', 'type': 'int'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'int'},
        'policy_type': {'key': 'policyType', 'type': 'str'},
        'truncation_percentage': {'key': 'truncationPercentage', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword delay_evaluation: Number of intervals by which to delay the first evaluation.
        :paramtype delay_evaluation: int
        :keyword evaluation_interval: Interval (number of runs) between policy evaluations.
        :paramtype evaluation_interval: int
        :keyword truncation_percentage: The percentage of runs to cancel at each evaluation interval.
        :paramtype truncation_percentage: int
        """
        super(TruncationSelectionPolicy, self).__init__(**kwargs)
        self.policy_type = 'TruncationSelection'  # type: str
        self.truncation_percentage = kwargs.get('truncation_percentage', 0)


class UriFileDataVersion(DataVersionBaseDetails):
    """uri-file data version entity.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "UriFile", "UriFolder", "MLTable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
     Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220201Preview.Assets.DataVersionBase.DataType.
    :vartype data_uri: str
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
         Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220201Preview.Assets.DataVersionBase.DataType.
        :paramtype data_uri: str
        """
        super(UriFileDataVersion, self).__init__(**kwargs)
        self.data_type = 'UriFile'  # type: str


class UriFileJobInput(JobInput, AssetJobInput):
    """UriFileJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Literal", "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(UriFileJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'UriFile'  # type: str
        self.description = kwargs.get('description', None)
        self.job_input_type = 'UriFile'  # type: str


class UriFileJobOutput(JobOutput, AssetJobOutput):
    """UriFileJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(UriFileJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'UriFile'  # type: str
        self.description = kwargs.get('description', None)
        self.job_output_type = 'UriFile'  # type: str


class UriFolderDataVersion(DataVersionBaseDetails):
    """uri-folder data version entity.

    All required parameters must be populated in order to send to Azure.

    :ivar description: The asset description text.
    :vartype description: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar is_archived: Is the asset archived?.
    :vartype is_archived: bool
    :ivar data_type: Required. [Required] Specifies the type of data.Constant filled by server.
     Possible values include: "UriFile", "UriFolder", "MLTable".
    :vartype data_type: str or ~azure.mgmt.machinelearningservices.models.DataType
    :ivar data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
     Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220201Preview.Assets.DataVersionBase.DataType.
    :vartype data_uri: str
    """

    _validation = {
        'data_type': {'required': True},
        'data_uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'is_archived': {'key': 'isArchived', 'type': 'bool'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'data_uri': {'key': 'dataUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword is_archived: Is the asset archived?.
        :paramtype is_archived: bool
        :keyword data_uri: Required. [Required] Uri of the data. Usage/meaning depends on
         Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20220201Preview.Assets.DataVersionBase.DataType.
        :paramtype data_uri: str
        """
        super(UriFolderDataVersion, self).__init__(**kwargs)
        self.data_type = 'UriFolder'  # type: str


class UriFolderJobInput(JobInput, AssetJobInput):
    """UriFolderJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. [Required] Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. [Required] Specifies the type of job.Constant filled by server.
     Possible values include: "Literal", "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. [Required] Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(UriFolderJobInput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs['uri']
        self.job_input_type = 'UriFolder'  # type: str
        self.description = kwargs.get('description', None)
        self.job_input_type = 'UriFolder'  # type: str


class UriFolderJobOutput(JobOutput, AssetJobOutput):
    """UriFolderJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. [Required] Specifies the type of job.Constant filled by
     server. Possible values include: "UriFile", "UriFolder", "MLTable", "CustomModel",
     "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(UriFolderJobOutput, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.uri = kwargs.get('uri', None)
        self.job_output_type = 'UriFolder'  # type: str
        self.description = kwargs.get('description', None)
        self.job_output_type = 'UriFolder'  # type: str


class UserAssignedIdentity(msrest.serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserIdentity(IdentityConfiguration):
    """User identity configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar identity_type: Required. [Required] Specifies the type of identity framework.Constant
     filled by server. Possible values include: "Managed", "AMLToken", "UserIdentity".
    :vartype identity_type: str or
     ~azure.mgmt.machinelearningservices.models.IdentityConfigurationType
    """

    _validation = {
        'identity_type': {'required': True},
    }

    _attribute_map = {
        'identity_type': {'key': 'identityType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserIdentity, self).__init__(**kwargs)
        self.identity_type = 'UserIdentity'  # type: str
