from tests.odm.models import Sample


async def test_sum(preset_documents, session):
    n = await Sample.find_many(Sample.integer == 1).sum(Sample.increment)

    assert n == 12

    n = await Sample.find_many(Sample.integer == 1).sum(
        Sample.increment, session=session
    )

    assert n == 12


async def test_sum_without_docs(session):
    n = await Sample.find_many(Sample.integer == 1).sum(Sample.increment)

    assert n is None

    n = await Sample.find_many(Sample.integer == 1).sum(
        Sample.increment, session=session
    )

    assert n is None


async def test_avg(preset_documents, session):
    n = await Sample.find_many(Sample.integer == 1).avg(Sample.increment)

    assert n == 4
    n = await Sample.find_many(Sample.integer == 1).avg(
        Sample.increment, session=session
    )

    assert n == 4


async def test_avg_without_docs(session):
    n = await Sample.find_many(Sample.integer == 1).avg(Sample.increment)

    assert n is None
    n = await Sample.find_many(Sample.integer == 1).avg(
        Sample.increment, session=session
    )

    assert n is None


async def test_max(preset_documents, session):
    n = await Sample.find_many(Sample.integer == 1).max(Sample.increment)

    assert n == 5

    n = await Sample.find_many(Sample.integer == 1).max(
        Sample.increment, session=session
    )

    assert n == 5


async def test_max_without_docs(session):
    n = await Sample.find_many(Sample.integer == 1).max(Sample.increment)

    assert n is None

    n = await Sample.find_many(Sample.integer == 1).max(
        Sample.increment, session=session
    )

    assert n is None


async def test_min(preset_documents, session):
    n = await Sample.find_many(Sample.integer == 1).min(Sample.increment)

    assert n == 3

    n = await Sample.find_many(Sample.integer == 1).min(
        Sample.increment, session=session
    )

    assert n == 3


async def test_min_without_docs(session):
    n = await Sample.find_many(Sample.integer == 1).min(Sample.increment)

    assert n is None

    n = await Sample.find_many(Sample.integer == 1).min(
        Sample.increment, session=session
    )

    assert n is None


async def test_all_sum(preset_documents, session):
    n = await Sample.sum(Sample.increment)

    assert n == 45

    n = await Sample.sum(Sample.increment, session=session)

    assert n == 45


async def test_all_sum_without_docs(session):
    n = await Sample.sum(Sample.increment)

    assert n is None

    n = await Sample.sum(Sample.increment, session=session)

    assert n is None


async def test_all_avg(preset_documents, session):
    n = await Sample.avg(Sample.increment)

    assert n == 4.5
    n = await Sample.avg(Sample.increment, session=session)

    assert n == 4.5


async def test_all_avg_without_docs(session):
    n = await Sample.avg(Sample.increment)

    assert n is None
    n = await Sample.avg(Sample.increment, session=session)

    assert n is None


async def test_all_max(preset_documents, session):
    n = await Sample.max(Sample.increment)

    assert n == 9

    n = await Sample.max(Sample.increment, session=session)

    assert n == 9


async def test_all_max_without_docs(session):
    n = await Sample.max(Sample.increment)

    assert n is None

    n = await Sample.max(Sample.increment, session=session)

    assert n is None


async def test_all_min(preset_documents, session):
    n = await Sample.min(Sample.increment)

    assert n == 0

    n = await Sample.min(Sample.increment, session=session)

    assert n == 0


async def test_all_min_without_docs(session):
    n = await Sample.min(Sample.increment)

    assert n is None

    n = await Sample.min(Sample.increment, session=session)

    assert n is None
