# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class EventTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.monitor.v1.events("AEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://monitor.twilio.com/v1/Events/AEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "actor_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "actor_type": "account",
                "description": null,
                "event_data": {
                    "friendly_name": {
                        "previous": "SubAccount Created at 2014-10-03 09:48 am",
                        "updated": "Mr. Friendly"
                    }
                },
                "event_date": "2014-10-03T16:48:25Z",
                "event_type": "account.updated",
                "links": {
                    "actor": "https://api.twilio.com/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                    "resource": "https://api.twilio.com/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                },
                "resource_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "resource_type": "account",
                "sid": "AEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "source": "api",
                "source_ip_address": "10.86.6.250",
                "url": "https://monitor.twilio.com/v1/Events/AEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.monitor.v1.events("AEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.monitor.v1.events.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://monitor.twilio.com/v1/Events',
        ))

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "events": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "actor_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "actor_type": "account",
                        "description": null,
                        "event_data": {
                            "friendly_name": {
                                "previous": "SubAccount Created at 2014-10-03 09:48 am",
                                "updated": "Mr. Friendly"
                            }
                        },
                        "event_date": "2014-10-03T16:48:25Z",
                        "event_type": "account.updated",
                        "links": {
                            "actor": "https://api.twilio.com/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "resource": "https://api.twilio.com/2010-04-01/Accounts/ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        },
                        "resource_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "resource_type": "account",
                        "sid": "AEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "source": "api",
                        "source_ip_address": "10.86.6.250",
                        "url": "https://monitor.twilio.com/v1/Events/AEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ],
                "meta": {
                    "first_page_url": "https://monitor.twilio.com/v1/Events?PageSize=50&Page=0",
                    "key": "events",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://monitor.twilio.com/v1/Events?PageSize=50&Page=0"
                }
            }
            '''
        ))

        actual = self.client.monitor.v1.events.list()

        self.assertIsNotNone(actual)

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "events": [],
                "meta": {
                    "first_page_url": "https://monitor.twilio.com/v1/Events?PageSize=50&Page=0",
                    "key": "events",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://monitor.twilio.com/v1/Events?PageSize=50&Page=0"
                }
            }
            '''
        ))

        actual = self.client.monitor.v1.events.list()

        self.assertIsNotNone(actual)
