# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class CurrentCallTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.preview.trusted_comms.current_calls().fetch(x_xcnam_sensitive_phone_number_from="x_xcnam_sensitive_phone_number_from", x_xcnam_sensitive_phone_number_to="x_xcnam_sensitive_phone_number_to")

        headers = {
            'X-Xcnam-Sensitive-Phone-Number-From': "x_xcnam_sensitive_phone_number_from",
            'X-Xcnam-Sensitive-Phone-Number-To': "x_xcnam_sensitive_phone_number_to",
        }
        self.holodeck.assert_has_request(Request(
            'get',
            'https://preview.twilio.com/TrustedComms/CurrentCall',
            headers=headers,
        ))

    def test_read_found_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "bg_color": "#fff",
                "caller": "Owl Bank",
                "created_at": "2019-05-01T20:00:00Z",
                "font_color": "#f22f46",
                "from": "+1500123",
                "logo": "https://www.twilio.com/marketing/bundles/company/img/logos/red/twilio-logo-red.png",
                "manager": "Twilio",
                "reason": "Hello Jhon, your bank appointment has been confirmed.",
                "shield_img": "https://www.twilio.com/marketing/bundles/company/img/badges/red/twilio-badge-red.png",
                "sid": "CQaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "status": "ringing",
                "to": "+1500456",
                "url": "https://preview.twilio.com/TrustedComms/CurrentCall",
                "use_case": "conversational"
            }
            '''
        ))

        actual = self.client.preview.trusted_comms.current_calls().fetch()

        self.assertIsNotNone(actual)
