% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colCounts.R, R/rowCounts.R
\name{colCounts,DelayedMatrix-method}
\alias{colCounts,DelayedMatrix-method}
\alias{rowCounts,DelayedMatrix-method}
\title{Count how often an element in a row (column) of a matrix-like object is
equal to a value}
\usage{
\S4method{colCounts}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  value = TRUE,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...
)

\S4method{rowCounts}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  value = TRUE,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{value}{The value to search for.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Returns a \code{\link{integer}} \code{\link{vector}} of length N (K).
}
\description{
Count how often an element in a row (column) of a matrix-like object is
equal to a value.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowCounts}
/ \code{matrixStats::colCounts}.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))
# A DelayedMatrix with a 'DataFrame' seed
dm_DF <- DelayedArray(S4Vectors::DataFrame(C1 = rep(1L, 5),
                                           C2 = as.integer((0:4) ^ 2),
                                           C3 = seq(-5L, -1L, 1L)))

colCounts(dm_matrix, value = 1)
# Only count those in the first 4 rows
colCounts(dm_matrix, rows = 1:4, value = 1)

rowCounts(dm_DF, value = 5)
# Only count those in the odd-numbered rows of the 2nd column
rowCounts(dm_DF, rows = seq(1, nrow(dm_DF), 2), cols = 2, value = 5)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowCounts}()} and
\code{matrixStats::\link[matrixStats:rowCounts]{colCounts}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For checks if any element is equal to a value, see
\code{\link[MatrixGenerics]{rowAnys}()}. To check if all elements are equal, see
\code{\link[MatrixGenerics]{rowAlls}()}.
}
}
\author{
Peter Hickey
}
