% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_multiple_branches_pseudotime}
\alias{plot_multiple_branches_pseudotime}
\title{Create a kinetic curves to demonstrate the bifurcation of gene expression along multiple branches}
\usage{
plot_multiple_branches_pseudotime(cds, branches, branches_name = NULL,
  min_expr = NULL, cell_size = 0.75, norm_method = c("vstExprs", "log"),
  nrow = NULL, ncol = 1, panel_order = NULL, color_by = "Branch",
  trend_formula = "~sm.ns(Pseudotime, df=3)", label_by_short_name = TRUE,
  TPM = FALSE, cores = 1)
}
\arguments{
\item{cds}{CellDataSet for the experiment (normally only the branching genes detected with BEAM)}

\item{branches}{The terminal branches (states) on the developmental tree you want to investigate.}

\item{branches_name}{Name (for example, cell type) of branches you believe the cells on the branches are associated with.}

\item{min_expr}{The minimum level of expression to show in the plot}

\item{cell_size}{A number how large the cells should be in the plot}

\item{norm_method}{Determines how to transform expression values prior to rendering}

\item{nrow}{the number of rows used when laying out the panels for each gene's expression}

\item{ncol}{the number of columns used when laying out the panels for each gene's expression}

\item{panel_order}{the order in which genes should be layed out (left-to-right, top-to-bottom)}

\item{color_by}{the cell attribute (e.g. the column of pData(cds)) to be used to color each cell}

\item{trend_formula}{the model formula to be used for fitting the expression trend over pseudotime}

\item{label_by_short_name}{label figure panels by gene_short_name (TRUE) or feature id (FALSE)}

\item{TPM}{Whether to convert the expression value into TPM values.}

\item{cores}{Number of cores to use when smoothing the expression curves shown in the heatmap.}
}
\value{
a ggplot2 plot object
}
\description{
Create a kinetic curves to demonstrate the bifurcation of gene expression along multiple branches
}
