% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_river.R
\name{plot_river}
\alias{plot_river}
\title{Plot a riverplot}
\usage{
plot_river(mut_matrix, condensed = FALSE)
}
\arguments{
\item{mut_matrix}{Matrix containing mutation counts.}

\item{condensed}{More condensed plotting format. Default = F.}
}
\value{
A ggplot object
}
\description{
Function to plot a SNV mutation matrix as a riverplot.
This is especially usefull when looking at a wide
mutational context
}
\examples{

## See the 'mut_matrix()' examples for how we obtained the
## mutation matrix information:
## Get regular matrix
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))

## Create heatmap of profile
plot_river(mut_mat[,c(1,4)])

## Get extended matrix
mut_mat_extended <- readRDS(system.file("states/mut_mat_data_extended.rds",
  package = "MutationalPatterns"
))

## Create heatmap of extended profile
plot_river(mut_mat_extended[,c(1,4)])

## Create condensed version of riverplot
plot_river(mut_mat_extended[,c(1,4)], condensed = TRUE)

}
\seealso{
\code{\link{mut_matrix}},
\code{\link{plot_96_profile}},
\code{\link{plot_profile_heatmap}}
}
