% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringQualityMetrics.R
\docType{methods}
\name{assessHousekeeping,RccSet-method}
\alias{assessHousekeeping,RccSet-method}
\alias{assessHousekeeping}
\title{assessHousekeeping}
\usage{
\S4method{assessHousekeeping}{RccSet}(rccSet, hk, covar, annotate = TRUE,
  plot = TRUE, digits = 2)
}
\arguments{
\item{rccSet}{An RccSet object}

\item{hk}{Either a boolean vector of length nrow(exprs(rccSet)) or a numeric vector of indices
which genes in exprs(rccSet) are housekeeping genes}

\item{covar}{character; colname in fData(rccSet) that can be used to label genes by a category of interest}

\item{annotate}{Scalar boolean; if TRUE (default), probes will be "annotated" using the "GeneName" column in the fData(rccSet) slot}

\item{plot}{Scalar boolean, plot pairwise relationships ?}

\item{digits}{Scalar integer, the number of decimal places}
}
\value{
A dataframe with one row per housekeeping genes and several columns with metrics suggested to
assess performance of defined housekeeping genes.
}
\description{
Assess correlation and variance/variability of housekeeping genes
}
\details{
Pairwise correlations of all defined housekeeping genes will be assessed and pairwise scatterplots will be generated. This function does not only
output pairwise correlation coefficients, but also - for each housekeeping gene - the variance, the interquartile range (IQR) and median expression
level across all samples in the experiment.
}
\author{
Dorothee Nickles
}
