#' Transforms output of [read_clip()] into data frame.
#'
#' Transforms clipped content into a data frame by putting
#' [read_clip()] output by using [read.table()].
#'
#' @param x Defaults to reading from the clipboard, but can be substituted by a
#'   character vector already generated by [read_clip()].
#' @param \ldots Options to pass to [read.table()]. The following
#'   [read.table()] arguments will be passed by default, but can be
#'   overridden by specifying them when calling `read_clip_tbl`: \describe{
#'   \item{`header`}{`TRUE`}
#'   \item{`sep`}{`"\t"`}
#'   \item{`row.names`}{`1`}
#'   \item{`stringsAsFactors`}{`FALSE`}
#'   \item{`na.strings`}{`c("NA", "")`}
#'   \item{`strip.white`}{`TRUE`} }
#'
#' @return A data frame with the contents of the clipboard. If the system
#'   clipboard is empty, returns `NULL`
#'
#' @export
read_clip_tbl <- function(x = read_clip(), ...) {
  if (is.null(x))
    return(NULL)

  .dots <- list(...)
  .dots$file <- textConnection(paste0(x, collapse = "\n"))

  if (is.null(.dots$header))
    .dots$header <- TRUE
  if (is.null(.dots$row.names)) {
    if (substr(x[1], 1, 1) == "\t") {
      .dots$row.names <- 1
    } else {
    .dots$row.names <- NULL
    }
  }
  if (is.null(.dots$sep))
    .dots$sep <- "\t"
  if (is.null(.dots$stringsAsFactors))
    .dots$stringsAsFactors <- FALSE
  if (is.null(.dots$na.strings))
    .dots$na.strings <- c("NA", "")
  if (is.null(.dots$strip.white))
    .dots$strip.white <- TRUE


  do.call(utils::read.table, args = .dots)
}
