% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DendSer.R
\name{untangle_DendSer}
\alias{untangle_DendSer}
\title{Tries to run DendSer on a dendrogram}
\usage{
untangle_DendSer(dend, ...)
}
\arguments{
\item{dend}{An object of class \link{dendlist}}

\item{...}{NOT USED}
}
\value{
A dendlist object with ordered dends
}
\description{
The function tries to turn the dend into hclust.
It then uses the \link{cophenetic} distance matrix
for optimizing the tree's rotation.

This is a good (and fast) starting point for link{untangle_step_rotate_2side}
}
\examples{
\dontrun{
set.seed(232)
ss <- sample(1:150, 20)
dend1 <- iris[ss, -5] \%>\%
  dist() \%>\%
  hclust("com") \%>\%
  as.dendrogram()
dend2 <- iris[ss, -5] \%>\%
  dist() \%>\%
  hclust("sin") \%>\%
  as.dendrogram()
dend12 <- dendlist(dend1, dend2)

# bad solutions
dend12 \%>\% tanglegram()
dend12 \%>\%
  untangle("step2") \%>\%
  tanglegram()
dend12 \%>\%
  untangle_DendSer() \%>\%
  tanglegram()
# but the combination is quite awsome:
dend12 \%>\%
  untangle_DendSer() \%>\%
  untangle("step2") \%>\%
  tanglegram()
}
}
\seealso{
\code{\link[DendSer]{DendSer}}, \link{DendSer.dendrogram} ,
\link{untangle_DendSer}, \link{rotate_DendSer}
}
