% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct_edges.R
\name{dend_diff}
\alias{dend_diff}
\alias{dend_diff.dendrogram}
\alias{dend_diff.dendlist}
\title{Plots two trees side by side, highlighting edges unique to each tree in red.}
\source{
A \link{dendrogram} implementation for \link[distory]{phylo.diff} from the {distory} package
}
\usage{
dend_diff(dend, ...)

\method{dend_diff}{dendrogram}(dend, dend2, horiz = TRUE, ...)

\method{dend_diff}{dendlist}(dend, ..., which = c(1L, 2L))
}
\arguments{
\item{dend}{a dendrogram or \link{dendlist} to compre with}

\item{...}{passed to \link{plot.dendrogram}}

\item{dend2}{a dendrogram to compare with}

\item{horiz}{logical (TRUE) indicating if the dendrogram should be drawn horizontally or not.}

\item{which}{an integer vector indicating, in the case "dend" is a dendlist,
on which of the trees should the modification be performed.
If missing - the change will be performed on all of objects in the dendlist.}
}
\value{
Invisible \link{dendlist} of both trees.
}
\description{
Plots two trees side by side, highlighting edges unique to each tree in red.
}
\examples{

x <- 1:5 \%>\%
  dist() \%>\%
  hclust() \%>\%
  as.dendrogram()
y <- set(x, "labels", 5:1)

dend_diff(x, y)
dend_diff(dendlist(x, y))
dend_diff(dendlist(y, x))

dend1 <- 1:10 \%>\%
  dist() \%>\%
  hclust() \%>\%
  as.dendrogram()
dend2 <- dend1 \%>\% set("labels", c(1, 3, 2, 4, 5:10))
dend_diff(dend1, dend2)
}
\seealso{
\link{distinct_edges}, \link{highlight_distinct_edges},
\link{dist.dendlist}, \link{tanglegram}
\link{assign_values_to_branches_edgePar},
\link[distory]{distinct.edges},
}
