\name{ei.MD.bayes}
\alias{ei.MD.bayes}
\title{Multinomial Dirichlet model for Ecological Inference in RxC tables}

\description{Implements a version of the hierarchical model suggested in Rosen et al. (2001)}

\usage{
ei.MD.bayes(formula, covariate = NULL, total = NULL, data, 
            lambda1 = 4, lambda2 = 2, covariate.prior.list = NULL,
            tune.list = NULL, start.list = NULL, sample = 1000, thin = 1, 
            burnin = 1000, verbose = 0, ret.beta = 'r', 
            ret.mcmc = TRUE, usrfun = NULL) 
}
\arguments{
  \item{formula}{A formula of the form \code{cbind(col1, col2, ...) ~
      cbind(row1, row2, ...)}.   Column and row marginals must have the
    same totals.}
  \item{covariate}{An optional formula of the form \code{~ covariate}.  The 
    default is \code{covariate = NULL}, which fits the model without a covariate.}
  \item{total}{if row and/or column marginals are given as proportions,
    \code{total} identifies the name of the variable in \code{data} containing the
    total number of individuals in each unit}    
  \item{data}{A data frame containing the variables specified in
    \code{formula} and \code{total}}
  \item{lambda1}{The shape parameter for the gamma prior (defaults to 4)}
  \item{lambda2}{The rate parameter for the gamma prior (defaults to 2)}
  \item{covariate.prior.list}{a list containing the parameters for
    normal prior distributions on delta and gamma for model with
    covariate.  See `details' for more information.}
  \item{tune.list}{A list containing tuning parameters for each block of
    parameters.  See `details' for more information.  Typically, this
    will be a list generated by \code{\link[eiPack]{tuneMD}}.  The
    default is \code{NULL}, in which case fixed tuning parameters are used.}
  \item{start.list}{A list containing starting values for each block of
    parameters.  See `details' for more information.  The default is
    \code{start.list = NULL}, which generates appropriate random starting values.}
\item{sample}{Number of draws to be saved from chain
and returned as output from the function (defaults to 1000).  The total
length of the chain is \code{sample}*\code{thin} + \code{burnin}.}
\item{thin}{an integer specifying the thinning interval for posterior
  draws (defaults to 1, but most problems will require a much larger thinning interval).}
\item{burnin}{integer specifying the number of initial iterations to be discarded (defaults to 1000, but most problems will require a longer burnin).}
\item{verbose}{an integer specifying whether the progress of the sampler 
is printed to the screen (defaults to 0).  If \code{verbose} is greater than 0, the
iteration number is printed to the screen every \code{verbose}th
iteration.}
\item{ret.beta}{A character indicating how the posterior draws of beta should be  
handled: `\code{r}'eturn as an R object, `\code{s}'ave as .txt.gz
files, `\code{d}'iscard (defaults to \code{r}).}  
\item{ret.mcmc}{A logical value indicating how the samples from the posterior 
should be returned.  If \code{TRUE} (default), samples are returned as
coda \code{mcmc} objects.  If \code{FALSE}, samples are returned as arrays.}
\item{usrfun}{the name of an optional a user-defined function to obtain quantities of
  interest while drawing from the MCMC chain (defaults to \code{NULL}).}
}
\value{
A list containing 
\item{draws}{A list containing samples from the posterior distribution
  of the parameters.  If a covariate is included in the model, the list contains: 
\itemize{
  \item{\code{Dr}}{ Posterior draws for Dr parameters as an R
     \eqn{\times}{x}sample matrix.  If
  \code{ret.mcmc = TRUE}, \code{Dr} is an \code{mcmc} object.}
\item{\code{Beta}}{ Posterior draws for beta parameters.  Only returned if 
  \code{ret.beta = TRUE}.  If \code{ret.mcmc = 
TRUE}, a  (R * C * units) \eqn{\times}{x} sample matrix saved as an \code{mcmc} 
object.  Otherwise, a R \eqn{\times}{x} C \eqn{\times}{x} units
\eqn{\times}{x} sample array}
\item{\code{Gamma}}{ Posterior draws for gamma parameters.  If \code{ret.mcmc =
TRUE}, a  (R * (C - 1)) \eqn{\times}{x} sample matrix saved as an \code{mcmc}
object.  Otherwise, a R \eqn{\times}{x} (C - 1) \eqn{\times}{x} sample array}
\item{\code{Delta}}{ Posterior draws for delta parameters.  If \code{ret.mcmc =                 
TRUE}, a  (R * (C - 1)) \eqn{\times}{x} sample matrix saved as an \code{mcmc}      
object.  Otherwise, a R \eqn{\times}{x}(C - 1) \eqn{\times}{x} sample array}
\item{\code{Cell.count}}{ Posterior draws for the cell counts, summed
  across units.  If \code{ret.mcmc =
    TRUE}, a (R * C) \eqn{\times}{x} sample matrix saved as an \code{mcmc} object.
  Otherwise, a R \eqn{\times}{x} C \eqn{\times}{x} sample array}
}

If the model is fit without a covariate, the list includes:
\itemize{
\item{\code{Alpha}}{ Posterior draws for alpha parameters.  If \code{ret.mcmc =
    TRUE}, a (R * C) \eqn{\times}{x} sample matrix saved as an \code{mcmc} object.
  Otherwise, a R \eqn{\times}{x} C \eqn{\times}{x} sample array}
\item{\code{Beta}}{ Posterior draws for beta parameters.  If \code{ret.mcmc =
    TRUE}, a (R * C * units) \eqn{\times}{x} sample matrix saved as
  an \code{mcmc} object. 
  Otherwise, a R \eqn{\times}{x} C \eqn{\times}{x} units
  \eqn{\times}{x} sample array} 
\item{\code{Cell.count}}{ Posterior draws for the cell counts, summed
  across units.  If \code{ret.mcmc =
    TRUE}, a (R * C) \eqn{\times}{x} sample matrix saved as an\code{mcmc} object.
  Otherwise, a R \eqn{\times}{x} C \eqn{\times}{x} sample array}
}}

\item{acc.ratios}{ A list containing acceptance ratios for the
  parameters.  If the model includes a covariate, the list includes:
\itemize{  
\item{\code{dr.acc}}{ A vector of acceptance ratios for \code{Dr} draws}
\item{\code{beta.acc}}{ A vector of acceptance ratios for \code{Beta} draws}
\item{\code{gamma.acc}}{ A vector of acceptance ratios for \code{Gamma} and
  \code{Delta} draws}
}
If the model is fit without a covariate , the list includes:
\itemize{
  \item{\code{alpha.acc}}{ A vector of acceptance ratios for \code{Alpha} draws}
\item{\code{beta.acc}}{ A vector of acceptance ratios for \code{Beta} draws}  
}}

\item{usrfun}{Output from the optional \code{usrfn}}
\item{call}{Call to \code{ei.MD.bayes}}
}

\details{

  \code{ei.MD.bayes} implements a version of the hierarchical
  Multinomial-Dirichlet model for ecological inference in \eqn{R
    \times C}{R x C} tables suggested by Rosen et al. (2001).

  Let \eqn{r = 1, \ldots, R}{r = 1, ..., R} index rows, \eqn{C = 1,
    \ldots, C}{C = 1, ..., C} index columns, and \eqn{i = 1, \ldots,
    n}{i = 1, ..., n} index units.  Let \eqn{N_{\cdot ci}}{N_.ci} be the
  marginal count for column \eqn{c}{c} in unit \eqn{i}{i} and \eqn{X_{ri}}{X_ri} be the
  marginal proportion for row \eqn{r}{r} in unit \eqn{i}{i}.  Finally, let
  \eqn{\beta_{rci}}{beta_rci} be the proportion of row \eqn{r}{r} in column \eqn{c}{c}
  for unit \eqn{i}{i}.

  The first stage of the model assumes that the vector of column
  marginal counts in unit \eqn{i}{i} follows a Multinomial distribution of the
  form:

  \deqn{(N_{\cdot 1i}, \ldots, N_{\cdot Ci}) {\sim}
    {\rm Multinomial}(N_i,\sum_{r=1}^R \beta_{r1i}X_{ri}, \dots,
    \sum_{r=1}^R \beta_{rCi}X_{ri})}{(N_.1i,..., N_.Ci) ~
    Multinomial(N_i,sum_{r=1}^R(beta_r1i*X_ri), ...,
    sum_{r=1}^R (beta_rCi*X_ri)}


  The second stage of the model assumes that the vector of
  \eqn{\beta}{beta} for row \eqn{r}{r} in unit \eqn{i}{i} follows a Dirichlet
  distribution with \eqn{C}{C} parameters.  The model may be fit with or
  without a covariate. 

  If the model is fit without a covariate, the distribution of the vector
  \eqn{\beta_{ri}}{beta_ri} is :
  
  \deqn{(\beta_{r1i}, \dots, \beta_{rCi}) {\sim} {\rm
      Dirichlet}(\alpha_{r1}, \dots, \alpha_{rC})}{(beta_r1i, ..., beta_rCi) ~
    Dirichlet(alpha_r1, ..., alpha_rC)}

  In this case, the prior on each \eqn{\alpha_{rc}}{alpha_rc} is assumed
  to be:

  \deqn{\alpha_{rc} \sim {\rm Gamma}(\lambda_1, \lambda_2)}{alpha_rc ~
    Gamma(lambda_1, lambda_2}


  If the model is fit with a covariate, the  distribution of the vector
  \eqn{\beta_{ri}}{beta_ri} is :
  
  \deqn{(\beta_{r1i}, \dots, \beta_{rCi}) {\sim} {\rm
      Dirichlet}(d_r\exp(\gamma_{r1} + \delta_{r1}Z_i),
    d_r\exp(\gamma_{r(C-1)} + \delta_{r(C-1)}Z_i), d_r)}{(beta_r1i, ...,
    beta_rCi) ~ Dirichlet(d_r*exp(gamma_r1 + delta_r1 * Z_i), ..., d_r *
    exp(gamma_r(C-1) + delta_r(C-1)*Z_i), d_r)}

  The parameters \eqn{\gamma_{rC}}{gamma_rC} and
  \eqn{\delta_{rC}}{delta_rC} are constrained to be zero for
  identification.  (In this function, the last column entered in the
  formula is so constrained.)

  Finally, the prior for \eqn{d_r}{d_r} is: 

   \deqn{d_r \sim {\rm Gamma}(\lambda_1, \lambda_2)}{d_r ~
    Gamma(lambda_1, lambda_2)}

  while \eqn{\gamma_{rC}}{gamma_rC} and \eqn{\delta_{rC}}{delta_rC} are
  given improper uniform priors if \code{covariate.prior.list = NULL} or
  have independent normal priors of the form:

   \deqn{\delta_{rC} \sim {\rm N}(\mu_{\delta_{rC}},
     \sigma_{\delta_{rC}}^2)}{delta_{rC} ~ N(mu_{delta_{rC}},
     sigma_{delta_{rC}}^2)}

      \deqn{\gamma_{rC} \sim {\rm N}(\mu_{\gamma_{rC}},
     \sigma_{\gamma_{rC}}^2)}{gamma_{rC} ~ N(mu_{gamma_{rC}},
     sigma_{gamma_{rC}}^2)}

   If the user wishes to estimate the model with proper normal priors on
   \eqn{\gamma_{rC}}{gamma_rC} and \eqn{\delta_{rC}}{delta_rC}, a list
   with four elements must be provided for \code{covariate.prior.list}:
   \itemize{
\item{\code{mu.delta}}{ an \eqn{R \times (C-1)}{R x (C-1)} matrix of
  prior means for Delta}
\item{\code{sigma.delta}}{ an \eqn{R \times (C-1)}{R x (C-1)} matrix of
  prior standard deviations for Delta} 
\item{\code{mu.gamma}}{ an \eqn{R \times (C-1)}{R x (C-1)} matrix of
  prior means for Gamma} 
\item{\code{sigma.gamma}}{ an \eqn{R \times (C-1)}{R x (C-1)} matrix of
  prior standard deviations for Gamma}}  

   
   Applying the model without a covariate is
   most reasonable in situations where one can think of individuals being
   randomly assigned to units, so that there are no aggregation or
   contextual effects.  When this assumption is not reasonable,
   including an appropriate covariate may improve inferences; note,
   however, that there is typically little information in the data about
   the relationship of any given covariate to the unit parameters, which can
   lead to extremely slow mixing of the MCMC chains and difficulty in
   assessing convergence.
   
   Because the conditional distributions are non-standard, draws from the
   posterior are obtained by using a Metropolis-within-Gibbs algorithm.
   The proposal density for each parameter is a univariate normal
   distribution centered at the current parameter value with standard
   deviation equal to the tuning constant; the only exception is for
   draws of \eqn{\gamma_{rc}}{gamma_rc} and \eqn{\delta_{rc}}{delta_rc}, which
   use a bivariate normal proposal with covariance zero.  
  
The function will accept user-specified starting values as an argument.
If the model includes a covariate, the starting values must be a list
with the following elements, in this order:

\itemize{
\item{\code{start.dr}}{ a vector of length \eqn{R}{R} of starting values for Dr.
  Starting values for Dr must be greater than zero.}

\item{\code{start.betas}}{ an \eqn{R \times C}{R x C} by precincts array
of starting values for Beta.  Each row of every precinct must sum to 1.}

\item{\code{start.gamma}}{ an \eqn{R \times C}{R x C} matrix of starting
  values for Gamma.  Values in the right-most column must be zero.}
\item{\code{start.delta}}{ an \eqn{R \times C}{R x C} matrix of starting
  values for Delta.  Values in the right-most column must be zero.}
}
If there is no covariate, the starting values must be a list with the following elements:
\itemize{
\item{\code{start.alphas}}{ an \eqn{R \times C}{R x C} matrix of starting values for Alpha.  Starting values for Alpha must be greater than zero.}
\item{\code{start.betas}}{ an \eqn{R \times C \times}{R x C x} units array of
  starting values for Beta.  Each row in every unit must sum to 1.}}

The function will accept user-specified tuning parameters as an
argument.  The tuning parameters define the standard deviation of the
normal distribution used to generate candidate values for each
parameter.  For the model with a covariate, a bivariate normal
distribution is used to generate proposals; the covariance of these
normal distributions is fixed at zero.  If the model includes a covariate, the tuning parameters must be a list with the following elements, in this order:
\itemize{
\item{\code{tune.dr}}{ a vector of length \eqn{R}{R} of tuning parameters for Dr}
\item{\code{tune.beta}}{ an \eqn{R \times (C-1)}{R x (C-1)} by precincts array
  of tuning parameters for Beta} 
\item{\code{tune.gamma}}{ an \eqn{R \times (C-1)}{R x (C-1)} matrix of tuning
  parameters for Gamma} 
\item{\code{tune.delta}}{ an \eqn{R \times (C-1)}{R x (C-1)} matrix of tuning
  parameters for Delta}} 
 
If there is no covariate, the tuning parameters are a list with the following elements:
\itemize{
\item{\code{tune.alpha}}{ an \eqn{R \times C}{R x C} matrix of tuning parameters for Alpha}
\item{\code{tune.beta}}{ an \eqn{R \times (C-1)}{R x (C-1)} by precincts array
  of tuning parameters for Beta}
}
}

\references{
      Martyn Plummer, Nicky Best, Kate Cowles, and Karen Vines. 2002.
     \emph{Output Analysis and Diagnostics for MCMC (CODA)}. \url{
      https://CRAN.R-project.org/package=coda}.

	 Ori Rosen, Wenxin Jiang, Gary King, and Martin A. Tanner.
	 2001.  ``Bayesian and Frequentist Inference for Ecological
	 Inference: The \eqn{R \times (C-1)}{R x (C-1)} Case.'' 
	 \emph{Statistica Neerlandica} 55: 134-156.  }

\author{
  Michael Kellermann <\email{mrkellermann@gmail.com}> and Olivia Lau 
<\email{olivia.lau@post.harvard.edu}>
}

\seealso{\code{\link[eiPack]{lambda.MD}}, \code{\link[eiPack]{cover.plot}}, 
\code{\link[eiPack]{density.plot}}, \code{\link[eiPack]{tuneMD}}, 
\code{\link[eiPack]{mergeMD}}}

\keyword{models}





