% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{neuralgia}
\alias{neuralgia}
\title{Neuralgia data}
\format{
A data frame with 60 observations and 5 variables:
\describe{
  \item{\code{Treatment}}{Factor with 3 levels \code{A}, \code{B}, and \code{P}.
    The latter is placebo}
  \item{\code{Sex}}{Factor with two levels \code{F} and \code{M}}
  \item{\code{Age}}{Numeric covariate -- patient's age in years}
  \item{\code{Duration}}{Numeric covariate -- duration of the condition before
    beginning treatment}
  \item{\code{Pain}}{Binary response factor with levels \code{No} and \code{Yes}}
}
}
\source{
Cai, Weijie (2014) \emph{Making Comparisons Fair: How LS-Means Unify 
  the Analysis of Linear Models}, SAS Institute, Inc. Technical paper 142-2014,
  page 12, 
  \url{http://support.sas.com/resources/papers/proceedings14/SAS060-2014.pdf}
}
\usage{
neuralgia
}
\description{
These data arise from a study of analgesic effects of treatments of elderly
patients who have neuralgia. Two treatments and a placebo are compared. The 
response variable is whether the patient reported pain or not. Researchers
recorded the age and gender of 60 patients along with the duration of
complaint before the treatment began.
}
\examples{
# Model and analysis shown in the SAS report:
neuralgia.glm <- glm(Pain ~ Treatment * Sex + Age, family = binomial(),
   data = neuralgia) 
pairs(emmeans(neuralgia.glm, ~ Treatment, at = list(Sex = "F")), 
    reverse = TRUE, type = "response", adjust = "bonferroni")

}
\keyword{datasets}
