% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is_file}
\alias{is_file}
\alias{is_dir}
\alias{is_link}
\alias{is_file_empty}
\title{Functions to test for file types}
\usage{
is_file(path, follow = TRUE)

is_dir(path, follow = TRUE)

is_link(path)

is_file_empty(path, follow = TRUE)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{follow}{If \code{TRUE}, symbolic links will be followed (recursively) and
the results will be that of the final file rather than the link.}
}
\value{
A named logical vector, where the names give the paths. If the given
object does not exist, \code{NA} is returned.
}
\description{
Functions to test for file types
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
dir_create("d")

file_create("d/file.txt")
dir_create("d/dir")
link_create(path(path_abs("d"), "file.txt"), "d/link")

paths <- dir_ls("d")
is_file(paths)
is_dir(paths)
is_link(paths)

# Cleanup
dir_delete("d")
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=file_exists]{file_exists()}}, \code{\link[=dir_exists]{dir_exists()}} and \code{\link[=link_exists]{link_exists()}} if you want
to ensure that the path also exists.
}
