% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_id-class.R
\name{as_id}
\alias{as_id}
\title{Extract and/or mark as file id}
\usage{
as_id(x, ...)
}
\arguments{
\item{x}{A character vector of file or shared drive ids or URLs, a
\code{\link{dribble}}, or a suitable data frame.}

\item{...}{Other arguments passed down to methods. (Not used.)}
}
\value{
A character vector bearing the S3 class \code{drive_id}.
}
\description{
Gets file ids from various inputs and marks them as such, to
distinguish them from file names or paths.

This is a generic function.
}
\examples{
\dontshow{if (drive_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
as_id("123abc")
as_id("https://docs.google.com/spreadsheets/d/qawsedrf16273849/edit#gid=12345")

x <- drive_find(n_max = 3)
as_id(x)
\dontshow{\}) # examplesIf}
}
