% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{gtable_trim}
\alias{gtable_trim}
\title{Trim off empty cells.}
\usage{
gtable_trim(x)
}
\arguments{
\item{x}{a gtable object}
}
\value{
A gtable object
}
\description{
This function detects rows and columns that does not contain any grobs and
removes thewm from the gtable. If the rows and/or columns removed had a
non-zero height/width the relative layout of the gtable may change.
}
\examples{
library(grid)
rect <- rectGrob(gp = gpar(fill = "black"))
base <- gtable(unit(c(2, 2, 2), "cm"), unit(c(2, 2, 2), "cm"))

center <- gtable_add_grob(base, rect, 2, 2)
plot(center)
plot(gtable_trim(center))

col <- gtable_add_grob(base, rect, 1, 2, 3, 2)
plot(col)
plot(gtable_trim(col))

row <- gtable_add_grob(base, rect, 2, 1, 2, 3)
plot(row)
plot(gtable_trim(row))
}
\concept{gtable modification}
