% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjunct_test_linter.R
\name{conjunct_test_linter}
\alias{conjunct_test_linter}
\title{Force && conditions in expect_true(), expect_false() to be written separately}
\usage{
conjunct_test_linter(allow_named_stopifnot = TRUE)
}
\arguments{
\item{allow_named_stopifnot}{Logical, \code{TRUE} by default. If \code{FALSE}, "named" calls to \code{stopifnot()},
available since R 4.0.0 to provide helpful messages for test failures, are also linted.}
}
\description{
For readability of test outputs, testing only one thing per call to
\code{\link[testthat:logical-expectations]{testthat::expect_true()}} is preferable, i.e.,
\verb{expect_true(A); expect_true(B)} is better than \code{expect_true(A && B)}, and
\verb{expect_false(A); expect_false(B)} is better than \code{expect_false(A || B)}.
}
\details{
Similar reasoning applies to \code{&&} usage inside \code{\link[=stopifnot]{stopifnot()}} and \code{assertthat::assert_that()} calls.
}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=package_development_linters]{package_development}, \link[=readability_linters]{readability}
}
